# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

modules = \
['module_cli']
entry_points = \
{'console_scripts': ['module-cli = module_cli:cli']}

setup_kwargs = {
    'name': 'module-cli',
    'version': '22.4.0',
    'description': 'Bootstrap extensible single-module CLIs',
    'long_description': '# module-cli\n\nBootstrap extensible single-module CLIs\n\n[![PyPI Version](https://img.shields.io/pypi/v/module-cli.svg)](https://pypi.org/project/module-cli/)\n\n## Installation\n\n### With `pipx`\n\nThis package is intended to generate python modules that function as CLIs and therefore shouldn\'t be a dependency of any module/package that it generates. **Because of this it\'s recommended to use this package via `pipx`**:\n\n```bash\npipx run module-cli /path/to/module.py\n```\n\n### With `pip`\n\nIf you really want this package as one of _your_ package\'s dependencies, then install via `pip` in the usual way:\n\n```bash\npip install module-cli\n```\n\nWhich you can then use the CLI:\n\n```bash\n$ module-cli -h\nusage: module-cli [-h] [-v] [out]\n\npositional arguments:\n  out            File to write to. (default: -)\n\noptional arguments:\n  -h, --help     show this help message and exit\n  -v, --version  show program\'s version number and exit\n```\n\n## Installing your CLI\n\nThe modules generated by `module-cli` contain a function `cli()`. This function is the one you\'ll likely want to point to if you intend to turn your module into an installable command-line application.\n\n- **`setup.cfg`**:\n\n  ```ini\n  [options.entry_points]\n  console_scripts =\n      my_cli = my_pkg.my_module:cli\n  ```\n\n- **`setup.py`**:\n\n  ```python\n  setup(\n      entry_points = {\n          \'console_scripts\': [\'my_cli=my_pkg.my_module:cli\'],\n      }\n  )\n  ```\n\n- **`pyproject.toml`** (poetry):\n\n  ```toml\n  [tool.poetry.scripts]\n  my_cli = "my_pkg.my_module:cli"\n  ```\n\n## Contributing\n\n1. Have or install a recent version of `poetry` (version >= 1.1)\n1. Fork the repo\n1. Setup a virtual environment (however you prefer)\n1. Run `poetry install`\n1. Run `pre-commit install`\n1. Add your changes (adding/updating tests is always nice too)\n1. Commit your changes + push to your fork\n1. Open a PR\n',
    'author': 'Andrew Ross',
    'author_email': 'andrew.ross.mail@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/andrewrosss/module-cli',
    'package_dir': package_dir,
    'py_modules': modules,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
