"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Validate that a given key is of a given type in an object
 *
 * If not optional, the key is considered required.
 *
 * Uses predicate validators that return a 'witness', so we can use the return type of
 * the validator function to infer the actual type of the value and enrich the type information
 * of the given input field.
 *
 * In effect, validators should be written like this:
 *
 *   if (!valid(input)) { throw; }
 *   return input;
 */
function expectKey(obj, key, validate, optional) {
    if (typeof obj !== 'object' || obj === null || (!(key in obj) && !optional)) {
        throw new Error(`Expected key '${key}' missing: ${JSON.stringify(obj)}`);
    }
    if (key in obj) {
        try {
            validate(obj[key]);
        }
        catch (e) {
            throw new Error(`${key}: ${e.message}`);
        }
    }
}
exports.expectKey = expectKey;
function isString(x) {
    if (typeof x !== 'string') {
        throw new Error(`Expected a string, got '${x}'`);
    }
    return x;
}
exports.isString = isString;
function isMapOf(pred) {
    return x => {
        assertIsObject(x);
        Object.values(x).forEach(pred);
        return x;
    };
}
exports.isMapOf = isMapOf;
function isObjectAnd(p) {
    return x => {
        assertIsObject(x);
        return p(x);
    };
}
exports.isObjectAnd = isObjectAnd;
function assertIsObject(x) {
    if (typeof x !== 'object' || x === null) {
        throw new Error(`Expected a map, got '${x}'`);
    }
}
exports.assertIsObject = assertIsObject;
//# sourceMappingURL=data:application/json;base64,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