# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DetectorModelAction',
    'DetectorModelAssetPropertyTimestamp',
    'DetectorModelAssetPropertyValue',
    'DetectorModelAssetPropertyVariant',
    'DetectorModelClearTimer',
    'DetectorModelDetectorModelDefinition',
    'DetectorModelDynamoDB',
    'DetectorModelDynamoDBv2',
    'DetectorModelEvent',
    'DetectorModelFirehose',
    'DetectorModelIotEvents',
    'DetectorModelIotSiteWise',
    'DetectorModelIotTopicPublish',
    'DetectorModelLambda',
    'DetectorModelOnEnter',
    'DetectorModelOnExit',
    'DetectorModelOnInput',
    'DetectorModelPayload',
    'DetectorModelResetTimer',
    'DetectorModelSetTimer',
    'DetectorModelSetVariable',
    'DetectorModelSns',
    'DetectorModelSqs',
    'DetectorModelState',
    'DetectorModelTag',
    'DetectorModelTransitionEvent',
    'InputAttribute',
    'InputInputDefinition',
    'InputTag',
]

@pulumi.output_type
class DetectorModelAction(dict):
    """
    The actions to be performed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clearTimer":
            suggest = "clear_timer"
        elif key == "dynamoDB":
            suggest = "dynamo_db"
        elif key == "dynamoDBv2":
            suggest = "dynamo_d_bv2"
        elif key == "iotEvents":
            suggest = "iot_events"
        elif key == "iotSiteWise":
            suggest = "iot_site_wise"
        elif key == "iotTopicPublish":
            suggest = "iot_topic_publish"
        elif key == "lambda":
            suggest = "lambda_"
        elif key == "resetTimer":
            suggest = "reset_timer"
        elif key == "setTimer":
            suggest = "set_timer"
        elif key == "setVariable":
            suggest = "set_variable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 clear_timer: Optional['outputs.DetectorModelClearTimer'] = None,
                 dynamo_db: Optional['outputs.DetectorModelDynamoDB'] = None,
                 dynamo_d_bv2: Optional['outputs.DetectorModelDynamoDBv2'] = None,
                 firehose: Optional['outputs.DetectorModelFirehose'] = None,
                 iot_events: Optional['outputs.DetectorModelIotEvents'] = None,
                 iot_site_wise: Optional['outputs.DetectorModelIotSiteWise'] = None,
                 iot_topic_publish: Optional['outputs.DetectorModelIotTopicPublish'] = None,
                 lambda_: Optional['outputs.DetectorModelLambda'] = None,
                 reset_timer: Optional['outputs.DetectorModelResetTimer'] = None,
                 set_timer: Optional['outputs.DetectorModelSetTimer'] = None,
                 set_variable: Optional['outputs.DetectorModelSetVariable'] = None,
                 sns: Optional['outputs.DetectorModelSns'] = None,
                 sqs: Optional['outputs.DetectorModelSqs'] = None):
        """
        The actions to be performed.
        """
        if clear_timer is not None:
            pulumi.set(__self__, "clear_timer", clear_timer)
        if dynamo_db is not None:
            pulumi.set(__self__, "dynamo_db", dynamo_db)
        if dynamo_d_bv2 is not None:
            pulumi.set(__self__, "dynamo_d_bv2", dynamo_d_bv2)
        if firehose is not None:
            pulumi.set(__self__, "firehose", firehose)
        if iot_events is not None:
            pulumi.set(__self__, "iot_events", iot_events)
        if iot_site_wise is not None:
            pulumi.set(__self__, "iot_site_wise", iot_site_wise)
        if iot_topic_publish is not None:
            pulumi.set(__self__, "iot_topic_publish", iot_topic_publish)
        if lambda_ is not None:
            pulumi.set(__self__, "lambda_", lambda_)
        if reset_timer is not None:
            pulumi.set(__self__, "reset_timer", reset_timer)
        if set_timer is not None:
            pulumi.set(__self__, "set_timer", set_timer)
        if set_variable is not None:
            pulumi.set(__self__, "set_variable", set_variable)
        if sns is not None:
            pulumi.set(__self__, "sns", sns)
        if sqs is not None:
            pulumi.set(__self__, "sqs", sqs)

    @property
    @pulumi.getter(name="clearTimer")
    def clear_timer(self) -> Optional['outputs.DetectorModelClearTimer']:
        return pulumi.get(self, "clear_timer")

    @property
    @pulumi.getter(name="dynamoDB")
    def dynamo_db(self) -> Optional['outputs.DetectorModelDynamoDB']:
        return pulumi.get(self, "dynamo_db")

    @property
    @pulumi.getter(name="dynamoDBv2")
    def dynamo_d_bv2(self) -> Optional['outputs.DetectorModelDynamoDBv2']:
        return pulumi.get(self, "dynamo_d_bv2")

    @property
    @pulumi.getter
    def firehose(self) -> Optional['outputs.DetectorModelFirehose']:
        return pulumi.get(self, "firehose")

    @property
    @pulumi.getter(name="iotEvents")
    def iot_events(self) -> Optional['outputs.DetectorModelIotEvents']:
        return pulumi.get(self, "iot_events")

    @property
    @pulumi.getter(name="iotSiteWise")
    def iot_site_wise(self) -> Optional['outputs.DetectorModelIotSiteWise']:
        return pulumi.get(self, "iot_site_wise")

    @property
    @pulumi.getter(name="iotTopicPublish")
    def iot_topic_publish(self) -> Optional['outputs.DetectorModelIotTopicPublish']:
        return pulumi.get(self, "iot_topic_publish")

    @property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> Optional['outputs.DetectorModelLambda']:
        return pulumi.get(self, "lambda_")

    @property
    @pulumi.getter(name="resetTimer")
    def reset_timer(self) -> Optional['outputs.DetectorModelResetTimer']:
        return pulumi.get(self, "reset_timer")

    @property
    @pulumi.getter(name="setTimer")
    def set_timer(self) -> Optional['outputs.DetectorModelSetTimer']:
        return pulumi.get(self, "set_timer")

    @property
    @pulumi.getter(name="setVariable")
    def set_variable(self) -> Optional['outputs.DetectorModelSetVariable']:
        return pulumi.get(self, "set_variable")

    @property
    @pulumi.getter
    def sns(self) -> Optional['outputs.DetectorModelSns']:
        return pulumi.get(self, "sns")

    @property
    @pulumi.getter
    def sqs(self) -> Optional['outputs.DetectorModelSqs']:
        return pulumi.get(self, "sqs")


@pulumi.output_type
class DetectorModelAssetPropertyTimestamp(dict):
    """
    A structure that contains timestamp information. For more information, see [TimeInNanos](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_TimeInNanos.html) in the *AWS IoT SiteWise API Reference*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeInSeconds":
            suggest = "time_in_seconds"
        elif key == "offsetInNanos":
            suggest = "offset_in_nanos"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelAssetPropertyTimestamp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelAssetPropertyTimestamp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelAssetPropertyTimestamp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_in_seconds: str,
                 offset_in_nanos: Optional[str] = None):
        """
        A structure that contains timestamp information. For more information, see [TimeInNanos](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_TimeInNanos.html) in the *AWS IoT SiteWise API Reference*.
        :param str time_in_seconds: The nanosecond offset converted from `timeInSeconds`. The valid range is between `0-999999999`. You can also specify an expression.
        :param str offset_in_nanos: The timestamp, in seconds, in the Unix epoch format. The valid range is between `1-31556889864403199`. You can also specify an expression.
        """
        pulumi.set(__self__, "time_in_seconds", time_in_seconds)
        if offset_in_nanos is not None:
            pulumi.set(__self__, "offset_in_nanos", offset_in_nanos)

    @property
    @pulumi.getter(name="timeInSeconds")
    def time_in_seconds(self) -> str:
        """
        The nanosecond offset converted from `timeInSeconds`. The valid range is between `0-999999999`. You can also specify an expression.
        """
        return pulumi.get(self, "time_in_seconds")

    @property
    @pulumi.getter(name="offsetInNanos")
    def offset_in_nanos(self) -> Optional[str]:
        """
        The timestamp, in seconds, in the Unix epoch format. The valid range is between `1-31556889864403199`. You can also specify an expression.
        """
        return pulumi.get(self, "offset_in_nanos")


@pulumi.output_type
class DetectorModelAssetPropertyValue(dict):
    """
    A structure that contains value information. For more information, see [AssetPropertyValue](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetPropertyValue.html) in the *AWS IoT SiteWise API Reference*.
    """
    def __init__(__self__, *,
                 value: 'outputs.DetectorModelAssetPropertyVariant',
                 quality: Optional[str] = None,
                 timestamp: Optional['outputs.DetectorModelAssetPropertyTimestamp'] = None):
        """
        A structure that contains value information. For more information, see [AssetPropertyValue](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetPropertyValue.html) in the *AWS IoT SiteWise API Reference*.
        :param str quality: The quality of the asset property value. The value must be `GOOD`, `BAD`, or `UNCERTAIN`. You can also specify an expression.
        """
        pulumi.set(__self__, "value", value)
        if quality is not None:
            pulumi.set(__self__, "quality", quality)
        if timestamp is not None:
            pulumi.set(__self__, "timestamp", timestamp)

    @property
    @pulumi.getter
    def value(self) -> 'outputs.DetectorModelAssetPropertyVariant':
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def quality(self) -> Optional[str]:
        """
        The quality of the asset property value. The value must be `GOOD`, `BAD`, or `UNCERTAIN`. You can also specify an expression.
        """
        return pulumi.get(self, "quality")

    @property
    @pulumi.getter
    def timestamp(self) -> Optional['outputs.DetectorModelAssetPropertyTimestamp']:
        return pulumi.get(self, "timestamp")


@pulumi.output_type
class DetectorModelAssetPropertyVariant(dict):
    """
    A structure that contains an asset property value. For more information, see [Variant](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_Variant.html) in the *AWS IoT SiteWise API Reference*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "booleanValue":
            suggest = "boolean_value"
        elif key == "doubleValue":
            suggest = "double_value"
        elif key == "integerValue":
            suggest = "integer_value"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelAssetPropertyVariant. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelAssetPropertyVariant.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelAssetPropertyVariant.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boolean_value: Optional[str] = None,
                 double_value: Optional[str] = None,
                 integer_value: Optional[str] = None,
                 string_value: Optional[str] = None):
        """
        A structure that contains an asset property value. For more information, see [Variant](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_Variant.html) in the *AWS IoT SiteWise API Reference*.
        :param str boolean_value: The asset property value is a Boolean value that must be `TRUE` or `FALSE`. You can also specify an expression. If you use an expression, the evaluated result should be a Boolean value.
        :param str double_value: The asset property value is a double. You can also specify an expression. If you use an expression, the evaluated result should be a double.
        :param str integer_value: The asset property value is an integer. You can also specify an expression. If you use an expression, the evaluated result should be an integer.
        :param str string_value: The asset property value is a string. You can also specify an expression. If you use an expression, the evaluated result should be a string.
        """
        if boolean_value is not None:
            pulumi.set(__self__, "boolean_value", boolean_value)
        if double_value is not None:
            pulumi.set(__self__, "double_value", double_value)
        if integer_value is not None:
            pulumi.set(__self__, "integer_value", integer_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="booleanValue")
    def boolean_value(self) -> Optional[str]:
        """
        The asset property value is a Boolean value that must be `TRUE` or `FALSE`. You can also specify an expression. If you use an expression, the evaluated result should be a Boolean value.
        """
        return pulumi.get(self, "boolean_value")

    @property
    @pulumi.getter(name="doubleValue")
    def double_value(self) -> Optional[str]:
        """
        The asset property value is a double. You can also specify an expression. If you use an expression, the evaluated result should be a double.
        """
        return pulumi.get(self, "double_value")

    @property
    @pulumi.getter(name="integerValue")
    def integer_value(self) -> Optional[str]:
        """
        The asset property value is an integer. You can also specify an expression. If you use an expression, the evaluated result should be an integer.
        """
        return pulumi.get(self, "integer_value")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[str]:
        """
        The asset property value is a string. You can also specify an expression. If you use an expression, the evaluated result should be a string.
        """
        return pulumi.get(self, "string_value")


@pulumi.output_type
class DetectorModelClearTimer(dict):
    """
    Information needed to clear the timer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timerName":
            suggest = "timer_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelClearTimer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelClearTimer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelClearTimer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 timer_name: str):
        """
        Information needed to clear the timer.
        """
        pulumi.set(__self__, "timer_name", timer_name)

    @property
    @pulumi.getter(name="timerName")
    def timer_name(self) -> str:
        return pulumi.get(self, "timer_name")


@pulumi.output_type
class DetectorModelDetectorModelDefinition(dict):
    """
    Information that defines how a detector operates.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "initialStateName":
            suggest = "initial_state_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelDetectorModelDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelDetectorModelDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelDetectorModelDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 initial_state_name: str,
                 states: Sequence['outputs.DetectorModelState']):
        """
        Information that defines how a detector operates.
        :param str initial_state_name: The state that is entered at the creation of each detector (instance).
        :param Sequence['DetectorModelState'] states: Information about the states of the detector.
        """
        pulumi.set(__self__, "initial_state_name", initial_state_name)
        pulumi.set(__self__, "states", states)

    @property
    @pulumi.getter(name="initialStateName")
    def initial_state_name(self) -> str:
        """
        The state that is entered at the creation of each detector (instance).
        """
        return pulumi.get(self, "initial_state_name")

    @property
    @pulumi.getter
    def states(self) -> Sequence['outputs.DetectorModelState']:
        """
        Information about the states of the detector.
        """
        return pulumi.get(self, "states")


@pulumi.output_type
class DetectorModelDynamoDB(dict):
    """
    Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can also customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more information, see [Actions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html) in *AWS IoT Events Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hashKeyField":
            suggest = "hash_key_field"
        elif key == "hashKeyValue":
            suggest = "hash_key_value"
        elif key == "tableName":
            suggest = "table_name"
        elif key == "hashKeyType":
            suggest = "hash_key_type"
        elif key == "payloadField":
            suggest = "payload_field"
        elif key == "rangeKeyField":
            suggest = "range_key_field"
        elif key == "rangeKeyType":
            suggest = "range_key_type"
        elif key == "rangeKeyValue":
            suggest = "range_key_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelDynamoDB. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelDynamoDB.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelDynamoDB.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hash_key_field: str,
                 hash_key_value: str,
                 table_name: str,
                 hash_key_type: Optional[str] = None,
                 operation: Optional[str] = None,
                 payload: Optional['outputs.DetectorModelPayload'] = None,
                 payload_field: Optional[str] = None,
                 range_key_field: Optional[str] = None,
                 range_key_type: Optional[str] = None,
                 range_key_value: Optional[str] = None):
        """
        Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can also customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more information, see [Actions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html) in *AWS IoT Events Developer Guide*.
        :param str hash_key_field: The name of the hash key (also called the partition key).
        :param str hash_key_value: The value of the hash key (also called the partition key).
        :param str table_name: The name of the DynamoDB table.
        :param str hash_key_type: The data type for the hash key (also called the partition key). You can specify the following values:
               
               * `STRING` - The hash key is a string.
               
               * `NUMBER` - The hash key is a number.
               
               If you don't specify `hashKeyType`, the default value is `STRING`.
        :param str operation: The type of operation to perform. You can specify the following values:
               
               * `INSERT` - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.
               
               * `UPDATE` - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
               
               * `DELETE` - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
               
               If you don't specify this parameter, AWS IoT Events triggers the `INSERT` operation.
        :param str payload_field: The name of the DynamoDB column that receives the action payload.
               
               If you don't specify this parameter, the name of the DynamoDB column is `payload`.
        :param str range_key_field: The name of the range key (also called the sort key).
        :param str range_key_type: The data type for the range key (also called the sort key), You can specify the following values:
               
               * `STRING` - The range key is a string.
               
               * `NUMBER` - The range key is number.
               
               If you don't specify `rangeKeyField`, the default value is `STRING`.
        :param str range_key_value: The value of the range key (also called the sort key).
        """
        pulumi.set(__self__, "hash_key_field", hash_key_field)
        pulumi.set(__self__, "hash_key_value", hash_key_value)
        pulumi.set(__self__, "table_name", table_name)
        if hash_key_type is not None:
            pulumi.set(__self__, "hash_key_type", hash_key_type)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if payload_field is not None:
            pulumi.set(__self__, "payload_field", payload_field)
        if range_key_field is not None:
            pulumi.set(__self__, "range_key_field", range_key_field)
        if range_key_type is not None:
            pulumi.set(__self__, "range_key_type", range_key_type)
        if range_key_value is not None:
            pulumi.set(__self__, "range_key_value", range_key_value)

    @property
    @pulumi.getter(name="hashKeyField")
    def hash_key_field(self) -> str:
        """
        The name of the hash key (also called the partition key).
        """
        return pulumi.get(self, "hash_key_field")

    @property
    @pulumi.getter(name="hashKeyValue")
    def hash_key_value(self) -> str:
        """
        The value of the hash key (also called the partition key).
        """
        return pulumi.get(self, "hash_key_value")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        """
        The name of the DynamoDB table.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="hashKeyType")
    def hash_key_type(self) -> Optional[str]:
        """
        The data type for the hash key (also called the partition key). You can specify the following values:

        * `STRING` - The hash key is a string.

        * `NUMBER` - The hash key is a number.

        If you don't specify `hashKeyType`, the default value is `STRING`.
        """
        return pulumi.get(self, "hash_key_type")

    @property
    @pulumi.getter
    def operation(self) -> Optional[str]:
        """
        The type of operation to perform. You can specify the following values:

        * `INSERT` - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.

        * `UPDATE` - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.

        * `DELETE` - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.

        If you don't specify this parameter, AWS IoT Events triggers the `INSERT` operation.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.DetectorModelPayload']:
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter(name="payloadField")
    def payload_field(self) -> Optional[str]:
        """
        The name of the DynamoDB column that receives the action payload.

        If you don't specify this parameter, the name of the DynamoDB column is `payload`.
        """
        return pulumi.get(self, "payload_field")

    @property
    @pulumi.getter(name="rangeKeyField")
    def range_key_field(self) -> Optional[str]:
        """
        The name of the range key (also called the sort key).
        """
        return pulumi.get(self, "range_key_field")

    @property
    @pulumi.getter(name="rangeKeyType")
    def range_key_type(self) -> Optional[str]:
        """
        The data type for the range key (also called the sort key), You can specify the following values:

        * `STRING` - The range key is a string.

        * `NUMBER` - The range key is number.

        If you don't specify `rangeKeyField`, the default value is `STRING`.
        """
        return pulumi.get(self, "range_key_type")

    @property
    @pulumi.getter(name="rangeKeyValue")
    def range_key_value(self) -> Optional[str]:
        """
        The value of the range key (also called the sort key).
        """
        return pulumi.get(self, "range_key_value")


@pulumi.output_type
class DetectorModelDynamoDBv2(dict):
    """
    Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can also customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.

    You can use expressions for parameters that are strings. For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *AWS IoT Events Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableName":
            suggest = "table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelDynamoDBv2. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelDynamoDBv2.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelDynamoDBv2.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table_name: str,
                 payload: Optional['outputs.DetectorModelPayload'] = None):
        """
        Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can also customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.

        You can use expressions for parameters that are strings. For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *AWS IoT Events Developer Guide*.
        :param str table_name: The name of the DynamoDB table.
        """
        pulumi.set(__self__, "table_name", table_name)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        """
        The name of the DynamoDB table.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.DetectorModelPayload']:
        return pulumi.get(self, "payload")


@pulumi.output_type
class DetectorModelEvent(dict):
    """
    Specifies the `actions` to be performed when the `condition` evaluates to `TRUE`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventName":
            suggest = "event_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelEvent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelEvent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelEvent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_name: str,
                 actions: Optional[Sequence['outputs.DetectorModelAction']] = None,
                 condition: Optional[str] = None):
        """
        Specifies the `actions` to be performed when the `condition` evaluates to `TRUE`.
        :param str event_name: The name of the event.
        :param Sequence['DetectorModelAction'] actions: The actions to be performed.
        :param str condition: The Boolean expression that, when `TRUE`, causes the `actions` to be performed. If not present, the `actions` are performed (=`TRUE`). If the expression result is not a `Boolean` value, the `actions` are not performed (=`FALSE`).
        """
        pulumi.set(__self__, "event_name", event_name)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter(name="eventName")
    def event_name(self) -> str:
        """
        The name of the event.
        """
        return pulumi.get(self, "event_name")

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence['outputs.DetectorModelAction']]:
        """
        The actions to be performed.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def condition(self) -> Optional[str]:
        """
        The Boolean expression that, when `TRUE`, causes the `actions` to be performed. If not present, the `actions` are performed (=`TRUE`). If the expression result is not a `Boolean` value, the `actions` are not performed (=`FALSE`).
        """
        return pulumi.get(self, "condition")


@pulumi.output_type
class DetectorModelFirehose(dict):
    """
    Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deliveryStreamName":
            suggest = "delivery_stream_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelFirehose. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelFirehose.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelFirehose.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delivery_stream_name: str,
                 payload: Optional['outputs.DetectorModelPayload'] = None,
                 separator: Optional[str] = None):
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
        :param str delivery_stream_name: The name of the Kinesis Data Firehose delivery stream where the data is written.
        :param str separator: A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
        """
        pulumi.set(__self__, "delivery_stream_name", delivery_stream_name)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if separator is not None:
            pulumi.set(__self__, "separator", separator)

    @property
    @pulumi.getter(name="deliveryStreamName")
    def delivery_stream_name(self) -> str:
        """
        The name of the Kinesis Data Firehose delivery stream where the data is written.
        """
        return pulumi.get(self, "delivery_stream_name")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.DetectorModelPayload']:
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter
    def separator(self) -> Optional[str]:
        """
        A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
        """
        return pulumi.get(self, "separator")


@pulumi.output_type
class DetectorModelIotEvents(dict):
    """
    Sends an AWS IoT Events input, passing in information about the detector model instance and the event that triggered the action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputName":
            suggest = "input_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelIotEvents. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelIotEvents.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelIotEvents.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_name: str,
                 payload: Optional['outputs.DetectorModelPayload'] = None):
        """
        Sends an AWS IoT Events input, passing in information about the detector model instance and the event that triggered the action.
        :param str input_name: The name of the AWS IoT Events input where the data is sent.
        """
        pulumi.set(__self__, "input_name", input_name)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="inputName")
    def input_name(self) -> str:
        """
        The name of the AWS IoT Events input where the data is sent.
        """
        return pulumi.get(self, "input_name")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.DetectorModelPayload']:
        return pulumi.get(self, "payload")


@pulumi.output_type
class DetectorModelIotSiteWise(dict):
    """
    Sends information about the detector model instance and the event that triggered the action to a specified asset property in AWS IoT SiteWise.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "propertyValue":
            suggest = "property_value"
        elif key == "assetId":
            suggest = "asset_id"
        elif key == "entryId":
            suggest = "entry_id"
        elif key == "propertyAlias":
            suggest = "property_alias"
        elif key == "propertyId":
            suggest = "property_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelIotSiteWise. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelIotSiteWise.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelIotSiteWise.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 property_value: 'outputs.DetectorModelAssetPropertyValue',
                 asset_id: Optional[str] = None,
                 entry_id: Optional[str] = None,
                 property_alias: Optional[str] = None,
                 property_id: Optional[str] = None):
        """
        Sends information about the detector model instance and the event that triggered the action to a specified asset property in AWS IoT SiteWise.
        :param str asset_id: The ID of the asset that has the specified property. You can specify an expression.
        :param str entry_id: A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier. You can also specify an expression.
        :param str property_alias: The alias of the asset property. You can also specify an expression.
        :param str property_id: The ID of the asset property. You can specify an expression.
        """
        pulumi.set(__self__, "property_value", property_value)
        if asset_id is not None:
            pulumi.set(__self__, "asset_id", asset_id)
        if entry_id is not None:
            pulumi.set(__self__, "entry_id", entry_id)
        if property_alias is not None:
            pulumi.set(__self__, "property_alias", property_alias)
        if property_id is not None:
            pulumi.set(__self__, "property_id", property_id)

    @property
    @pulumi.getter(name="propertyValue")
    def property_value(self) -> 'outputs.DetectorModelAssetPropertyValue':
        return pulumi.get(self, "property_value")

    @property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> Optional[str]:
        """
        The ID of the asset that has the specified property. You can specify an expression.
        """
        return pulumi.get(self, "asset_id")

    @property
    @pulumi.getter(name="entryId")
    def entry_id(self) -> Optional[str]:
        """
        A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier. You can also specify an expression.
        """
        return pulumi.get(self, "entry_id")

    @property
    @pulumi.getter(name="propertyAlias")
    def property_alias(self) -> Optional[str]:
        """
        The alias of the asset property. You can also specify an expression.
        """
        return pulumi.get(self, "property_alias")

    @property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> Optional[str]:
        """
        The ID of the asset property. You can specify an expression.
        """
        return pulumi.get(self, "property_id")


@pulumi.output_type
class DetectorModelIotTopicPublish(dict):
    """
    Information required to publish the MQTT message through the AWS IoT message broker.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mqttTopic":
            suggest = "mqtt_topic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelIotTopicPublish. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelIotTopicPublish.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelIotTopicPublish.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mqtt_topic: str,
                 payload: Optional['outputs.DetectorModelPayload'] = None):
        """
        Information required to publish the MQTT message through the AWS IoT message broker.
        :param str mqtt_topic: The MQTT topic of the message. You can use a string expression that includes variables (`$variable.<variable-name>`) and input values (`$input.<input-name>.<path-to-datum>`) as the topic string.
        """
        pulumi.set(__self__, "mqtt_topic", mqtt_topic)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="mqttTopic")
    def mqtt_topic(self) -> str:
        """
        The MQTT topic of the message. You can use a string expression that includes variables (`$variable.<variable-name>`) and input values (`$input.<input-name>.<path-to-datum>`) as the topic string.
        """
        return pulumi.get(self, "mqtt_topic")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.DetectorModelPayload']:
        return pulumi.get(self, "payload")


@pulumi.output_type
class DetectorModelLambda(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionArn":
            suggest = "function_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelLambda. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelLambda.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelLambda.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_arn: str,
                 payload: Optional['outputs.DetectorModelPayload'] = None):
        """
        :param str function_arn: The ARN of the Lambda function that is executed.
        """
        pulumi.set(__self__, "function_arn", function_arn)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> str:
        """
        The ARN of the Lambda function that is executed.
        """
        return pulumi.get(self, "function_arn")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.DetectorModelPayload']:
        return pulumi.get(self, "payload")


@pulumi.output_type
class DetectorModelOnEnter(dict):
    """
    When entering this state, perform these `actions` if the `condition` is `TRUE`.
    """
    def __init__(__self__, *,
                 events: Optional[Sequence['outputs.DetectorModelEvent']] = None):
        """
        When entering this state, perform these `actions` if the `condition` is `TRUE`.
        :param Sequence['DetectorModelEvent'] events: Specifies the `actions` that are performed when the state is entered and the `condition` is `TRUE`.
        """
        if events is not None:
            pulumi.set(__self__, "events", events)

    @property
    @pulumi.getter
    def events(self) -> Optional[Sequence['outputs.DetectorModelEvent']]:
        """
        Specifies the `actions` that are performed when the state is entered and the `condition` is `TRUE`.
        """
        return pulumi.get(self, "events")


@pulumi.output_type
class DetectorModelOnExit(dict):
    """
    When exiting this state, perform these `actions` if the specified `condition` is `TRUE`.
    """
    def __init__(__self__, *,
                 events: Optional[Sequence['outputs.DetectorModelEvent']] = None):
        """
        When exiting this state, perform these `actions` if the specified `condition` is `TRUE`.
        :param Sequence['DetectorModelEvent'] events: Specifies the `actions` that are performed when the state is exited and the `condition` is `TRUE`.
        """
        if events is not None:
            pulumi.set(__self__, "events", events)

    @property
    @pulumi.getter
    def events(self) -> Optional[Sequence['outputs.DetectorModelEvent']]:
        """
        Specifies the `actions` that are performed when the state is exited and the `condition` is `TRUE`.
        """
        return pulumi.get(self, "events")


@pulumi.output_type
class DetectorModelOnInput(dict):
    """
    When an input is received and the `condition` is `TRUE`, perform the specified `actions`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "transitionEvents":
            suggest = "transition_events"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelOnInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelOnInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelOnInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 events: Optional[Sequence['outputs.DetectorModelEvent']] = None,
                 transition_events: Optional[Sequence['outputs.DetectorModelTransitionEvent']] = None):
        """
        When an input is received and the `condition` is `TRUE`, perform the specified `actions`.
        :param Sequence['DetectorModelEvent'] events: Specifies the `actions` performed when the `condition` evaluates to `TRUE`.
        :param Sequence['DetectorModelTransitionEvent'] transition_events: Specifies the `actions` performed, and the next `state` entered, when a `condition` evaluates to `TRUE`.
        """
        if events is not None:
            pulumi.set(__self__, "events", events)
        if transition_events is not None:
            pulumi.set(__self__, "transition_events", transition_events)

    @property
    @pulumi.getter
    def events(self) -> Optional[Sequence['outputs.DetectorModelEvent']]:
        """
        Specifies the `actions` performed when the `condition` evaluates to `TRUE`.
        """
        return pulumi.get(self, "events")

    @property
    @pulumi.getter(name="transitionEvents")
    def transition_events(self) -> Optional[Sequence['outputs.DetectorModelTransitionEvent']]:
        """
        Specifies the `actions` performed, and the next `state` entered, when a `condition` evaluates to `TRUE`.
        """
        return pulumi.get(self, "transition_events")


@pulumi.output_type
class DetectorModelPayload(dict):
    """
    Information needed to configure the payload.

    By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use `contentExpression`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentExpression":
            suggest = "content_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelPayload. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelPayload.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelPayload.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_expression: str,
                 type: str):
        """
        Information needed to configure the payload.

        By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use `contentExpression`.
        :param str content_expression: The content of the payload. You can use a string expression that includes quoted strings (`'<string>'`), variables (`$variable.<variable-name>`), input values (`$input.<input-name>.<path-to-datum>`), string concatenations, and quoted strings that contain `${}` as the content. The recommended maximum size of a content expression is 1 KB.
        :param str type: The value of the payload type can be either `STRING` or `JSON`.
        """
        pulumi.set(__self__, "content_expression", content_expression)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="contentExpression")
    def content_expression(self) -> str:
        """
        The content of the payload. You can use a string expression that includes quoted strings (`'<string>'`), variables (`$variable.<variable-name>`), input values (`$input.<input-name>.<path-to-datum>`), string concatenations, and quoted strings that contain `${}` as the content. The recommended maximum size of a content expression is 1 KB.
        """
        return pulumi.get(self, "content_expression")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The value of the payload type can be either `STRING` or `JSON`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DetectorModelResetTimer(dict):
    """
    Information required to reset the timer. The timer is reset to the previously evaluated result of the duration. The duration expression isn't reevaluated when you reset the timer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timerName":
            suggest = "timer_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelResetTimer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelResetTimer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelResetTimer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 timer_name: str):
        """
        Information required to reset the timer. The timer is reset to the previously evaluated result of the duration. The duration expression isn't reevaluated when you reset the timer.
        :param str timer_name: The name of the timer to reset.
        """
        pulumi.set(__self__, "timer_name", timer_name)

    @property
    @pulumi.getter(name="timerName")
    def timer_name(self) -> str:
        """
        The name of the timer to reset.
        """
        return pulumi.get(self, "timer_name")


@pulumi.output_type
class DetectorModelSetTimer(dict):
    """
    Information needed to set the timer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timerName":
            suggest = "timer_name"
        elif key == "durationExpression":
            suggest = "duration_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelSetTimer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelSetTimer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelSetTimer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 timer_name: str,
                 duration_expression: Optional[str] = None,
                 seconds: Optional[int] = None):
        """
        Information needed to set the timer.
        :param str timer_name: The name of the timer.
        :param str duration_expression: The duration of the timer, in seconds. You can use a string expression that includes numbers, variables (`$variable.<variable-name>`), and input values (`$input.<input-name>.<path-to-datum>`) as the duration. The range of the duration is `1-31622400` seconds. To ensure accuracy, the minimum duration is `60` seconds. The evaluated result of the duration is rounded down to the nearest whole number.
        :param int seconds: The number of seconds until the timer expires. The minimum value is `60` seconds to ensure accuracy. The maximum value is `31622400` seconds.
        """
        pulumi.set(__self__, "timer_name", timer_name)
        if duration_expression is not None:
            pulumi.set(__self__, "duration_expression", duration_expression)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter(name="timerName")
    def timer_name(self) -> str:
        """
        The name of the timer.
        """
        return pulumi.get(self, "timer_name")

    @property
    @pulumi.getter(name="durationExpression")
    def duration_expression(self) -> Optional[str]:
        """
        The duration of the timer, in seconds. You can use a string expression that includes numbers, variables (`$variable.<variable-name>`), and input values (`$input.<input-name>.<path-to-datum>`) as the duration. The range of the duration is `1-31622400` seconds. To ensure accuracy, the minimum duration is `60` seconds. The evaluated result of the duration is rounded down to the nearest whole number.
        """
        return pulumi.get(self, "duration_expression")

    @property
    @pulumi.getter
    def seconds(self) -> Optional[int]:
        """
        The number of seconds until the timer expires. The minimum value is `60` seconds to ensure accuracy. The maximum value is `31622400` seconds.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class DetectorModelSetVariable(dict):
    """
    Information about the variable and its new value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "variableName":
            suggest = "variable_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelSetVariable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelSetVariable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelSetVariable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value: str,
                 variable_name: str):
        """
        Information about the variable and its new value.
        :param str value: The new value of the variable.
        :param str variable_name: The name of the variable.
        """
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "variable_name", variable_name)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The new value of the variable.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="variableName")
    def variable_name(self) -> str:
        """
        The name of the variable.
        """
        return pulumi.get(self, "variable_name")


@pulumi.output_type
class DetectorModelSns(dict):
    """
    Information required to publish the Amazon SNS message.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetArn":
            suggest = "target_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelSns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelSns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelSns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_arn: str,
                 payload: Optional['outputs.DetectorModelPayload'] = None):
        """
        Information required to publish the Amazon SNS message.
        :param str target_arn: The ARN of the Amazon SNS target where the message is sent.
        """
        pulumi.set(__self__, "target_arn", target_arn)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> str:
        """
        The ARN of the Amazon SNS target where the message is sent.
        """
        return pulumi.get(self, "target_arn")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.DetectorModelPayload']:
        return pulumi.get(self, "payload")


@pulumi.output_type
class DetectorModelSqs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueUrl":
            suggest = "queue_url"
        elif key == "useBase64":
            suggest = "use_base64"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelSqs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelSqs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelSqs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 queue_url: str,
                 payload: Optional['outputs.DetectorModelPayload'] = None,
                 use_base64: Optional[bool] = None):
        """
        :param str queue_url: The URL of the SQS queue where the data is written.
        :param bool use_base64: Set this to `TRUE` if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set this to `FALSE`.
        """
        pulumi.set(__self__, "queue_url", queue_url)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if use_base64 is not None:
            pulumi.set(__self__, "use_base64", use_base64)

    @property
    @pulumi.getter(name="queueUrl")
    def queue_url(self) -> str:
        """
        The URL of the SQS queue where the data is written.
        """
        return pulumi.get(self, "queue_url")

    @property
    @pulumi.getter
    def payload(self) -> Optional['outputs.DetectorModelPayload']:
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter(name="useBase64")
    def use_base64(self) -> Optional[bool]:
        """
        Set this to `TRUE` if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set this to `FALSE`.
        """
        return pulumi.get(self, "use_base64")


@pulumi.output_type
class DetectorModelState(dict):
    """
    Information that defines a state of a detector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stateName":
            suggest = "state_name"
        elif key == "onEnter":
            suggest = "on_enter"
        elif key == "onExit":
            suggest = "on_exit"
        elif key == "onInput":
            suggest = "on_input"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelState. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelState.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelState.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 state_name: str,
                 on_enter: Optional['outputs.DetectorModelOnEnter'] = None,
                 on_exit: Optional['outputs.DetectorModelOnExit'] = None,
                 on_input: Optional['outputs.DetectorModelOnInput'] = None):
        """
        Information that defines a state of a detector.
        :param str state_name: The name of the state.
        """
        pulumi.set(__self__, "state_name", state_name)
        if on_enter is not None:
            pulumi.set(__self__, "on_enter", on_enter)
        if on_exit is not None:
            pulumi.set(__self__, "on_exit", on_exit)
        if on_input is not None:
            pulumi.set(__self__, "on_input", on_input)

    @property
    @pulumi.getter(name="stateName")
    def state_name(self) -> str:
        """
        The name of the state.
        """
        return pulumi.get(self, "state_name")

    @property
    @pulumi.getter(name="onEnter")
    def on_enter(self) -> Optional['outputs.DetectorModelOnEnter']:
        return pulumi.get(self, "on_enter")

    @property
    @pulumi.getter(name="onExit")
    def on_exit(self) -> Optional['outputs.DetectorModelOnExit']:
        return pulumi.get(self, "on_exit")

    @property
    @pulumi.getter(name="onInput")
    def on_input(self) -> Optional['outputs.DetectorModelOnInput']:
        return pulumi.get(self, "on_input")


@pulumi.output_type
class DetectorModelTag(dict):
    """
    Tags to be applied to Input.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        Tags to be applied to Input.
        :param str key: Key of the Tag.
        :param str value: Value of the Tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Key of the Tag.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the Tag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DetectorModelTransitionEvent(dict):
    """
    Specifies the `actions `performed and the next `state` entered when a `condition` evaluates to `TRUE`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventName":
            suggest = "event_name"
        elif key == "nextState":
            suggest = "next_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorModelTransitionEvent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorModelTransitionEvent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorModelTransitionEvent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: str,
                 event_name: str,
                 next_state: str,
                 actions: Optional[Sequence['outputs.DetectorModelAction']] = None):
        """
        Specifies the `actions `performed and the next `state` entered when a `condition` evaluates to `TRUE`.
        :param str condition: A Boolean expression that when `TRUE` causes the `actions` to be performed and the `nextState` to be entered.
        :param str event_name: The name of the event.
        :param str next_state: The next state to enter.
        :param Sequence['DetectorModelAction'] actions: The actions to be performed.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "event_name", event_name)
        pulumi.set(__self__, "next_state", next_state)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)

    @property
    @pulumi.getter
    def condition(self) -> str:
        """
        A Boolean expression that when `TRUE` causes the `actions` to be performed and the `nextState` to be entered.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="eventName")
    def event_name(self) -> str:
        """
        The name of the event.
        """
        return pulumi.get(self, "event_name")

    @property
    @pulumi.getter(name="nextState")
    def next_state(self) -> str:
        """
        The next state to enter.
        """
        return pulumi.get(self, "next_state")

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence['outputs.DetectorModelAction']]:
        """
        The actions to be performed.
        """
        return pulumi.get(self, "actions")


@pulumi.output_type
class InputAttribute(dict):
    """
    The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the AWS IoT Events system using `BatchPutMessage`. Each such message contains a JSON payload, and those attributes (and their paired values) specified here are available for use in the `condition` expressions used by detectors that monitor this input.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jsonPath":
            suggest = "json_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InputAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InputAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InputAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 json_path: str):
        """
        The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the AWS IoT Events system using `BatchPutMessage`. Each such message contains a JSON payload, and those attributes (and their paired values) specified here are available for use in the `condition` expressions used by detectors that monitor this input.
        :param str json_path: An expression that specifies an attribute-value pair in a JSON structure. Use this to specify an attribute from the JSON payload that is made available by the input. Inputs are derived from messages sent to AWS IoT Events (`BatchPutMessage`). Each such message contains a JSON payload. The attribute (and its paired value) specified here are available for use in the `condition` expressions used by detectors.
               
               _Syntax_: `<field-name>.<field-name>...`
        """
        pulumi.set(__self__, "json_path", json_path)

    @property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> str:
        """
        An expression that specifies an attribute-value pair in a JSON structure. Use this to specify an attribute from the JSON payload that is made available by the input. Inputs are derived from messages sent to AWS IoT Events (`BatchPutMessage`). Each such message contains a JSON payload. The attribute (and its paired value) specified here are available for use in the `condition` expressions used by detectors.

        _Syntax_: `<field-name>.<field-name>...`
        """
        return pulumi.get(self, "json_path")


@pulumi.output_type
class InputInputDefinition(dict):
    """
    The definition of the input.
    """
    def __init__(__self__, *,
                 attributes: Sequence['outputs.InputAttribute']):
        """
        The definition of the input.
        :param Sequence['InputAttribute'] attributes: The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the AWS IoT Events system using `BatchPutMessage`. Each such message contains a JSON payload, and those attributes (and their paired values) specified here are available for use in the `condition` expressions used by detectors that monitor this input.
        """
        pulumi.set(__self__, "attributes", attributes)

    @property
    @pulumi.getter
    def attributes(self) -> Sequence['outputs.InputAttribute']:
        """
        The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the AWS IoT Events system using `BatchPutMessage`. Each such message contains a JSON payload, and those attributes (and their paired values) specified here are available for use in the `condition` expressions used by detectors that monitor this input.
        """
        return pulumi.get(self, "attributes")


@pulumi.output_type
class InputTag(dict):
    """
    Tags to be applied to Input.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        Tags to be applied to Input.
        :param str key: Key of the Tag.
        :param str value: Value of the Tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Key of the Tag.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the Tag.
        """
        return pulumi.get(self, "value")


