# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 certificate_authority_arn: pulumi.Input[str],
                 certificate_signing_request: pulumi.Input[str],
                 signing_algorithm: pulumi.Input[str],
                 validity: pulumi.Input['CertificateValidityArgs'],
                 api_passthrough: Optional[pulumi.Input['CertificateApiPassthroughArgs']] = None,
                 template_arn: Optional[pulumi.Input[str]] = None,
                 validity_not_before: Optional[pulumi.Input['CertificateValidityArgs']] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input[str] certificate_authority_arn: The Amazon Resource Name (ARN) for the private CA to issue the certificate.
        :param pulumi.Input[str] certificate_signing_request: The certificate signing request (CSR) for the Certificate.
        :param pulumi.Input[str] signing_algorithm: The name of the algorithm that will be used to sign the Certificate.
        :param pulumi.Input['CertificateValidityArgs'] validity: The time before which the Certificate will be valid.
        :param pulumi.Input['CertificateApiPassthroughArgs'] api_passthrough: These are fields to be overridden in a certificate at the time of issuance. These requires an API_Passthrough template be used or they will be ignored.
        :param pulumi.Input[str] template_arn: Specifies a custom configuration template to use when issuing a certificate. If this parameter is not provided, ACM Private CA defaults to the EndEntityCertificate/V1 template.
        :param pulumi.Input['CertificateValidityArgs'] validity_not_before: The time after which the Certificate will be valid.
        """
        pulumi.set(__self__, "certificate_authority_arn", certificate_authority_arn)
        pulumi.set(__self__, "certificate_signing_request", certificate_signing_request)
        pulumi.set(__self__, "signing_algorithm", signing_algorithm)
        pulumi.set(__self__, "validity", validity)
        if api_passthrough is not None:
            pulumi.set(__self__, "api_passthrough", api_passthrough)
        if template_arn is not None:
            pulumi.set(__self__, "template_arn", template_arn)
        if validity_not_before is not None:
            pulumi.set(__self__, "validity_not_before", validity_not_before)

    @property
    @pulumi.getter(name="certificateAuthorityArn")
    def certificate_authority_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) for the private CA to issue the certificate.
        """
        return pulumi.get(self, "certificate_authority_arn")

    @certificate_authority_arn.setter
    def certificate_authority_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_authority_arn", value)

    @property
    @pulumi.getter(name="certificateSigningRequest")
    def certificate_signing_request(self) -> pulumi.Input[str]:
        """
        The certificate signing request (CSR) for the Certificate.
        """
        return pulumi.get(self, "certificate_signing_request")

    @certificate_signing_request.setter
    def certificate_signing_request(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_signing_request", value)

    @property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> pulumi.Input[str]:
        """
        The name of the algorithm that will be used to sign the Certificate.
        """
        return pulumi.get(self, "signing_algorithm")

    @signing_algorithm.setter
    def signing_algorithm(self, value: pulumi.Input[str]):
        pulumi.set(self, "signing_algorithm", value)

    @property
    @pulumi.getter
    def validity(self) -> pulumi.Input['CertificateValidityArgs']:
        """
        The time before which the Certificate will be valid.
        """
        return pulumi.get(self, "validity")

    @validity.setter
    def validity(self, value: pulumi.Input['CertificateValidityArgs']):
        pulumi.set(self, "validity", value)

    @property
    @pulumi.getter(name="apiPassthrough")
    def api_passthrough(self) -> Optional[pulumi.Input['CertificateApiPassthroughArgs']]:
        """
        These are fields to be overridden in a certificate at the time of issuance. These requires an API_Passthrough template be used or they will be ignored.
        """
        return pulumi.get(self, "api_passthrough")

    @api_passthrough.setter
    def api_passthrough(self, value: Optional[pulumi.Input['CertificateApiPassthroughArgs']]):
        pulumi.set(self, "api_passthrough", value)

    @property
    @pulumi.getter(name="templateArn")
    def template_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a custom configuration template to use when issuing a certificate. If this parameter is not provided, ACM Private CA defaults to the EndEntityCertificate/V1 template.
        """
        return pulumi.get(self, "template_arn")

    @template_arn.setter
    def template_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_arn", value)

    @property
    @pulumi.getter(name="validityNotBefore")
    def validity_not_before(self) -> Optional[pulumi.Input['CertificateValidityArgs']]:
        """
        The time after which the Certificate will be valid.
        """
        return pulumi.get(self, "validity_not_before")

    @validity_not_before.setter
    def validity_not_before(self, value: Optional[pulumi.Input['CertificateValidityArgs']]):
        pulumi.set(self, "validity_not_before", value)


class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_passthrough: Optional[pulumi.Input[pulumi.InputType['CertificateApiPassthroughArgs']]] = None,
                 certificate_authority_arn: Optional[pulumi.Input[str]] = None,
                 certificate_signing_request: Optional[pulumi.Input[str]] = None,
                 signing_algorithm: Optional[pulumi.Input[str]] = None,
                 template_arn: Optional[pulumi.Input[str]] = None,
                 validity: Optional[pulumi.Input[pulumi.InputType['CertificateValidityArgs']]] = None,
                 validity_not_before: Optional[pulumi.Input[pulumi.InputType['CertificateValidityArgs']]] = None,
                 __props__=None):
        """
        A certificate issued via a private certificate authority

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['CertificateApiPassthroughArgs']] api_passthrough: These are fields to be overridden in a certificate at the time of issuance. These requires an API_Passthrough template be used or they will be ignored.
        :param pulumi.Input[str] certificate_authority_arn: The Amazon Resource Name (ARN) for the private CA to issue the certificate.
        :param pulumi.Input[str] certificate_signing_request: The certificate signing request (CSR) for the Certificate.
        :param pulumi.Input[str] signing_algorithm: The name of the algorithm that will be used to sign the Certificate.
        :param pulumi.Input[str] template_arn: Specifies a custom configuration template to use when issuing a certificate. If this parameter is not provided, ACM Private CA defaults to the EndEntityCertificate/V1 template.
        :param pulumi.Input[pulumi.InputType['CertificateValidityArgs']] validity: The time before which the Certificate will be valid.
        :param pulumi.Input[pulumi.InputType['CertificateValidityArgs']] validity_not_before: The time after which the Certificate will be valid.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A certificate issued via a private certificate authority

        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_passthrough: Optional[pulumi.Input[pulumi.InputType['CertificateApiPassthroughArgs']]] = None,
                 certificate_authority_arn: Optional[pulumi.Input[str]] = None,
                 certificate_signing_request: Optional[pulumi.Input[str]] = None,
                 signing_algorithm: Optional[pulumi.Input[str]] = None,
                 template_arn: Optional[pulumi.Input[str]] = None,
                 validity: Optional[pulumi.Input[pulumi.InputType['CertificateValidityArgs']]] = None,
                 validity_not_before: Optional[pulumi.Input[pulumi.InputType['CertificateValidityArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            __props__.__dict__["api_passthrough"] = api_passthrough
            if certificate_authority_arn is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_authority_arn'")
            __props__.__dict__["certificate_authority_arn"] = certificate_authority_arn
            if certificate_signing_request is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_signing_request'")
            __props__.__dict__["certificate_signing_request"] = certificate_signing_request
            if signing_algorithm is None and not opts.urn:
                raise TypeError("Missing required property 'signing_algorithm'")
            __props__.__dict__["signing_algorithm"] = signing_algorithm
            __props__.__dict__["template_arn"] = template_arn
            if validity is None and not opts.urn:
                raise TypeError("Missing required property 'validity'")
            __props__.__dict__["validity"] = validity
            __props__.__dict__["validity_not_before"] = validity_not_before
            __props__.__dict__["arn"] = None
            __props__.__dict__["certificate"] = None
        super(Certificate, __self__).__init__(
            'aws-native:acmpca:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CertificateArgs.__new__(CertificateArgs)

        __props__.__dict__["api_passthrough"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["certificate"] = None
        __props__.__dict__["certificate_authority_arn"] = None
        __props__.__dict__["certificate_signing_request"] = None
        __props__.__dict__["signing_algorithm"] = None
        __props__.__dict__["template_arn"] = None
        __props__.__dict__["validity"] = None
        __props__.__dict__["validity_not_before"] = None
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiPassthrough")
    def api_passthrough(self) -> pulumi.Output[Optional['outputs.CertificateApiPassthrough']]:
        """
        These are fields to be overridden in a certificate at the time of issuance. These requires an API_Passthrough template be used or they will be ignored.
        """
        return pulumi.get(self, "api_passthrough")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the issued certificate.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[str]:
        """
        The issued certificate in base 64 PEM-encoded format.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificateAuthorityArn")
    def certificate_authority_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) for the private CA to issue the certificate.
        """
        return pulumi.get(self, "certificate_authority_arn")

    @property
    @pulumi.getter(name="certificateSigningRequest")
    def certificate_signing_request(self) -> pulumi.Output[str]:
        """
        The certificate signing request (CSR) for the Certificate.
        """
        return pulumi.get(self, "certificate_signing_request")

    @property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> pulumi.Output[str]:
        """
        The name of the algorithm that will be used to sign the Certificate.
        """
        return pulumi.get(self, "signing_algorithm")

    @property
    @pulumi.getter(name="templateArn")
    def template_arn(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies a custom configuration template to use when issuing a certificate. If this parameter is not provided, ACM Private CA defaults to the EndEntityCertificate/V1 template.
        """
        return pulumi.get(self, "template_arn")

    @property
    @pulumi.getter
    def validity(self) -> pulumi.Output['outputs.CertificateValidity']:
        """
        The time before which the Certificate will be valid.
        """
        return pulumi.get(self, "validity")

    @property
    @pulumi.getter(name="validityNotBefore")
    def validity_not_before(self) -> pulumi.Output[Optional['outputs.CertificateValidity']]:
        """
        The time after which the Certificate will be valid.
        """
        return pulumi.get(self, "validity_not_before")

