# Generated by Django 3.1.2 on 2020-10-29 15:01

from django.db import migrations, models
import django.db.models.deletion
import django.db.models.expressions
import django.utils.timezone
import isc_common.fields.related


class Migration(migrations.Migration):

    dependencies = [
        ('ckk', '0256_auto_20201014_1237'),
    ]

    operations = [
        migrations.CreateModel(
            name='Item_refs_location',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='Дата мягкого удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('child', isc_common.fields.related.ForeignKeyProtect(on_delete=django.db.models.deletion.PROTECT, related_name='Item_refs_location_child', to='ckk.item')),
                ('location', isc_common.fields.related.ForeignKeyProtect(on_delete=django.db.models.deletion.PROTECT, to='ckk.locations')),
                ('parent', isc_common.fields.related.ForeignKeyProtect(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='Item_refs_location_parent', to='ckk.item')),
            ],
            options={
                'verbose_name': 'Item_refs_location',
            },
        ),
        migrations.AddConstraint(
            model_name='item_refs_location',
            constraint=models.CheckConstraint(check=models.Q(_negated=True, child=django.db.models.expressions.F('parent')), name='Item_refs_location_not_circulate_refs'),
        ),
        migrations.AddConstraint(
            model_name='item_refs_location',
            constraint=models.UniqueConstraint(condition=models.Q(parent_id=None), fields=('child_id',), name='Item_refs_location_unique_constraint_0'),
        ),
        migrations.AddConstraint(
            model_name='item_refs_location',
            constraint=models.UniqueConstraint(fields=('child_id', 'parent_id'), name='Item_refs_location_unique_constraint_1'),
        ),
    ]
