import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { CreateAssociationBatchRequest, CreateAssociationBatchResult } from "../models/models_0";
import { ServiceInputTypes, ServiceOutputTypes, SSMClientResolvedConfig } from "../SSMClient";
export interface CreateAssociationBatchCommandInput extends CreateAssociationBatchRequest {
}
export interface CreateAssociationBatchCommandOutput extends CreateAssociationBatchResult, __MetadataBearer {
}
/**
 * <p>Associates the specified Amazon Web Services Systems Manager document (SSM document) with the specified managed nodes
 *    or targets.</p>
 *          <p>When you associate a document with one or more managed nodes using IDs or tags, Amazon Web Services Systems Manager
 *    Agent (SSM Agent) running on the managed node processes the document and configures the node as
 *    specified.</p>
 *          <p>If you associate a document with a managed node that already has an associated document, the
 *    system returns the AssociationAlreadyExists exception.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { SSMClient, CreateAssociationBatchCommand } from "@aws-sdk/client-ssm"; // ES Modules import
 * // const { SSMClient, CreateAssociationBatchCommand } = require("@aws-sdk/client-ssm"); // CommonJS import
 * const client = new SSMClient(config);
 * const command = new CreateAssociationBatchCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link CreateAssociationBatchCommandInput} for command's `input` shape.
 * @see {@link CreateAssociationBatchCommandOutput} for command's `response` shape.
 * @see {@link SSMClientResolvedConfig | config} for SSMClient's `config` shape.
 *
 */
export declare class CreateAssociationBatchCommand extends $Command<CreateAssociationBatchCommandInput, CreateAssociationBatchCommandOutput, SSMClientResolvedConfig> {
    readonly input: CreateAssociationBatchCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: CreateAssociationBatchCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: SSMClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateAssociationBatchCommandInput, CreateAssociationBatchCommandOutput>;
    private serialize;
    private deserialize;
}
