import { SENSITIVE_STRING } from "@aws-sdk/smithy-client";
import { SSMServiceException as __BaseException } from "./SSMServiceException";
export var ResourceTypeForTagging;
(function (ResourceTypeForTagging) {
    ResourceTypeForTagging["ASSOCIATION"] = "Association";
    ResourceTypeForTagging["AUTOMATION"] = "Automation";
    ResourceTypeForTagging["DOCUMENT"] = "Document";
    ResourceTypeForTagging["MAINTENANCE_WINDOW"] = "MaintenanceWindow";
    ResourceTypeForTagging["MANAGED_INSTANCE"] = "ManagedInstance";
    ResourceTypeForTagging["OPSMETADATA"] = "OpsMetadata";
    ResourceTypeForTagging["OPS_ITEM"] = "OpsItem";
    ResourceTypeForTagging["PARAMETER"] = "Parameter";
    ResourceTypeForTagging["PATCH_BASELINE"] = "PatchBaseline";
})(ResourceTypeForTagging || (ResourceTypeForTagging = {}));
export class InternalServerError extends __BaseException {
    constructor(opts) {
        super({
            name: "InternalServerError",
            $fault: "server",
            ...opts,
        });
        this.name = "InternalServerError";
        this.$fault = "server";
        Object.setPrototypeOf(this, InternalServerError.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidResourceId extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidResourceId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidResourceId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidResourceId.prototype);
    }
}
export class InvalidResourceType extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidResourceType",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidResourceType";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidResourceType.prototype);
    }
}
export class TooManyTagsError extends __BaseException {
    constructor(opts) {
        super({
            name: "TooManyTagsError",
            $fault: "client",
            ...opts,
        });
        this.name = "TooManyTagsError";
        this.$fault = "client";
        Object.setPrototypeOf(this, TooManyTagsError.prototype);
    }
}
export class TooManyUpdates extends __BaseException {
    constructor(opts) {
        super({
            name: "TooManyUpdates",
            $fault: "client",
            ...opts,
        });
        this.name = "TooManyUpdates";
        this.$fault = "client";
        Object.setPrototypeOf(this, TooManyUpdates.prototype);
        this.Message = opts.Message;
    }
}
export var ExternalAlarmState;
(function (ExternalAlarmState) {
    ExternalAlarmState["ALARM"] = "ALARM";
    ExternalAlarmState["UNKNOWN"] = "UNKNOWN";
})(ExternalAlarmState || (ExternalAlarmState = {}));
export class AlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "AlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "AlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AlreadyExistsException.prototype);
        this.Message = opts.Message;
    }
}
export class OpsItemInvalidParameterException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsItemInvalidParameterException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemInvalidParameterException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemInvalidParameterException.prototype);
        this.ParameterNames = opts.ParameterNames;
        this.Message = opts.Message;
    }
}
export class OpsItemLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsItemLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemLimitExceededException.prototype);
        this.ResourceTypes = opts.ResourceTypes;
        this.Limit = opts.Limit;
        this.LimitType = opts.LimitType;
        this.Message = opts.Message;
    }
}
export class OpsItemNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsItemNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export class OpsItemRelatedItemAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsItemRelatedItemAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemRelatedItemAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemRelatedItemAlreadyExistsException.prototype);
        this.Message = opts.Message;
        this.ResourceUri = opts.ResourceUri;
        this.OpsItemId = opts.OpsItemId;
    }
}
export class DuplicateInstanceId extends __BaseException {
    constructor(opts) {
        super({
            name: "DuplicateInstanceId",
            $fault: "client",
            ...opts,
        });
        this.name = "DuplicateInstanceId";
        this.$fault = "client";
        Object.setPrototypeOf(this, DuplicateInstanceId.prototype);
    }
}
export class InvalidCommandId extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidCommandId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidCommandId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidCommandId.prototype);
    }
}
export class InvalidInstanceId extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidInstanceId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInstanceId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInstanceId.prototype);
        this.Message = opts.Message;
    }
}
export class DoesNotExistException extends __BaseException {
    constructor(opts) {
        super({
            name: "DoesNotExistException",
            $fault: "client",
            ...opts,
        });
        this.name = "DoesNotExistException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DoesNotExistException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidParameters extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidParameters",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidParameters";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidParameters.prototype);
        this.Message = opts.Message;
    }
}
export class AssociationAlreadyExists extends __BaseException {
    constructor(opts) {
        super({
            name: "AssociationAlreadyExists",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationAlreadyExists";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationAlreadyExists.prototype);
    }
}
export class AssociationLimitExceeded extends __BaseException {
    constructor(opts) {
        super({
            name: "AssociationLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationLimitExceeded.prototype);
    }
}
export var AssociationComplianceSeverity;
(function (AssociationComplianceSeverity) {
    AssociationComplianceSeverity["Critical"] = "CRITICAL";
    AssociationComplianceSeverity["High"] = "HIGH";
    AssociationComplianceSeverity["Low"] = "LOW";
    AssociationComplianceSeverity["Medium"] = "MEDIUM";
    AssociationComplianceSeverity["Unspecified"] = "UNSPECIFIED";
})(AssociationComplianceSeverity || (AssociationComplianceSeverity = {}));
export var AssociationSyncCompliance;
(function (AssociationSyncCompliance) {
    AssociationSyncCompliance["Auto"] = "AUTO";
    AssociationSyncCompliance["Manual"] = "MANUAL";
})(AssociationSyncCompliance || (AssociationSyncCompliance = {}));
export var AssociationStatusName;
(function (AssociationStatusName) {
    AssociationStatusName["Failed"] = "Failed";
    AssociationStatusName["Pending"] = "Pending";
    AssociationStatusName["Success"] = "Success";
})(AssociationStatusName || (AssociationStatusName = {}));
export class InvalidDocument extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDocument",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocument";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocument.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidDocumentVersion extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDocumentVersion",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentVersion";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentVersion.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidOutputLocation extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidOutputLocation",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidOutputLocation";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidOutputLocation.prototype);
    }
}
export class InvalidSchedule extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidSchedule",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidSchedule";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidSchedule.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidTag extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidTag",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTag";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTag.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidTarget extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidTarget",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTarget";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTarget.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidTargetMaps extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidTargetMaps",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTargetMaps";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTargetMaps.prototype);
        this.Message = opts.Message;
    }
}
export class UnsupportedPlatformType extends __BaseException {
    constructor(opts) {
        super({
            name: "UnsupportedPlatformType",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedPlatformType";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedPlatformType.prototype);
        this.Message = opts.Message;
    }
}
export var Fault;
(function (Fault) {
    Fault["Client"] = "Client";
    Fault["Server"] = "Server";
    Fault["Unknown"] = "Unknown";
})(Fault || (Fault = {}));
export var AttachmentsSourceKey;
(function (AttachmentsSourceKey) {
    AttachmentsSourceKey["AttachmentReference"] = "AttachmentReference";
    AttachmentsSourceKey["S3FileUrl"] = "S3FileUrl";
    AttachmentsSourceKey["SourceUrl"] = "SourceUrl";
})(AttachmentsSourceKey || (AttachmentsSourceKey = {}));
export var DocumentFormat;
(function (DocumentFormat) {
    DocumentFormat["JSON"] = "JSON";
    DocumentFormat["TEXT"] = "TEXT";
    DocumentFormat["YAML"] = "YAML";
})(DocumentFormat || (DocumentFormat = {}));
export var DocumentType;
(function (DocumentType) {
    DocumentType["ApplicationConfiguration"] = "ApplicationConfiguration";
    DocumentType["ApplicationConfigurationSchema"] = "ApplicationConfigurationSchema";
    DocumentType["Automation"] = "Automation";
    DocumentType["ChangeCalendar"] = "ChangeCalendar";
    DocumentType["ChangeTemplate"] = "Automation.ChangeTemplate";
    DocumentType["CloudFormation"] = "CloudFormation";
    DocumentType["Command"] = "Command";
    DocumentType["ConformancePackTemplate"] = "ConformancePackTemplate";
    DocumentType["DeploymentStrategy"] = "DeploymentStrategy";
    DocumentType["Package"] = "Package";
    DocumentType["Policy"] = "Policy";
    DocumentType["ProblemAnalysis"] = "ProblemAnalysis";
    DocumentType["ProblemAnalysisTemplate"] = "ProblemAnalysisTemplate";
    DocumentType["QuickSetup"] = "QuickSetup";
    DocumentType["Session"] = "Session";
})(DocumentType || (DocumentType = {}));
export var DocumentHashType;
(function (DocumentHashType) {
    DocumentHashType["SHA1"] = "Sha1";
    DocumentHashType["SHA256"] = "Sha256";
})(DocumentHashType || (DocumentHashType = {}));
export var DocumentParameterType;
(function (DocumentParameterType) {
    DocumentParameterType["String"] = "String";
    DocumentParameterType["StringList"] = "StringList";
})(DocumentParameterType || (DocumentParameterType = {}));
export var PlatformType;
(function (PlatformType) {
    PlatformType["LINUX"] = "Linux";
    PlatformType["MACOS"] = "MacOS";
    PlatformType["WINDOWS"] = "Windows";
})(PlatformType || (PlatformType = {}));
export var ReviewStatus;
(function (ReviewStatus) {
    ReviewStatus["APPROVED"] = "APPROVED";
    ReviewStatus["NOT_REVIEWED"] = "NOT_REVIEWED";
    ReviewStatus["PENDING"] = "PENDING";
    ReviewStatus["REJECTED"] = "REJECTED";
})(ReviewStatus || (ReviewStatus = {}));
export var DocumentStatus;
(function (DocumentStatus) {
    DocumentStatus["Active"] = "Active";
    DocumentStatus["Creating"] = "Creating";
    DocumentStatus["Deleting"] = "Deleting";
    DocumentStatus["Failed"] = "Failed";
    DocumentStatus["Updating"] = "Updating";
})(DocumentStatus || (DocumentStatus = {}));
export class DocumentAlreadyExists extends __BaseException {
    constructor(opts) {
        super({
            name: "DocumentAlreadyExists",
            $fault: "client",
            ...opts,
        });
        this.name = "DocumentAlreadyExists";
        this.$fault = "client";
        Object.setPrototypeOf(this, DocumentAlreadyExists.prototype);
        this.Message = opts.Message;
    }
}
export class DocumentLimitExceeded extends __BaseException {
    constructor(opts) {
        super({
            name: "DocumentLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "DocumentLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, DocumentLimitExceeded.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidDocumentContent extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDocumentContent",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentContent";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentContent.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidDocumentSchemaVersion extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDocumentSchemaVersion",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentSchemaVersion";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentSchemaVersion.prototype);
        this.Message = opts.Message;
    }
}
export class MaxDocumentSizeExceeded extends __BaseException {
    constructor(opts) {
        super({
            name: "MaxDocumentSizeExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "MaxDocumentSizeExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, MaxDocumentSizeExceeded.prototype);
        this.Message = opts.Message;
    }
}
export class IdempotentParameterMismatch extends __BaseException {
    constructor(opts) {
        super({
            name: "IdempotentParameterMismatch",
            $fault: "client",
            ...opts,
        });
        this.name = "IdempotentParameterMismatch";
        this.$fault = "client";
        Object.setPrototypeOf(this, IdempotentParameterMismatch.prototype);
        this.Message = opts.Message;
    }
}
export class ResourceLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceLimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
export var OpsItemDataType;
(function (OpsItemDataType) {
    OpsItemDataType["SEARCHABLE_STRING"] = "SearchableString";
    OpsItemDataType["STRING"] = "String";
})(OpsItemDataType || (OpsItemDataType = {}));
export class OpsItemAccessDeniedException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsItemAccessDeniedException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemAccessDeniedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemAccessDeniedException.prototype);
        this.Message = opts.Message;
    }
}
export class OpsItemAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsItemAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemAlreadyExistsException.prototype);
        this.Message = opts.Message;
        this.OpsItemId = opts.OpsItemId;
    }
}
export class OpsMetadataAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsMetadataAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataAlreadyExistsException.prototype);
    }
}
export class OpsMetadataInvalidArgumentException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsMetadataInvalidArgumentException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataInvalidArgumentException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataInvalidArgumentException.prototype);
    }
}
export class OpsMetadataLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsMetadataLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataLimitExceededException.prototype);
    }
}
export class OpsMetadataTooManyUpdatesException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsMetadataTooManyUpdatesException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataTooManyUpdatesException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataTooManyUpdatesException.prototype);
    }
}
export var PatchComplianceLevel;
(function (PatchComplianceLevel) {
    PatchComplianceLevel["Critical"] = "CRITICAL";
    PatchComplianceLevel["High"] = "HIGH";
    PatchComplianceLevel["Informational"] = "INFORMATIONAL";
    PatchComplianceLevel["Low"] = "LOW";
    PatchComplianceLevel["Medium"] = "MEDIUM";
    PatchComplianceLevel["Unspecified"] = "UNSPECIFIED";
})(PatchComplianceLevel || (PatchComplianceLevel = {}));
export var PatchFilterKey;
(function (PatchFilterKey) {
    PatchFilterKey["AdvisoryId"] = "ADVISORY_ID";
    PatchFilterKey["Arch"] = "ARCH";
    PatchFilterKey["BugzillaId"] = "BUGZILLA_ID";
    PatchFilterKey["CVEId"] = "CVE_ID";
    PatchFilterKey["Classification"] = "CLASSIFICATION";
    PatchFilterKey["Epoch"] = "EPOCH";
    PatchFilterKey["MsrcSeverity"] = "MSRC_SEVERITY";
    PatchFilterKey["Name"] = "NAME";
    PatchFilterKey["PatchId"] = "PATCH_ID";
    PatchFilterKey["PatchSet"] = "PATCH_SET";
    PatchFilterKey["Priority"] = "PRIORITY";
    PatchFilterKey["Product"] = "PRODUCT";
    PatchFilterKey["ProductFamily"] = "PRODUCT_FAMILY";
    PatchFilterKey["Release"] = "RELEASE";
    PatchFilterKey["Repository"] = "REPOSITORY";
    PatchFilterKey["Section"] = "SECTION";
    PatchFilterKey["Security"] = "SECURITY";
    PatchFilterKey["Severity"] = "SEVERITY";
    PatchFilterKey["Version"] = "VERSION";
})(PatchFilterKey || (PatchFilterKey = {}));
export var OperatingSystem;
(function (OperatingSystem) {
    OperatingSystem["AmazonLinux"] = "AMAZON_LINUX";
    OperatingSystem["AmazonLinux2"] = "AMAZON_LINUX_2";
    OperatingSystem["AmazonLinux2022"] = "AMAZON_LINUX_2022";
    OperatingSystem["CentOS"] = "CENTOS";
    OperatingSystem["Debian"] = "DEBIAN";
    OperatingSystem["MacOS"] = "MACOS";
    OperatingSystem["OracleLinux"] = "ORACLE_LINUX";
    OperatingSystem["Raspbian"] = "RASPBIAN";
    OperatingSystem["RedhatEnterpriseLinux"] = "REDHAT_ENTERPRISE_LINUX";
    OperatingSystem["Rocky_Linux"] = "ROCKY_LINUX";
    OperatingSystem["Suse"] = "SUSE";
    OperatingSystem["Ubuntu"] = "UBUNTU";
    OperatingSystem["Windows"] = "WINDOWS";
})(OperatingSystem || (OperatingSystem = {}));
export var PatchAction;
(function (PatchAction) {
    PatchAction["AllowAsDependency"] = "ALLOW_AS_DEPENDENCY";
    PatchAction["Block"] = "BLOCK";
})(PatchAction || (PatchAction = {}));
export var ResourceDataSyncS3Format;
(function (ResourceDataSyncS3Format) {
    ResourceDataSyncS3Format["JSON_SERDE"] = "JsonSerDe";
})(ResourceDataSyncS3Format || (ResourceDataSyncS3Format = {}));
export class ResourceDataSyncAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceDataSyncAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceDataSyncAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceDataSyncAlreadyExistsException.prototype);
        this.SyncName = opts.SyncName;
    }
}
export class ResourceDataSyncCountExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceDataSyncCountExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceDataSyncCountExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceDataSyncCountExceededException.prototype);
        this.Message = opts.Message;
    }
}
export class ResourceDataSyncInvalidConfigurationException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceDataSyncInvalidConfigurationException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceDataSyncInvalidConfigurationException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceDataSyncInvalidConfigurationException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidActivation extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidActivation",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidActivation";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidActivation.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidActivationId extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidActivationId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidActivationId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidActivationId.prototype);
        this.Message = opts.Message;
    }
}
export class AssociationDoesNotExist extends __BaseException {
    constructor(opts) {
        super({
            name: "AssociationDoesNotExist",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationDoesNotExist";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationDoesNotExist.prototype);
        this.Message = opts.Message;
    }
}
export class AssociatedInstances extends __BaseException {
    constructor(opts) {
        super({
            name: "AssociatedInstances",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociatedInstances";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociatedInstances.prototype);
    }
}
export class InvalidDocumentOperation extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDocumentOperation",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentOperation";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentOperation.prototype);
        this.Message = opts.Message;
    }
}
export var InventorySchemaDeleteOption;
(function (InventorySchemaDeleteOption) {
    InventorySchemaDeleteOption["DELETE_SCHEMA"] = "DeleteSchema";
    InventorySchemaDeleteOption["DISABLE_SCHEMA"] = "DisableSchema";
})(InventorySchemaDeleteOption || (InventorySchemaDeleteOption = {}));
export class InvalidDeleteInventoryParametersException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDeleteInventoryParametersException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDeleteInventoryParametersException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDeleteInventoryParametersException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidInventoryRequestException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidInventoryRequestException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInventoryRequestException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInventoryRequestException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidOptionException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidOptionException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidOptionException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidOptionException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidTypeNameException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidTypeNameException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTypeNameException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTypeNameException.prototype);
        this.Message = opts.Message;
    }
}
export class OpsMetadataNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsMetadataNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataNotFoundException.prototype);
    }
}
export class ParameterNotFound extends __BaseException {
    constructor(opts) {
        super({
            name: "ParameterNotFound",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterNotFound";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterNotFound.prototype);
    }
}
export class ResourceInUseException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceInUseException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceInUseException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceInUseException.prototype);
        this.Message = opts.Message;
    }
}
export class ResourceDataSyncNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceDataSyncNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceDataSyncNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceDataSyncNotFoundException.prototype);
        this.SyncName = opts.SyncName;
        this.SyncType = opts.SyncType;
        this.Message = opts.Message;
    }
}
export class ResourcePolicyConflictException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourcePolicyConflictException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourcePolicyConflictException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourcePolicyConflictException.prototype);
        this.Message = opts.Message;
    }
}
export class ResourcePolicyInvalidParameterException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourcePolicyInvalidParameterException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourcePolicyInvalidParameterException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourcePolicyInvalidParameterException.prototype);
        this.ParameterNames = opts.ParameterNames;
        this.Message = opts.Message;
    }
}
export class TargetInUseException extends __BaseException {
    constructor(opts) {
        super({
            name: "TargetInUseException",
            $fault: "client",
            ...opts,
        });
        this.name = "TargetInUseException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TargetInUseException.prototype);
        this.Message = opts.Message;
    }
}
export var DescribeActivationsFilterKeys;
(function (DescribeActivationsFilterKeys) {
    DescribeActivationsFilterKeys["ACTIVATION_IDS"] = "ActivationIds";
    DescribeActivationsFilterKeys["DEFAULT_INSTANCE_NAME"] = "DefaultInstanceName";
    DescribeActivationsFilterKeys["IAM_ROLE"] = "IamRole";
})(DescribeActivationsFilterKeys || (DescribeActivationsFilterKeys = {}));
export class InvalidFilter extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidFilter",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidFilter";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidFilter.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidNextToken extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidNextToken",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidNextToken";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidNextToken.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidAssociationVersion extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidAssociationVersion",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAssociationVersion";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAssociationVersion.prototype);
        this.Message = opts.Message;
    }
}
export var AssociationExecutionFilterKey;
(function (AssociationExecutionFilterKey) {
    AssociationExecutionFilterKey["CreatedTime"] = "CreatedTime";
    AssociationExecutionFilterKey["ExecutionId"] = "ExecutionId";
    AssociationExecutionFilterKey["Status"] = "Status";
})(AssociationExecutionFilterKey || (AssociationExecutionFilterKey = {}));
export var AssociationFilterOperatorType;
(function (AssociationFilterOperatorType) {
    AssociationFilterOperatorType["Equal"] = "EQUAL";
    AssociationFilterOperatorType["GreaterThan"] = "GREATER_THAN";
    AssociationFilterOperatorType["LessThan"] = "LESS_THAN";
})(AssociationFilterOperatorType || (AssociationFilterOperatorType = {}));
export class AssociationExecutionDoesNotExist extends __BaseException {
    constructor(opts) {
        super({
            name: "AssociationExecutionDoesNotExist",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationExecutionDoesNotExist";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationExecutionDoesNotExist.prototype);
        this.Message = opts.Message;
    }
}
export var AssociationExecutionTargetsFilterKey;
(function (AssociationExecutionTargetsFilterKey) {
    AssociationExecutionTargetsFilterKey["ResourceId"] = "ResourceId";
    AssociationExecutionTargetsFilterKey["ResourceType"] = "ResourceType";
    AssociationExecutionTargetsFilterKey["Status"] = "Status";
})(AssociationExecutionTargetsFilterKey || (AssociationExecutionTargetsFilterKey = {}));
export var AutomationExecutionFilterKey;
(function (AutomationExecutionFilterKey) {
    AutomationExecutionFilterKey["AUTOMATION_SUBTYPE"] = "AutomationSubtype";
    AutomationExecutionFilterKey["AUTOMATION_TYPE"] = "AutomationType";
    AutomationExecutionFilterKey["CURRENT_ACTION"] = "CurrentAction";
    AutomationExecutionFilterKey["DOCUMENT_NAME_PREFIX"] = "DocumentNamePrefix";
    AutomationExecutionFilterKey["EXECUTION_ID"] = "ExecutionId";
    AutomationExecutionFilterKey["EXECUTION_STATUS"] = "ExecutionStatus";
    AutomationExecutionFilterKey["OPS_ITEM_ID"] = "OpsItemId";
    AutomationExecutionFilterKey["PARENT_EXECUTION_ID"] = "ParentExecutionId";
    AutomationExecutionFilterKey["START_TIME_AFTER"] = "StartTimeAfter";
    AutomationExecutionFilterKey["START_TIME_BEFORE"] = "StartTimeBefore";
    AutomationExecutionFilterKey["TAG_KEY"] = "TagKey";
    AutomationExecutionFilterKey["TARGET_RESOURCE_GROUP"] = "TargetResourceGroup";
})(AutomationExecutionFilterKey || (AutomationExecutionFilterKey = {}));
export var AutomationExecutionStatus;
(function (AutomationExecutionStatus) {
    AutomationExecutionStatus["APPROVED"] = "Approved";
    AutomationExecutionStatus["CANCELLED"] = "Cancelled";
    AutomationExecutionStatus["CANCELLING"] = "Cancelling";
    AutomationExecutionStatus["CHANGE_CALENDAR_OVERRIDE_APPROVED"] = "ChangeCalendarOverrideApproved";
    AutomationExecutionStatus["CHANGE_CALENDAR_OVERRIDE_REJECTED"] = "ChangeCalendarOverrideRejected";
    AutomationExecutionStatus["COMPLETED_WITH_FAILURE"] = "CompletedWithFailure";
    AutomationExecutionStatus["COMPLETED_WITH_SUCCESS"] = "CompletedWithSuccess";
    AutomationExecutionStatus["FAILED"] = "Failed";
    AutomationExecutionStatus["INPROGRESS"] = "InProgress";
    AutomationExecutionStatus["PENDING"] = "Pending";
    AutomationExecutionStatus["PENDING_APPROVAL"] = "PendingApproval";
    AutomationExecutionStatus["PENDING_CHANGE_CALENDAR_OVERRIDE"] = "PendingChangeCalendarOverride";
    AutomationExecutionStatus["REJECTED"] = "Rejected";
    AutomationExecutionStatus["RUNBOOK_INPROGRESS"] = "RunbookInProgress";
    AutomationExecutionStatus["SCHEDULED"] = "Scheduled";
    AutomationExecutionStatus["SUCCESS"] = "Success";
    AutomationExecutionStatus["TIMEDOUT"] = "TimedOut";
    AutomationExecutionStatus["WAITING"] = "Waiting";
})(AutomationExecutionStatus || (AutomationExecutionStatus = {}));
export var AutomationSubtype;
(function (AutomationSubtype) {
    AutomationSubtype["ChangeRequest"] = "ChangeRequest";
})(AutomationSubtype || (AutomationSubtype = {}));
export var AutomationType;
(function (AutomationType) {
    AutomationType["CrossAccount"] = "CrossAccount";
    AutomationType["Local"] = "Local";
})(AutomationType || (AutomationType = {}));
export var ExecutionMode;
(function (ExecutionMode) {
    ExecutionMode["Auto"] = "Auto";
    ExecutionMode["Interactive"] = "Interactive";
})(ExecutionMode || (ExecutionMode = {}));
export class InvalidFilterKey extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidFilterKey",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidFilterKey";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidFilterKey.prototype);
    }
}
export class InvalidFilterValue extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidFilterValue",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidFilterValue";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidFilterValue.prototype);
        this.Message = opts.Message;
    }
}
export class AutomationExecutionNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "AutomationExecutionNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "AutomationExecutionNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AutomationExecutionNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export var StepExecutionFilterKey;
(function (StepExecutionFilterKey) {
    StepExecutionFilterKey["ACTION"] = "Action";
    StepExecutionFilterKey["START_TIME_AFTER"] = "StartTimeAfter";
    StepExecutionFilterKey["START_TIME_BEFORE"] = "StartTimeBefore";
    StepExecutionFilterKey["STEP_EXECUTION_ID"] = "StepExecutionId";
    StepExecutionFilterKey["STEP_EXECUTION_STATUS"] = "StepExecutionStatus";
    StepExecutionFilterKey["STEP_NAME"] = "StepName";
})(StepExecutionFilterKey || (StepExecutionFilterKey = {}));
export var DocumentPermissionType;
(function (DocumentPermissionType) {
    DocumentPermissionType["SHARE"] = "Share";
})(DocumentPermissionType || (DocumentPermissionType = {}));
export class InvalidPermissionType extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidPermissionType",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidPermissionType";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidPermissionType.prototype);
        this.Message = opts.Message;
    }
}
export var PatchDeploymentStatus;
(function (PatchDeploymentStatus) {
    PatchDeploymentStatus["Approved"] = "APPROVED";
    PatchDeploymentStatus["ExplicitApproved"] = "EXPLICIT_APPROVED";
    PatchDeploymentStatus["ExplicitRejected"] = "EXPLICIT_REJECTED";
    PatchDeploymentStatus["PendingApproval"] = "PENDING_APPROVAL";
})(PatchDeploymentStatus || (PatchDeploymentStatus = {}));
export class UnsupportedOperatingSystem extends __BaseException {
    constructor(opts) {
        super({
            name: "UnsupportedOperatingSystem",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedOperatingSystem";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedOperatingSystem.prototype);
        this.Message = opts.Message;
    }
}
export var InstanceInformationFilterKey;
(function (InstanceInformationFilterKey) {
    InstanceInformationFilterKey["ACTIVATION_IDS"] = "ActivationIds";
    InstanceInformationFilterKey["AGENT_VERSION"] = "AgentVersion";
    InstanceInformationFilterKey["ASSOCIATION_STATUS"] = "AssociationStatus";
    InstanceInformationFilterKey["IAM_ROLE"] = "IamRole";
    InstanceInformationFilterKey["INSTANCE_IDS"] = "InstanceIds";
    InstanceInformationFilterKey["PING_STATUS"] = "PingStatus";
    InstanceInformationFilterKey["PLATFORM_TYPES"] = "PlatformTypes";
    InstanceInformationFilterKey["RESOURCE_TYPE"] = "ResourceType";
})(InstanceInformationFilterKey || (InstanceInformationFilterKey = {}));
export var PingStatus;
(function (PingStatus) {
    PingStatus["CONNECTION_LOST"] = "ConnectionLost";
    PingStatus["INACTIVE"] = "Inactive";
    PingStatus["ONLINE"] = "Online";
})(PingStatus || (PingStatus = {}));
export var ResourceType;
(function (ResourceType) {
    ResourceType["DOCUMENT"] = "Document";
    ResourceType["EC2_INSTANCE"] = "EC2Instance";
    ResourceType["MANAGED_INSTANCE"] = "ManagedInstance";
})(ResourceType || (ResourceType = {}));
export var SourceType;
(function (SourceType) {
    SourceType["AWS_EC2_INSTANCE"] = "AWS::EC2::Instance";
    SourceType["AWS_IOT_THING"] = "AWS::IoT::Thing";
    SourceType["AWS_SSM_MANAGEDINSTANCE"] = "AWS::SSM::ManagedInstance";
})(SourceType || (SourceType = {}));
export class InvalidInstanceInformationFilterValue extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidInstanceInformationFilterValue",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInstanceInformationFilterValue";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInstanceInformationFilterValue.prototype);
    }
}
export var PatchComplianceDataState;
(function (PatchComplianceDataState) {
    PatchComplianceDataState["Failed"] = "FAILED";
    PatchComplianceDataState["Installed"] = "INSTALLED";
    PatchComplianceDataState["InstalledOther"] = "INSTALLED_OTHER";
    PatchComplianceDataState["InstalledPendingReboot"] = "INSTALLED_PENDING_REBOOT";
    PatchComplianceDataState["InstalledRejected"] = "INSTALLED_REJECTED";
    PatchComplianceDataState["Missing"] = "MISSING";
    PatchComplianceDataState["NotApplicable"] = "NOT_APPLICABLE";
})(PatchComplianceDataState || (PatchComplianceDataState = {}));
export var PatchOperationType;
(function (PatchOperationType) {
    PatchOperationType["INSTALL"] = "Install";
    PatchOperationType["SCAN"] = "Scan";
})(PatchOperationType || (PatchOperationType = {}));
export var RebootOption;
(function (RebootOption) {
    RebootOption["NO_REBOOT"] = "NoReboot";
    RebootOption["REBOOT_IF_NEEDED"] = "RebootIfNeeded";
})(RebootOption || (RebootOption = {}));
export var InstancePatchStateOperatorType;
(function (InstancePatchStateOperatorType) {
    InstancePatchStateOperatorType["EQUAL"] = "Equal";
    InstancePatchStateOperatorType["GREATER_THAN"] = "GreaterThan";
    InstancePatchStateOperatorType["LESS_THAN"] = "LessThan";
    InstancePatchStateOperatorType["NOT_EQUAL"] = "NotEqual";
})(InstancePatchStateOperatorType || (InstancePatchStateOperatorType = {}));
export var InventoryDeletionStatus;
(function (InventoryDeletionStatus) {
    InventoryDeletionStatus["COMPLETE"] = "Complete";
    InventoryDeletionStatus["IN_PROGRESS"] = "InProgress";
})(InventoryDeletionStatus || (InventoryDeletionStatus = {}));
export class InvalidDeletionIdException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDeletionIdException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDeletionIdException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDeletionIdException.prototype);
        this.Message = opts.Message;
    }
}
export var MaintenanceWindowExecutionStatus;
(function (MaintenanceWindowExecutionStatus) {
    MaintenanceWindowExecutionStatus["Cancelled"] = "CANCELLED";
    MaintenanceWindowExecutionStatus["Cancelling"] = "CANCELLING";
    MaintenanceWindowExecutionStatus["Failed"] = "FAILED";
    MaintenanceWindowExecutionStatus["InProgress"] = "IN_PROGRESS";
    MaintenanceWindowExecutionStatus["Pending"] = "PENDING";
    MaintenanceWindowExecutionStatus["SkippedOverlapping"] = "SKIPPED_OVERLAPPING";
    MaintenanceWindowExecutionStatus["Success"] = "SUCCESS";
    MaintenanceWindowExecutionStatus["TimedOut"] = "TIMED_OUT";
})(MaintenanceWindowExecutionStatus || (MaintenanceWindowExecutionStatus = {}));
export var MaintenanceWindowTaskType;
(function (MaintenanceWindowTaskType) {
    MaintenanceWindowTaskType["Automation"] = "AUTOMATION";
    MaintenanceWindowTaskType["Lambda"] = "LAMBDA";
    MaintenanceWindowTaskType["RunCommand"] = "RUN_COMMAND";
    MaintenanceWindowTaskType["StepFunctions"] = "STEP_FUNCTIONS";
})(MaintenanceWindowTaskType || (MaintenanceWindowTaskType = {}));
export var MaintenanceWindowResourceType;
(function (MaintenanceWindowResourceType) {
    MaintenanceWindowResourceType["Instance"] = "INSTANCE";
    MaintenanceWindowResourceType["ResourceGroup"] = "RESOURCE_GROUP";
})(MaintenanceWindowResourceType || (MaintenanceWindowResourceType = {}));
export var MaintenanceWindowTaskCutoffBehavior;
(function (MaintenanceWindowTaskCutoffBehavior) {
    MaintenanceWindowTaskCutoffBehavior["CancelTask"] = "CANCEL_TASK";
    MaintenanceWindowTaskCutoffBehavior["ContinueTask"] = "CONTINUE_TASK";
})(MaintenanceWindowTaskCutoffBehavior || (MaintenanceWindowTaskCutoffBehavior = {}));
export var OpsItemFilterKey;
(function (OpsItemFilterKey) {
    OpsItemFilterKey["ACCOUNT_ID"] = "AccountId";
    OpsItemFilterKey["ACTUAL_END_TIME"] = "ActualEndTime";
    OpsItemFilterKey["ACTUAL_START_TIME"] = "ActualStartTime";
    OpsItemFilterKey["AUTOMATION_ID"] = "AutomationId";
    OpsItemFilterKey["CATEGORY"] = "Category";
    OpsItemFilterKey["CHANGE_REQUEST_APPROVER_ARN"] = "ChangeRequestByApproverArn";
    OpsItemFilterKey["CHANGE_REQUEST_APPROVER_NAME"] = "ChangeRequestByApproverName";
    OpsItemFilterKey["CHANGE_REQUEST_REQUESTER_ARN"] = "ChangeRequestByRequesterArn";
    OpsItemFilterKey["CHANGE_REQUEST_REQUESTER_NAME"] = "ChangeRequestByRequesterName";
    OpsItemFilterKey["CHANGE_REQUEST_TARGETS_RESOURCE_GROUP"] = "ChangeRequestByTargetsResourceGroup";
    OpsItemFilterKey["CHANGE_REQUEST_TEMPLATE"] = "ChangeRequestByTemplate";
    OpsItemFilterKey["CREATED_BY"] = "CreatedBy";
    OpsItemFilterKey["CREATED_TIME"] = "CreatedTime";
    OpsItemFilterKey["INSIGHT_TYPE"] = "InsightByType";
    OpsItemFilterKey["LAST_MODIFIED_TIME"] = "LastModifiedTime";
    OpsItemFilterKey["OPERATIONAL_DATA"] = "OperationalData";
    OpsItemFilterKey["OPERATIONAL_DATA_KEY"] = "OperationalDataKey";
    OpsItemFilterKey["OPERATIONAL_DATA_VALUE"] = "OperationalDataValue";
    OpsItemFilterKey["OPSITEM_ID"] = "OpsItemId";
    OpsItemFilterKey["OPSITEM_TYPE"] = "OpsItemType";
    OpsItemFilterKey["PLANNED_END_TIME"] = "PlannedEndTime";
    OpsItemFilterKey["PLANNED_START_TIME"] = "PlannedStartTime";
    OpsItemFilterKey["PRIORITY"] = "Priority";
    OpsItemFilterKey["RESOURCE_ID"] = "ResourceId";
    OpsItemFilterKey["SEVERITY"] = "Severity";
    OpsItemFilterKey["SOURCE"] = "Source";
    OpsItemFilterKey["STATUS"] = "Status";
    OpsItemFilterKey["TITLE"] = "Title";
})(OpsItemFilterKey || (OpsItemFilterKey = {}));
export var OpsItemFilterOperator;
(function (OpsItemFilterOperator) {
    OpsItemFilterOperator["CONTAINS"] = "Contains";
    OpsItemFilterOperator["EQUAL"] = "Equal";
    OpsItemFilterOperator["GREATER_THAN"] = "GreaterThan";
    OpsItemFilterOperator["LESS_THAN"] = "LessThan";
})(OpsItemFilterOperator || (OpsItemFilterOperator = {}));
export const AccountSharingInfoFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TagFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ActivationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AddTagsToResourceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AddTagsToResourceResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AlarmFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AlarmConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AlarmStateInformationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AssociateOpsItemRelatedItemRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AssociateOpsItemRelatedItemResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CancelCommandRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CancelCommandResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CancelMaintenanceWindowExecutionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CancelMaintenanceWindowExecutionResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RegistrationMetadataItemFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateActivationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateActivationResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const S3OutputLocationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const InstanceAssociationOutputLocationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TargetLocationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TargetFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateAssociationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: SENSITIVE_STRING }),
});
export const AssociationOverviewFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AssociationStatusFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AssociationDescriptionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: SENSITIVE_STRING }),
});
export const CreateAssociationResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AssociationDescription && {
        AssociationDescription: AssociationDescriptionFilterSensitiveLog(obj.AssociationDescription),
    }),
});
export const CreateAssociationBatchRequestEntryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: SENSITIVE_STRING }),
});
export const CreateAssociationBatchRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Entries && {
        Entries: obj.Entries.map((item) => CreateAssociationBatchRequestEntryFilterSensitiveLog(item)),
    }),
});
export const FailedCreateAssociationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Entry && { Entry: CreateAssociationBatchRequestEntryFilterSensitiveLog(obj.Entry) }),
});
export const CreateAssociationBatchResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Successful && { Successful: obj.Successful.map((item) => AssociationDescriptionFilterSensitiveLog(item)) }),
    ...(obj.Failed && { Failed: obj.Failed.map((item) => FailedCreateAssociationFilterSensitiveLog(item)) }),
});
export const AttachmentsSourceFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DocumentRequiresFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateDocumentRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AttachmentInformationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DocumentParameterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ReviewInformationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DocumentDescriptionFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateDocumentResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateMaintenanceWindowRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Description && { Description: SENSITIVE_STRING }),
});
export const CreateMaintenanceWindowResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const OpsItemNotificationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const OpsItemDataValueFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RelatedOpsItemFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateOpsItemRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateOpsItemResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MetadataValueFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateOpsMetadataRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateOpsMetadataResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PatchFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PatchFilterGroupFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PatchRuleFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PatchRuleGroupFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PatchSourceFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Configuration && { Configuration: SENSITIVE_STRING }),
});
export const CreatePatchBaselineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Sources && { Sources: obj.Sources.map((item) => PatchSourceFilterSensitiveLog(item)) }),
});
export const CreatePatchBaselineResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ResourceDataSyncDestinationDataSharingFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ResourceDataSyncS3DestinationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ResourceDataSyncOrganizationalUnitFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ResourceDataSyncAwsOrganizationsSourceFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ResourceDataSyncSourceFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateResourceDataSyncRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateResourceDataSyncResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteActivationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteActivationResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteAssociationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteAssociationResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteDocumentRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteDocumentResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteInventoryRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const InventoryDeletionSummaryItemFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const InventoryDeletionSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteInventoryResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteMaintenanceWindowRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteMaintenanceWindowResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteOpsMetadataRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteOpsMetadataResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteParameterRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteParameterResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteParametersRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteParametersResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeletePatchBaselineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeletePatchBaselineResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteResourceDataSyncRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteResourceDataSyncResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteResourcePolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteResourcePolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeregisterManagedInstanceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeregisterManagedInstanceResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeregisterPatchBaselineForPatchGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeregisterPatchBaselineForPatchGroupResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeregisterTargetFromMaintenanceWindowRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeregisterTargetFromMaintenanceWindowResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeregisterTaskFromMaintenanceWindowRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeregisterTaskFromMaintenanceWindowResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeActivationsFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeActivationsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeActivationsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeAssociationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeAssociationResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AssociationDescription && {
        AssociationDescription: AssociationDescriptionFilterSensitiveLog(obj.AssociationDescription),
    }),
});
export const AssociationExecutionFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeAssociationExecutionsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AssociationExecutionFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeAssociationExecutionsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AssociationExecutionTargetsFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeAssociationExecutionTargetsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const OutputSourceFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AssociationExecutionTargetFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeAssociationExecutionTargetsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AutomationExecutionFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeAutomationExecutionsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ResolvedTargetsFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RunbookFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AutomationExecutionMetadataFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeAutomationExecutionsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const StepExecutionFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeAutomationStepExecutionsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const FailureDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const StepExecutionFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeAutomationStepExecutionsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PatchOrchestratorFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeAvailablePatchesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PatchFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeAvailablePatchesResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeDocumentRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeDocumentResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeDocumentPermissionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeDocumentPermissionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeEffectiveInstanceAssociationsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const InstanceAssociationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeEffectiveInstanceAssociationsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeEffectivePatchesForPatchBaselineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PatchStatusFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const EffectivePatchFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeEffectivePatchesForPatchBaselineResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeInstanceAssociationsStatusRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const S3OutputUrlFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const InstanceAssociationOutputUrlFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const InstanceAssociationStatusInfoFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeInstanceAssociationsStatusResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const InstanceInformationStringFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const InstanceInformationFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeInstanceInformationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const InstanceAggregatedAssociationOverviewFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const InstanceInformationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeInstanceInformationResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeInstancePatchesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PatchComplianceDataFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeInstancePatchesResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeInstancePatchStatesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const InstancePatchStateFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OwnerInformation && { OwnerInformation: SENSITIVE_STRING }),
});
export const DescribeInstancePatchStatesResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.InstancePatchStates && {
        InstancePatchStates: obj.InstancePatchStates.map((item) => InstancePatchStateFilterSensitiveLog(item)),
    }),
});
export const InstancePatchStateFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeInstancePatchStatesForPatchGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeInstancePatchStatesForPatchGroupResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.InstancePatchStates && {
        InstancePatchStates: obj.InstancePatchStates.map((item) => InstancePatchStateFilterSensitiveLog(item)),
    }),
});
export const DescribeInventoryDeletionsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const InventoryDeletionStatusItemFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeInventoryDeletionsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MaintenanceWindowFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeMaintenanceWindowExecutionsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MaintenanceWindowExecutionFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeMaintenanceWindowExecutionsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeMaintenanceWindowExecutionTaskInvocationsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: SENSITIVE_STRING }),
    ...(obj.OwnerInformation && { OwnerInformation: SENSITIVE_STRING }),
});
export const DescribeMaintenanceWindowExecutionTaskInvocationsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.WindowExecutionTaskInvocationIdentities && {
        WindowExecutionTaskInvocationIdentities: obj.WindowExecutionTaskInvocationIdentities.map((item) => MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog(item)),
    }),
});
export const DescribeMaintenanceWindowExecutionTasksRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MaintenanceWindowExecutionTaskIdentityFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeMaintenanceWindowExecutionTasksResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeMaintenanceWindowsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MaintenanceWindowIdentityFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Description && { Description: SENSITIVE_STRING }),
});
export const DescribeMaintenanceWindowsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.WindowIdentities && {
        WindowIdentities: obj.WindowIdentities.map((item) => MaintenanceWindowIdentityFilterSensitiveLog(item)),
    }),
});
export const DescribeMaintenanceWindowScheduleRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ScheduledWindowExecutionFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeMaintenanceWindowScheduleResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeMaintenanceWindowsForTargetRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MaintenanceWindowIdentityForTargetFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeMaintenanceWindowsForTargetResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeMaintenanceWindowTargetsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MaintenanceWindowTargetFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OwnerInformation && { OwnerInformation: SENSITIVE_STRING }),
    ...(obj.Description && { Description: SENSITIVE_STRING }),
});
export const DescribeMaintenanceWindowTargetsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Targets && { Targets: obj.Targets.map((item) => MaintenanceWindowTargetFilterSensitiveLog(item)) }),
});
export const DescribeMaintenanceWindowTasksRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const LoggingInfoFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MaintenanceWindowTaskParameterValueExpressionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Values && { Values: SENSITIVE_STRING }),
});
export const MaintenanceWindowTaskFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TaskParameters && { TaskParameters: SENSITIVE_STRING }),
    ...(obj.Description && { Description: SENSITIVE_STRING }),
});
export const DescribeMaintenanceWindowTasksResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Tasks && { Tasks: obj.Tasks.map((item) => MaintenanceWindowTaskFilterSensitiveLog(item)) }),
});
