"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpsMetadataAlreadyExistsException = exports.OpsItemAlreadyExistsException = exports.OpsItemAccessDeniedException = exports.OpsItemDataType = exports.ResourceLimitExceededException = exports.IdempotentParameterMismatch = exports.MaxDocumentSizeExceeded = exports.InvalidDocumentSchemaVersion = exports.InvalidDocumentContent = exports.DocumentLimitExceeded = exports.DocumentAlreadyExists = exports.DocumentStatus = exports.ReviewStatus = exports.PlatformType = exports.DocumentParameterType = exports.DocumentHashType = exports.DocumentType = exports.DocumentFormat = exports.AttachmentsSourceKey = exports.Fault = exports.UnsupportedPlatformType = exports.InvalidTargetMaps = exports.InvalidTarget = exports.InvalidTag = exports.InvalidSchedule = exports.InvalidOutputLocation = exports.InvalidDocumentVersion = exports.InvalidDocument = exports.AssociationStatusName = exports.AssociationSyncCompliance = exports.AssociationComplianceSeverity = exports.AssociationLimitExceeded = exports.AssociationAlreadyExists = exports.InvalidParameters = exports.DoesNotExistException = exports.InvalidInstanceId = exports.InvalidCommandId = exports.DuplicateInstanceId = exports.OpsItemRelatedItemAlreadyExistsException = exports.OpsItemNotFoundException = exports.OpsItemLimitExceededException = exports.OpsItemInvalidParameterException = exports.AlreadyExistsException = exports.ExternalAlarmState = exports.TooManyUpdates = exports.TooManyTagsError = exports.InvalidResourceType = exports.InvalidResourceId = exports.InternalServerError = exports.ResourceTypeForTagging = void 0;
exports.InstanceInformationFilterKey = exports.UnsupportedOperatingSystem = exports.PatchDeploymentStatus = exports.InvalidPermissionType = exports.DocumentPermissionType = exports.StepExecutionFilterKey = exports.AutomationExecutionNotFoundException = exports.InvalidFilterValue = exports.InvalidFilterKey = exports.ExecutionMode = exports.AutomationType = exports.AutomationSubtype = exports.AutomationExecutionStatus = exports.AutomationExecutionFilterKey = exports.AssociationExecutionTargetsFilterKey = exports.AssociationExecutionDoesNotExist = exports.AssociationFilterOperatorType = exports.AssociationExecutionFilterKey = exports.InvalidAssociationVersion = exports.InvalidNextToken = exports.InvalidFilter = exports.DescribeActivationsFilterKeys = exports.TargetInUseException = exports.ResourcePolicyInvalidParameterException = exports.ResourcePolicyConflictException = exports.ResourceDataSyncNotFoundException = exports.ResourceInUseException = exports.ParameterNotFound = exports.OpsMetadataNotFoundException = exports.InvalidTypeNameException = exports.InvalidOptionException = exports.InvalidInventoryRequestException = exports.InvalidDeleteInventoryParametersException = exports.InventorySchemaDeleteOption = exports.InvalidDocumentOperation = exports.AssociatedInstances = exports.AssociationDoesNotExist = exports.InvalidActivationId = exports.InvalidActivation = exports.ResourceDataSyncInvalidConfigurationException = exports.ResourceDataSyncCountExceededException = exports.ResourceDataSyncAlreadyExistsException = exports.ResourceDataSyncS3Format = exports.PatchAction = exports.OperatingSystem = exports.PatchFilterKey = exports.PatchComplianceLevel = exports.OpsMetadataTooManyUpdatesException = exports.OpsMetadataLimitExceededException = exports.OpsMetadataInvalidArgumentException = void 0;
exports.AttachmentInformationFilterSensitiveLog = exports.CreateDocumentRequestFilterSensitiveLog = exports.DocumentRequiresFilterSensitiveLog = exports.AttachmentsSourceFilterSensitiveLog = exports.CreateAssociationBatchResultFilterSensitiveLog = exports.FailedCreateAssociationFilterSensitiveLog = exports.CreateAssociationBatchRequestFilterSensitiveLog = exports.CreateAssociationBatchRequestEntryFilterSensitiveLog = exports.CreateAssociationResultFilterSensitiveLog = exports.AssociationDescriptionFilterSensitiveLog = exports.AssociationStatusFilterSensitiveLog = exports.AssociationOverviewFilterSensitiveLog = exports.CreateAssociationRequestFilterSensitiveLog = exports.TargetFilterSensitiveLog = exports.TargetLocationFilterSensitiveLog = exports.InstanceAssociationOutputLocationFilterSensitiveLog = exports.S3OutputLocationFilterSensitiveLog = exports.CreateActivationResultFilterSensitiveLog = exports.CreateActivationRequestFilterSensitiveLog = exports.RegistrationMetadataItemFilterSensitiveLog = exports.CancelMaintenanceWindowExecutionResultFilterSensitiveLog = exports.CancelMaintenanceWindowExecutionRequestFilterSensitiveLog = exports.CancelCommandResultFilterSensitiveLog = exports.CancelCommandRequestFilterSensitiveLog = exports.AssociateOpsItemRelatedItemResponseFilterSensitiveLog = exports.AssociateOpsItemRelatedItemRequestFilterSensitiveLog = exports.AlarmStateInformationFilterSensitiveLog = exports.AlarmConfigurationFilterSensitiveLog = exports.AlarmFilterSensitiveLog = exports.AddTagsToResourceResultFilterSensitiveLog = exports.AddTagsToResourceRequestFilterSensitiveLog = exports.ActivationFilterSensitiveLog = exports.TagFilterSensitiveLog = exports.AccountSharingInfoFilterSensitiveLog = exports.OpsItemFilterOperator = exports.OpsItemFilterKey = exports.MaintenanceWindowTaskCutoffBehavior = exports.MaintenanceWindowResourceType = exports.MaintenanceWindowTaskType = exports.MaintenanceWindowExecutionStatus = exports.InvalidDeletionIdException = exports.InventoryDeletionStatus = exports.InstancePatchStateOperatorType = exports.RebootOption = exports.PatchOperationType = exports.PatchComplianceDataState = exports.InvalidInstanceInformationFilterValue = exports.SourceType = exports.ResourceType = exports.PingStatus = void 0;
exports.DeleteResourceDataSyncResultFilterSensitiveLog = exports.DeleteResourceDataSyncRequestFilterSensitiveLog = exports.DeletePatchBaselineResultFilterSensitiveLog = exports.DeletePatchBaselineRequestFilterSensitiveLog = exports.DeleteParametersResultFilterSensitiveLog = exports.DeleteParametersRequestFilterSensitiveLog = exports.DeleteParameterResultFilterSensitiveLog = exports.DeleteParameterRequestFilterSensitiveLog = exports.DeleteOpsMetadataResultFilterSensitiveLog = exports.DeleteOpsMetadataRequestFilterSensitiveLog = exports.DeleteMaintenanceWindowResultFilterSensitiveLog = exports.DeleteMaintenanceWindowRequestFilterSensitiveLog = exports.DeleteInventoryResultFilterSensitiveLog = exports.InventoryDeletionSummaryFilterSensitiveLog = exports.InventoryDeletionSummaryItemFilterSensitiveLog = exports.DeleteInventoryRequestFilterSensitiveLog = exports.DeleteDocumentResultFilterSensitiveLog = exports.DeleteDocumentRequestFilterSensitiveLog = exports.DeleteAssociationResultFilterSensitiveLog = exports.DeleteAssociationRequestFilterSensitiveLog = exports.DeleteActivationResultFilterSensitiveLog = exports.DeleteActivationRequestFilterSensitiveLog = exports.CreateResourceDataSyncResultFilterSensitiveLog = exports.CreateResourceDataSyncRequestFilterSensitiveLog = exports.ResourceDataSyncSourceFilterSensitiveLog = exports.ResourceDataSyncAwsOrganizationsSourceFilterSensitiveLog = exports.ResourceDataSyncOrganizationalUnitFilterSensitiveLog = exports.ResourceDataSyncS3DestinationFilterSensitiveLog = exports.ResourceDataSyncDestinationDataSharingFilterSensitiveLog = exports.CreatePatchBaselineResultFilterSensitiveLog = exports.CreatePatchBaselineRequestFilterSensitiveLog = exports.PatchSourceFilterSensitiveLog = exports.PatchRuleGroupFilterSensitiveLog = exports.PatchRuleFilterSensitiveLog = exports.PatchFilterGroupFilterSensitiveLog = exports.PatchFilterFilterSensitiveLog = exports.CreateOpsMetadataResultFilterSensitiveLog = exports.CreateOpsMetadataRequestFilterSensitiveLog = exports.MetadataValueFilterSensitiveLog = exports.CreateOpsItemResponseFilterSensitiveLog = exports.CreateOpsItemRequestFilterSensitiveLog = exports.RelatedOpsItemFilterSensitiveLog = exports.OpsItemDataValueFilterSensitiveLog = exports.OpsItemNotificationFilterSensitiveLog = exports.CreateMaintenanceWindowResultFilterSensitiveLog = exports.CreateMaintenanceWindowRequestFilterSensitiveLog = exports.CreateDocumentResultFilterSensitiveLog = exports.DocumentDescriptionFilterSensitiveLog = exports.ReviewInformationFilterSensitiveLog = exports.DocumentParameterFilterSensitiveLog = void 0;
exports.DescribeEffectivePatchesForPatchBaselineResultFilterSensitiveLog = exports.EffectivePatchFilterSensitiveLog = exports.PatchStatusFilterSensitiveLog = exports.DescribeEffectivePatchesForPatchBaselineRequestFilterSensitiveLog = exports.DescribeEffectiveInstanceAssociationsResultFilterSensitiveLog = exports.InstanceAssociationFilterSensitiveLog = exports.DescribeEffectiveInstanceAssociationsRequestFilterSensitiveLog = exports.DescribeDocumentPermissionResponseFilterSensitiveLog = exports.DescribeDocumentPermissionRequestFilterSensitiveLog = exports.DescribeDocumentResultFilterSensitiveLog = exports.DescribeDocumentRequestFilterSensitiveLog = exports.DescribeAvailablePatchesResultFilterSensitiveLog = exports.PatchFilterSensitiveLog = exports.DescribeAvailablePatchesRequestFilterSensitiveLog = exports.PatchOrchestratorFilterFilterSensitiveLog = exports.DescribeAutomationStepExecutionsResultFilterSensitiveLog = exports.StepExecutionFilterSensitiveLog = exports.FailureDetailsFilterSensitiveLog = exports.DescribeAutomationStepExecutionsRequestFilterSensitiveLog = exports.StepExecutionFilterFilterSensitiveLog = exports.DescribeAutomationExecutionsResultFilterSensitiveLog = exports.AutomationExecutionMetadataFilterSensitiveLog = exports.RunbookFilterSensitiveLog = exports.ResolvedTargetsFilterSensitiveLog = exports.DescribeAutomationExecutionsRequestFilterSensitiveLog = exports.AutomationExecutionFilterFilterSensitiveLog = exports.DescribeAssociationExecutionTargetsResultFilterSensitiveLog = exports.AssociationExecutionTargetFilterSensitiveLog = exports.OutputSourceFilterSensitiveLog = exports.DescribeAssociationExecutionTargetsRequestFilterSensitiveLog = exports.AssociationExecutionTargetsFilterFilterSensitiveLog = exports.DescribeAssociationExecutionsResultFilterSensitiveLog = exports.AssociationExecutionFilterSensitiveLog = exports.DescribeAssociationExecutionsRequestFilterSensitiveLog = exports.AssociationExecutionFilterFilterSensitiveLog = exports.DescribeAssociationResultFilterSensitiveLog = exports.DescribeAssociationRequestFilterSensitiveLog = exports.DescribeActivationsResultFilterSensitiveLog = exports.DescribeActivationsRequestFilterSensitiveLog = exports.DescribeActivationsFilterFilterSensitiveLog = exports.DeregisterTaskFromMaintenanceWindowResultFilterSensitiveLog = exports.DeregisterTaskFromMaintenanceWindowRequestFilterSensitiveLog = exports.DeregisterTargetFromMaintenanceWindowResultFilterSensitiveLog = exports.DeregisterTargetFromMaintenanceWindowRequestFilterSensitiveLog = exports.DeregisterPatchBaselineForPatchGroupResultFilterSensitiveLog = exports.DeregisterPatchBaselineForPatchGroupRequestFilterSensitiveLog = exports.DeregisterManagedInstanceResultFilterSensitiveLog = exports.DeregisterManagedInstanceRequestFilterSensitiveLog = exports.DeleteResourcePolicyResponseFilterSensitiveLog = exports.DeleteResourcePolicyRequestFilterSensitiveLog = void 0;
exports.DescribeMaintenanceWindowTasksResultFilterSensitiveLog = exports.MaintenanceWindowTaskFilterSensitiveLog = exports.MaintenanceWindowTaskParameterValueExpressionFilterSensitiveLog = exports.LoggingInfoFilterSensitiveLog = exports.DescribeMaintenanceWindowTasksRequestFilterSensitiveLog = exports.DescribeMaintenanceWindowTargetsResultFilterSensitiveLog = exports.MaintenanceWindowTargetFilterSensitiveLog = exports.DescribeMaintenanceWindowTargetsRequestFilterSensitiveLog = exports.DescribeMaintenanceWindowsForTargetResultFilterSensitiveLog = exports.MaintenanceWindowIdentityForTargetFilterSensitiveLog = exports.DescribeMaintenanceWindowsForTargetRequestFilterSensitiveLog = exports.DescribeMaintenanceWindowScheduleResultFilterSensitiveLog = exports.ScheduledWindowExecutionFilterSensitiveLog = exports.DescribeMaintenanceWindowScheduleRequestFilterSensitiveLog = exports.DescribeMaintenanceWindowsResultFilterSensitiveLog = exports.MaintenanceWindowIdentityFilterSensitiveLog = exports.DescribeMaintenanceWindowsRequestFilterSensitiveLog = exports.DescribeMaintenanceWindowExecutionTasksResultFilterSensitiveLog = exports.MaintenanceWindowExecutionTaskIdentityFilterSensitiveLog = exports.DescribeMaintenanceWindowExecutionTasksRequestFilterSensitiveLog = exports.DescribeMaintenanceWindowExecutionTaskInvocationsResultFilterSensitiveLog = exports.MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog = exports.DescribeMaintenanceWindowExecutionTaskInvocationsRequestFilterSensitiveLog = exports.DescribeMaintenanceWindowExecutionsResultFilterSensitiveLog = exports.MaintenanceWindowExecutionFilterSensitiveLog = exports.DescribeMaintenanceWindowExecutionsRequestFilterSensitiveLog = exports.MaintenanceWindowFilterFilterSensitiveLog = exports.DescribeInventoryDeletionsResultFilterSensitiveLog = exports.InventoryDeletionStatusItemFilterSensitiveLog = exports.DescribeInventoryDeletionsRequestFilterSensitiveLog = exports.DescribeInstancePatchStatesForPatchGroupResultFilterSensitiveLog = exports.DescribeInstancePatchStatesForPatchGroupRequestFilterSensitiveLog = exports.InstancePatchStateFilterFilterSensitiveLog = exports.DescribeInstancePatchStatesResultFilterSensitiveLog = exports.InstancePatchStateFilterSensitiveLog = exports.DescribeInstancePatchStatesRequestFilterSensitiveLog = exports.DescribeInstancePatchesResultFilterSensitiveLog = exports.PatchComplianceDataFilterSensitiveLog = exports.DescribeInstancePatchesRequestFilterSensitiveLog = exports.DescribeInstanceInformationResultFilterSensitiveLog = exports.InstanceInformationFilterSensitiveLog = exports.InstanceAggregatedAssociationOverviewFilterSensitiveLog = exports.DescribeInstanceInformationRequestFilterSensitiveLog = exports.InstanceInformationFilterFilterSensitiveLog = exports.InstanceInformationStringFilterFilterSensitiveLog = exports.DescribeInstanceAssociationsStatusResultFilterSensitiveLog = exports.InstanceAssociationStatusInfoFilterSensitiveLog = exports.InstanceAssociationOutputUrlFilterSensitiveLog = exports.S3OutputUrlFilterSensitiveLog = exports.DescribeInstanceAssociationsStatusRequestFilterSensitiveLog = void 0;
const smithy_client_1 = require("@aws-sdk/smithy-client");
const SSMServiceException_1 = require("./SSMServiceException");
var ResourceTypeForTagging;
(function (ResourceTypeForTagging) {
    ResourceTypeForTagging["ASSOCIATION"] = "Association";
    ResourceTypeForTagging["AUTOMATION"] = "Automation";
    ResourceTypeForTagging["DOCUMENT"] = "Document";
    ResourceTypeForTagging["MAINTENANCE_WINDOW"] = "MaintenanceWindow";
    ResourceTypeForTagging["MANAGED_INSTANCE"] = "ManagedInstance";
    ResourceTypeForTagging["OPSMETADATA"] = "OpsMetadata";
    ResourceTypeForTagging["OPS_ITEM"] = "OpsItem";
    ResourceTypeForTagging["PARAMETER"] = "Parameter";
    ResourceTypeForTagging["PATCH_BASELINE"] = "PatchBaseline";
})(ResourceTypeForTagging = exports.ResourceTypeForTagging || (exports.ResourceTypeForTagging = {}));
class InternalServerError extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InternalServerError",
            $fault: "server",
            ...opts,
        });
        this.name = "InternalServerError";
        this.$fault = "server";
        Object.setPrototypeOf(this, InternalServerError.prototype);
        this.Message = opts.Message;
    }
}
exports.InternalServerError = InternalServerError;
class InvalidResourceId extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidResourceId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidResourceId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidResourceId.prototype);
    }
}
exports.InvalidResourceId = InvalidResourceId;
class InvalidResourceType extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidResourceType",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidResourceType";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidResourceType.prototype);
    }
}
exports.InvalidResourceType = InvalidResourceType;
class TooManyTagsError extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "TooManyTagsError",
            $fault: "client",
            ...opts,
        });
        this.name = "TooManyTagsError";
        this.$fault = "client";
        Object.setPrototypeOf(this, TooManyTagsError.prototype);
    }
}
exports.TooManyTagsError = TooManyTagsError;
class TooManyUpdates extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "TooManyUpdates",
            $fault: "client",
            ...opts,
        });
        this.name = "TooManyUpdates";
        this.$fault = "client";
        Object.setPrototypeOf(this, TooManyUpdates.prototype);
        this.Message = opts.Message;
    }
}
exports.TooManyUpdates = TooManyUpdates;
var ExternalAlarmState;
(function (ExternalAlarmState) {
    ExternalAlarmState["ALARM"] = "ALARM";
    ExternalAlarmState["UNKNOWN"] = "UNKNOWN";
})(ExternalAlarmState = exports.ExternalAlarmState || (exports.ExternalAlarmState = {}));
class AlreadyExistsException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "AlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AlreadyExistsException.prototype);
        this.Message = opts.Message;
    }
}
exports.AlreadyExistsException = AlreadyExistsException;
class OpsItemInvalidParameterException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsItemInvalidParameterException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemInvalidParameterException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemInvalidParameterException.prototype);
        this.ParameterNames = opts.ParameterNames;
        this.Message = opts.Message;
    }
}
exports.OpsItemInvalidParameterException = OpsItemInvalidParameterException;
class OpsItemLimitExceededException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsItemLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemLimitExceededException.prototype);
        this.ResourceTypes = opts.ResourceTypes;
        this.Limit = opts.Limit;
        this.LimitType = opts.LimitType;
        this.Message = opts.Message;
    }
}
exports.OpsItemLimitExceededException = OpsItemLimitExceededException;
class OpsItemNotFoundException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsItemNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
exports.OpsItemNotFoundException = OpsItemNotFoundException;
class OpsItemRelatedItemAlreadyExistsException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsItemRelatedItemAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemRelatedItemAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemRelatedItemAlreadyExistsException.prototype);
        this.Message = opts.Message;
        this.ResourceUri = opts.ResourceUri;
        this.OpsItemId = opts.OpsItemId;
    }
}
exports.OpsItemRelatedItemAlreadyExistsException = OpsItemRelatedItemAlreadyExistsException;
class DuplicateInstanceId extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "DuplicateInstanceId",
            $fault: "client",
            ...opts,
        });
        this.name = "DuplicateInstanceId";
        this.$fault = "client";
        Object.setPrototypeOf(this, DuplicateInstanceId.prototype);
    }
}
exports.DuplicateInstanceId = DuplicateInstanceId;
class InvalidCommandId extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidCommandId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidCommandId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidCommandId.prototype);
    }
}
exports.InvalidCommandId = InvalidCommandId;
class InvalidInstanceId extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidInstanceId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInstanceId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInstanceId.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidInstanceId = InvalidInstanceId;
class DoesNotExistException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "DoesNotExistException",
            $fault: "client",
            ...opts,
        });
        this.name = "DoesNotExistException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DoesNotExistException.prototype);
        this.Message = opts.Message;
    }
}
exports.DoesNotExistException = DoesNotExistException;
class InvalidParameters extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidParameters",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidParameters";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidParameters.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidParameters = InvalidParameters;
class AssociationAlreadyExists extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AssociationAlreadyExists",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationAlreadyExists";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationAlreadyExists.prototype);
    }
}
exports.AssociationAlreadyExists = AssociationAlreadyExists;
class AssociationLimitExceeded extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AssociationLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationLimitExceeded.prototype);
    }
}
exports.AssociationLimitExceeded = AssociationLimitExceeded;
var AssociationComplianceSeverity;
(function (AssociationComplianceSeverity) {
    AssociationComplianceSeverity["Critical"] = "CRITICAL";
    AssociationComplianceSeverity["High"] = "HIGH";
    AssociationComplianceSeverity["Low"] = "LOW";
    AssociationComplianceSeverity["Medium"] = "MEDIUM";
    AssociationComplianceSeverity["Unspecified"] = "UNSPECIFIED";
})(AssociationComplianceSeverity = exports.AssociationComplianceSeverity || (exports.AssociationComplianceSeverity = {}));
var AssociationSyncCompliance;
(function (AssociationSyncCompliance) {
    AssociationSyncCompliance["Auto"] = "AUTO";
    AssociationSyncCompliance["Manual"] = "MANUAL";
})(AssociationSyncCompliance = exports.AssociationSyncCompliance || (exports.AssociationSyncCompliance = {}));
var AssociationStatusName;
(function (AssociationStatusName) {
    AssociationStatusName["Failed"] = "Failed";
    AssociationStatusName["Pending"] = "Pending";
    AssociationStatusName["Success"] = "Success";
})(AssociationStatusName = exports.AssociationStatusName || (exports.AssociationStatusName = {}));
class InvalidDocument extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidDocument",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocument";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocument.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidDocument = InvalidDocument;
class InvalidDocumentVersion extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidDocumentVersion",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentVersion";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentVersion.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidDocumentVersion = InvalidDocumentVersion;
class InvalidOutputLocation extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidOutputLocation",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidOutputLocation";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidOutputLocation.prototype);
    }
}
exports.InvalidOutputLocation = InvalidOutputLocation;
class InvalidSchedule extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidSchedule",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidSchedule";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidSchedule.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidSchedule = InvalidSchedule;
class InvalidTag extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidTag",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTag";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTag.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidTag = InvalidTag;
class InvalidTarget extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidTarget",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTarget";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTarget.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidTarget = InvalidTarget;
class InvalidTargetMaps extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidTargetMaps",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTargetMaps";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTargetMaps.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidTargetMaps = InvalidTargetMaps;
class UnsupportedPlatformType extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "UnsupportedPlatformType",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedPlatformType";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedPlatformType.prototype);
        this.Message = opts.Message;
    }
}
exports.UnsupportedPlatformType = UnsupportedPlatformType;
var Fault;
(function (Fault) {
    Fault["Client"] = "Client";
    Fault["Server"] = "Server";
    Fault["Unknown"] = "Unknown";
})(Fault = exports.Fault || (exports.Fault = {}));
var AttachmentsSourceKey;
(function (AttachmentsSourceKey) {
    AttachmentsSourceKey["AttachmentReference"] = "AttachmentReference";
    AttachmentsSourceKey["S3FileUrl"] = "S3FileUrl";
    AttachmentsSourceKey["SourceUrl"] = "SourceUrl";
})(AttachmentsSourceKey = exports.AttachmentsSourceKey || (exports.AttachmentsSourceKey = {}));
var DocumentFormat;
(function (DocumentFormat) {
    DocumentFormat["JSON"] = "JSON";
    DocumentFormat["TEXT"] = "TEXT";
    DocumentFormat["YAML"] = "YAML";
})(DocumentFormat = exports.DocumentFormat || (exports.DocumentFormat = {}));
var DocumentType;
(function (DocumentType) {
    DocumentType["ApplicationConfiguration"] = "ApplicationConfiguration";
    DocumentType["ApplicationConfigurationSchema"] = "ApplicationConfigurationSchema";
    DocumentType["Automation"] = "Automation";
    DocumentType["ChangeCalendar"] = "ChangeCalendar";
    DocumentType["ChangeTemplate"] = "Automation.ChangeTemplate";
    DocumentType["CloudFormation"] = "CloudFormation";
    DocumentType["Command"] = "Command";
    DocumentType["ConformancePackTemplate"] = "ConformancePackTemplate";
    DocumentType["DeploymentStrategy"] = "DeploymentStrategy";
    DocumentType["Package"] = "Package";
    DocumentType["Policy"] = "Policy";
    DocumentType["ProblemAnalysis"] = "ProblemAnalysis";
    DocumentType["ProblemAnalysisTemplate"] = "ProblemAnalysisTemplate";
    DocumentType["QuickSetup"] = "QuickSetup";
    DocumentType["Session"] = "Session";
})(DocumentType = exports.DocumentType || (exports.DocumentType = {}));
var DocumentHashType;
(function (DocumentHashType) {
    DocumentHashType["SHA1"] = "Sha1";
    DocumentHashType["SHA256"] = "Sha256";
})(DocumentHashType = exports.DocumentHashType || (exports.DocumentHashType = {}));
var DocumentParameterType;
(function (DocumentParameterType) {
    DocumentParameterType["String"] = "String";
    DocumentParameterType["StringList"] = "StringList";
})(DocumentParameterType = exports.DocumentParameterType || (exports.DocumentParameterType = {}));
var PlatformType;
(function (PlatformType) {
    PlatformType["LINUX"] = "Linux";
    PlatformType["MACOS"] = "MacOS";
    PlatformType["WINDOWS"] = "Windows";
})(PlatformType = exports.PlatformType || (exports.PlatformType = {}));
var ReviewStatus;
(function (ReviewStatus) {
    ReviewStatus["APPROVED"] = "APPROVED";
    ReviewStatus["NOT_REVIEWED"] = "NOT_REVIEWED";
    ReviewStatus["PENDING"] = "PENDING";
    ReviewStatus["REJECTED"] = "REJECTED";
})(ReviewStatus = exports.ReviewStatus || (exports.ReviewStatus = {}));
var DocumentStatus;
(function (DocumentStatus) {
    DocumentStatus["Active"] = "Active";
    DocumentStatus["Creating"] = "Creating";
    DocumentStatus["Deleting"] = "Deleting";
    DocumentStatus["Failed"] = "Failed";
    DocumentStatus["Updating"] = "Updating";
})(DocumentStatus = exports.DocumentStatus || (exports.DocumentStatus = {}));
class DocumentAlreadyExists extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "DocumentAlreadyExists",
            $fault: "client",
            ...opts,
        });
        this.name = "DocumentAlreadyExists";
        this.$fault = "client";
        Object.setPrototypeOf(this, DocumentAlreadyExists.prototype);
        this.Message = opts.Message;
    }
}
exports.DocumentAlreadyExists = DocumentAlreadyExists;
class DocumentLimitExceeded extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "DocumentLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "DocumentLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, DocumentLimitExceeded.prototype);
        this.Message = opts.Message;
    }
}
exports.DocumentLimitExceeded = DocumentLimitExceeded;
class InvalidDocumentContent extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidDocumentContent",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentContent";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentContent.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidDocumentContent = InvalidDocumentContent;
class InvalidDocumentSchemaVersion extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidDocumentSchemaVersion",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentSchemaVersion";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentSchemaVersion.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidDocumentSchemaVersion = InvalidDocumentSchemaVersion;
class MaxDocumentSizeExceeded extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "MaxDocumentSizeExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "MaxDocumentSizeExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, MaxDocumentSizeExceeded.prototype);
        this.Message = opts.Message;
    }
}
exports.MaxDocumentSizeExceeded = MaxDocumentSizeExceeded;
class IdempotentParameterMismatch extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "IdempotentParameterMismatch",
            $fault: "client",
            ...opts,
        });
        this.name = "IdempotentParameterMismatch";
        this.$fault = "client";
        Object.setPrototypeOf(this, IdempotentParameterMismatch.prototype);
        this.Message = opts.Message;
    }
}
exports.IdempotentParameterMismatch = IdempotentParameterMismatch;
class ResourceLimitExceededException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourceLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceLimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
exports.ResourceLimitExceededException = ResourceLimitExceededException;
var OpsItemDataType;
(function (OpsItemDataType) {
    OpsItemDataType["SEARCHABLE_STRING"] = "SearchableString";
    OpsItemDataType["STRING"] = "String";
})(OpsItemDataType = exports.OpsItemDataType || (exports.OpsItemDataType = {}));
class OpsItemAccessDeniedException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsItemAccessDeniedException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemAccessDeniedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemAccessDeniedException.prototype);
        this.Message = opts.Message;
    }
}
exports.OpsItemAccessDeniedException = OpsItemAccessDeniedException;
class OpsItemAlreadyExistsException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsItemAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemAlreadyExistsException.prototype);
        this.Message = opts.Message;
        this.OpsItemId = opts.OpsItemId;
    }
}
exports.OpsItemAlreadyExistsException = OpsItemAlreadyExistsException;
class OpsMetadataAlreadyExistsException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsMetadataAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataAlreadyExistsException.prototype);
    }
}
exports.OpsMetadataAlreadyExistsException = OpsMetadataAlreadyExistsException;
class OpsMetadataInvalidArgumentException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsMetadataInvalidArgumentException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataInvalidArgumentException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataInvalidArgumentException.prototype);
    }
}
exports.OpsMetadataInvalidArgumentException = OpsMetadataInvalidArgumentException;
class OpsMetadataLimitExceededException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsMetadataLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataLimitExceededException.prototype);
    }
}
exports.OpsMetadataLimitExceededException = OpsMetadataLimitExceededException;
class OpsMetadataTooManyUpdatesException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsMetadataTooManyUpdatesException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataTooManyUpdatesException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataTooManyUpdatesException.prototype);
    }
}
exports.OpsMetadataTooManyUpdatesException = OpsMetadataTooManyUpdatesException;
var PatchComplianceLevel;
(function (PatchComplianceLevel) {
    PatchComplianceLevel["Critical"] = "CRITICAL";
    PatchComplianceLevel["High"] = "HIGH";
    PatchComplianceLevel["Informational"] = "INFORMATIONAL";
    PatchComplianceLevel["Low"] = "LOW";
    PatchComplianceLevel["Medium"] = "MEDIUM";
    PatchComplianceLevel["Unspecified"] = "UNSPECIFIED";
})(PatchComplianceLevel = exports.PatchComplianceLevel || (exports.PatchComplianceLevel = {}));
var PatchFilterKey;
(function (PatchFilterKey) {
    PatchFilterKey["AdvisoryId"] = "ADVISORY_ID";
    PatchFilterKey["Arch"] = "ARCH";
    PatchFilterKey["BugzillaId"] = "BUGZILLA_ID";
    PatchFilterKey["CVEId"] = "CVE_ID";
    PatchFilterKey["Classification"] = "CLASSIFICATION";
    PatchFilterKey["Epoch"] = "EPOCH";
    PatchFilterKey["MsrcSeverity"] = "MSRC_SEVERITY";
    PatchFilterKey["Name"] = "NAME";
    PatchFilterKey["PatchId"] = "PATCH_ID";
    PatchFilterKey["PatchSet"] = "PATCH_SET";
    PatchFilterKey["Priority"] = "PRIORITY";
    PatchFilterKey["Product"] = "PRODUCT";
    PatchFilterKey["ProductFamily"] = "PRODUCT_FAMILY";
    PatchFilterKey["Release"] = "RELEASE";
    PatchFilterKey["Repository"] = "REPOSITORY";
    PatchFilterKey["Section"] = "SECTION";
    PatchFilterKey["Security"] = "SECURITY";
    PatchFilterKey["Severity"] = "SEVERITY";
    PatchFilterKey["Version"] = "VERSION";
})(PatchFilterKey = exports.PatchFilterKey || (exports.PatchFilterKey = {}));
var OperatingSystem;
(function (OperatingSystem) {
    OperatingSystem["AmazonLinux"] = "AMAZON_LINUX";
    OperatingSystem["AmazonLinux2"] = "AMAZON_LINUX_2";
    OperatingSystem["AmazonLinux2022"] = "AMAZON_LINUX_2022";
    OperatingSystem["CentOS"] = "CENTOS";
    OperatingSystem["Debian"] = "DEBIAN";
    OperatingSystem["MacOS"] = "MACOS";
    OperatingSystem["OracleLinux"] = "ORACLE_LINUX";
    OperatingSystem["Raspbian"] = "RASPBIAN";
    OperatingSystem["RedhatEnterpriseLinux"] = "REDHAT_ENTERPRISE_LINUX";
    OperatingSystem["Rocky_Linux"] = "ROCKY_LINUX";
    OperatingSystem["Suse"] = "SUSE";
    OperatingSystem["Ubuntu"] = "UBUNTU";
    OperatingSystem["Windows"] = "WINDOWS";
})(OperatingSystem = exports.OperatingSystem || (exports.OperatingSystem = {}));
var PatchAction;
(function (PatchAction) {
    PatchAction["AllowAsDependency"] = "ALLOW_AS_DEPENDENCY";
    PatchAction["Block"] = "BLOCK";
})(PatchAction = exports.PatchAction || (exports.PatchAction = {}));
var ResourceDataSyncS3Format;
(function (ResourceDataSyncS3Format) {
    ResourceDataSyncS3Format["JSON_SERDE"] = "JsonSerDe";
})(ResourceDataSyncS3Format = exports.ResourceDataSyncS3Format || (exports.ResourceDataSyncS3Format = {}));
class ResourceDataSyncAlreadyExistsException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourceDataSyncAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceDataSyncAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceDataSyncAlreadyExistsException.prototype);
        this.SyncName = opts.SyncName;
    }
}
exports.ResourceDataSyncAlreadyExistsException = ResourceDataSyncAlreadyExistsException;
class ResourceDataSyncCountExceededException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourceDataSyncCountExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceDataSyncCountExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceDataSyncCountExceededException.prototype);
        this.Message = opts.Message;
    }
}
exports.ResourceDataSyncCountExceededException = ResourceDataSyncCountExceededException;
class ResourceDataSyncInvalidConfigurationException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourceDataSyncInvalidConfigurationException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceDataSyncInvalidConfigurationException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceDataSyncInvalidConfigurationException.prototype);
        this.Message = opts.Message;
    }
}
exports.ResourceDataSyncInvalidConfigurationException = ResourceDataSyncInvalidConfigurationException;
class InvalidActivation extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidActivation",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidActivation";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidActivation.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidActivation = InvalidActivation;
class InvalidActivationId extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidActivationId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidActivationId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidActivationId.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidActivationId = InvalidActivationId;
class AssociationDoesNotExist extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AssociationDoesNotExist",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationDoesNotExist";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationDoesNotExist.prototype);
        this.Message = opts.Message;
    }
}
exports.AssociationDoesNotExist = AssociationDoesNotExist;
class AssociatedInstances extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AssociatedInstances",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociatedInstances";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociatedInstances.prototype);
    }
}
exports.AssociatedInstances = AssociatedInstances;
class InvalidDocumentOperation extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidDocumentOperation",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentOperation";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentOperation.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidDocumentOperation = InvalidDocumentOperation;
var InventorySchemaDeleteOption;
(function (InventorySchemaDeleteOption) {
    InventorySchemaDeleteOption["DELETE_SCHEMA"] = "DeleteSchema";
    InventorySchemaDeleteOption["DISABLE_SCHEMA"] = "DisableSchema";
})(InventorySchemaDeleteOption = exports.InventorySchemaDeleteOption || (exports.InventorySchemaDeleteOption = {}));
class InvalidDeleteInventoryParametersException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidDeleteInventoryParametersException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDeleteInventoryParametersException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDeleteInventoryParametersException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidDeleteInventoryParametersException = InvalidDeleteInventoryParametersException;
class InvalidInventoryRequestException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidInventoryRequestException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInventoryRequestException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInventoryRequestException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidInventoryRequestException = InvalidInventoryRequestException;
class InvalidOptionException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidOptionException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidOptionException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidOptionException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidOptionException = InvalidOptionException;
class InvalidTypeNameException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidTypeNameException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTypeNameException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTypeNameException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidTypeNameException = InvalidTypeNameException;
class OpsMetadataNotFoundException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsMetadataNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataNotFoundException.prototype);
    }
}
exports.OpsMetadataNotFoundException = OpsMetadataNotFoundException;
class ParameterNotFound extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ParameterNotFound",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterNotFound";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterNotFound.prototype);
    }
}
exports.ParameterNotFound = ParameterNotFound;
class ResourceInUseException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourceInUseException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceInUseException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceInUseException.prototype);
        this.Message = opts.Message;
    }
}
exports.ResourceInUseException = ResourceInUseException;
class ResourceDataSyncNotFoundException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourceDataSyncNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceDataSyncNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceDataSyncNotFoundException.prototype);
        this.SyncName = opts.SyncName;
        this.SyncType = opts.SyncType;
        this.Message = opts.Message;
    }
}
exports.ResourceDataSyncNotFoundException = ResourceDataSyncNotFoundException;
class ResourcePolicyConflictException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourcePolicyConflictException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourcePolicyConflictException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourcePolicyConflictException.prototype);
        this.Message = opts.Message;
    }
}
exports.ResourcePolicyConflictException = ResourcePolicyConflictException;
class ResourcePolicyInvalidParameterException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourcePolicyInvalidParameterException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourcePolicyInvalidParameterException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourcePolicyInvalidParameterException.prototype);
        this.ParameterNames = opts.ParameterNames;
        this.Message = opts.Message;
    }
}
exports.ResourcePolicyInvalidParameterException = ResourcePolicyInvalidParameterException;
class TargetInUseException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "TargetInUseException",
            $fault: "client",
            ...opts,
        });
        this.name = "TargetInUseException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TargetInUseException.prototype);
        this.Message = opts.Message;
    }
}
exports.TargetInUseException = TargetInUseException;
var DescribeActivationsFilterKeys;
(function (DescribeActivationsFilterKeys) {
    DescribeActivationsFilterKeys["ACTIVATION_IDS"] = "ActivationIds";
    DescribeActivationsFilterKeys["DEFAULT_INSTANCE_NAME"] = "DefaultInstanceName";
    DescribeActivationsFilterKeys["IAM_ROLE"] = "IamRole";
})(DescribeActivationsFilterKeys = exports.DescribeActivationsFilterKeys || (exports.DescribeActivationsFilterKeys = {}));
class InvalidFilter extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidFilter",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidFilter";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidFilter.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidFilter = InvalidFilter;
class InvalidNextToken extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidNextToken",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidNextToken";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidNextToken.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidNextToken = InvalidNextToken;
class InvalidAssociationVersion extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidAssociationVersion",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAssociationVersion";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAssociationVersion.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidAssociationVersion = InvalidAssociationVersion;
var AssociationExecutionFilterKey;
(function (AssociationExecutionFilterKey) {
    AssociationExecutionFilterKey["CreatedTime"] = "CreatedTime";
    AssociationExecutionFilterKey["ExecutionId"] = "ExecutionId";
    AssociationExecutionFilterKey["Status"] = "Status";
})(AssociationExecutionFilterKey = exports.AssociationExecutionFilterKey || (exports.AssociationExecutionFilterKey = {}));
var AssociationFilterOperatorType;
(function (AssociationFilterOperatorType) {
    AssociationFilterOperatorType["Equal"] = "EQUAL";
    AssociationFilterOperatorType["GreaterThan"] = "GREATER_THAN";
    AssociationFilterOperatorType["LessThan"] = "LESS_THAN";
})(AssociationFilterOperatorType = exports.AssociationFilterOperatorType || (exports.AssociationFilterOperatorType = {}));
class AssociationExecutionDoesNotExist extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AssociationExecutionDoesNotExist",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationExecutionDoesNotExist";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationExecutionDoesNotExist.prototype);
        this.Message = opts.Message;
    }
}
exports.AssociationExecutionDoesNotExist = AssociationExecutionDoesNotExist;
var AssociationExecutionTargetsFilterKey;
(function (AssociationExecutionTargetsFilterKey) {
    AssociationExecutionTargetsFilterKey["ResourceId"] = "ResourceId";
    AssociationExecutionTargetsFilterKey["ResourceType"] = "ResourceType";
    AssociationExecutionTargetsFilterKey["Status"] = "Status";
})(AssociationExecutionTargetsFilterKey = exports.AssociationExecutionTargetsFilterKey || (exports.AssociationExecutionTargetsFilterKey = {}));
var AutomationExecutionFilterKey;
(function (AutomationExecutionFilterKey) {
    AutomationExecutionFilterKey["AUTOMATION_SUBTYPE"] = "AutomationSubtype";
    AutomationExecutionFilterKey["AUTOMATION_TYPE"] = "AutomationType";
    AutomationExecutionFilterKey["CURRENT_ACTION"] = "CurrentAction";
    AutomationExecutionFilterKey["DOCUMENT_NAME_PREFIX"] = "DocumentNamePrefix";
    AutomationExecutionFilterKey["EXECUTION_ID"] = "ExecutionId";
    AutomationExecutionFilterKey["EXECUTION_STATUS"] = "ExecutionStatus";
    AutomationExecutionFilterKey["OPS_ITEM_ID"] = "OpsItemId";
    AutomationExecutionFilterKey["PARENT_EXECUTION_ID"] = "ParentExecutionId";
    AutomationExecutionFilterKey["START_TIME_AFTER"] = "StartTimeAfter";
    AutomationExecutionFilterKey["START_TIME_BEFORE"] = "StartTimeBefore";
    AutomationExecutionFilterKey["TAG_KEY"] = "TagKey";
    AutomationExecutionFilterKey["TARGET_RESOURCE_GROUP"] = "TargetResourceGroup";
})(AutomationExecutionFilterKey = exports.AutomationExecutionFilterKey || (exports.AutomationExecutionFilterKey = {}));
var AutomationExecutionStatus;
(function (AutomationExecutionStatus) {
    AutomationExecutionStatus["APPROVED"] = "Approved";
    AutomationExecutionStatus["CANCELLED"] = "Cancelled";
    AutomationExecutionStatus["CANCELLING"] = "Cancelling";
    AutomationExecutionStatus["CHANGE_CALENDAR_OVERRIDE_APPROVED"] = "ChangeCalendarOverrideApproved";
    AutomationExecutionStatus["CHANGE_CALENDAR_OVERRIDE_REJECTED"] = "ChangeCalendarOverrideRejected";
    AutomationExecutionStatus["COMPLETED_WITH_FAILURE"] = "CompletedWithFailure";
    AutomationExecutionStatus["COMPLETED_WITH_SUCCESS"] = "CompletedWithSuccess";
    AutomationExecutionStatus["FAILED"] = "Failed";
    AutomationExecutionStatus["INPROGRESS"] = "InProgress";
    AutomationExecutionStatus["PENDING"] = "Pending";
    AutomationExecutionStatus["PENDING_APPROVAL"] = "PendingApproval";
    AutomationExecutionStatus["PENDING_CHANGE_CALENDAR_OVERRIDE"] = "PendingChangeCalendarOverride";
    AutomationExecutionStatus["REJECTED"] = "Rejected";
    AutomationExecutionStatus["RUNBOOK_INPROGRESS"] = "RunbookInProgress";
    AutomationExecutionStatus["SCHEDULED"] = "Scheduled";
    AutomationExecutionStatus["SUCCESS"] = "Success";
    AutomationExecutionStatus["TIMEDOUT"] = "TimedOut";
    AutomationExecutionStatus["WAITING"] = "Waiting";
})(AutomationExecutionStatus = exports.AutomationExecutionStatus || (exports.AutomationExecutionStatus = {}));
var AutomationSubtype;
(function (AutomationSubtype) {
    AutomationSubtype["ChangeRequest"] = "ChangeRequest";
})(AutomationSubtype = exports.AutomationSubtype || (exports.AutomationSubtype = {}));
var AutomationType;
(function (AutomationType) {
    AutomationType["CrossAccount"] = "CrossAccount";
    AutomationType["Local"] = "Local";
})(AutomationType = exports.AutomationType || (exports.AutomationType = {}));
var ExecutionMode;
(function (ExecutionMode) {
    ExecutionMode["Auto"] = "Auto";
    ExecutionMode["Interactive"] = "Interactive";
})(ExecutionMode = exports.ExecutionMode || (exports.ExecutionMode = {}));
class InvalidFilterKey extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidFilterKey",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidFilterKey";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidFilterKey.prototype);
    }
}
exports.InvalidFilterKey = InvalidFilterKey;
class InvalidFilterValue extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidFilterValue",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidFilterValue";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidFilterValue.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidFilterValue = InvalidFilterValue;
class AutomationExecutionNotFoundException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AutomationExecutionNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "AutomationExecutionNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AutomationExecutionNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
exports.AutomationExecutionNotFoundException = AutomationExecutionNotFoundException;
var StepExecutionFilterKey;
(function (StepExecutionFilterKey) {
    StepExecutionFilterKey["ACTION"] = "Action";
    StepExecutionFilterKey["START_TIME_AFTER"] = "StartTimeAfter";
    StepExecutionFilterKey["START_TIME_BEFORE"] = "StartTimeBefore";
    StepExecutionFilterKey["STEP_EXECUTION_ID"] = "StepExecutionId";
    StepExecutionFilterKey["STEP_EXECUTION_STATUS"] = "StepExecutionStatus";
    StepExecutionFilterKey["STEP_NAME"] = "StepName";
})(StepExecutionFilterKey = exports.StepExecutionFilterKey || (exports.StepExecutionFilterKey = {}));
var DocumentPermissionType;
(function (DocumentPermissionType) {
    DocumentPermissionType["SHARE"] = "Share";
})(DocumentPermissionType = exports.DocumentPermissionType || (exports.DocumentPermissionType = {}));
class InvalidPermissionType extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidPermissionType",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidPermissionType";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidPermissionType.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidPermissionType = InvalidPermissionType;
var PatchDeploymentStatus;
(function (PatchDeploymentStatus) {
    PatchDeploymentStatus["Approved"] = "APPROVED";
    PatchDeploymentStatus["ExplicitApproved"] = "EXPLICIT_APPROVED";
    PatchDeploymentStatus["ExplicitRejected"] = "EXPLICIT_REJECTED";
    PatchDeploymentStatus["PendingApproval"] = "PENDING_APPROVAL";
})(PatchDeploymentStatus = exports.PatchDeploymentStatus || (exports.PatchDeploymentStatus = {}));
class UnsupportedOperatingSystem extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "UnsupportedOperatingSystem",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedOperatingSystem";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedOperatingSystem.prototype);
        this.Message = opts.Message;
    }
}
exports.UnsupportedOperatingSystem = UnsupportedOperatingSystem;
var InstanceInformationFilterKey;
(function (InstanceInformationFilterKey) {
    InstanceInformationFilterKey["ACTIVATION_IDS"] = "ActivationIds";
    InstanceInformationFilterKey["AGENT_VERSION"] = "AgentVersion";
    InstanceInformationFilterKey["ASSOCIATION_STATUS"] = "AssociationStatus";
    InstanceInformationFilterKey["IAM_ROLE"] = "IamRole";
    InstanceInformationFilterKey["INSTANCE_IDS"] = "InstanceIds";
    InstanceInformationFilterKey["PING_STATUS"] = "PingStatus";
    InstanceInformationFilterKey["PLATFORM_TYPES"] = "PlatformTypes";
    InstanceInformationFilterKey["RESOURCE_TYPE"] = "ResourceType";
})(InstanceInformationFilterKey = exports.InstanceInformationFilterKey || (exports.InstanceInformationFilterKey = {}));
var PingStatus;
(function (PingStatus) {
    PingStatus["CONNECTION_LOST"] = "ConnectionLost";
    PingStatus["INACTIVE"] = "Inactive";
    PingStatus["ONLINE"] = "Online";
})(PingStatus = exports.PingStatus || (exports.PingStatus = {}));
var ResourceType;
(function (ResourceType) {
    ResourceType["DOCUMENT"] = "Document";
    ResourceType["EC2_INSTANCE"] = "EC2Instance";
    ResourceType["MANAGED_INSTANCE"] = "ManagedInstance";
})(ResourceType = exports.ResourceType || (exports.ResourceType = {}));
var SourceType;
(function (SourceType) {
    SourceType["AWS_EC2_INSTANCE"] = "AWS::EC2::Instance";
    SourceType["AWS_IOT_THING"] = "AWS::IoT::Thing";
    SourceType["AWS_SSM_MANAGEDINSTANCE"] = "AWS::SSM::ManagedInstance";
})(SourceType = exports.SourceType || (exports.SourceType = {}));
class InvalidInstanceInformationFilterValue extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidInstanceInformationFilterValue",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInstanceInformationFilterValue";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInstanceInformationFilterValue.prototype);
    }
}
exports.InvalidInstanceInformationFilterValue = InvalidInstanceInformationFilterValue;
var PatchComplianceDataState;
(function (PatchComplianceDataState) {
    PatchComplianceDataState["Failed"] = "FAILED";
    PatchComplianceDataState["Installed"] = "INSTALLED";
    PatchComplianceDataState["InstalledOther"] = "INSTALLED_OTHER";
    PatchComplianceDataState["InstalledPendingReboot"] = "INSTALLED_PENDING_REBOOT";
    PatchComplianceDataState["InstalledRejected"] = "INSTALLED_REJECTED";
    PatchComplianceDataState["Missing"] = "MISSING";
    PatchComplianceDataState["NotApplicable"] = "NOT_APPLICABLE";
})(PatchComplianceDataState = exports.PatchComplianceDataState || (exports.PatchComplianceDataState = {}));
var PatchOperationType;
(function (PatchOperationType) {
    PatchOperationType["INSTALL"] = "Install";
    PatchOperationType["SCAN"] = "Scan";
})(PatchOperationType = exports.PatchOperationType || (exports.PatchOperationType = {}));
var RebootOption;
(function (RebootOption) {
    RebootOption["NO_REBOOT"] = "NoReboot";
    RebootOption["REBOOT_IF_NEEDED"] = "RebootIfNeeded";
})(RebootOption = exports.RebootOption || (exports.RebootOption = {}));
var InstancePatchStateOperatorType;
(function (InstancePatchStateOperatorType) {
    InstancePatchStateOperatorType["EQUAL"] = "Equal";
    InstancePatchStateOperatorType["GREATER_THAN"] = "GreaterThan";
    InstancePatchStateOperatorType["LESS_THAN"] = "LessThan";
    InstancePatchStateOperatorType["NOT_EQUAL"] = "NotEqual";
})(InstancePatchStateOperatorType = exports.InstancePatchStateOperatorType || (exports.InstancePatchStateOperatorType = {}));
var InventoryDeletionStatus;
(function (InventoryDeletionStatus) {
    InventoryDeletionStatus["COMPLETE"] = "Complete";
    InventoryDeletionStatus["IN_PROGRESS"] = "InProgress";
})(InventoryDeletionStatus = exports.InventoryDeletionStatus || (exports.InventoryDeletionStatus = {}));
class InvalidDeletionIdException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidDeletionIdException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDeletionIdException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDeletionIdException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidDeletionIdException = InvalidDeletionIdException;
var MaintenanceWindowExecutionStatus;
(function (MaintenanceWindowExecutionStatus) {
    MaintenanceWindowExecutionStatus["Cancelled"] = "CANCELLED";
    MaintenanceWindowExecutionStatus["Cancelling"] = "CANCELLING";
    MaintenanceWindowExecutionStatus["Failed"] = "FAILED";
    MaintenanceWindowExecutionStatus["InProgress"] = "IN_PROGRESS";
    MaintenanceWindowExecutionStatus["Pending"] = "PENDING";
    MaintenanceWindowExecutionStatus["SkippedOverlapping"] = "SKIPPED_OVERLAPPING";
    MaintenanceWindowExecutionStatus["Success"] = "SUCCESS";
    MaintenanceWindowExecutionStatus["TimedOut"] = "TIMED_OUT";
})(MaintenanceWindowExecutionStatus = exports.MaintenanceWindowExecutionStatus || (exports.MaintenanceWindowExecutionStatus = {}));
var MaintenanceWindowTaskType;
(function (MaintenanceWindowTaskType) {
    MaintenanceWindowTaskType["Automation"] = "AUTOMATION";
    MaintenanceWindowTaskType["Lambda"] = "LAMBDA";
    MaintenanceWindowTaskType["RunCommand"] = "RUN_COMMAND";
    MaintenanceWindowTaskType["StepFunctions"] = "STEP_FUNCTIONS";
})(MaintenanceWindowTaskType = exports.MaintenanceWindowTaskType || (exports.MaintenanceWindowTaskType = {}));
var MaintenanceWindowResourceType;
(function (MaintenanceWindowResourceType) {
    MaintenanceWindowResourceType["Instance"] = "INSTANCE";
    MaintenanceWindowResourceType["ResourceGroup"] = "RESOURCE_GROUP";
})(MaintenanceWindowResourceType = exports.MaintenanceWindowResourceType || (exports.MaintenanceWindowResourceType = {}));
var MaintenanceWindowTaskCutoffBehavior;
(function (MaintenanceWindowTaskCutoffBehavior) {
    MaintenanceWindowTaskCutoffBehavior["CancelTask"] = "CANCEL_TASK";
    MaintenanceWindowTaskCutoffBehavior["ContinueTask"] = "CONTINUE_TASK";
})(MaintenanceWindowTaskCutoffBehavior = exports.MaintenanceWindowTaskCutoffBehavior || (exports.MaintenanceWindowTaskCutoffBehavior = {}));
var OpsItemFilterKey;
(function (OpsItemFilterKey) {
    OpsItemFilterKey["ACCOUNT_ID"] = "AccountId";
    OpsItemFilterKey["ACTUAL_END_TIME"] = "ActualEndTime";
    OpsItemFilterKey["ACTUAL_START_TIME"] = "ActualStartTime";
    OpsItemFilterKey["AUTOMATION_ID"] = "AutomationId";
    OpsItemFilterKey["CATEGORY"] = "Category";
    OpsItemFilterKey["CHANGE_REQUEST_APPROVER_ARN"] = "ChangeRequestByApproverArn";
    OpsItemFilterKey["CHANGE_REQUEST_APPROVER_NAME"] = "ChangeRequestByApproverName";
    OpsItemFilterKey["CHANGE_REQUEST_REQUESTER_ARN"] = "ChangeRequestByRequesterArn";
    OpsItemFilterKey["CHANGE_REQUEST_REQUESTER_NAME"] = "ChangeRequestByRequesterName";
    OpsItemFilterKey["CHANGE_REQUEST_TARGETS_RESOURCE_GROUP"] = "ChangeRequestByTargetsResourceGroup";
    OpsItemFilterKey["CHANGE_REQUEST_TEMPLATE"] = "ChangeRequestByTemplate";
    OpsItemFilterKey["CREATED_BY"] = "CreatedBy";
    OpsItemFilterKey["CREATED_TIME"] = "CreatedTime";
    OpsItemFilterKey["INSIGHT_TYPE"] = "InsightByType";
    OpsItemFilterKey["LAST_MODIFIED_TIME"] = "LastModifiedTime";
    OpsItemFilterKey["OPERATIONAL_DATA"] = "OperationalData";
    OpsItemFilterKey["OPERATIONAL_DATA_KEY"] = "OperationalDataKey";
    OpsItemFilterKey["OPERATIONAL_DATA_VALUE"] = "OperationalDataValue";
    OpsItemFilterKey["OPSITEM_ID"] = "OpsItemId";
    OpsItemFilterKey["OPSITEM_TYPE"] = "OpsItemType";
    OpsItemFilterKey["PLANNED_END_TIME"] = "PlannedEndTime";
    OpsItemFilterKey["PLANNED_START_TIME"] = "PlannedStartTime";
    OpsItemFilterKey["PRIORITY"] = "Priority";
    OpsItemFilterKey["RESOURCE_ID"] = "ResourceId";
    OpsItemFilterKey["SEVERITY"] = "Severity";
    OpsItemFilterKey["SOURCE"] = "Source";
    OpsItemFilterKey["STATUS"] = "Status";
    OpsItemFilterKey["TITLE"] = "Title";
})(OpsItemFilterKey = exports.OpsItemFilterKey || (exports.OpsItemFilterKey = {}));
var OpsItemFilterOperator;
(function (OpsItemFilterOperator) {
    OpsItemFilterOperator["CONTAINS"] = "Contains";
    OpsItemFilterOperator["EQUAL"] = "Equal";
    OpsItemFilterOperator["GREATER_THAN"] = "GreaterThan";
    OpsItemFilterOperator["LESS_THAN"] = "LessThan";
})(OpsItemFilterOperator = exports.OpsItemFilterOperator || (exports.OpsItemFilterOperator = {}));
const AccountSharingInfoFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.AccountSharingInfoFilterSensitiveLog = AccountSharingInfoFilterSensitiveLog;
const TagFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.TagFilterSensitiveLog = TagFilterSensitiveLog;
const ActivationFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.ActivationFilterSensitiveLog = ActivationFilterSensitiveLog;
const AddTagsToResourceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.AddTagsToResourceRequestFilterSensitiveLog = AddTagsToResourceRequestFilterSensitiveLog;
const AddTagsToResourceResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.AddTagsToResourceResultFilterSensitiveLog = AddTagsToResourceResultFilterSensitiveLog;
const AlarmFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.AlarmFilterSensitiveLog = AlarmFilterSensitiveLog;
const AlarmConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.AlarmConfigurationFilterSensitiveLog = AlarmConfigurationFilterSensitiveLog;
const AlarmStateInformationFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.AlarmStateInformationFilterSensitiveLog = AlarmStateInformationFilterSensitiveLog;
const AssociateOpsItemRelatedItemRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.AssociateOpsItemRelatedItemRequestFilterSensitiveLog = AssociateOpsItemRelatedItemRequestFilterSensitiveLog;
const AssociateOpsItemRelatedItemResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.AssociateOpsItemRelatedItemResponseFilterSensitiveLog = AssociateOpsItemRelatedItemResponseFilterSensitiveLog;
const CancelCommandRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.CancelCommandRequestFilterSensitiveLog = CancelCommandRequestFilterSensitiveLog;
const CancelCommandResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.CancelCommandResultFilterSensitiveLog = CancelCommandResultFilterSensitiveLog;
const CancelMaintenanceWindowExecutionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.CancelMaintenanceWindowExecutionRequestFilterSensitiveLog = CancelMaintenanceWindowExecutionRequestFilterSensitiveLog;
const CancelMaintenanceWindowExecutionResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.CancelMaintenanceWindowExecutionResultFilterSensitiveLog = CancelMaintenanceWindowExecutionResultFilterSensitiveLog;
const RegistrationMetadataItemFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.RegistrationMetadataItemFilterSensitiveLog = RegistrationMetadataItemFilterSensitiveLog;
const CreateActivationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.CreateActivationRequestFilterSensitiveLog = CreateActivationRequestFilterSensitiveLog;
const CreateActivationResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.CreateActivationResultFilterSensitiveLog = CreateActivationResultFilterSensitiveLog;
const S3OutputLocationFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.S3OutputLocationFilterSensitiveLog = S3OutputLocationFilterSensitiveLog;
const InstanceAssociationOutputLocationFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.InstanceAssociationOutputLocationFilterSensitiveLog = InstanceAssociationOutputLocationFilterSensitiveLog;
const TargetLocationFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.TargetLocationFilterSensitiveLog = TargetLocationFilterSensitiveLog;
const TargetFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.TargetFilterSensitiveLog = TargetFilterSensitiveLog;
const CreateAssociationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: smithy_client_1.SENSITIVE_STRING }),
});
exports.CreateAssociationRequestFilterSensitiveLog = CreateAssociationRequestFilterSensitiveLog;
const AssociationOverviewFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.AssociationOverviewFilterSensitiveLog = AssociationOverviewFilterSensitiveLog;
const AssociationStatusFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.AssociationStatusFilterSensitiveLog = AssociationStatusFilterSensitiveLog;
const AssociationDescriptionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: smithy_client_1.SENSITIVE_STRING }),
});
exports.AssociationDescriptionFilterSensitiveLog = AssociationDescriptionFilterSensitiveLog;
const CreateAssociationResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AssociationDescription && {
        AssociationDescription: (0, exports.AssociationDescriptionFilterSensitiveLog)(obj.AssociationDescription),
    }),
});
exports.CreateAssociationResultFilterSensitiveLog = CreateAssociationResultFilterSensitiveLog;
const CreateAssociationBatchRequestEntryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: smithy_client_1.SENSITIVE_STRING }),
});
exports.CreateAssociationBatchRequestEntryFilterSensitiveLog = CreateAssociationBatchRequestEntryFilterSensitiveLog;
const CreateAssociationBatchRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Entries && {
        Entries: obj.Entries.map((item) => (0, exports.CreateAssociationBatchRequestEntryFilterSensitiveLog)(item)),
    }),
});
exports.CreateAssociationBatchRequestFilterSensitiveLog = CreateAssociationBatchRequestFilterSensitiveLog;
const FailedCreateAssociationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Entry && { Entry: (0, exports.CreateAssociationBatchRequestEntryFilterSensitiveLog)(obj.Entry) }),
});
exports.FailedCreateAssociationFilterSensitiveLog = FailedCreateAssociationFilterSensitiveLog;
const CreateAssociationBatchResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Successful && { Successful: obj.Successful.map((item) => (0, exports.AssociationDescriptionFilterSensitiveLog)(item)) }),
    ...(obj.Failed && { Failed: obj.Failed.map((item) => (0, exports.FailedCreateAssociationFilterSensitiveLog)(item)) }),
});
exports.CreateAssociationBatchResultFilterSensitiveLog = CreateAssociationBatchResultFilterSensitiveLog;
const AttachmentsSourceFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.AttachmentsSourceFilterSensitiveLog = AttachmentsSourceFilterSensitiveLog;
const DocumentRequiresFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DocumentRequiresFilterSensitiveLog = DocumentRequiresFilterSensitiveLog;
const CreateDocumentRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.CreateDocumentRequestFilterSensitiveLog = CreateDocumentRequestFilterSensitiveLog;
const AttachmentInformationFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.AttachmentInformationFilterSensitiveLog = AttachmentInformationFilterSensitiveLog;
const DocumentParameterFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DocumentParameterFilterSensitiveLog = DocumentParameterFilterSensitiveLog;
const ReviewInformationFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.ReviewInformationFilterSensitiveLog = ReviewInformationFilterSensitiveLog;
const DocumentDescriptionFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DocumentDescriptionFilterSensitiveLog = DocumentDescriptionFilterSensitiveLog;
const CreateDocumentResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.CreateDocumentResultFilterSensitiveLog = CreateDocumentResultFilterSensitiveLog;
const CreateMaintenanceWindowRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Description && { Description: smithy_client_1.SENSITIVE_STRING }),
});
exports.CreateMaintenanceWindowRequestFilterSensitiveLog = CreateMaintenanceWindowRequestFilterSensitiveLog;
const CreateMaintenanceWindowResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.CreateMaintenanceWindowResultFilterSensitiveLog = CreateMaintenanceWindowResultFilterSensitiveLog;
const OpsItemNotificationFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.OpsItemNotificationFilterSensitiveLog = OpsItemNotificationFilterSensitiveLog;
const OpsItemDataValueFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.OpsItemDataValueFilterSensitiveLog = OpsItemDataValueFilterSensitiveLog;
const RelatedOpsItemFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.RelatedOpsItemFilterSensitiveLog = RelatedOpsItemFilterSensitiveLog;
const CreateOpsItemRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.CreateOpsItemRequestFilterSensitiveLog = CreateOpsItemRequestFilterSensitiveLog;
const CreateOpsItemResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.CreateOpsItemResponseFilterSensitiveLog = CreateOpsItemResponseFilterSensitiveLog;
const MetadataValueFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.MetadataValueFilterSensitiveLog = MetadataValueFilterSensitiveLog;
const CreateOpsMetadataRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.CreateOpsMetadataRequestFilterSensitiveLog = CreateOpsMetadataRequestFilterSensitiveLog;
const CreateOpsMetadataResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.CreateOpsMetadataResultFilterSensitiveLog = CreateOpsMetadataResultFilterSensitiveLog;
const PatchFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.PatchFilterFilterSensitiveLog = PatchFilterFilterSensitiveLog;
const PatchFilterGroupFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.PatchFilterGroupFilterSensitiveLog = PatchFilterGroupFilterSensitiveLog;
const PatchRuleFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.PatchRuleFilterSensitiveLog = PatchRuleFilterSensitiveLog;
const PatchRuleGroupFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.PatchRuleGroupFilterSensitiveLog = PatchRuleGroupFilterSensitiveLog;
const PatchSourceFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Configuration && { Configuration: smithy_client_1.SENSITIVE_STRING }),
});
exports.PatchSourceFilterSensitiveLog = PatchSourceFilterSensitiveLog;
const CreatePatchBaselineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Sources && { Sources: obj.Sources.map((item) => (0, exports.PatchSourceFilterSensitiveLog)(item)) }),
});
exports.CreatePatchBaselineRequestFilterSensitiveLog = CreatePatchBaselineRequestFilterSensitiveLog;
const CreatePatchBaselineResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.CreatePatchBaselineResultFilterSensitiveLog = CreatePatchBaselineResultFilterSensitiveLog;
const ResourceDataSyncDestinationDataSharingFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.ResourceDataSyncDestinationDataSharingFilterSensitiveLog = ResourceDataSyncDestinationDataSharingFilterSensitiveLog;
const ResourceDataSyncS3DestinationFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.ResourceDataSyncS3DestinationFilterSensitiveLog = ResourceDataSyncS3DestinationFilterSensitiveLog;
const ResourceDataSyncOrganizationalUnitFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.ResourceDataSyncOrganizationalUnitFilterSensitiveLog = ResourceDataSyncOrganizationalUnitFilterSensitiveLog;
const ResourceDataSyncAwsOrganizationsSourceFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.ResourceDataSyncAwsOrganizationsSourceFilterSensitiveLog = ResourceDataSyncAwsOrganizationsSourceFilterSensitiveLog;
const ResourceDataSyncSourceFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.ResourceDataSyncSourceFilterSensitiveLog = ResourceDataSyncSourceFilterSensitiveLog;
const CreateResourceDataSyncRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.CreateResourceDataSyncRequestFilterSensitiveLog = CreateResourceDataSyncRequestFilterSensitiveLog;
const CreateResourceDataSyncResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.CreateResourceDataSyncResultFilterSensitiveLog = CreateResourceDataSyncResultFilterSensitiveLog;
const DeleteActivationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeleteActivationRequestFilterSensitiveLog = DeleteActivationRequestFilterSensitiveLog;
const DeleteActivationResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeleteActivationResultFilterSensitiveLog = DeleteActivationResultFilterSensitiveLog;
const DeleteAssociationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeleteAssociationRequestFilterSensitiveLog = DeleteAssociationRequestFilterSensitiveLog;
const DeleteAssociationResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeleteAssociationResultFilterSensitiveLog = DeleteAssociationResultFilterSensitiveLog;
const DeleteDocumentRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeleteDocumentRequestFilterSensitiveLog = DeleteDocumentRequestFilterSensitiveLog;
const DeleteDocumentResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeleteDocumentResultFilterSensitiveLog = DeleteDocumentResultFilterSensitiveLog;
const DeleteInventoryRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeleteInventoryRequestFilterSensitiveLog = DeleteInventoryRequestFilterSensitiveLog;
const InventoryDeletionSummaryItemFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.InventoryDeletionSummaryItemFilterSensitiveLog = InventoryDeletionSummaryItemFilterSensitiveLog;
const InventoryDeletionSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.InventoryDeletionSummaryFilterSensitiveLog = InventoryDeletionSummaryFilterSensitiveLog;
const DeleteInventoryResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeleteInventoryResultFilterSensitiveLog = DeleteInventoryResultFilterSensitiveLog;
const DeleteMaintenanceWindowRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeleteMaintenanceWindowRequestFilterSensitiveLog = DeleteMaintenanceWindowRequestFilterSensitiveLog;
const DeleteMaintenanceWindowResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeleteMaintenanceWindowResultFilterSensitiveLog = DeleteMaintenanceWindowResultFilterSensitiveLog;
const DeleteOpsMetadataRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeleteOpsMetadataRequestFilterSensitiveLog = DeleteOpsMetadataRequestFilterSensitiveLog;
const DeleteOpsMetadataResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeleteOpsMetadataResultFilterSensitiveLog = DeleteOpsMetadataResultFilterSensitiveLog;
const DeleteParameterRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeleteParameterRequestFilterSensitiveLog = DeleteParameterRequestFilterSensitiveLog;
const DeleteParameterResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeleteParameterResultFilterSensitiveLog = DeleteParameterResultFilterSensitiveLog;
const DeleteParametersRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeleteParametersRequestFilterSensitiveLog = DeleteParametersRequestFilterSensitiveLog;
const DeleteParametersResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeleteParametersResultFilterSensitiveLog = DeleteParametersResultFilterSensitiveLog;
const DeletePatchBaselineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeletePatchBaselineRequestFilterSensitiveLog = DeletePatchBaselineRequestFilterSensitiveLog;
const DeletePatchBaselineResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeletePatchBaselineResultFilterSensitiveLog = DeletePatchBaselineResultFilterSensitiveLog;
const DeleteResourceDataSyncRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeleteResourceDataSyncRequestFilterSensitiveLog = DeleteResourceDataSyncRequestFilterSensitiveLog;
const DeleteResourceDataSyncResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeleteResourceDataSyncResultFilterSensitiveLog = DeleteResourceDataSyncResultFilterSensitiveLog;
const DeleteResourcePolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeleteResourcePolicyRequestFilterSensitiveLog = DeleteResourcePolicyRequestFilterSensitiveLog;
const DeleteResourcePolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeleteResourcePolicyResponseFilterSensitiveLog = DeleteResourcePolicyResponseFilterSensitiveLog;
const DeregisterManagedInstanceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeregisterManagedInstanceRequestFilterSensitiveLog = DeregisterManagedInstanceRequestFilterSensitiveLog;
const DeregisterManagedInstanceResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeregisterManagedInstanceResultFilterSensitiveLog = DeregisterManagedInstanceResultFilterSensitiveLog;
const DeregisterPatchBaselineForPatchGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeregisterPatchBaselineForPatchGroupRequestFilterSensitiveLog = DeregisterPatchBaselineForPatchGroupRequestFilterSensitiveLog;
const DeregisterPatchBaselineForPatchGroupResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeregisterPatchBaselineForPatchGroupResultFilterSensitiveLog = DeregisterPatchBaselineForPatchGroupResultFilterSensitiveLog;
const DeregisterTargetFromMaintenanceWindowRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeregisterTargetFromMaintenanceWindowRequestFilterSensitiveLog = DeregisterTargetFromMaintenanceWindowRequestFilterSensitiveLog;
const DeregisterTargetFromMaintenanceWindowResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeregisterTargetFromMaintenanceWindowResultFilterSensitiveLog = DeregisterTargetFromMaintenanceWindowResultFilterSensitiveLog;
const DeregisterTaskFromMaintenanceWindowRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeregisterTaskFromMaintenanceWindowRequestFilterSensitiveLog = DeregisterTaskFromMaintenanceWindowRequestFilterSensitiveLog;
const DeregisterTaskFromMaintenanceWindowResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DeregisterTaskFromMaintenanceWindowResultFilterSensitiveLog = DeregisterTaskFromMaintenanceWindowResultFilterSensitiveLog;
const DescribeActivationsFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeActivationsFilterFilterSensitiveLog = DescribeActivationsFilterFilterSensitiveLog;
const DescribeActivationsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeActivationsRequestFilterSensitiveLog = DescribeActivationsRequestFilterSensitiveLog;
const DescribeActivationsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeActivationsResultFilterSensitiveLog = DescribeActivationsResultFilterSensitiveLog;
const DescribeAssociationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeAssociationRequestFilterSensitiveLog = DescribeAssociationRequestFilterSensitiveLog;
const DescribeAssociationResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AssociationDescription && {
        AssociationDescription: (0, exports.AssociationDescriptionFilterSensitiveLog)(obj.AssociationDescription),
    }),
});
exports.DescribeAssociationResultFilterSensitiveLog = DescribeAssociationResultFilterSensitiveLog;
const AssociationExecutionFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.AssociationExecutionFilterFilterSensitiveLog = AssociationExecutionFilterFilterSensitiveLog;
const DescribeAssociationExecutionsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeAssociationExecutionsRequestFilterSensitiveLog = DescribeAssociationExecutionsRequestFilterSensitiveLog;
const AssociationExecutionFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.AssociationExecutionFilterSensitiveLog = AssociationExecutionFilterSensitiveLog;
const DescribeAssociationExecutionsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeAssociationExecutionsResultFilterSensitiveLog = DescribeAssociationExecutionsResultFilterSensitiveLog;
const AssociationExecutionTargetsFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.AssociationExecutionTargetsFilterFilterSensitiveLog = AssociationExecutionTargetsFilterFilterSensitiveLog;
const DescribeAssociationExecutionTargetsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeAssociationExecutionTargetsRequestFilterSensitiveLog = DescribeAssociationExecutionTargetsRequestFilterSensitiveLog;
const OutputSourceFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.OutputSourceFilterSensitiveLog = OutputSourceFilterSensitiveLog;
const AssociationExecutionTargetFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.AssociationExecutionTargetFilterSensitiveLog = AssociationExecutionTargetFilterSensitiveLog;
const DescribeAssociationExecutionTargetsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeAssociationExecutionTargetsResultFilterSensitiveLog = DescribeAssociationExecutionTargetsResultFilterSensitiveLog;
const AutomationExecutionFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.AutomationExecutionFilterFilterSensitiveLog = AutomationExecutionFilterFilterSensitiveLog;
const DescribeAutomationExecutionsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeAutomationExecutionsRequestFilterSensitiveLog = DescribeAutomationExecutionsRequestFilterSensitiveLog;
const ResolvedTargetsFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.ResolvedTargetsFilterSensitiveLog = ResolvedTargetsFilterSensitiveLog;
const RunbookFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.RunbookFilterSensitiveLog = RunbookFilterSensitiveLog;
const AutomationExecutionMetadataFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.AutomationExecutionMetadataFilterSensitiveLog = AutomationExecutionMetadataFilterSensitiveLog;
const DescribeAutomationExecutionsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeAutomationExecutionsResultFilterSensitiveLog = DescribeAutomationExecutionsResultFilterSensitiveLog;
const StepExecutionFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.StepExecutionFilterFilterSensitiveLog = StepExecutionFilterFilterSensitiveLog;
const DescribeAutomationStepExecutionsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeAutomationStepExecutionsRequestFilterSensitiveLog = DescribeAutomationStepExecutionsRequestFilterSensitiveLog;
const FailureDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.FailureDetailsFilterSensitiveLog = FailureDetailsFilterSensitiveLog;
const StepExecutionFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.StepExecutionFilterSensitiveLog = StepExecutionFilterSensitiveLog;
const DescribeAutomationStepExecutionsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeAutomationStepExecutionsResultFilterSensitiveLog = DescribeAutomationStepExecutionsResultFilterSensitiveLog;
const PatchOrchestratorFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.PatchOrchestratorFilterFilterSensitiveLog = PatchOrchestratorFilterFilterSensitiveLog;
const DescribeAvailablePatchesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeAvailablePatchesRequestFilterSensitiveLog = DescribeAvailablePatchesRequestFilterSensitiveLog;
const PatchFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.PatchFilterSensitiveLog = PatchFilterSensitiveLog;
const DescribeAvailablePatchesResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeAvailablePatchesResultFilterSensitiveLog = DescribeAvailablePatchesResultFilterSensitiveLog;
const DescribeDocumentRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeDocumentRequestFilterSensitiveLog = DescribeDocumentRequestFilterSensitiveLog;
const DescribeDocumentResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeDocumentResultFilterSensitiveLog = DescribeDocumentResultFilterSensitiveLog;
const DescribeDocumentPermissionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeDocumentPermissionRequestFilterSensitiveLog = DescribeDocumentPermissionRequestFilterSensitiveLog;
const DescribeDocumentPermissionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeDocumentPermissionResponseFilterSensitiveLog = DescribeDocumentPermissionResponseFilterSensitiveLog;
const DescribeEffectiveInstanceAssociationsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeEffectiveInstanceAssociationsRequestFilterSensitiveLog = DescribeEffectiveInstanceAssociationsRequestFilterSensitiveLog;
const InstanceAssociationFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.InstanceAssociationFilterSensitiveLog = InstanceAssociationFilterSensitiveLog;
const DescribeEffectiveInstanceAssociationsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeEffectiveInstanceAssociationsResultFilterSensitiveLog = DescribeEffectiveInstanceAssociationsResultFilterSensitiveLog;
const DescribeEffectivePatchesForPatchBaselineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeEffectivePatchesForPatchBaselineRequestFilterSensitiveLog = DescribeEffectivePatchesForPatchBaselineRequestFilterSensitiveLog;
const PatchStatusFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.PatchStatusFilterSensitiveLog = PatchStatusFilterSensitiveLog;
const EffectivePatchFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.EffectivePatchFilterSensitiveLog = EffectivePatchFilterSensitiveLog;
const DescribeEffectivePatchesForPatchBaselineResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeEffectivePatchesForPatchBaselineResultFilterSensitiveLog = DescribeEffectivePatchesForPatchBaselineResultFilterSensitiveLog;
const DescribeInstanceAssociationsStatusRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeInstanceAssociationsStatusRequestFilterSensitiveLog = DescribeInstanceAssociationsStatusRequestFilterSensitiveLog;
const S3OutputUrlFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.S3OutputUrlFilterSensitiveLog = S3OutputUrlFilterSensitiveLog;
const InstanceAssociationOutputUrlFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.InstanceAssociationOutputUrlFilterSensitiveLog = InstanceAssociationOutputUrlFilterSensitiveLog;
const InstanceAssociationStatusInfoFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.InstanceAssociationStatusInfoFilterSensitiveLog = InstanceAssociationStatusInfoFilterSensitiveLog;
const DescribeInstanceAssociationsStatusResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeInstanceAssociationsStatusResultFilterSensitiveLog = DescribeInstanceAssociationsStatusResultFilterSensitiveLog;
const InstanceInformationStringFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.InstanceInformationStringFilterFilterSensitiveLog = InstanceInformationStringFilterFilterSensitiveLog;
const InstanceInformationFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.InstanceInformationFilterFilterSensitiveLog = InstanceInformationFilterFilterSensitiveLog;
const DescribeInstanceInformationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeInstanceInformationRequestFilterSensitiveLog = DescribeInstanceInformationRequestFilterSensitiveLog;
const InstanceAggregatedAssociationOverviewFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.InstanceAggregatedAssociationOverviewFilterSensitiveLog = InstanceAggregatedAssociationOverviewFilterSensitiveLog;
const InstanceInformationFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.InstanceInformationFilterSensitiveLog = InstanceInformationFilterSensitiveLog;
const DescribeInstanceInformationResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeInstanceInformationResultFilterSensitiveLog = DescribeInstanceInformationResultFilterSensitiveLog;
const DescribeInstancePatchesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeInstancePatchesRequestFilterSensitiveLog = DescribeInstancePatchesRequestFilterSensitiveLog;
const PatchComplianceDataFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.PatchComplianceDataFilterSensitiveLog = PatchComplianceDataFilterSensitiveLog;
const DescribeInstancePatchesResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeInstancePatchesResultFilterSensitiveLog = DescribeInstancePatchesResultFilterSensitiveLog;
const DescribeInstancePatchStatesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeInstancePatchStatesRequestFilterSensitiveLog = DescribeInstancePatchStatesRequestFilterSensitiveLog;
const InstancePatchStateFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OwnerInformation && { OwnerInformation: smithy_client_1.SENSITIVE_STRING }),
});
exports.InstancePatchStateFilterSensitiveLog = InstancePatchStateFilterSensitiveLog;
const DescribeInstancePatchStatesResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.InstancePatchStates && {
        InstancePatchStates: obj.InstancePatchStates.map((item) => (0, exports.InstancePatchStateFilterSensitiveLog)(item)),
    }),
});
exports.DescribeInstancePatchStatesResultFilterSensitiveLog = DescribeInstancePatchStatesResultFilterSensitiveLog;
const InstancePatchStateFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.InstancePatchStateFilterFilterSensitiveLog = InstancePatchStateFilterFilterSensitiveLog;
const DescribeInstancePatchStatesForPatchGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeInstancePatchStatesForPatchGroupRequestFilterSensitiveLog = DescribeInstancePatchStatesForPatchGroupRequestFilterSensitiveLog;
const DescribeInstancePatchStatesForPatchGroupResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.InstancePatchStates && {
        InstancePatchStates: obj.InstancePatchStates.map((item) => (0, exports.InstancePatchStateFilterSensitiveLog)(item)),
    }),
});
exports.DescribeInstancePatchStatesForPatchGroupResultFilterSensitiveLog = DescribeInstancePatchStatesForPatchGroupResultFilterSensitiveLog;
const DescribeInventoryDeletionsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeInventoryDeletionsRequestFilterSensitiveLog = DescribeInventoryDeletionsRequestFilterSensitiveLog;
const InventoryDeletionStatusItemFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.InventoryDeletionStatusItemFilterSensitiveLog = InventoryDeletionStatusItemFilterSensitiveLog;
const DescribeInventoryDeletionsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeInventoryDeletionsResultFilterSensitiveLog = DescribeInventoryDeletionsResultFilterSensitiveLog;
const MaintenanceWindowFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.MaintenanceWindowFilterFilterSensitiveLog = MaintenanceWindowFilterFilterSensitiveLog;
const DescribeMaintenanceWindowExecutionsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeMaintenanceWindowExecutionsRequestFilterSensitiveLog = DescribeMaintenanceWindowExecutionsRequestFilterSensitiveLog;
const MaintenanceWindowExecutionFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.MaintenanceWindowExecutionFilterSensitiveLog = MaintenanceWindowExecutionFilterSensitiveLog;
const DescribeMaintenanceWindowExecutionsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeMaintenanceWindowExecutionsResultFilterSensitiveLog = DescribeMaintenanceWindowExecutionsResultFilterSensitiveLog;
const DescribeMaintenanceWindowExecutionTaskInvocationsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeMaintenanceWindowExecutionTaskInvocationsRequestFilterSensitiveLog = DescribeMaintenanceWindowExecutionTaskInvocationsRequestFilterSensitiveLog;
const MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.OwnerInformation && { OwnerInformation: smithy_client_1.SENSITIVE_STRING }),
});
exports.MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog = MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog;
const DescribeMaintenanceWindowExecutionTaskInvocationsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.WindowExecutionTaskInvocationIdentities && {
        WindowExecutionTaskInvocationIdentities: obj.WindowExecutionTaskInvocationIdentities.map((item) => (0, exports.MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog)(item)),
    }),
});
exports.DescribeMaintenanceWindowExecutionTaskInvocationsResultFilterSensitiveLog = DescribeMaintenanceWindowExecutionTaskInvocationsResultFilterSensitiveLog;
const DescribeMaintenanceWindowExecutionTasksRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeMaintenanceWindowExecutionTasksRequestFilterSensitiveLog = DescribeMaintenanceWindowExecutionTasksRequestFilterSensitiveLog;
const MaintenanceWindowExecutionTaskIdentityFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.MaintenanceWindowExecutionTaskIdentityFilterSensitiveLog = MaintenanceWindowExecutionTaskIdentityFilterSensitiveLog;
const DescribeMaintenanceWindowExecutionTasksResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeMaintenanceWindowExecutionTasksResultFilterSensitiveLog = DescribeMaintenanceWindowExecutionTasksResultFilterSensitiveLog;
const DescribeMaintenanceWindowsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeMaintenanceWindowsRequestFilterSensitiveLog = DescribeMaintenanceWindowsRequestFilterSensitiveLog;
const MaintenanceWindowIdentityFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Description && { Description: smithy_client_1.SENSITIVE_STRING }),
});
exports.MaintenanceWindowIdentityFilterSensitiveLog = MaintenanceWindowIdentityFilterSensitiveLog;
const DescribeMaintenanceWindowsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.WindowIdentities && {
        WindowIdentities: obj.WindowIdentities.map((item) => (0, exports.MaintenanceWindowIdentityFilterSensitiveLog)(item)),
    }),
});
exports.DescribeMaintenanceWindowsResultFilterSensitiveLog = DescribeMaintenanceWindowsResultFilterSensitiveLog;
const DescribeMaintenanceWindowScheduleRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeMaintenanceWindowScheduleRequestFilterSensitiveLog = DescribeMaintenanceWindowScheduleRequestFilterSensitiveLog;
const ScheduledWindowExecutionFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.ScheduledWindowExecutionFilterSensitiveLog = ScheduledWindowExecutionFilterSensitiveLog;
const DescribeMaintenanceWindowScheduleResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeMaintenanceWindowScheduleResultFilterSensitiveLog = DescribeMaintenanceWindowScheduleResultFilterSensitiveLog;
const DescribeMaintenanceWindowsForTargetRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeMaintenanceWindowsForTargetRequestFilterSensitiveLog = DescribeMaintenanceWindowsForTargetRequestFilterSensitiveLog;
const MaintenanceWindowIdentityForTargetFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.MaintenanceWindowIdentityForTargetFilterSensitiveLog = MaintenanceWindowIdentityForTargetFilterSensitiveLog;
const DescribeMaintenanceWindowsForTargetResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeMaintenanceWindowsForTargetResultFilterSensitiveLog = DescribeMaintenanceWindowsForTargetResultFilterSensitiveLog;
const DescribeMaintenanceWindowTargetsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeMaintenanceWindowTargetsRequestFilterSensitiveLog = DescribeMaintenanceWindowTargetsRequestFilterSensitiveLog;
const MaintenanceWindowTargetFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OwnerInformation && { OwnerInformation: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Description && { Description: smithy_client_1.SENSITIVE_STRING }),
});
exports.MaintenanceWindowTargetFilterSensitiveLog = MaintenanceWindowTargetFilterSensitiveLog;
const DescribeMaintenanceWindowTargetsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Targets && { Targets: obj.Targets.map((item) => (0, exports.MaintenanceWindowTargetFilterSensitiveLog)(item)) }),
});
exports.DescribeMaintenanceWindowTargetsResultFilterSensitiveLog = DescribeMaintenanceWindowTargetsResultFilterSensitiveLog;
const DescribeMaintenanceWindowTasksRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.DescribeMaintenanceWindowTasksRequestFilterSensitiveLog = DescribeMaintenanceWindowTasksRequestFilterSensitiveLog;
const LoggingInfoFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.LoggingInfoFilterSensitiveLog = LoggingInfoFilterSensitiveLog;
const MaintenanceWindowTaskParameterValueExpressionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Values && { Values: smithy_client_1.SENSITIVE_STRING }),
});
exports.MaintenanceWindowTaskParameterValueExpressionFilterSensitiveLog = MaintenanceWindowTaskParameterValueExpressionFilterSensitiveLog;
const MaintenanceWindowTaskFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TaskParameters && { TaskParameters: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Description && { Description: smithy_client_1.SENSITIVE_STRING }),
});
exports.MaintenanceWindowTaskFilterSensitiveLog = MaintenanceWindowTaskFilterSensitiveLog;
const DescribeMaintenanceWindowTasksResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Tasks && { Tasks: obj.Tasks.map((item) => (0, exports.MaintenanceWindowTaskFilterSensitiveLog)(item)) }),
});
exports.DescribeMaintenanceWindowTasksResultFilterSensitiveLog = DescribeMaintenanceWindowTasksResultFilterSensitiveLog;
