import { HttpRequest as __HttpRequest } from "@aws-sdk/protocol-http";
import { decorateServiceException as __decorateServiceException, expectBoolean as __expectBoolean, expectLong as __expectLong, expectNonNull as __expectNonNull, expectNumber as __expectNumber, expectString as __expectString, parseEpochTimestamp as __parseEpochTimestamp, throwDefaultError, } from "@aws-sdk/smithy-client";
import { v4 as generateIdempotencyToken } from "uuid";
import { DecryptionFailure, EncryptionFailure, InternalServiceError, InvalidNextTokenException, InvalidParameterException, InvalidRequestException, LimitExceededException, MalformedPolicyDocumentException, PreconditionNotMetException, PublicPolicyException, ResourceExistsException, ResourceNotFoundException, } from "../models/models_0";
import { SecretsManagerServiceException as __BaseException } from "../models/SecretsManagerServiceException";
export const serializeAws_json1_1CancelRotateSecretCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "secretsmanager.CancelRotateSecret",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1CancelRotateSecretRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1CreateSecretCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "secretsmanager.CreateSecret",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1CreateSecretRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1DeleteResourcePolicyCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "secretsmanager.DeleteResourcePolicy",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1DeleteResourcePolicyRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1DeleteSecretCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "secretsmanager.DeleteSecret",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1DeleteSecretRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1DescribeSecretCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "secretsmanager.DescribeSecret",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1DescribeSecretRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1GetRandomPasswordCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "secretsmanager.GetRandomPassword",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1GetRandomPasswordRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1GetResourcePolicyCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "secretsmanager.GetResourcePolicy",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1GetResourcePolicyRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1GetSecretValueCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "secretsmanager.GetSecretValue",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1GetSecretValueRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1ListSecretsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "secretsmanager.ListSecrets",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1ListSecretsRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1ListSecretVersionIdsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "secretsmanager.ListSecretVersionIds",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1ListSecretVersionIdsRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1PutResourcePolicyCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "secretsmanager.PutResourcePolicy",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1PutResourcePolicyRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1PutSecretValueCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "secretsmanager.PutSecretValue",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1PutSecretValueRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1RemoveRegionsFromReplicationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "secretsmanager.RemoveRegionsFromReplication",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1RemoveRegionsFromReplicationRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1ReplicateSecretToRegionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "secretsmanager.ReplicateSecretToRegions",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1ReplicateSecretToRegionsRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1RestoreSecretCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "secretsmanager.RestoreSecret",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1RestoreSecretRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1RotateSecretCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "secretsmanager.RotateSecret",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1RotateSecretRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1StopReplicationToReplicaCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "secretsmanager.StopReplicationToReplica",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1StopReplicationToReplicaRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1TagResourceCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "secretsmanager.TagResource",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1TagResourceRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1UntagResourceCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "secretsmanager.UntagResource",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1UntagResourceRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1UpdateSecretCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "secretsmanager.UpdateSecret",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1UpdateSecretRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1UpdateSecretVersionStageCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "secretsmanager.UpdateSecretVersionStage",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1UpdateSecretVersionStageRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_json1_1ValidateResourcePolicyCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": "secretsmanager.ValidateResourcePolicy",
    };
    let body;
    body = JSON.stringify(serializeAws_json1_1ValidateResourcePolicyRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const deserializeAws_json1_1CancelRotateSecretCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1CancelRotateSecretCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1CancelRotateSecretResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1CancelRotateSecretCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InternalServiceError":
        case "com.amazonaws.secretsmanager#InternalServiceError":
            throw await deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.secretsmanager#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.secretsmanager#InvalidRequestException":
            throw await deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.secretsmanager#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1CreateSecretCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1CreateSecretCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1CreateSecretResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1CreateSecretCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "DecryptionFailure":
        case "com.amazonaws.secretsmanager#DecryptionFailure":
            throw await deserializeAws_json1_1DecryptionFailureResponse(parsedOutput, context);
        case "EncryptionFailure":
        case "com.amazonaws.secretsmanager#EncryptionFailure":
            throw await deserializeAws_json1_1EncryptionFailureResponse(parsedOutput, context);
        case "InternalServiceError":
        case "com.amazonaws.secretsmanager#InternalServiceError":
            throw await deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.secretsmanager#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.secretsmanager#InvalidRequestException":
            throw await deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context);
        case "LimitExceededException":
        case "com.amazonaws.secretsmanager#LimitExceededException":
            throw await deserializeAws_json1_1LimitExceededExceptionResponse(parsedOutput, context);
        case "MalformedPolicyDocumentException":
        case "com.amazonaws.secretsmanager#MalformedPolicyDocumentException":
            throw await deserializeAws_json1_1MalformedPolicyDocumentExceptionResponse(parsedOutput, context);
        case "PreconditionNotMetException":
        case "com.amazonaws.secretsmanager#PreconditionNotMetException":
            throw await deserializeAws_json1_1PreconditionNotMetExceptionResponse(parsedOutput, context);
        case "ResourceExistsException":
        case "com.amazonaws.secretsmanager#ResourceExistsException":
            throw await deserializeAws_json1_1ResourceExistsExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.secretsmanager#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1DeleteResourcePolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1DeleteResourcePolicyCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1DeleteResourcePolicyResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1DeleteResourcePolicyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InternalServiceError":
        case "com.amazonaws.secretsmanager#InternalServiceError":
            throw await deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.secretsmanager#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.secretsmanager#InvalidRequestException":
            throw await deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.secretsmanager#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1DeleteSecretCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1DeleteSecretCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1DeleteSecretResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1DeleteSecretCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InternalServiceError":
        case "com.amazonaws.secretsmanager#InternalServiceError":
            throw await deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.secretsmanager#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.secretsmanager#InvalidRequestException":
            throw await deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.secretsmanager#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1DescribeSecretCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1DescribeSecretCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1DescribeSecretResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1DescribeSecretCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InternalServiceError":
        case "com.amazonaws.secretsmanager#InternalServiceError":
            throw await deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.secretsmanager#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.secretsmanager#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1GetRandomPasswordCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1GetRandomPasswordCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1GetRandomPasswordResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1GetRandomPasswordCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InternalServiceError":
        case "com.amazonaws.secretsmanager#InternalServiceError":
            throw await deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.secretsmanager#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.secretsmanager#InvalidRequestException":
            throw await deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1GetResourcePolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1GetResourcePolicyCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1GetResourcePolicyResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1GetResourcePolicyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InternalServiceError":
        case "com.amazonaws.secretsmanager#InternalServiceError":
            throw await deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.secretsmanager#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.secretsmanager#InvalidRequestException":
            throw await deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.secretsmanager#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1GetSecretValueCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1GetSecretValueCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1GetSecretValueResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1GetSecretValueCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "DecryptionFailure":
        case "com.amazonaws.secretsmanager#DecryptionFailure":
            throw await deserializeAws_json1_1DecryptionFailureResponse(parsedOutput, context);
        case "InternalServiceError":
        case "com.amazonaws.secretsmanager#InternalServiceError":
            throw await deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.secretsmanager#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.secretsmanager#InvalidRequestException":
            throw await deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.secretsmanager#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1ListSecretsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1ListSecretsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1ListSecretsResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1ListSecretsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InternalServiceError":
        case "com.amazonaws.secretsmanager#InternalServiceError":
            throw await deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context);
        case "InvalidNextTokenException":
        case "com.amazonaws.secretsmanager#InvalidNextTokenException":
            throw await deserializeAws_json1_1InvalidNextTokenExceptionResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.secretsmanager#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1ListSecretVersionIdsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1ListSecretVersionIdsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1ListSecretVersionIdsResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1ListSecretVersionIdsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InternalServiceError":
        case "com.amazonaws.secretsmanager#InternalServiceError":
            throw await deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context);
        case "InvalidNextTokenException":
        case "com.amazonaws.secretsmanager#InvalidNextTokenException":
            throw await deserializeAws_json1_1InvalidNextTokenExceptionResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.secretsmanager#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.secretsmanager#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1PutResourcePolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1PutResourcePolicyCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1PutResourcePolicyResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1PutResourcePolicyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InternalServiceError":
        case "com.amazonaws.secretsmanager#InternalServiceError":
            throw await deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.secretsmanager#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.secretsmanager#InvalidRequestException":
            throw await deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context);
        case "MalformedPolicyDocumentException":
        case "com.amazonaws.secretsmanager#MalformedPolicyDocumentException":
            throw await deserializeAws_json1_1MalformedPolicyDocumentExceptionResponse(parsedOutput, context);
        case "PublicPolicyException":
        case "com.amazonaws.secretsmanager#PublicPolicyException":
            throw await deserializeAws_json1_1PublicPolicyExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.secretsmanager#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1PutSecretValueCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1PutSecretValueCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1PutSecretValueResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1PutSecretValueCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "DecryptionFailure":
        case "com.amazonaws.secretsmanager#DecryptionFailure":
            throw await deserializeAws_json1_1DecryptionFailureResponse(parsedOutput, context);
        case "EncryptionFailure":
        case "com.amazonaws.secretsmanager#EncryptionFailure":
            throw await deserializeAws_json1_1EncryptionFailureResponse(parsedOutput, context);
        case "InternalServiceError":
        case "com.amazonaws.secretsmanager#InternalServiceError":
            throw await deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.secretsmanager#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.secretsmanager#InvalidRequestException":
            throw await deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context);
        case "LimitExceededException":
        case "com.amazonaws.secretsmanager#LimitExceededException":
            throw await deserializeAws_json1_1LimitExceededExceptionResponse(parsedOutput, context);
        case "ResourceExistsException":
        case "com.amazonaws.secretsmanager#ResourceExistsException":
            throw await deserializeAws_json1_1ResourceExistsExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.secretsmanager#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1RemoveRegionsFromReplicationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1RemoveRegionsFromReplicationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1RemoveRegionsFromReplicationResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1RemoveRegionsFromReplicationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InternalServiceError":
        case "com.amazonaws.secretsmanager#InternalServiceError":
            throw await deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.secretsmanager#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.secretsmanager#InvalidRequestException":
            throw await deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.secretsmanager#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1ReplicateSecretToRegionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1ReplicateSecretToRegionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1ReplicateSecretToRegionsResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1ReplicateSecretToRegionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InternalServiceError":
        case "com.amazonaws.secretsmanager#InternalServiceError":
            throw await deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.secretsmanager#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.secretsmanager#InvalidRequestException":
            throw await deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.secretsmanager#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1RestoreSecretCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1RestoreSecretCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1RestoreSecretResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1RestoreSecretCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InternalServiceError":
        case "com.amazonaws.secretsmanager#InternalServiceError":
            throw await deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.secretsmanager#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.secretsmanager#InvalidRequestException":
            throw await deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.secretsmanager#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1RotateSecretCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1RotateSecretCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1RotateSecretResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1RotateSecretCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InternalServiceError":
        case "com.amazonaws.secretsmanager#InternalServiceError":
            throw await deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.secretsmanager#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.secretsmanager#InvalidRequestException":
            throw await deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.secretsmanager#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1StopReplicationToReplicaCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1StopReplicationToReplicaCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1StopReplicationToReplicaResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1StopReplicationToReplicaCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InternalServiceError":
        case "com.amazonaws.secretsmanager#InternalServiceError":
            throw await deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.secretsmanager#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.secretsmanager#InvalidRequestException":
            throw await deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.secretsmanager#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1TagResourceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1TagResourceCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1TagResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InternalServiceError":
        case "com.amazonaws.secretsmanager#InternalServiceError":
            throw await deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.secretsmanager#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.secretsmanager#InvalidRequestException":
            throw await deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.secretsmanager#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1UntagResourceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1UntagResourceCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1UntagResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InternalServiceError":
        case "com.amazonaws.secretsmanager#InternalServiceError":
            throw await deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.secretsmanager#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.secretsmanager#InvalidRequestException":
            throw await deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.secretsmanager#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1UpdateSecretCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1UpdateSecretCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1UpdateSecretResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1UpdateSecretCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "DecryptionFailure":
        case "com.amazonaws.secretsmanager#DecryptionFailure":
            throw await deserializeAws_json1_1DecryptionFailureResponse(parsedOutput, context);
        case "EncryptionFailure":
        case "com.amazonaws.secretsmanager#EncryptionFailure":
            throw await deserializeAws_json1_1EncryptionFailureResponse(parsedOutput, context);
        case "InternalServiceError":
        case "com.amazonaws.secretsmanager#InternalServiceError":
            throw await deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.secretsmanager#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.secretsmanager#InvalidRequestException":
            throw await deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context);
        case "LimitExceededException":
        case "com.amazonaws.secretsmanager#LimitExceededException":
            throw await deserializeAws_json1_1LimitExceededExceptionResponse(parsedOutput, context);
        case "MalformedPolicyDocumentException":
        case "com.amazonaws.secretsmanager#MalformedPolicyDocumentException":
            throw await deserializeAws_json1_1MalformedPolicyDocumentExceptionResponse(parsedOutput, context);
        case "PreconditionNotMetException":
        case "com.amazonaws.secretsmanager#PreconditionNotMetException":
            throw await deserializeAws_json1_1PreconditionNotMetExceptionResponse(parsedOutput, context);
        case "ResourceExistsException":
        case "com.amazonaws.secretsmanager#ResourceExistsException":
            throw await deserializeAws_json1_1ResourceExistsExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.secretsmanager#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1UpdateSecretVersionStageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1UpdateSecretVersionStageCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1UpdateSecretVersionStageResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1UpdateSecretVersionStageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InternalServiceError":
        case "com.amazonaws.secretsmanager#InternalServiceError":
            throw await deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.secretsmanager#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.secretsmanager#InvalidRequestException":
            throw await deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context);
        case "LimitExceededException":
        case "com.amazonaws.secretsmanager#LimitExceededException":
            throw await deserializeAws_json1_1LimitExceededExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.secretsmanager#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const deserializeAws_json1_1ValidateResourcePolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_json1_1ValidateResourcePolicyCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_json1_1ValidateResourcePolicyResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_json1_1ValidateResourcePolicyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InternalServiceError":
        case "com.amazonaws.secretsmanager#InternalServiceError":
            throw await deserializeAws_json1_1InternalServiceErrorResponse(parsedOutput, context);
        case "InvalidParameterException":
        case "com.amazonaws.secretsmanager#InvalidParameterException":
            throw await deserializeAws_json1_1InvalidParameterExceptionResponse(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.secretsmanager#InvalidRequestException":
            throw await deserializeAws_json1_1InvalidRequestExceptionResponse(parsedOutput, context);
        case "MalformedPolicyDocumentException":
        case "com.amazonaws.secretsmanager#MalformedPolicyDocumentException":
            throw await deserializeAws_json1_1MalformedPolicyDocumentExceptionResponse(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.secretsmanager#ResourceNotFoundException":
            throw await deserializeAws_json1_1ResourceNotFoundExceptionResponse(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
const deserializeAws_json1_1DecryptionFailureResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1DecryptionFailure(body, context);
    const exception = new DecryptionFailure({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const deserializeAws_json1_1EncryptionFailureResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1EncryptionFailure(body, context);
    const exception = new EncryptionFailure({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const deserializeAws_json1_1InternalServiceErrorResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1InternalServiceError(body, context);
    const exception = new InternalServiceError({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const deserializeAws_json1_1InvalidNextTokenExceptionResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1InvalidNextTokenException(body, context);
    const exception = new InvalidNextTokenException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const deserializeAws_json1_1InvalidParameterExceptionResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1InvalidParameterException(body, context);
    const exception = new InvalidParameterException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const deserializeAws_json1_1InvalidRequestExceptionResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1InvalidRequestException(body, context);
    const exception = new InvalidRequestException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const deserializeAws_json1_1LimitExceededExceptionResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1LimitExceededException(body, context);
    const exception = new LimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const deserializeAws_json1_1MalformedPolicyDocumentExceptionResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1MalformedPolicyDocumentException(body, context);
    const exception = new MalformedPolicyDocumentException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const deserializeAws_json1_1PreconditionNotMetExceptionResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1PreconditionNotMetException(body, context);
    const exception = new PreconditionNotMetException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const deserializeAws_json1_1PublicPolicyExceptionResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1PublicPolicyException(body, context);
    const exception = new PublicPolicyException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const deserializeAws_json1_1ResourceExistsExceptionResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1ResourceExistsException(body, context);
    const exception = new ResourceExistsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const deserializeAws_json1_1ResourceNotFoundExceptionResponse = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = deserializeAws_json1_1ResourceNotFoundException(body, context);
    const exception = new ResourceNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const serializeAws_json1_1AddReplicaRegionListType = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_json1_1ReplicaRegionType(entry, context);
    });
};
const serializeAws_json1_1CancelRotateSecretRequest = (input, context) => {
    return {
        ...(input.SecretId != null && { SecretId: input.SecretId }),
    };
};
const serializeAws_json1_1CreateSecretRequest = (input, context) => {
    return {
        ...(input.AddReplicaRegions != null && {
            AddReplicaRegions: serializeAws_json1_1AddReplicaRegionListType(input.AddReplicaRegions, context),
        }),
        ClientRequestToken: input.ClientRequestToken ?? generateIdempotencyToken(),
        ...(input.Description != null && { Description: input.Description }),
        ...(input.ForceOverwriteReplicaSecret != null && {
            ForceOverwriteReplicaSecret: input.ForceOverwriteReplicaSecret,
        }),
        ...(input.KmsKeyId != null && { KmsKeyId: input.KmsKeyId }),
        ...(input.Name != null && { Name: input.Name }),
        ...(input.SecretBinary != null && { SecretBinary: context.base64Encoder(input.SecretBinary) }),
        ...(input.SecretString != null && { SecretString: input.SecretString }),
        ...(input.Tags != null && { Tags: serializeAws_json1_1TagListType(input.Tags, context) }),
    };
};
const serializeAws_json1_1DeleteResourcePolicyRequest = (input, context) => {
    return {
        ...(input.SecretId != null && { SecretId: input.SecretId }),
    };
};
const serializeAws_json1_1DeleteSecretRequest = (input, context) => {
    return {
        ...(input.ForceDeleteWithoutRecovery != null && { ForceDeleteWithoutRecovery: input.ForceDeleteWithoutRecovery }),
        ...(input.RecoveryWindowInDays != null && { RecoveryWindowInDays: input.RecoveryWindowInDays }),
        ...(input.SecretId != null && { SecretId: input.SecretId }),
    };
};
const serializeAws_json1_1DescribeSecretRequest = (input, context) => {
    return {
        ...(input.SecretId != null && { SecretId: input.SecretId }),
    };
};
const serializeAws_json1_1Filter = (input, context) => {
    return {
        ...(input.Key != null && { Key: input.Key }),
        ...(input.Values != null && { Values: serializeAws_json1_1FilterValuesStringList(input.Values, context) }),
    };
};
const serializeAws_json1_1FiltersListType = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_json1_1Filter(entry, context);
    });
};
const serializeAws_json1_1FilterValuesStringList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_json1_1GetRandomPasswordRequest = (input, context) => {
    return {
        ...(input.ExcludeCharacters != null && { ExcludeCharacters: input.ExcludeCharacters }),
        ...(input.ExcludeLowercase != null && { ExcludeLowercase: input.ExcludeLowercase }),
        ...(input.ExcludeNumbers != null && { ExcludeNumbers: input.ExcludeNumbers }),
        ...(input.ExcludePunctuation != null && { ExcludePunctuation: input.ExcludePunctuation }),
        ...(input.ExcludeUppercase != null && { ExcludeUppercase: input.ExcludeUppercase }),
        ...(input.IncludeSpace != null && { IncludeSpace: input.IncludeSpace }),
        ...(input.PasswordLength != null && { PasswordLength: input.PasswordLength }),
        ...(input.RequireEachIncludedType != null && { RequireEachIncludedType: input.RequireEachIncludedType }),
    };
};
const serializeAws_json1_1GetResourcePolicyRequest = (input, context) => {
    return {
        ...(input.SecretId != null && { SecretId: input.SecretId }),
    };
};
const serializeAws_json1_1GetSecretValueRequest = (input, context) => {
    return {
        ...(input.SecretId != null && { SecretId: input.SecretId }),
        ...(input.VersionId != null && { VersionId: input.VersionId }),
        ...(input.VersionStage != null && { VersionStage: input.VersionStage }),
    };
};
const serializeAws_json1_1ListSecretsRequest = (input, context) => {
    return {
        ...(input.Filters != null && { Filters: serializeAws_json1_1FiltersListType(input.Filters, context) }),
        ...(input.IncludePlannedDeletion != null && { IncludePlannedDeletion: input.IncludePlannedDeletion }),
        ...(input.MaxResults != null && { MaxResults: input.MaxResults }),
        ...(input.NextToken != null && { NextToken: input.NextToken }),
        ...(input.SortOrder != null && { SortOrder: input.SortOrder }),
    };
};
const serializeAws_json1_1ListSecretVersionIdsRequest = (input, context) => {
    return {
        ...(input.IncludeDeprecated != null && { IncludeDeprecated: input.IncludeDeprecated }),
        ...(input.MaxResults != null && { MaxResults: input.MaxResults }),
        ...(input.NextToken != null && { NextToken: input.NextToken }),
        ...(input.SecretId != null && { SecretId: input.SecretId }),
    };
};
const serializeAws_json1_1PutResourcePolicyRequest = (input, context) => {
    return {
        ...(input.BlockPublicPolicy != null && { BlockPublicPolicy: input.BlockPublicPolicy }),
        ...(input.ResourcePolicy != null && { ResourcePolicy: input.ResourcePolicy }),
        ...(input.SecretId != null && { SecretId: input.SecretId }),
    };
};
const serializeAws_json1_1PutSecretValueRequest = (input, context) => {
    return {
        ClientRequestToken: input.ClientRequestToken ?? generateIdempotencyToken(),
        ...(input.SecretBinary != null && { SecretBinary: context.base64Encoder(input.SecretBinary) }),
        ...(input.SecretId != null && { SecretId: input.SecretId }),
        ...(input.SecretString != null && { SecretString: input.SecretString }),
        ...(input.VersionStages != null && {
            VersionStages: serializeAws_json1_1SecretVersionStagesType(input.VersionStages, context),
        }),
    };
};
const serializeAws_json1_1RemoveRegionsFromReplicationRequest = (input, context) => {
    return {
        ...(input.RemoveReplicaRegions != null && {
            RemoveReplicaRegions: serializeAws_json1_1RemoveReplicaRegionListType(input.RemoveReplicaRegions, context),
        }),
        ...(input.SecretId != null && { SecretId: input.SecretId }),
    };
};
const serializeAws_json1_1RemoveReplicaRegionListType = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_json1_1ReplicaRegionType = (input, context) => {
    return {
        ...(input.KmsKeyId != null && { KmsKeyId: input.KmsKeyId }),
        ...(input.Region != null && { Region: input.Region }),
    };
};
const serializeAws_json1_1ReplicateSecretToRegionsRequest = (input, context) => {
    return {
        ...(input.AddReplicaRegions != null && {
            AddReplicaRegions: serializeAws_json1_1AddReplicaRegionListType(input.AddReplicaRegions, context),
        }),
        ...(input.ForceOverwriteReplicaSecret != null && {
            ForceOverwriteReplicaSecret: input.ForceOverwriteReplicaSecret,
        }),
        ...(input.SecretId != null && { SecretId: input.SecretId }),
    };
};
const serializeAws_json1_1RestoreSecretRequest = (input, context) => {
    return {
        ...(input.SecretId != null && { SecretId: input.SecretId }),
    };
};
const serializeAws_json1_1RotateSecretRequest = (input, context) => {
    return {
        ClientRequestToken: input.ClientRequestToken ?? generateIdempotencyToken(),
        ...(input.RotateImmediately != null && { RotateImmediately: input.RotateImmediately }),
        ...(input.RotationLambdaARN != null && { RotationLambdaARN: input.RotationLambdaARN }),
        ...(input.RotationRules != null && {
            RotationRules: serializeAws_json1_1RotationRulesType(input.RotationRules, context),
        }),
        ...(input.SecretId != null && { SecretId: input.SecretId }),
    };
};
const serializeAws_json1_1RotationRulesType = (input, context) => {
    return {
        ...(input.AutomaticallyAfterDays != null && { AutomaticallyAfterDays: input.AutomaticallyAfterDays }),
        ...(input.Duration != null && { Duration: input.Duration }),
        ...(input.ScheduleExpression != null && { ScheduleExpression: input.ScheduleExpression }),
    };
};
const serializeAws_json1_1SecretVersionStagesType = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_json1_1StopReplicationToReplicaRequest = (input, context) => {
    return {
        ...(input.SecretId != null && { SecretId: input.SecretId }),
    };
};
const serializeAws_json1_1Tag = (input, context) => {
    return {
        ...(input.Key != null && { Key: input.Key }),
        ...(input.Value != null && { Value: input.Value }),
    };
};
const serializeAws_json1_1TagKeyListType = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const serializeAws_json1_1TagListType = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return serializeAws_json1_1Tag(entry, context);
    });
};
const serializeAws_json1_1TagResourceRequest = (input, context) => {
    return {
        ...(input.SecretId != null && { SecretId: input.SecretId }),
        ...(input.Tags != null && { Tags: serializeAws_json1_1TagListType(input.Tags, context) }),
    };
};
const serializeAws_json1_1UntagResourceRequest = (input, context) => {
    return {
        ...(input.SecretId != null && { SecretId: input.SecretId }),
        ...(input.TagKeys != null && { TagKeys: serializeAws_json1_1TagKeyListType(input.TagKeys, context) }),
    };
};
const serializeAws_json1_1UpdateSecretRequest = (input, context) => {
    return {
        ClientRequestToken: input.ClientRequestToken ?? generateIdempotencyToken(),
        ...(input.Description != null && { Description: input.Description }),
        ...(input.KmsKeyId != null && { KmsKeyId: input.KmsKeyId }),
        ...(input.SecretBinary != null && { SecretBinary: context.base64Encoder(input.SecretBinary) }),
        ...(input.SecretId != null && { SecretId: input.SecretId }),
        ...(input.SecretString != null && { SecretString: input.SecretString }),
    };
};
const serializeAws_json1_1UpdateSecretVersionStageRequest = (input, context) => {
    return {
        ...(input.MoveToVersionId != null && { MoveToVersionId: input.MoveToVersionId }),
        ...(input.RemoveFromVersionId != null && { RemoveFromVersionId: input.RemoveFromVersionId }),
        ...(input.SecretId != null && { SecretId: input.SecretId }),
        ...(input.VersionStage != null && { VersionStage: input.VersionStage }),
    };
};
const serializeAws_json1_1ValidateResourcePolicyRequest = (input, context) => {
    return {
        ...(input.ResourcePolicy != null && { ResourcePolicy: input.ResourcePolicy }),
        ...(input.SecretId != null && { SecretId: input.SecretId }),
    };
};
const deserializeAws_json1_1CancelRotateSecretResponse = (output, context) => {
    return {
        ARN: __expectString(output.ARN),
        Name: __expectString(output.Name),
        VersionId: __expectString(output.VersionId),
    };
};
const deserializeAws_json1_1CreateSecretResponse = (output, context) => {
    return {
        ARN: __expectString(output.ARN),
        Name: __expectString(output.Name),
        ReplicationStatus: output.ReplicationStatus != null
            ? deserializeAws_json1_1ReplicationStatusListType(output.ReplicationStatus, context)
            : undefined,
        VersionId: __expectString(output.VersionId),
    };
};
const deserializeAws_json1_1DecryptionFailure = (output, context) => {
    return {
        Message: __expectString(output.Message),
    };
};
const deserializeAws_json1_1DeleteResourcePolicyResponse = (output, context) => {
    return {
        ARN: __expectString(output.ARN),
        Name: __expectString(output.Name),
    };
};
const deserializeAws_json1_1DeleteSecretResponse = (output, context) => {
    return {
        ARN: __expectString(output.ARN),
        DeletionDate: output.DeletionDate != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.DeletionDate)))
            : undefined,
        Name: __expectString(output.Name),
    };
};
const deserializeAws_json1_1DescribeSecretResponse = (output, context) => {
    return {
        ARN: __expectString(output.ARN),
        CreatedDate: output.CreatedDate != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedDate)))
            : undefined,
        DeletedDate: output.DeletedDate != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.DeletedDate)))
            : undefined,
        Description: __expectString(output.Description),
        KmsKeyId: __expectString(output.KmsKeyId),
        LastAccessedDate: output.LastAccessedDate != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastAccessedDate)))
            : undefined,
        LastChangedDate: output.LastChangedDate != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastChangedDate)))
            : undefined,
        LastRotatedDate: output.LastRotatedDate != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastRotatedDate)))
            : undefined,
        Name: __expectString(output.Name),
        NextRotationDate: output.NextRotationDate != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.NextRotationDate)))
            : undefined,
        OwningService: __expectString(output.OwningService),
        PrimaryRegion: __expectString(output.PrimaryRegion),
        ReplicationStatus: output.ReplicationStatus != null
            ? deserializeAws_json1_1ReplicationStatusListType(output.ReplicationStatus, context)
            : undefined,
        RotationEnabled: __expectBoolean(output.RotationEnabled),
        RotationLambdaARN: __expectString(output.RotationLambdaARN),
        RotationRules: output.RotationRules != null ? deserializeAws_json1_1RotationRulesType(output.RotationRules, context) : undefined,
        Tags: output.Tags != null ? deserializeAws_json1_1TagListType(output.Tags, context) : undefined,
        VersionIdsToStages: output.VersionIdsToStages != null
            ? deserializeAws_json1_1SecretVersionsToStagesMapType(output.VersionIdsToStages, context)
            : undefined,
    };
};
const deserializeAws_json1_1EncryptionFailure = (output, context) => {
    return {
        Message: __expectString(output.Message),
    };
};
const deserializeAws_json1_1GetRandomPasswordResponse = (output, context) => {
    return {
        RandomPassword: __expectString(output.RandomPassword),
    };
};
const deserializeAws_json1_1GetResourcePolicyResponse = (output, context) => {
    return {
        ARN: __expectString(output.ARN),
        Name: __expectString(output.Name),
        ResourcePolicy: __expectString(output.ResourcePolicy),
    };
};
const deserializeAws_json1_1GetSecretValueResponse = (output, context) => {
    return {
        ARN: __expectString(output.ARN),
        CreatedDate: output.CreatedDate != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedDate)))
            : undefined,
        Name: __expectString(output.Name),
        SecretBinary: output.SecretBinary != null ? context.base64Decoder(output.SecretBinary) : undefined,
        SecretString: __expectString(output.SecretString),
        VersionId: __expectString(output.VersionId),
        VersionStages: output.VersionStages != null
            ? deserializeAws_json1_1SecretVersionStagesType(output.VersionStages, context)
            : undefined,
    };
};
const deserializeAws_json1_1InternalServiceError = (output, context) => {
    return {
        Message: __expectString(output.Message),
    };
};
const deserializeAws_json1_1InvalidNextTokenException = (output, context) => {
    return {
        Message: __expectString(output.Message),
    };
};
const deserializeAws_json1_1InvalidParameterException = (output, context) => {
    return {
        Message: __expectString(output.Message),
    };
};
const deserializeAws_json1_1InvalidRequestException = (output, context) => {
    return {
        Message: __expectString(output.Message),
    };
};
const deserializeAws_json1_1KmsKeyIdListType = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return __expectString(entry);
    });
    return retVal;
};
const deserializeAws_json1_1LimitExceededException = (output, context) => {
    return {
        Message: __expectString(output.Message),
    };
};
const deserializeAws_json1_1ListSecretsResponse = (output, context) => {
    return {
        NextToken: __expectString(output.NextToken),
        SecretList: output.SecretList != null ? deserializeAws_json1_1SecretListType(output.SecretList, context) : undefined,
    };
};
const deserializeAws_json1_1ListSecretVersionIdsResponse = (output, context) => {
    return {
        ARN: __expectString(output.ARN),
        Name: __expectString(output.Name),
        NextToken: __expectString(output.NextToken),
        Versions: output.Versions != null ? deserializeAws_json1_1SecretVersionsListType(output.Versions, context) : undefined,
    };
};
const deserializeAws_json1_1MalformedPolicyDocumentException = (output, context) => {
    return {
        Message: __expectString(output.Message),
    };
};
const deserializeAws_json1_1PreconditionNotMetException = (output, context) => {
    return {
        Message: __expectString(output.Message),
    };
};
const deserializeAws_json1_1PublicPolicyException = (output, context) => {
    return {
        Message: __expectString(output.Message),
    };
};
const deserializeAws_json1_1PutResourcePolicyResponse = (output, context) => {
    return {
        ARN: __expectString(output.ARN),
        Name: __expectString(output.Name),
    };
};
const deserializeAws_json1_1PutSecretValueResponse = (output, context) => {
    return {
        ARN: __expectString(output.ARN),
        Name: __expectString(output.Name),
        VersionId: __expectString(output.VersionId),
        VersionStages: output.VersionStages != null
            ? deserializeAws_json1_1SecretVersionStagesType(output.VersionStages, context)
            : undefined,
    };
};
const deserializeAws_json1_1RemoveRegionsFromReplicationResponse = (output, context) => {
    return {
        ARN: __expectString(output.ARN),
        ReplicationStatus: output.ReplicationStatus != null
            ? deserializeAws_json1_1ReplicationStatusListType(output.ReplicationStatus, context)
            : undefined,
    };
};
const deserializeAws_json1_1ReplicateSecretToRegionsResponse = (output, context) => {
    return {
        ARN: __expectString(output.ARN),
        ReplicationStatus: output.ReplicationStatus != null
            ? deserializeAws_json1_1ReplicationStatusListType(output.ReplicationStatus, context)
            : undefined,
    };
};
const deserializeAws_json1_1ReplicationStatusListType = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1ReplicationStatusType(entry, context);
    });
    return retVal;
};
const deserializeAws_json1_1ReplicationStatusType = (output, context) => {
    return {
        KmsKeyId: __expectString(output.KmsKeyId),
        LastAccessedDate: output.LastAccessedDate != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastAccessedDate)))
            : undefined,
        Region: __expectString(output.Region),
        Status: __expectString(output.Status),
        StatusMessage: __expectString(output.StatusMessage),
    };
};
const deserializeAws_json1_1ResourceExistsException = (output, context) => {
    return {
        Message: __expectString(output.Message),
    };
};
const deserializeAws_json1_1ResourceNotFoundException = (output, context) => {
    return {
        Message: __expectString(output.Message),
    };
};
const deserializeAws_json1_1RestoreSecretResponse = (output, context) => {
    return {
        ARN: __expectString(output.ARN),
        Name: __expectString(output.Name),
    };
};
const deserializeAws_json1_1RotateSecretResponse = (output, context) => {
    return {
        ARN: __expectString(output.ARN),
        Name: __expectString(output.Name),
        VersionId: __expectString(output.VersionId),
    };
};
const deserializeAws_json1_1RotationRulesType = (output, context) => {
    return {
        AutomaticallyAfterDays: __expectLong(output.AutomaticallyAfterDays),
        Duration: __expectString(output.Duration),
        ScheduleExpression: __expectString(output.ScheduleExpression),
    };
};
const deserializeAws_json1_1SecretListEntry = (output, context) => {
    return {
        ARN: __expectString(output.ARN),
        CreatedDate: output.CreatedDate != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedDate)))
            : undefined,
        DeletedDate: output.DeletedDate != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.DeletedDate)))
            : undefined,
        Description: __expectString(output.Description),
        KmsKeyId: __expectString(output.KmsKeyId),
        LastAccessedDate: output.LastAccessedDate != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastAccessedDate)))
            : undefined,
        LastChangedDate: output.LastChangedDate != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastChangedDate)))
            : undefined,
        LastRotatedDate: output.LastRotatedDate != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastRotatedDate)))
            : undefined,
        Name: __expectString(output.Name),
        NextRotationDate: output.NextRotationDate != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.NextRotationDate)))
            : undefined,
        OwningService: __expectString(output.OwningService),
        PrimaryRegion: __expectString(output.PrimaryRegion),
        RotationEnabled: __expectBoolean(output.RotationEnabled),
        RotationLambdaARN: __expectString(output.RotationLambdaARN),
        RotationRules: output.RotationRules != null ? deserializeAws_json1_1RotationRulesType(output.RotationRules, context) : undefined,
        SecretVersionsToStages: output.SecretVersionsToStages != null
            ? deserializeAws_json1_1SecretVersionsToStagesMapType(output.SecretVersionsToStages, context)
            : undefined,
        Tags: output.Tags != null ? deserializeAws_json1_1TagListType(output.Tags, context) : undefined,
    };
};
const deserializeAws_json1_1SecretListType = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1SecretListEntry(entry, context);
    });
    return retVal;
};
const deserializeAws_json1_1SecretVersionsListEntry = (output, context) => {
    return {
        CreatedDate: output.CreatedDate != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.CreatedDate)))
            : undefined,
        KmsKeyIds: output.KmsKeyIds != null ? deserializeAws_json1_1KmsKeyIdListType(output.KmsKeyIds, context) : undefined,
        LastAccessedDate: output.LastAccessedDate != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.LastAccessedDate)))
            : undefined,
        VersionId: __expectString(output.VersionId),
        VersionStages: output.VersionStages != null
            ? deserializeAws_json1_1SecretVersionStagesType(output.VersionStages, context)
            : undefined,
    };
};
const deserializeAws_json1_1SecretVersionsListType = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1SecretVersionsListEntry(entry, context);
    });
    return retVal;
};
const deserializeAws_json1_1SecretVersionStagesType = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return __expectString(entry);
    });
    return retVal;
};
const deserializeAws_json1_1SecretVersionsToStagesMapType = (output, context) => {
    return Object.entries(output).reduce((acc, [key, value]) => {
        if (value === null) {
            return acc;
        }
        acc[key] = deserializeAws_json1_1SecretVersionStagesType(value, context);
        return acc;
    }, {});
};
const deserializeAws_json1_1StopReplicationToReplicaResponse = (output, context) => {
    return {
        ARN: __expectString(output.ARN),
    };
};
const deserializeAws_json1_1Tag = (output, context) => {
    return {
        Key: __expectString(output.Key),
        Value: __expectString(output.Value),
    };
};
const deserializeAws_json1_1TagListType = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1Tag(entry, context);
    });
    return retVal;
};
const deserializeAws_json1_1UpdateSecretResponse = (output, context) => {
    return {
        ARN: __expectString(output.ARN),
        Name: __expectString(output.Name),
        VersionId: __expectString(output.VersionId),
    };
};
const deserializeAws_json1_1UpdateSecretVersionStageResponse = (output, context) => {
    return {
        ARN: __expectString(output.ARN),
        Name: __expectString(output.Name),
    };
};
const deserializeAws_json1_1ValidateResourcePolicyResponse = (output, context) => {
    return {
        PolicyValidationPassed: __expectBoolean(output.PolicyValidationPassed),
        ValidationErrors: output.ValidationErrors != null
            ? deserializeAws_json1_1ValidationErrorsType(output.ValidationErrors, context)
            : undefined,
    };
};
const deserializeAws_json1_1ValidationErrorsEntry = (output, context) => {
    return {
        CheckName: __expectString(output.CheckName),
        ErrorMessage: __expectString(output.ErrorMessage),
    };
};
const deserializeAws_json1_1ValidationErrorsType = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return deserializeAws_json1_1ValidationErrorsEntry(entry, context);
    });
    return retVal;
};
const deserializeMetadata = (output) => ({
    httpStatusCode: output.statusCode,
    requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
    extendedRequestId: output.headers["x-amz-id-2"],
    cfId: output.headers["x-amz-cf-id"],
});
const collectBody = (streamBody = new Uint8Array(), context) => {
    if (streamBody instanceof Uint8Array) {
        return Promise.resolve(streamBody);
    }
    return context.streamCollector(streamBody) || Promise.resolve(new Uint8Array());
};
const collectBodyString = (streamBody, context) => collectBody(streamBody, context).then((body) => context.utf8Encoder(body));
const buildHttpRpcRequest = async (context, headers, path, resolvedHostname, body) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const contents = {
        protocol,
        hostname,
        port,
        method: "POST",
        path: basePath.endsWith("/") ? basePath.slice(0, -1) + path : basePath + path,
        headers,
    };
    if (resolvedHostname !== undefined) {
        contents.hostname = resolvedHostname;
    }
    if (body !== undefined) {
        contents.body = body;
    }
    return new __HttpRequest(contents);
};
const parseBody = (streamBody, context) => collectBodyString(streamBody, context).then((encoded) => {
    if (encoded.length) {
        return JSON.parse(encoded);
    }
    return {};
});
const parseErrorBody = async (errorBody, context) => {
    const value = await parseBody(errorBody, context);
    value.message = value.message ?? value.Message;
    return value;
};
const loadRestJsonErrorCode = (output, data) => {
    const findKey = (object, key) => Object.keys(object).find((k) => k.toLowerCase() === key.toLowerCase());
    const sanitizeErrorCode = (rawValue) => {
        let cleanValue = rawValue;
        if (typeof cleanValue === "number") {
            cleanValue = cleanValue.toString();
        }
        if (cleanValue.indexOf(",") >= 0) {
            cleanValue = cleanValue.split(",")[0];
        }
        if (cleanValue.indexOf(":") >= 0) {
            cleanValue = cleanValue.split(":")[0];
        }
        if (cleanValue.indexOf("#") >= 0) {
            cleanValue = cleanValue.split("#")[1];
        }
        return cleanValue;
    };
    const headerKey = findKey(output.headers, "x-amzn-errortype");
    if (headerKey !== undefined) {
        return sanitizeErrorCode(output.headers[headerKey]);
    }
    if (data.code !== undefined) {
        return sanitizeErrorCode(data.code);
    }
    if (data["__type"] !== undefined) {
        return sanitizeErrorCode(data["__type"]);
    }
};
