import { ListSecretsCommand } from "../commands/ListSecretsCommand";
import { SecretsManager } from "../SecretsManager";
import { SecretsManagerClient } from "../SecretsManagerClient";
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListSecretsCommand(input), ...args);
};
const makePagedRequest = async (client, input, ...args) => {
    return await client.listSecrets(input, ...args);
};
export async function* paginateListSecrets(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof SecretsManager) {
            page = await makePagedRequest(config.client, input, ...additionalArguments);
        }
        else if (config.client instanceof SecretsManagerClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected SecretsManager | SecretsManagerClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
