import { SENSITIVE_STRING } from "@aws-sdk/smithy-client";
import { SecretsManagerServiceException as __BaseException } from "./SecretsManagerServiceException";
export class InternalServiceError extends __BaseException {
    constructor(opts) {
        super({
            name: "InternalServiceError",
            $fault: "server",
            ...opts,
        });
        this.name = "InternalServiceError";
        this.$fault = "server";
        Object.setPrototypeOf(this, InternalServiceError.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidParameterException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidParameterException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidParameterException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidParameterException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidRequestException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidRequestException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidRequestException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidRequestException.prototype);
        this.Message = opts.Message;
    }
}
export class ResourceNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export var StatusType;
(function (StatusType) {
    StatusType["Failed"] = "Failed";
    StatusType["InProgress"] = "InProgress";
    StatusType["InSync"] = "InSync";
})(StatusType || (StatusType = {}));
export class DecryptionFailure extends __BaseException {
    constructor(opts) {
        super({
            name: "DecryptionFailure",
            $fault: "client",
            ...opts,
        });
        this.name = "DecryptionFailure";
        this.$fault = "client";
        Object.setPrototypeOf(this, DecryptionFailure.prototype);
        this.Message = opts.Message;
    }
}
export class EncryptionFailure extends __BaseException {
    constructor(opts) {
        super({
            name: "EncryptionFailure",
            $fault: "client",
            ...opts,
        });
        this.name = "EncryptionFailure";
        this.$fault = "client";
        Object.setPrototypeOf(this, EncryptionFailure.prototype);
        this.Message = opts.Message;
    }
}
export class LimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "LimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "LimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, LimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
export class MalformedPolicyDocumentException extends __BaseException {
    constructor(opts) {
        super({
            name: "MalformedPolicyDocumentException",
            $fault: "client",
            ...opts,
        });
        this.name = "MalformedPolicyDocumentException";
        this.$fault = "client";
        Object.setPrototypeOf(this, MalformedPolicyDocumentException.prototype);
        this.Message = opts.Message;
    }
}
export class PreconditionNotMetException extends __BaseException {
    constructor(opts) {
        super({
            name: "PreconditionNotMetException",
            $fault: "client",
            ...opts,
        });
        this.name = "PreconditionNotMetException";
        this.$fault = "client";
        Object.setPrototypeOf(this, PreconditionNotMetException.prototype);
        this.Message = opts.Message;
    }
}
export class ResourceExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceExistsException.prototype);
        this.Message = opts.Message;
    }
}
export var FilterNameStringType;
(function (FilterNameStringType) {
    FilterNameStringType["all"] = "all";
    FilterNameStringType["description"] = "description";
    FilterNameStringType["name"] = "name";
    FilterNameStringType["owning_service"] = "owning-service";
    FilterNameStringType["primary_region"] = "primary-region";
    FilterNameStringType["tag_key"] = "tag-key";
    FilterNameStringType["tag_value"] = "tag-value";
})(FilterNameStringType || (FilterNameStringType = {}));
export class InvalidNextTokenException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidNextTokenException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidNextTokenException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidNextTokenException.prototype);
        this.Message = opts.Message;
    }
}
export var SortOrderType;
(function (SortOrderType) {
    SortOrderType["asc"] = "asc";
    SortOrderType["desc"] = "desc";
})(SortOrderType || (SortOrderType = {}));
export class PublicPolicyException extends __BaseException {
    constructor(opts) {
        super({
            name: "PublicPolicyException",
            $fault: "client",
            ...opts,
        });
        this.name = "PublicPolicyException";
        this.$fault = "client";
        Object.setPrototypeOf(this, PublicPolicyException.prototype);
        this.Message = opts.Message;
    }
}
export const ReplicaRegionTypeFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CancelRotateSecretRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CancelRotateSecretResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TagFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateSecretRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SecretBinary && { SecretBinary: SENSITIVE_STRING }),
    ...(obj.SecretString && { SecretString: SENSITIVE_STRING }),
});
export const ReplicationStatusTypeFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateSecretResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteResourcePolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteResourcePolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteSecretRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteSecretResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeSecretRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RotationRulesTypeFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeSecretResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const FilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetRandomPasswordRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetRandomPasswordResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.RandomPassword && { RandomPassword: SENSITIVE_STRING }),
});
export const GetResourcePolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetResourcePolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetSecretValueRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetSecretValueResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SecretBinary && { SecretBinary: SENSITIVE_STRING }),
    ...(obj.SecretString && { SecretString: SENSITIVE_STRING }),
});
export const ListSecretsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SecretListEntryFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListSecretsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListSecretVersionIdsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SecretVersionsListEntryFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListSecretVersionIdsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutResourcePolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutResourcePolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutSecretValueRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SecretBinary && { SecretBinary: SENSITIVE_STRING }),
    ...(obj.SecretString && { SecretString: SENSITIVE_STRING }),
});
export const PutSecretValueResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RemoveRegionsFromReplicationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RemoveRegionsFromReplicationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ReplicateSecretToRegionsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ReplicateSecretToRegionsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RestoreSecretRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RestoreSecretResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RotateSecretRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RotateSecretResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const StopReplicationToReplicaRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const StopReplicationToReplicaResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TagResourceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UntagResourceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateSecretRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SecretBinary && { SecretBinary: SENSITIVE_STRING }),
    ...(obj.SecretString && { SecretString: SENSITIVE_STRING }),
});
export const UpdateSecretResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateSecretVersionStageRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateSecretVersionStageResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ValidateResourcePolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ValidationErrorsEntryFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ValidateResourcePolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
