"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getOwner = void 0;
let cachedOwner;
exports.getOwner = async (octokit, owner) => {
    if (owner) {
        return owner;
    }
    else if (cachedOwner) {
        return cachedOwner;
    }
    const fetchedOwner = await octokit.request('GET /user').then(({ data }) => (data.login));
    cachedOwner = fetchedOwner;
    return fetchedOwner;
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2l0aHViLWhlbHBlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9oYW5kbGVyL3NlY3JldHMvZ2l0aHViLWhlbHBlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFFQSxJQUFJLFdBQStCLENBQUM7QUFFdkIsUUFBQSxRQUFRLEdBQUcsS0FBSyxFQUFFLE9BQWdCLEVBQUUsS0FBeUIsRUFBbUIsRUFBRTtJQUM3RixJQUFJLEtBQUssRUFBRTtRQUNULE9BQU8sS0FBSyxDQUFDO0tBQ2Q7U0FBTSxJQUFJLFdBQVcsRUFBRTtRQUN0QixPQUFPLFdBQVcsQ0FBQztLQUNwQjtJQUVELE1BQU0sWUFBWSxHQUFHLE1BQU0sT0FBTyxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxFQUFFLElBQUksRUFBRSxFQUFFLEVBQUUsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO0lBQ3pGLFdBQVcsR0FBRyxZQUFZLENBQUM7SUFDM0IsT0FBTyxZQUFZLENBQUM7QUFFdEIsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgT2N0b2tpdCB9IGZyb20gJ0BvY3Rva2l0L2NvcmUnO1xuXG5sZXQgY2FjaGVkT3duZXI6IHN0cmluZyB8IHVuZGVmaW5lZDtcblxuZXhwb3J0IGNvbnN0IGdldE93bmVyID0gYXN5bmMgKG9jdG9raXQ6IE9jdG9raXQsIG93bmVyOiBzdHJpbmcgfCB1bmRlZmluZWQpOiBQcm9taXNlPHN0cmluZz4gPT4ge1xuICBpZiAob3duZXIpIHtcbiAgICByZXR1cm4gb3duZXI7XG4gIH0gZWxzZSBpZiAoY2FjaGVkT3duZXIpIHtcbiAgICByZXR1cm4gY2FjaGVkT3duZXI7XG4gIH1cblxuICBjb25zdCBmZXRjaGVkT3duZXIgPSBhd2FpdCBvY3Rva2l0LnJlcXVlc3QoJ0dFVCAvdXNlcicpLnRoZW4oKHsgZGF0YSB9KSA9PiAoZGF0YS5sb2dpbikpO1xuICBjYWNoZWRPd25lciA9IGZldGNoZWRPd25lcjtcbiAgcmV0dXJuIGZldGNoZWRPd25lcjtcblxufTtcbiJdfQ==