# Teams Attendance Report Converter

This tool is a simple script that converts basic attendance reports generated from MS Teams events into calculated attendance spreadsheets.

## Instalation

You can install this converter from [PyPI](https://pypi.org/project/teams-report-converter):

```python
pip install teams-report-converter
```

## How to use

This converter can be used as a command line application as well as a package imported by your own python application.

### Using as command line application:

```cmd
convert-teams-report -f <path-to-original-csv> -s <datetime-event-start> -e <datetime-event-end> -tz <timezone-event> -o <path-to-resulting-spreadsheet>
```
In this scenario the converter uses the following parameters:
- `-f`: path of attendance report generated by MS Teams for a live event (usually called "AttendeeReport.csv")
- `-s`: datetime of event start in the format "%Y-%m-%d %H:%M:%S" (you must use double quotes)
- `-e`: datetime of event end in the format "%Y-%m-%d %H:%M:%S" (you must use double quotes)
- `-o`: path of resulting spreadsheet
- `-tz`: timezone of event start and event end (for reference use [TZ database name](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones#List))

Note that this is the unique scenario that outputs a ready to use resulting spreadsheet.

### Using as package imported by your python application

You can still use the converter as a package only for processing the original report e apply your own calculations. In this scenario, the Converter class outputs three dataframes that you can handle:

```python
from teams_report_converter import Converter

converter = Converter(report_content='AttendeeReport.csv', 
                      event_start='2021-11-03 15:00:00', 
                      event_end='2021-11-03 17:00:00', 
                      local_tz='America/Sao_Paulo')
```
From this point, you can call `converter.data` for accessing the original data. Calling `converter.sessions` outputs another dataframe listing all joins and lefts paired by sessions and `converter.frequency` outputs the dataframe that contains the total of valid minutes accumulated by each participant. 