# Introduction #

This is a Python script that interacts with the AXIS door access control system to perform user management tasks such as getting all users, finding a user by username, id, or card number, and disabling a user.

# Axis Communications #

Axis Communications is company that does network video surveillance technology, offering a wide range of network cameras, video encoders, software, and other accessories for video surveillance applications. 

Axis Communications specializes in creating network-based surveillance solutions that can be easily integrated into existing IT infrastructure. Their products are designed to provide high-quality video surveillance, with features such as high-resolution video, remote monitoring and control, advanced analytics, and built-in intelligence.

Axis Communications' solutions are used in a variety of industries, including retail, transportation, education, healthcare, and more. Their products are known for their reliability, scalability, and ease of use, and they are widely used by businesses and organizations around the world to enhance security, increase efficiency, and improve operations.

Axis is a security platform that has a set of services for configuration and management of the access control systems.

# Installation #

    Clone this repository to your local machine
    
    Create a virtual environment for the project
        python3 -m venv [path to new virtual environment] (usually is .)
    
    Activate the virtual environment
        source [venv path to new virtual environment]/bin/activate
    
    Install the dependencies using pip install -r requirements.txt
    
    Create a .env file in the root directory and set the following environment variables:
        - AXIS_USER: The username for the AXIS system
        - AXIS_PASSWORD: The password for the AXIS system
        - CAMPUS_ID: The ID of the campus for the Dropi system
        - LOG_FILE_PATH (Optional): The path to the log file that will be generated by the script, 
        - This variable is set by default in the script directory with the name axis.log
        - UID42: 42 app uid
        - SECRET42: 42 app secret
        - SCOPE42: 42 app scope
    If no env file is specified then the script will ask for input 
    There is a .env.example file in the root directory that explains how you should configure your environment


### Usage of class ###

To use the script, run it with the command python main.py in your terminal. This will execute the script and perform the tasks defined in the main function. The tasks are:

    Get all users
    Find a user by username, id, or card number
    Enable or Disable a user
    Create and Remove a user

## Step by step on how to use axis class ##

Create a Axis() object

```python
    
    axis: Axis = Axis()
    users: list[User] = axis.get_all_users() # Returns a list of User objects

    axis.create_user('Ricardo', '[42 student] rimartin')

    # Find a user by username
    user = axis.get_user_by_username('rimartin')

    # Find a user by ID
    user = axis.get_user_by_id(123)

    # Find a user by card number
    user = axis.get_user_by_card_number('123456')

    # Disable a user
    axis.disable_user(user)

    # Enable a user
    axis.enable_user(user)

    # Remove a user
    axis.remove_user(user)
```

User class:

    Overall, the User class is used to represent information about a user in the Axis system and provides convenient methods to retrieve and modify the user's properties.

The class has several properties:

    - login (str): login of the user
    - tag (str): tag of the user
    - fullname (str): fullname of the user
    - user_token (str): user token of the user, every user has a unique token
    - enabled (bool): True if user is enabled in Axis, False otherwise
    - credential_groups (list[str]): list of credential groups of the user
    - credential_token (str): credential token of the user, every credential has a unique token
    - card_number (str): card number of the user
    - axis_credential (dict): axis credential information of the user, when we make a request to Axis, they expect this format
    - axis_user (dict): axis user information, when we make a request to Axis, they expect this format
    - id (str): id of the user on 42 intra, which is not initalized, because it is time consuming and most times it's not necessary
    - status (UserStatusEnum): status of the user on 42 intra, which is not initalized, because it is time consuming and most times it's not necessary

The User class has an __init__ method that takes a dictionary as input. The keys in the dictionary correspond to the properties listed above. The method initializes all the properties using the values in the dictionary. The id and status properties are set to None initially.

### Project status ###

This code is functional, but may need additional documentation and testing.

### Glossario ###

    HTTP Digest Auth:
        It's a server side authentication mechanism, it will ask the user to autenticate by providing a username and password, 
        but the request will be sent over http, so if someone is watching the packages it's dangerous to send the credentials 
        in plain text withou some sort of encryption.
        To solve this Http Digest Auth will send a "challenge" which is a random string that the browser can't predict, so the
        browser combines it with the password and hashes the result. Then this value will be returned in the response. The server
        will do the same calculation with his copy of the password and compares the result with the response.



