/*
 * Decompiled with CFR 0.152.
 */
package pdfextract;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import pdfextract.Common;
import pdfextract.StreamGobblerWithOutput;

public class SentenceJoin {
    private Common common = new Common();
    private String _sScriptPath = "";
    private String _skenlmPath = "";
    private Process _proc = null;
    private WorkerStatus _workerStatus;
    private String _language = "";
    private String _modelPath = "";
    private ExecutorService _executor;
    private Object _objectWorker = new Object();
    private StreamGobblerWithOutput _errorStreamGobbler;
    private StreamGobblerWithOutput _inputStreamGobbler;
    public boolean isKenlmError = false;

    public SentenceJoin(String lang, String scriptPath, String modelPath) {
        this._language = lang;
        this._sScriptPath = scriptPath;
        this._modelPath = modelPath;
        this._executor = Executors.newSingleThreadExecutor();
    }

    public SentenceJoin(String lang, String scriptPath, String modelPath, String sKenlmPath) {
        this._language = lang;
        this._sScriptPath = scriptPath;
        this._modelPath = modelPath;
        this._skenlmPath = sKenlmPath;
        this._executor = Executors.newSingleThreadExecutor();
    }

    public WorkerStatus status() {
        return this._workerStatus;
    }

    public void start() throws Exception {
        if (this._workerStatus == WorkerStatus.RUNNING || this._workerStatus == WorkerStatus.LOADING) {
            return;
        }
        if (!this.common.IsExist(this._sScriptPath)) {
            return;
        }
        if (this.common.IsEmpty(this._modelPath)) {
            return;
        }
        this._workerStatus = WorkerStatus.LOADING;
        try {
            StringBuilder sbError = new StringBuilder();
            String[] commands = new String[4];
            if (!StringUtils.isEmpty(this._skenlmPath)) {
                commands = new String[6];
            }
            commands[0] = this._sScriptPath;
            commands[1] = "--apply";
            commands[2] = "--model";
            commands[3] = this._modelPath;
            if (!StringUtils.isEmpty(this._skenlmPath)) {
                commands[4] = "--kenlm_path";
                commands[5] = this._skenlmPath;
            }
            ProcessBuilder proc = new ProcessBuilder(commands);
            proc.redirectErrorStream(false);
            this._proc = proc.start();
            this._inputStreamGobbler = new StreamGobblerWithOutput("InputStreamST", this._proc.getInputStream(), this._proc.getOutputStream(), "test\teating");
            this._errorStreamGobbler = new StreamGobblerWithOutput("ErrorStreamST", this._proc.getErrorStream());
            Thread tInput = new Thread(this._inputStreamGobbler);
            Thread tError = new Thread(this._errorStreamGobbler);
            tError.start();
            tInput.start();
            tInput.join();
            sbError = this._errorStreamGobbler.getOutputBuffer();
            if (sbError.length() > 0) {
                String sTemp = sbError.toString();
                sTemp = sTemp.replaceAll("(This binary file contains trie with quantization and array\\-compressed pointers\\.)(\\n*)", "");
                if (!this._proc.isAlive() && !StringUtils.isEmpty(sTemp) && this._proc.exitValue() != 0) {
                    throw new Exception(sTemp.toString());
                }
                this._workerStatus = WorkerStatus.RUNNING;
            } else {
                this._workerStatus = WorkerStatus.RUNNING;
            }
            this._inputStreamGobbler.getSentenceJoin("Someone\tplays football");
        }
        catch (Exception e) {
            if (null != e.getMessage() && e.getMessage().contains("KenLM")) {
                this.isKenlmError = true;
            }
            this._workerStatus = WorkerStatus.ERROR;
            throw new Exception("Start sentence join [" + this._language + "] failed: " + e.getMessage());
        }
        this._executor.shutdown();
    }

    public void stop() throws Exception {
        try {
            if (null != this._inputStreamGobbler) {
                this._inputStreamGobbler.CloseBuffer();
            }
            if (null != this._errorStreamGobbler) {
                this._errorStreamGobbler.CloseBuffer();
            }
            if (this._proc != null) {
                this._proc.destroy();
            }
            this._proc = null;
        }
        catch (Exception e) {
            this.common.print("stop sentence join [" + this._language + "] failed. " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String text1, String text2) throws Exception {
        Object object = this._objectWorker;
        synchronized (object) {
            try {
                String sOutput = "";
                sOutput = this._inputStreamGobbler.getSentenceJoin(text1 + "\t" + text2);
                return this.common.getBool(sOutput);
            }
            catch (Exception e) {
                this.common.print("execute sentence join [" + this._language + "] failed. " + text1 + "\t" + text2 + " ," + e.getMessage());
            }
        }
        return false;
    }

    public static enum WorkerStatus {
        STOPPED,
        LOADING,
        RUNNING,
        ERROR;

    }
}

