/*
 * Decompiled with CFR 0.152.
 */
package pdfextract;

import com.itextpdf.text.pdf.PdfEncryptor;
import com.itextpdf.text.pdf.PdfReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import pdfextract.Common;
import pdfextract.StreamGobbler;

public class PDFToHtml {
    Common common = new Common();
    private long timeout = 30L;

    public PDFToHtml(long timeout_) {
        if (timeout_ > 0L) {
            this.timeout = timeout_;
        }
    }

    public StringBuffer extract(ByteArrayInputStream bIn) throws Exception {
        StringBuffer sbuf = new StringBuffer();
        try {
            return sbuf.append(this.executeCommandByteArrayInputStream(bIn).toString());
        }
        catch (Exception e) {
            return new StringBuffer();
        }
    }

    public StringBuffer extract(String inputPath) throws Exception {
        StringBuffer sb = null;
        sb = new StringBuffer();
        String[] sCommand = new String[]{"pdftohtml", "-stdout", "-i", "-noframes", "-xml", "-fontfullname", inputPath};
        try {
            sb.append(this.executeCommand(sCommand).toString());
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            if (errorMsg.contains("Permission Error:")) {
                this.decrypt(inputPath);
                sb = new StringBuffer();
                sb.append(this.executeCommand(sCommand).toString());
            }
            throw e;
        }
        return sb;
    }

    public void decrypt(String file) throws IOException {
        this.decrypt(null, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrypt(PdfReader reader, String file) throws IOException {
        File fTemp = null;
        try {
            if (reader == null) {
                reader = new PdfReader(file);
                PdfReader.unethicalreading = true;
            }
            fTemp = File.createTempFile(new File(file).getName(), ".unlocked");
            fTemp.deleteOnExit();
            String inputPathUnlocked = fTemp.getPath();
            PdfEncryptor.encrypt(reader, (OutputStream)new FileOutputStream(inputPathUnlocked), null, null, 3900, false);
            this.common.moveFile(fTemp.getPath(), file);
        }
        catch (Exception exception) {
        }
        finally {
            if (reader != null) {
                reader.close();
                reader = null;
            }
            if (fTemp != null) {
                this.common.deleteFile(fTemp);
            }
        }
    }

    private StringBuilder executeCommand(String ... command) throws Exception {
        Process proc = null;
        boolean bTimeout = false;
        StringBuilder sbError = null;
        StringBuilder sb = null;
        try {
            sb = new StringBuilder();
            sbError = new StringBuilder();
            proc = Runtime.getRuntime().exec(command);
            StreamGobbler errorStreamGobbler = new StreamGobbler("ErrorStream", proc.getErrorStream());
            StreamGobbler inputStreamGobbler = new StreamGobbler("InputStream", proc.getInputStream());
            Thread tInput = new Thread(inputStreamGobbler);
            Thread tError = new Thread(errorStreamGobbler);
            tError.start();
            tInput.start();
            if (!proc.waitFor(this.timeout, TimeUnit.SECONDS)) {
                bTimeout = true;
                proc.destroyForcibly();
            }
            tError.join();
            tInput.join();
            errorStreamGobbler.CloseBuffer();
            inputStreamGobbler.CloseBuffer();
            sbError = errorStreamGobbler.getSbText();
            sb = inputStreamGobbler.getSbText();
            if (sbError.length() > 0) {
                String sTemp = sbError.toString();
                if (!proc.isAlive() && !StringUtils.isEmpty(sTemp) && proc.exitValue() != 0) {
                    throw new Exception(sTemp.toString());
                }
                StringBuilder stringBuilder = sb;
                return stringBuilder;
            }
            StringBuilder stringBuilder = sb;
            return stringBuilder;
        }
        catch (IOException e) {
            if (bTimeout) {
                throw new TimeoutException("Timed out waiting for poppler extract pdf reach. (" + this.timeout + " seconds)");
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            proc.destroy();
        }
    }

    private StringBuilder executeCommandByteArrayInputStream(ByteArrayInputStream bIn) throws Exception {
        Process proc = null;
        boolean bTimeout = false;
        StringBuilder sbError = null;
        StringBuilder sb = null;
        try {
            sb = new StringBuilder();
            sbError = new StringBuilder();
            String[] commands = new String[]{"pdftohtml", "-xml", "-fontfullname", "-stdout", "-i", "-noframes", "-", "nonsense"};
            ProcessBuilder procBuilder = new ProcessBuilder(commands);
            proc = procBuilder.start();
            StreamGobbler errorStreamGobbler = new StreamGobbler("ErrorStreamST", proc.getErrorStream());
            StreamGobbler inputStreamGobbler = new StreamGobbler("InputStreamST", proc.getInputStream(), proc.getOutputStream(), bIn);
            inputStreamGobbler.SetOutputStream();
            Thread tInput = new Thread(inputStreamGobbler);
            Thread tError = new Thread(errorStreamGobbler);
            tError.start();
            tInput.start();
            if (!proc.waitFor(this.timeout, TimeUnit.SECONDS)) {
                bTimeout = true;
                proc.destroyForcibly();
            }
            tError.join();
            tInput.join();
            errorStreamGobbler.CloseBuffer();
            inputStreamGobbler.CloseBuffer();
            sbError = errorStreamGobbler.getSbText();
            sb = inputStreamGobbler.getSbText();
            if (sbError.length() > 0) {
                String sTemp = sbError.toString();
                if (!proc.isAlive() && !StringUtils.isEmpty(sTemp) && proc.exitValue() != 0) {
                    throw new Exception(sTemp.toString());
                }
                StringBuilder stringBuilder = sb;
                return stringBuilder;
            }
            StringBuilder stringBuilder = sb;
            return stringBuilder;
        }
        catch (IOException e) {
            if (bTimeout) {
                throw new TimeoutException("Timed out waiting for poppler extract pdf reach. (" + this.timeout + " seconds)");
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            proc.destroy();
        }
    }
}

