# Responsible AI Toolbox

<p align="center">
  <img width="200" height="200" src="brand/logo_no_text_small.png">
</p>

<p align="center">
  <a href="https://pypi.org/project/rai-toolbox/">
    <img src="https://img.shields.io/pypi/v/rai-toolbox.svg" alt="PyPI" />
  </a>
  <a>
    <img src="https://img.shields.io/badge/python-3.7%20&#8208;%203.9-blue.svg" alt="Python version support" />
  </a>
  <a href="https://github.com/mit-ll-responsible-ai/responsible-ai-toolbox/actions?query=workflow%3ATests+branch%3Amain">
    <img src="https://github.com/mit-ll-responsible-ai/responsible-ai-toolbox/workflows/Tests/badge.svg" alt="GitHub Actions" />
  <a href="https://hypothesis.readthedocs.io/">
    <img src="https://img.shields.io/badge/hypothesis-tested-brightgreen.svg" alt="Tested with Hypothesis" />
  </a>

  <p align="center">
    A library that provides high-quality, PyTorch-centric tools for evaluating and enhancing both the robustness and the explainability of AI models.
  </p>
  <p align="center">
    Check out our <a href="https://mit-ll-responsible-ai.github.io/responsible-ai-toolbox/">documentation</a> for more information.
  </p>
  <p align="center">
    The rAI-toolbox works great with <a href="https://www.pytorchlightning.ai/">PyTorch Lightning</a> ⚡ and <a href="https://hydra.cc/">Hydra</a> 🐉. Check out <a href="https://mit-ll-responsible-ai.github.io/responsible-ai-toolbox/ref_mushin.html">rai_toolbox.mushin</a> to see how we use these frameworks to create efficient, configurable, and reproducible ML workflows with minimal boilerplate code.
  </p>
</p>



## Citation

Using `rai_toolbox` for your research? Please cite the following publication:

```
@article{soklaski2022tools,
  title={Tools and Practices for Responsible AI Engineering},
  author={Soklaski, Ryan and Goodwin, Justin and Brown, Olivia and Yee, Michael and Matterer, Jason},
  journal={arXiv preprint arXiv:2201.05647},
  year={2022}
}
```


## Contributing

If you would like to contribute to this repo, please refer to our `CONTRIBUTING.md` document.



## Disclaimer

DISTRIBUTION STATEMENT A. Approved for public release. Distribution is unlimited.

© 2022 MASSACHUSETTS INSTITUTE OF TECHNOLOGY

- Subject to FAR 52.227-11 – Patent Rights – Ownership by the Contractor (May 2014)
- SPDX-License-Identifier: MIT

This material is based upon work supported by the Under Secretary of Defense for Research and Engineering under Air Force Contract No. FA8702-15-D-0001. Any opinions, findings, conclusions or recommendations expressed in this material are those of the author(s) and do not necessarily reflect the views of the Under Secretary of Defense for Research and Engineering.

A portion of this research was sponsored by the United States Air Force Research Laboratory and the United States Air Force Artificial Intelligence Accelerator and was accomplished under Cooperative Agreement Number FA8750-19-2-1000. The views and conclusions contained in this document are those of the authors and should not be interpreted as representing the official policies, either expressed or implied, of the United States Air Force or the U.S. Government. The U.S. Government is authorized to reproduce and distribute reprints for Government purposes notwithstanding any copyright notation herein.

The software/firmware is provided to you on an As-Is basis.
