# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['forseti_lang', 'forseti_lang.checkers', 'forseti_lang.functions']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['main = forseti.__main__:start']}

setup_kwargs = {
    'name': 'forseti-lang',
    'version': '1.0.0',
    'description': 'The system for determining the compliance of the text with the specified rules',
    'long_description': '# Forseti Language\n\nThe system for determining the compliance of the text with the specified rules\n\n## How to install:\n\nPyPi installation guide\n```shell\npip install forseti-lang\n```\n\n## How to use:\n\n```python\nfrom forseti_lang.execute import execute_condition\n\ncondition = "TRUE AND FALSE"\ntext = ""\nexecute_condition(condition, text)  # False\n```\n\nAll regular expressions should be in lowercase.\n\n## Supported logic operators\n\n### English\n\nBelow is a table of available logical operators and their description.\n\n| Operator               | Description                                 | Priority |\n|------------------------|---------------------------------------------|----------|\n| ()                     | The conditions in quotes will be met first  | 0        |\n| AND                    | Logical **AND**                             | 1        |\n| AND NOT                | Logical **AND NOT**                         | 2        |\n| OR                     | Logical **OR**                              | 3        |\n| Atoms (TRUE and FALSE) | Minimum logical unit                        | 4        |\n\n### Russian\n\nForseti was developed for the analysis of texts in Russian.\nSo, you can use:\n\n| RU  | ENG |\n|-----|-----|\n| И   | AND |\n| ИЛИ | OR  |\n\n#### Note\n\nYou can combine ru and eng operators.\n\n## Supported functions\n\nWe really lacked a simple syntax (but regular expressions did not allow us to achieve this), so we created our own\nfunctions!\n\n| Function         | In Forseti | Description                                               | Priority |\n|------------------|------------|-----------------------------------------------------------|----------|\n| f text length    | ll, lg     | Text length in characters check function                  | 5        |\n| f words distance | wN, cN, N  | Checks whether the words are in the specified interval    | 6        |\n| f words nearby   | nearby     | Checks the words that are next to another word            | 7        |\n| f regex search   |            | Checks the occurrence of a regular expression in the text | 8        |\n\n### Explanations\n\n* `|ll` - length less (in characters)\n* `|lg` - length great (in characters)\n* `|wN` - word in distance `N words`\n* `|cN` - word in distance `N characters`\n* `|N` - alias of `|wN`\n* `|nearby` - the word is nearby to the words `word1 |nearby word2 | word3 | word4`\n\n#### Notes\n\n* All function starts with special character: `|`. That\'s why we don\'t support it in regular expressions\n* It is also forbidden to use the `-` character, it is used in the distance function\n* The function of finding words at a distance will allow you to exclude constructions with a word at a distance,\nfor example:\n```\ncondition - "hello |w1 -world"\ntext      - "Hello beautiful world!"\nresult    - False\n```\n* You cannot combine two functions in one expression\n* Nearby only works in one direction\n* Text length and word distance functions don\'t work with negative values\n* Nearby and word distance in characters are sensitive to punctuation marks\n\n## Priority table\n\n| Operator                   | Description                                               | Priority |\n|----------------------------|-----------------------------------------------------------|----------|\n| `()`                       | The conditions in quotes will be met first                | 0        |\n| `AND`                      | Logical `AND`                                             | 1        |\n| `AND NOT`                  | Logical `AND NOT`                                         | 2        |\n| `OR`                       | Logical `OR`                                              | 3        |\n| Atoms (`TRUE` and `FALSE`) | Minimum logical unit                                      | 4        |\n| f text length              | Text length in characters check function                  | 5        |\n| f words distance           | Checks whether the words are in the specified interval    | 6        |\n| f words nearby             | Checks the words that are next to another word            | 7        |\n| f regex search             | Checks the occurrence of a regular expression in the text | 8        |\n\n\n## Examples\n\n### Checking the length of the text\n\n```python\nfrom forseti_lang.execute import execute_condition\n\ncondition = \'|ll5\'\nexecute_condition(condition, "Hello world!")  # False\nexecute_condition(condition, "Hi")  # True\n\ncondition = \'|lg5\'\nexecute_condition(condition, "Hello world!")  # True\nexecute_condition(condition, "Hi")  # False\n```\n\n### Checking the words distance\n\n```python\nfrom forseti_lang.execute import execute_condition\n\ncondition = \'hello |w1 world\'\nexecute_condition(condition, "Hello world!")  # True\nexecute_condition(condition, "Hello sunny world!")  # True\nexecute_condition(condition, "Hello dirty and dark world!")  # False\n\ncondition = \'hi\\W? |c1 how are you\'\nexecute_condition(condition, "Hi, how are you?")  # True\nexecute_condition(condition, "Hi, hmm.. how ary you?")  # False\n\ncondition = \'hello |1 world\'\nexecute_condition(condition, "Hello world!")  # True\n```\n\n### Checking nearby words\n\n```python\nfrom forseti_lang.execute import execute_condition\n\ncondition = \'hello |nearby world | people | notalib\'\nexecute_condition(condition, "Hello world!")  # True\nexecute_condition(condition, "Hello notalib!")  # True\n```\n\n### Logic processing\n\n```python\nfrom forseti_lang.execute import execute_condition\n\nexecute_condition("TRUE AND FALSE", "") # False\nexecute_condition("TRUE OR FALSE", "") # True\nexecute_condition("FALSE OR TRUE AND (TRUE OR FALSE)", "") # True\nexecute_condition("FALSE OR TRUE AND (FALSE AND TRUE)", "") # False\nexecute_condition("(TRUE OR FALSE) AND NOT (TRUE AND FALSE)", "") # TRUE\n```\n\n\n### Difficult rules example\n* `короб AND NOT короб |2 конфет`\n* `минимальн\\w,{,2} |1 стоимо`\n* `балл AND NOT (сн[ия]\\w* балл ИЛИ 10\\s?балл ИЛИ десять\\sбаллов) AND |lg15`\n',
    'author': 'Kirill_Lekhov',
    'author_email': 'Kirill.Lekhov@mail.ru',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Kirill-Lekhov/forseti_lang',
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
