# coding: utf-8

"""
    Xero AppStore API

    These endpoints are for Xero Partners to interact with the App Store Billing platform  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class Plan(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "id": "str",
        "name": "str",
        "status": "str",
        "subscription_items": "list[SubscriptionItem]",
    }

    attribute_map = {
        "id": "id",
        "name": "name",
        "status": "status",
        "subscription_items": "subscriptionItems",
    }

    def __init__(
        self, id=None, name=None, status=None, subscription_items=None
    ):  # noqa: E501
        """Plan - a model defined in OpenAPI"""  # noqa: E501

        self._id = None
        self._name = None
        self._status = None
        self._subscription_items = None
        self.discriminator = None

        self.id = id
        self.name = name
        self.status = status
        self.subscription_items = subscription_items

    @property
    def id(self):
        """Gets the id of this Plan.  # noqa: E501

        The unique identifier of the plan  # noqa: E501

        :return: The id of this Plan.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Plan.

        The unique identifier of the plan  # noqa: E501

        :param id: The id of this Plan.  # noqa: E501
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def name(self):
        """Gets the name of this Plan.  # noqa: E501

        The name of the plan. It is used in the invoice line item description.   # noqa: E501

        :return: The name of this Plan.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Plan.

        The name of the plan. It is used in the invoice line item description.   # noqa: E501

        :param name: The name of this Plan.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError(
                "Invalid value for `name`, must not be `None`"
            )  # noqa: E501

        self._name = name

    @property
    def status(self):
        """Gets the status of this Plan.  # noqa: E501

        Status of the plan. Available statuses are ACTIVE, PENDING_ACTIVATION.   # noqa: E501

        :return: The status of this Plan.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Plan.

        Status of the plan. Available statuses are ACTIVE, PENDING_ACTIVATION.   # noqa: E501

        :param status: The status of this Plan.  # noqa: E501
        :type: str
        """
        if status is None:
            raise ValueError(
                "Invalid value for `status`, must not be `None`"
            )  # noqa: E501
        allowed_values = ["ACTIVE", "PENDING_ACTIVATION", "None"]  # noqa: E501

        if status:
            if status not in allowed_values:
                raise ValueError(
                    "Invalid value for `status` ({0}), must be one of {1}".format(  # noqa: E501
                        status, allowed_values
                    )
                )

        self._status = status

    @property
    def subscription_items(self):
        """Gets the subscription_items of this Plan.  # noqa: E501

        List of the subscription items belonging to the plan. It does not include cancelled subscription items.   # noqa: E501

        :return: The subscription_items of this Plan.  # noqa: E501
        :rtype: list[SubscriptionItem]
        """
        return self._subscription_items

    @subscription_items.setter
    def subscription_items(self, subscription_items):
        """Sets the subscription_items of this Plan.

        List of the subscription items belonging to the plan. It does not include cancelled subscription items.   # noqa: E501

        :param subscription_items: The subscription_items of this Plan.  # noqa: E501
        :type: list[SubscriptionItem]
        """
        if subscription_items is None:
            raise ValueError(
                "Invalid value for `subscription_items`, must not be `None`"
            )  # noqa: E501

        self._subscription_items = subscription_items
