import pickle

import numpy as np
import pytest


@pytest.fixture
def complex_transform():
    return {
        'initial': [
            {
                'Transform': ['EulerTransform'],
                'NumberOfParameters': ['3'],
                'TransformParameters': [
                    '1.5707963267948966',
                    '601.5749999999998',
                    '-601.5749999999998',
                ],
                'InitialTransformParametersFileName': ['NoInitialTransform'],
                'HowToCombineTransforms': ['Compose'],
                'FixedImageDimension': ['2'],
                'MovingImageDimension': ['2'],
                'FixedInternalImagePixelType': ['float'],
                'MovingInternalImagePixelType': ['float'],
                'Size': ['6769', '7386'],
                'Index': ['0', '0'],
                'Spacing': ['1.95', '1.95'],
                'Origin': ['0.0000', '0.0000'],
                'Direction': [
                    '1.0000000000',
                    '0.0000000000',
                    '0.0000000000',
                    '1.0000000000',
                ],
                'UseDirectionCosines': ['true'],
                'CenterOfRotationPoint': ['6598.8', '7200.375'],
                'ResampleInterpolator': ['FinalNearestNeighborInterpolator'],
                'Resampler': ['DefaultResampler'],
                'DefaultPixelValue': ['0.000000'],
                'ResultImageFormat': ['mha'],
                'ResultImagePixelType': ['float'],
                'CompressResultImage': ['true'],
            },
            {
                'Transform': ['AffineTransform'],
                'NumberOfParameters': ['6'],
                'TransformParameters': ['-1', '0', '0', '1', '0', '0'],
                'InitialTransformParametersFileName': ['NoInitialTransform'],
                'HowToCombineTransforms': ['Compose'],
                'FixedImageDimension': ['2'],
                'MovingImageDimension': ['2'],
                'FixedInternalImagePixelType': ['float'],
                'MovingInternalImagePixelType': ['float'],
                'Size': ['6769', '7386'],
                'Index': ['0', '0'],
                'Spacing': ['1.95', '1.95'],
                'Origin': ['0.0000', '0.0000'],
                'Direction': [
                    '1.0000000000',
                    '0.0000000000',
                    '0.0000000000',
                    '1.0000000000',
                ],
                'UseDirectionCosines': ['true'],
                'CenterOfRotationPoint': ['6598.8', '7200.375'],
                'ResampleInterpolator': ['FinalNearestNeighborInterpolator'],
                'Resampler': ['DefaultResampler'],
                'DefaultPixelValue': ['0.000000'],
                'ResultImageFormat': ['mha'],
                'ResultImagePixelType': ['float'],
                'CompressResultImage': ['true'],
            },
        ],
        '0': [
            {
                'CenterOfRotationPoint': ['6622.2', '7784.4'],
                'CompressResultImage': ['true'],
                'DefaultPixelValue': ['0'],
                'Direction': ['1', '0', '0', '1'],
                'FixedImageDimension': ['2'],
                'FixedInternalImagePixelType': ['float'],
                'HowToCombineTransforms': ['Compose'],
                'Index': ['0', '0'],
                'InitialTransformParametersFileName': ['NoInitialTransform'],
                'MovingImageDimension': ['2'],
                'MovingInternalImagePixelType': ['float'],
                'NumberOfParameters': ['3'],
                'Origin': ['0', '0'],
                'ResampleInterpolator': ['FinalNearestNeighborInterpolator'],
                'Resampler': ['DefaultResampler'],
                'ResultImageFormat': ['mha'],
                'ResultImagePixelType': ['float'],
                'Size': ['6793', '7985'],
                'Spacing': ['1.95', '1.95'],
                'Transform': ['EulerTransform'],
                'TransformParameters': [
                    '-0.08284214564408873',
                    '-1306.3427228105772',
                    '-991.9182706690468',
                ],
                'UseDirectionCosines': ['true'],
            },
            {
                'BSplineTransformSplineOrder': ['3'],
                'CompressResultImage': ['true'],
                'DefaultPixelValue': ['0'],
                'Direction': ['1', '0', '0', '1'],
                'FixedImageDimension': ['2'],
                'FixedInternalImagePixelType': ['float'],
                'GridDirection': ['1', '0', '0', '1'],
                'GridIndex': ['0', '0'],
                'GridOrigin': ['-2067.5640452749403', '-1636.5330828131607'],
                'GridSize': ['136', '159'],
                'GridSpacing': ['109.38401959206463', '106.69639002714067'],
                'HowToCombineTransforms': ['Compose'],
                'Index': ['0', '0'],
                'InitialTransformParametersFileName': ['0'],
                'MovingImageDimension': ['2'],
                'MovingInternalImagePixelType': ['float'],
                'NumberOfParameters': ['43248'],
                'Origin': ['0', '0'],
                'ResampleInterpolator': ['FinalNearestNeighborInterpolator'],
                'Resampler': ['DefaultResampler'],
                'ResultImageFormat': ['mha'],
                'ResultImagePixelType': ['float'],
                'Size': ['1024', '1024'],
                'Spacing': ['1.95', '1.95'],
                'Transform': ['BSplineTransform'],
                'TransformParameters': np.random.random((43248,)).tolist(),
                'UseCyclicTransform': ['false'],
                'UseDirectionCosines': ['true'],
            },
        ],
        '1': [
            {
                'CenterOfRotationPoint': ['5559', '7609'],
                'CompressResultImage': ['true'],
                'DefaultPixelValue': ['0'],
                'Direction': ['1', '0', '0', '1'],
                'FixedImageDimension': ['2'],
                'FixedInternalImagePixelType': ['float'],
                'HowToCombineTransforms': ['Compose'],
                'Index': ['0', '0'],
                'InitialTransformParametersFileName': ['NoInitialTransform'],
                'MovingImageDimension': ['2'],
                'MovingInternalImagePixelType': ['float'],
                'NumberOfParameters': ['3'],
                'Origin': ['0', '0'],
                'ResampleInterpolator': ['FinalNearestNeighborInterpolator'],
                'Resampler': ['DefaultResampler'],
                'ResultImageFormat': ['mha'],
                'ResultImagePixelType': ['float'],
                'Size': ['1024', '1024'],
                'Spacing': ['2', '2'],
                'Transform': ['EulerTransform'],
                'TransformParameters': [
                    '-0.0042257214326670706',
                    '1485.2882969318628',
                    '1562.9184348320616',
                ],
                'UseDirectionCosines': ['true'],
            },
            {
                'CenterOfRotationPoint': [
                    '7044.288296931862',
                    '9171.918434832063',
                ],
                'CompressResultImage': ['true'],
                'DefaultPixelValue': ['0'],
                'Direction': ['1', '0', '0', '1'],
                'FixedImageDimension': ['2'],
                'FixedInternalImagePixelType': ['float'],
                'HowToCombineTransforms': ['Compose'],
                'Index': ['0', '0'],
                'InitialTransformParametersFileName': ['0'],
                'MovingImageDimension': ['2'],
                'MovingInternalImagePixelType': ['float'],
                'NumberOfParameters': ['6'],
                'Origin': ['0', '0'],
                'ResampleInterpolator': ['FinalNearestNeighborInterpolator'],
                'Resampler': ['DefaultResampler'],
                'ResultImageFormat': ['mha'],
                'ResultImagePixelType': ['float'],
                'Size': ['1024', '1024'],
                'Spacing': ['2', '2'],
                'Transform': ['AffineTransform'],
                'TransformParameters': [
                    '0.9950415227069288',
                    '-0.00010257497254207552',
                    '-0.0011168508123054915',
                    '0.994578583104989',
                    '0.42502362300245433',
                    '-7.2389671174396275',
                ],
                'UseDirectionCosines': ['true'],
            },
        ],
    }


@pytest.fixture
def complex_transform_larger():
    return {
        'initial': [
            {
                'Transform': ['EulerTransform'],
                'NumberOfParameters': ['3'],
                'TransformParameters': [
                    '1.5707963267948966',
                    '601.5749999999998',
                    '-601.5749999999998',
                ],
                'InitialTransformParametersFileName': ['NoInitialTransform'],
                'HowToCombineTransforms': ['Compose'],
                'FixedImageDimension': ['2'],
                'MovingImageDimension': ['2'],
                'FixedInternalImagePixelType': ['float'],
                'MovingInternalImagePixelType': ['float'],
                'Size': ['6769', '7386'],
                'Index': ['0', '0'],
                'Spacing': ['1.95', '1.95'],
                'Origin': ['0.0000', '0.0000'],
                'Direction': [
                    '1.0000000000',
                    '0.0000000000',
                    '0.0000000000',
                    '1.0000000000',
                ],
                'UseDirectionCosines': ['true'],
                'CenterOfRotationPoint': ['6598.8', '7200.375'],
                'ResampleInterpolator': ['FinalNearestNeighborInterpolator'],
                'Resampler': ['DefaultResampler'],
                'DefaultPixelValue': ['0.000000'],
                'ResultImageFormat': ['mha'],
                'ResultImagePixelType': ['float'],
                'CompressResultImage': ['true'],
            },
            {
                'Transform': ['AffineTransform'],
                'NumberOfParameters': ['6'],
                'TransformParameters': ['-1', '0', '0', '1', '0', '0'],
                'InitialTransformParametersFileName': ['NoInitialTransform'],
                'HowToCombineTransforms': ['Compose'],
                'FixedImageDimension': ['2'],
                'MovingImageDimension': ['2'],
                'FixedInternalImagePixelType': ['float'],
                'MovingInternalImagePixelType': ['float'],
                'Size': ['6769', '7386'],
                'Index': ['0', '0'],
                'Spacing': ['1.95', '1.95'],
                'Origin': ['0.0000', '0.0000'],
                'Direction': [
                    '1.0000000000',
                    '0.0000000000',
                    '0.0000000000',
                    '1.0000000000',
                ],
                'UseDirectionCosines': ['true'],
                'CenterOfRotationPoint': ['6598.8', '7200.375'],
                'ResampleInterpolator': ['FinalNearestNeighborInterpolator'],
                'Resampler': ['DefaultResampler'],
                'DefaultPixelValue': ['0.000000'],
                'ResultImageFormat': ['mha'],
                'ResultImagePixelType': ['float'],
                'CompressResultImage': ['true'],
            },
        ],
        '0': [
            {
                'CenterOfRotationPoint': ['6622.2', '7784.4'],
                'CompressResultImage': ['true'],
                'DefaultPixelValue': ['0'],
                'Direction': ['1', '0', '0', '1'],
                'FixedImageDimension': ['2'],
                'FixedInternalImagePixelType': ['float'],
                'HowToCombineTransforms': ['Compose'],
                'Index': ['0', '0'],
                'InitialTransformParametersFileName': ['NoInitialTransform'],
                'MovingImageDimension': ['2'],
                'MovingInternalImagePixelType': ['float'],
                'NumberOfParameters': ['3'],
                'Origin': ['0', '0'],
                'ResampleInterpolator': ['FinalNearestNeighborInterpolator'],
                'Resampler': ['DefaultResampler'],
                'ResultImageFormat': ['mha'],
                'ResultImagePixelType': ['float'],
                'Size': ['6793', '7985'],
                'Spacing': ['1.95', '1.95'],
                'Transform': ['EulerTransform'],
                'TransformParameters': [
                    '-0.08284214564408873',
                    '-1306.3427228105772',
                    '-991.9182706690468',
                ],
                'UseDirectionCosines': ['true'],
            },
            {
                'BSplineTransformSplineOrder': ['3'],
                'CompressResultImage': ['true'],
                'DefaultPixelValue': ['0'],
                'Direction': ['1', '0', '0', '1'],
                'FixedImageDimension': ['2'],
                'FixedInternalImagePixelType': ['float'],
                'GridDirection': ['1', '0', '0', '1'],
                'GridIndex': ['0', '0'],
                'GridOrigin': ['-2067.5640452749403', '-1636.5330828131607'],
                'GridSize': ['136', '159'],
                'GridSpacing': ['109.38401959206463', '106.69639002714067'],
                'HowToCombineTransforms': ['Compose'],
                'Index': ['0', '0'],
                'InitialTransformParametersFileName': ['0'],
                'MovingImageDimension': ['2'],
                'MovingInternalImagePixelType': ['float'],
                'NumberOfParameters': ['43248'],
                'Origin': ['0', '0'],
                'ResampleInterpolator': ['FinalNearestNeighborInterpolator'],
                'Resampler': ['DefaultResampler'],
                'ResultImageFormat': ['mha'],
                'ResultImagePixelType': ['float'],
                'Size': ['1024', '1024'],
                'Spacing': ['1.95', '1.95'],
                'Transform': ['BSplineTransform'],
                'TransformParameters': np.random.random((43248,)).tolist(),
                'UseCyclicTransform': ['false'],
                'UseDirectionCosines': ['true'],
            },
        ],
        '1': [
            {
                'CenterOfRotationPoint': ['5559', '7609'],
                'CompressResultImage': ['true'],
                'DefaultPixelValue': ['0'],
                'Direction': ['1', '0', '0', '1'],
                'FixedImageDimension': ['2'],
                'FixedInternalImagePixelType': ['float'],
                'HowToCombineTransforms': ['Compose'],
                'Index': ['0', '0'],
                'InitialTransformParametersFileName': ['NoInitialTransform'],
                'MovingImageDimension': ['2'],
                'MovingInternalImagePixelType': ['float'],
                'NumberOfParameters': ['3'],
                'Origin': ['0', '0'],
                'ResampleInterpolator': ['FinalNearestNeighborInterpolator'],
                'Resampler': ['DefaultResampler'],
                'ResultImageFormat': ['mha'],
                'ResultImagePixelType': ['float'],
                'Size': ['2099', '3099'],
                'Spacing': ['2', '2'],
                'Transform': ['EulerTransform'],
                'TransformParameters': [
                    '-0.0042257214326670706',
                    '1485.2882969318628',
                    '1562.9184348320616',
                ],
                'UseDirectionCosines': ['true'],
            },
            {
                'CenterOfRotationPoint': [
                    '7044.288296931862',
                    '9171.918434832063',
                ],
                'CompressResultImage': ['true'],
                'DefaultPixelValue': ['0'],
                'Direction': ['1', '0', '0', '1'],
                'FixedImageDimension': ['2'],
                'FixedInternalImagePixelType': ['float'],
                'HowToCombineTransforms': ['Compose'],
                'Index': ['0', '0'],
                'InitialTransformParametersFileName': ['0'],
                'MovingImageDimension': ['2'],
                'MovingInternalImagePixelType': ['float'],
                'NumberOfParameters': ['6'],
                'Origin': ['0', '0'],
                'ResampleInterpolator': ['FinalNearestNeighborInterpolator'],
                'Resampler': ['DefaultResampler'],
                'ResultImageFormat': ['mha'],
                'ResultImagePixelType': ['float'],
                'Size': ['1024', '1024'],
                'Spacing': ['2', '2'],
                'Transform': ['AffineTransform'],
                'TransformParameters': [
                    '0.9950415227069288',
                    '-0.00010257497254207552',
                    '-0.0011168508123054915',
                    '0.994578583104989',
                    '0.42502362300245433',
                    '-7.2389671174396275',
                ],
                'UseDirectionCosines': ['true'],
            },
        ],
    }


@pytest.fixture
def complex_transform_larger_padded():
    return {
        'initial': [
            {
                'Transform': ['EulerTransform'],
                'NumberOfParameters': ['3'],
                'TransformParameters': [
                    '1.5707963267948966',
                    '601.5749999999998',
                    '-601.5749999999998',
                ],
                'InitialTransformParametersFileName': ['NoInitialTransform'],
                'HowToCombineTransforms': ['Compose'],
                'FixedImageDimension': ['2'],
                'MovingImageDimension': ['2'],
                'FixedInternalImagePixelType': ['float'],
                'MovingInternalImagePixelType': ['float'],
                'Size': ['6769', '7386'],
                'Index': ['0', '0'],
                'Spacing': ['1.95', '1.95'],
                'Origin': ['0.0000', '0.0000'],
                'Direction': [
                    '1.0000000000',
                    '0.0000000000',
                    '0.0000000000',
                    '1.0000000000',
                ],
                'UseDirectionCosines': ['true'],
                'CenterOfRotationPoint': ['6598.8', '7200.375'],
                'ResampleInterpolator': ['FinalNearestNeighborInterpolator'],
                'Resampler': ['DefaultResampler'],
                'DefaultPixelValue': ['0.000000'],
                'ResultImageFormat': ['mha'],
                'ResultImagePixelType': ['float'],
                'CompressResultImage': ['true'],
            },
            {
                'Transform': ['AffineTransform'],
                'NumberOfParameters': ['6'],
                'TransformParameters': ['-1', '0', '0', '1', '0', '0'],
                'InitialTransformParametersFileName': ['NoInitialTransform'],
                'HowToCombineTransforms': ['Compose'],
                'FixedImageDimension': ['2'],
                'MovingImageDimension': ['2'],
                'FixedInternalImagePixelType': ['float'],
                'MovingInternalImagePixelType': ['float'],
                'Size': ['6769', '7386'],
                'Index': ['0', '0'],
                'Spacing': ['1.95', '1.95'],
                'Origin': ['0.0000', '0.0000'],
                'Direction': [
                    '1.0000000000',
                    '0.0000000000',
                    '0.0000000000',
                    '1.0000000000',
                ],
                'UseDirectionCosines': ['true'],
                'CenterOfRotationPoint': ['6598.8', '7200.375'],
                'ResampleInterpolator': ['FinalNearestNeighborInterpolator'],
                'Resampler': ['DefaultResampler'],
                'DefaultPixelValue': ['0.000000'],
                'ResultImageFormat': ['mha'],
                'ResultImagePixelType': ['float'],
                'CompressResultImage': ['true'],
            },
        ],
        '0': [
            {
                'CenterOfRotationPoint': ['6622.2', '7784.4'],
                'CompressResultImage': ['true'],
                'DefaultPixelValue': ['0'],
                'Direction': ['1', '0', '0', '1'],
                'FixedImageDimension': ['2'],
                'FixedInternalImagePixelType': ['float'],
                'HowToCombineTransforms': ['Compose'],
                'Index': ['0', '0'],
                'InitialTransformParametersFileName': ['NoInitialTransform'],
                'MovingImageDimension': ['2'],
                'MovingInternalImagePixelType': ['float'],
                'NumberOfParameters': ['3'],
                'Origin': ['0', '0'],
                'ResampleInterpolator': ['FinalNearestNeighborInterpolator'],
                'Resampler': ['DefaultResampler'],
                'ResultImageFormat': ['mha'],
                'ResultImagePixelType': ['float'],
                'Size': ['6793', '7985'],
                'Spacing': ['1.95', '1.95'],
                'Transform': ['EulerTransform'],
                'TransformParameters': [
                    '-0.08284214564408873',
                    '-1306.3427228105772',
                    '-991.9182706690468',
                ],
                'UseDirectionCosines': ['true'],
            },
            {
                'BSplineTransformSplineOrder': ['3'],
                'CompressResultImage': ['true'],
                'DefaultPixelValue': ['0'],
                'Direction': ['1', '0', '0', '1'],
                'FixedImageDimension': ['2'],
                'FixedInternalImagePixelType': ['float'],
                'GridDirection': ['1', '0', '0', '1'],
                'GridIndex': ['0', '0'],
                'GridOrigin': ['-2067.5640452749403', '-1636.5330828131607'],
                'GridSize': ['136', '159'],
                'GridSpacing': ['109.38401959206463', '106.69639002714067'],
                'HowToCombineTransforms': ['Compose'],
                'Index': ['0', '0'],
                'InitialTransformParametersFileName': ['0'],
                'MovingImageDimension': ['2'],
                'MovingInternalImagePixelType': ['float'],
                'NumberOfParameters': ['43248'],
                'Origin': ['0', '0'],
                'ResampleInterpolator': ['FinalNearestNeighborInterpolator'],
                'Resampler': ['DefaultResampler'],
                'ResultImageFormat': ['mha'],
                'ResultImagePixelType': ['float'],
                'Size': ['1024', '1024'],
                'Spacing': ['1.95', '1.95'],
                'Transform': ['BSplineTransform'],
                'TransformParameters': np.random.random((43248,)).tolist(),
                'UseCyclicTransform': ['false'],
                'UseDirectionCosines': ['true'],
            },
        ],
        '1': [
            {
                'CenterOfRotationPoint': ['5559', '7609'],
                'CompressResultImage': ['true'],
                'DefaultPixelValue': ['0'],
                'Direction': ['1', '0', '0', '1'],
                'FixedImageDimension': ['2'],
                'FixedInternalImagePixelType': ['float'],
                'HowToCombineTransforms': ['Compose'],
                'Index': ['0', '0'],
                'InitialTransformParametersFileName': ['NoInitialTransform'],
                'MovingImageDimension': ['2'],
                'MovingInternalImagePixelType': ['float'],
                'NumberOfParameters': ['3'],
                'Origin': ['0', '0'],
                'ResampleInterpolator': ['FinalNearestNeighborInterpolator'],
                'Resampler': ['DefaultResampler'],
                'ResultImageFormat': ['mha'],
                'ResultImagePixelType': ['float'],
                'Size': ['2099', '3099'],
                'Spacing': ['2', '2'],
                'Transform': ['EulerTransform'],
                'TransformParameters': [
                    '-0.0042257214326670706',
                    '1485.2882969318628',
                    '1562.9184348320616',
                ],
                'UseDirectionCosines': ['true'],
            },
            {
                'CenterOfRotationPoint': [
                    '7044.288296931862',
                    '9171.918434832063',
                ],
                'CompressResultImage': ['true'],
                'DefaultPixelValue': ['0'],
                'Direction': ['1', '0', '0', '1'],
                'FixedImageDimension': ['2'],
                'FixedInternalImagePixelType': ['float'],
                'HowToCombineTransforms': ['Compose'],
                'Index': ['0', '0'],
                'InitialTransformParametersFileName': ['0'],
                'MovingImageDimension': ['2'],
                'MovingInternalImagePixelType': ['float'],
                'NumberOfParameters': ['6'],
                'Origin': ['0', '0'],
                'ResampleInterpolator': ['FinalNearestNeighborInterpolator'],
                'Resampler': ['DefaultResampler'],
                'ResultImageFormat': ['mha'],
                'ResultImagePixelType': ['float'],
                'Size': ['3099', '2099'],
                'Spacing': ['2', '2'],
                'Transform': ['AffineTransform'],
                'TransformParameters': [
                    '0.9950415227069288',
                    '-0.00010257497254207552',
                    '-0.0011168508123054915',
                    '0.994578583104989',
                    '0.42502362300245433',
                    '-7.2389671174396275',
                ],
                'UseDirectionCosines': ['true'],
            },
        ],
    }


@pytest.fixture
def simple_transform_affine():
    return {
        'initial': [],
        '0': [
            {
                'CenterOfRotationPoint': ['1023', '1023'],
                'CompressResultImage': ['true'],
                'DefaultPixelValue': ['0'],
                'Direction': ['1', '0', '0', '1'],
                'FixedImageDimension': ['2'],
                'FixedInternalImagePixelType': ['float'],
                'HowToCombineTransforms': ['Compose'],
                'Index': ['0', '0'],
                'InitialTransformParametersFileName': ['NoInitialTransform'],
                'MovingImageDimension': ['2'],
                'MovingInternalImagePixelType': ['float'],
                'NumberOfParameters': ['6'],
                'Origin': ['0', '0'],
                'ResampleInterpolator': ['FinalNearestNeighborInterpolator'],
                'Resampler': ['DefaultResampler'],
                'ResultImageFormat': ['mha'],
                'ResultImagePixelType': ['float'],
                'Size': ['1024', '1024'],
                'Spacing': ['2', '2'],
                'Transform': ['AffineTransform'],
                'TransformParameters': [
                    '0.7567764805571071',
                    '0.03837669141118439',
                    '-0.13607342366687353',
                    '1.0305545112711545',
                    '469.55900326093416',
                    '156.0908167708924',
                ],
                'UseDirectionCosines': ['true'],
            }
        ],
    }


@pytest.fixture
def simple_transform_affine_nl():
    return {
        "initial": [],
        "0": [
            {
                "CenterOfRotationPoint": ["1549", "1049"],
                "CompressResultImage": ["true"],
                "DefaultPixelValue": ["0"],
                "Direction": ["1", "0", "0", "1"],
                "FixedImageDimension": ["2"],
                "FixedInternalImagePixelType": ["float"],
                "HowToCombineTransforms": ["Compose"],
                "Index": ["0", "0"],
                "InitialTransformParametersFileName": ["NoInitialTransform"],
                "MovingImageDimension": ["2"],
                "MovingInternalImagePixelType": ["float"],
                "NumberOfParameters": ["6"],
                "Origin": ["0", "0"],
                "ResampleInterpolator": ["FinalNearestNeighborInterpolator"],
                "Resampler": ["DefaultResampler"],
                "ResultImageFormat": ["mha"],
                "ResultImagePixelType": ["float"],
                "Size": ["3099", "2099"],
                "Spacing": ["1", "1"],
                "Transform": ["AffineTransform"],
                "TransformParameters": [
                    "0.6952751205730702",
                    "-0.03563788730868529",
                    "-0.05465117691985885",
                    "0.9017096836910463",
                    "-451.277133969974",
                    "-8.122965475836498",
                ],
                "UseDirectionCosines": ["true"],
            },
            {
                "BSplineTransformSplineOrder": ["3"],
                "CompressResultImage": ["true"],
                "DefaultPixelValue": ["0"],
                "Direction": ["1", "0", "0", "1"],
                "FixedImageDimension": ["2"],
                "FixedInternalImagePixelType": ["float"],
                "GridDirection": ["1", "0", "0", "1"],
                "GridIndex": ["0", "0"],
                "GridOrigin": ["-89.30279837599048", "-88.89451068735627"],
                "GridSize": ["34", "24"],
                "GridSpacing": ["71.94094935794038", "98.24100393143651"],
                "HowToCombineTransforms": ["Compose"],
                "Index": ["0", "0"],
                "InitialTransformParametersFileName": ["0"],
                "MovingImageDimension": ["2"],
                "MovingInternalImagePixelType": ["float"],
                "NumberOfParameters": ["1632"],
                "Origin": ["0", "0"],
                "ResampleInterpolator": ["FinalNearestNeighborInterpolator"],
                "Resampler": ["DefaultResampler"],
                "ResultImageFormat": ["mha"],
                "ResultImagePixelType": ["float"],
                "Size": ["3099", "2099"],
                "Spacing": ["1", "1"],
                "Transform": ["BSplineTransform"],
                "TransformParameters": [
                    "346.1685176801543",
                    "327.4731409437514",
                    "324.41761059730425",
                    "319.55188298376845",
                    "315.5054982266721",
                    "311.8090280751891",
                    "308.63574902154454",
                    "305.5677365141201",
                    "302.451898481584",
                    "299.22134936237245",
                    "295.82550917191196",
                    "292.25256246884754",
                    "288.47978395143554",
                    "284.43127946856777",
                    "280.2309433328638",
                    "276.20482640671565",
                    "272.6266495821223",
                    "269.9344130037499",
                    "267.9484273671518",
                    "265.85911655701136",
                    "263.06367432655617",
                    "258.7900740668137",
                    "253.05783153035833",
                    "246.7041920051949",
                    "240.33509647662493",
                    "234.69970667906586",
                    "230.33279720420848",
                    "227.38273335915315",
                    "226.20062413251713",
                    "227.2725832160369",
                    "230.22158168410098",
                    "234.81850288299557",
                    "238.2380783068482",
                    "254.36124363615576",
                    "338.1333623132271",
                    "318.75963497528016",
                    "315.5674618149036",
                    "310.5467403438256",
                    "306.46668114194364",
                    "302.94267435129007",
                    "300.10818185759285",
                    "297.40340174210337",
                    "294.5209443579451",
                    "291.492297899927",
                    "288.396090253388",
                    "285.2085240000449",
                    "281.6997903965263",
                    "277.8917158193537",
                    "273.59786018177",
                    "270.1037678766348",
                    "267.6944806106202",
                    "265.7322236905214",
                    "263.9648320441369",
                    "261.4738922644175",
                    "256.91965254089087",
                    "249.08185693874574",
                    "237.60841957409198",
                    "225.52341695598344",
                    "212.57513470156124",
                    "200.42677009383195",
                    "192.22277812853812",
                    "186.95443927401362",
                    "185.4011423672134",
                    "188.82398206664433",
                    "196.1240675014792",
                    "205.9592026844881",
                    "213.49787256385952",
                    "236.72223737708487",
                    "338.02048118896914",
                    "318.546972581579",
                    "315.53186498826415",
                    "310.6242122256941",
                    "305.6737918954718",
                    "302.73209154716415",
                    "299.2985891195221",
                    "297.1329682815004",
                    "293.8452502540424",
                    "289.43209880875685",
                    "287.8140140881465",
                    "285.9707404466337",
                    "281.9732477443762",
                    "279.81221103348605",
                    "274.96152042194996",
                    "272.34314215423296",
                    "270.29862277661874",
                    "267.3027820794648",
                    "265.6527475354288",
                    "263.31453233248794",
                    "258.3223614514568",
                    "249.76961578484517",
                    "234.84825180323256",
                    "221.30639972307043",
                    "204.61166324295954",
                    "190.3974716361549",
                    "181.5993914816903",
                    "175.84373064258494",
                    "173.81706126013896",
                    "178.1931430199949",
                    "187.57449487223244",
                    "199.72289436206358",
                    "208.98347358595103",
                    "234.92722426762512",
                    "336.6399088966055",
                    "316.93316476047534",
                    "313.76904503025014",
                    "307.6796326215777",
                    "301.0778380342201",
                    "301.22876388094056",
                    "298.96922053989107",
                    "295.24111962712294",
                    "291.65107390778826",
                    "287.81515673702233",
                    "288.0521662324887",
                    "282.686487362343",
                    "278.2996104470501",
                    "277.75773099961094",
                    "274.652136491453",
                    "274.3626387218978",
                    "270.5024029968783",
                    "268.0890254853293",
                    "269.55195011264345",
                    "269.7958598669742",
                    "261.93222045998397",
                    "246.97761702760496",
                    "229.28842913432882",
                    "215.007854898739",
                    "197.09789223830046",
                    "179.49290661628194",
                    "168.61037818154202",
                    "159.08914219426157",
                    "157.98588966146505",
                    "164.36059201134609",
                    "176.01016668032045",
                    "190.7362845487527",
                    "201.9545524921357",
                    "231.0845811889134",
                    "334.92667911111243",
                    "315.0037778788224",
                    "311.2791377850094",
                    "304.9716050556274",
                    "301.3679880097212",
                    "298.688581995427",
                    "298.6629116786487",
                    "296.6162472896863",
                    "292.09658808009334",
                    "288.180592768034",
                    "283.67968534533674",
                    "277.3219446193805",
                    "274.7172190263485",
                    "273.13079145167336",
                    "271.6453852010701",
                    "272.30291166223503",
                    "270.1957199302014",
                    "268.6382658745035",
                    "270.9055375169434",
                    "271.7145387539127",
                    "261.31771386162575",
                    "244.4756294759902",
                    "228.85499362412753",
                    "208.73474211987568",
                    "190.16886487744472",
                    "169.67610987236336",
                    "156.9816098888557",
                    "148.39534823009677",
                    "147.1128193407157",
                    "154.2124093909722",
                    "167.2845822822831",
                    "183.69920268081617",
                    "196.2317249048742",
                    "227.56372600096137",
                    "333.0992865052926",
                    "313.22632048260033",
                    "309.2855448211806",
                    "305.17747061563324",
                    "302.25851257041603",
                    "296.25812410233084",
                    "296.1535842931649",
                    "296.1408805688194",
                    "291.68805574397817",
                    "285.4270699956124",
                    "280.2220747925449",
                    "274.5739513217589",
                    "271.92524214886566",
                    "268.83988366801765",
                    "270.968364882148",
                    "273.2047986310636",
                    "271.6143729252179",
                    "267.68059249405843",
                    "268.6429135282244",
                    "269.8133978542261",
                    "261.00130548354053",
                    "241.37068571103976",
                    "223.3083697066741",
                    "201.3107468908836",
                    "181.8045021823426",
                    "162.88026677917887",
                    "148.87969917005864",
                    "141.4979622752536",
                    "140.00121689945934",
                    "147.79870344047518",
                    "161.52458419898358",
                    "178.722228745679",
                    "191.91677004316315",
                    "224.44653945005643",
                    "331.7254007783348",
                    "311.88681691644103",
                    "308.43295604807946",
                    "304.55093088424616",
                    "303.16043931739966",
                    "299.87206374602073",
                    "298.9415344320633",
                    "295.98347069790196",
                    "291.10690011598933",
                    "283.58833401077214",
                    "277.5516097799515",
                    "273.17754331545524",
                    "270.244064134124",
                    "264.58485466383775",
                    "264.9707054604393",
                    "269.5647342626765",
                    "269.8389641186398",
                    "267.63709067522285",
                    "271.4807169086873",
                    "268.64963990961957",
                    "256.3111829811734",
                    "236.86600020387905",
                    "216.88524555926654",
                    "197.12478793744543",
                    "177.2046703912743",
                    "156.85390385400723",
                    "142.5275710053363",
                    "138.5455356733213",
                    "137.76701744502114",
                    "145.42450293271443",
                    "159.06401203643813",
                    "176.19641244159678",
                    "189.42456619300987",
                    "222.15184235200078",
                    "331.4755672429598",
                    "312.3034032663087",
                    "309.4430056464251",
                    "306.6207353233411",
                    "305.0924491021132",
                    "301.28387883370664",
                    "302.69022435986085",
                    "299.6016461677884",
                    "292.2867972287593",
                    "280.2880457275338",
                    "273.92064801170704",
                    "271.99643651153747",
                    "266.60397389608517",
                    "260.5104402039107",
                    "259.95238934554305",
                    "265.76387995069354",
                    "268.01380290028044",
                    "268.92866615475583",
                    "271.3868695228665",
                    "265.3024650868406",
                    "251.53351839497944",
                    "233.93664732546065",
                    "213.96317771012409",
                    "192.20406211114064",
                    "174.98372636042916",
                    "158.22627655258518",
                    "143.43355197371275",
                    "136.3114195715595",
                    "136.90324527711027",
                    "144.64411849598588",
                    "157.98285303109225",
                    "174.82142449288943",
                    "187.8777905025387",
                    "220.42930383589717",
                    "332.6382177675383",
                    "315.1409598494502",
                    "313.69615827193576",
                    "310.3951917531788",
                    "306.5748927516067",
                    "303.0649982771692",
                    "304.14815464356343",
                    "299.95762718861874",
                    "293.42980235760905",
                    "287.6208906501058",
                    "280.12873774101206",
                    "272.11774676931464",
                    "264.6050942956283",
                    "257.15240036301765",
                    "256.02257046513745",
                    "260.49094194325454",
                    "263.35582676198493",
                    "267.2501089762176",
                    "266.82292169414086",
                    "261.11222308701184",
                    "248.51924063725278",
                    "230.6184009467372",
                    "215.2701903013648",
                    "192.5197508166504",
                    "170.95632305674528",
                    "157.29943739717342",
                    "145.31292005301992",
                    "138.1191122595529",
                    "136.36863743026382",
                    "144.44735886122348",
                    "157.66387937155338",
                    "174.2035380769798",
                    "187.04182003906985",
                    "219.27940554360686",
                    "335.23148261255943",
                    "318.95412063712894",
                    "318.102201541211",
                    "317.02695453664046",
                    "314.77800785070997",
                    "313.02470208993395",
                    "308.66474805999906",
                    "303.9890380249832",
                    "296.46900011209146",
                    "291.0880997825945",
                    "283.59749721641356",
                    "273.31960634985364",
                    "264.82007144496293",
                    "256.3340297291796",
                    "253.4767485257203",
                    "254.95045215382947",
                    "258.25768902864706",
                    "261.88943244446966",
                    "260.61667543048713",
                    "254.454410926501",
                    "242.36585846017428",
                    "227.36519849630673",
                    "211.47389013903722",
                    "190.857927091437",
                    "165.36301018041814",
                    "150.7810092701164",
                    "144.3438087510288",
                    "138.4901282210333",
                    "136.83887309983456",
                    "145.09044751814506",
                    "158.1276907668684",
                    "174.35762474720715",
                    "186.951752571121",
                    "218.77807357649013",
                    "338.93859147647794",
                    "324.72446232238264",
                    "323.71873613097205",
                    "323.9142130359808",
                    "323.4491692979075",
                    "322.290899060616",
                    "314.4945800369632",
                    "313.37876979296595",
                    "304.8017625443029",
                    "294.0097620865666",
                    "284.22316701213697",
                    "274.2142822301352",
                    "265.7632866251417",
                    "257.70181194370645",
                    "251.4709200185006",
                    "248.95462864479225",
                    "253.35203930961555",
                    "255.1741818631165",
                    "254.11041559490712",
                    "246.61017218015814",
                    "237.00303605435914",
                    "222.2571717326766",
                    "205.5477670526594",
                    "185.19658953809866",
                    "164.00596461088375",
                    "149.5028749938405",
                    "141.93040459607658",
                    "138.3397998313917",
                    "139.6678854379909",
                    "146.82514023324794",
                    "159.5316117189098",
                    "175.38890305454987",
                    "187.67666364088808",
                    "218.93967668907146",
                    "342.9353248883213",
                    "331.19226914298383",
                    "330.3248143130418",
                    "330.75506284252185",
                    "332.0844750987303",
                    "328.3705873590471",
                    "320.66706596125084",
                    "317.1316365816014",
                    "309.538961550857",
                    "295.1794874968513",
                    "287.6417581211964",
                    "280.13685640801805",
                    "268.44240669278224",
                    "260.89215505838774",
                    "256.1820990752209",
                    "249.92481812282594",
                    "247.5583281904001",
                    "248.24896161499407",
                    "245.85460102981943",
                    "235.8092844807058",
                    "229.96954369756577",
                    "219.24335098840427",
                    "199.41062204679352",
                    "181.03178925608614",
                    "165.0734921497009",
                    "150.05637787357634",
                    "143.1695029690003",
                    "142.1741294622833",
                    "141.7562504905459",
                    "150.00003663937085",
                    "162.44382454313362",
                    "177.67157747211155",
                    "189.43354035324614",
                    "219.73478854132128",
                    "346.76031006404037",
                    "336.0399548017178",
                    "335.5449056763668",
                    "335.0783469393114",
                    "336.1863658528581",
                    "332.33016857846894",
                    "324.6631415792094",
                    "316.5289730223695",
                    "309.3581897453022",
                    "294.89859126616346",
                    "287.8113970230678",
                    "281.5862299549016",
                    "271.89276216389766",
                    "263.7626731275445",
                    "256.00002181968085",
                    "249.9607438938724",
                    "247.54287560437015",
                    "245.36047907844596",
                    "241.62198803031833",
                    "232.85816339859826",
                    "225.57573173126755",
                    "215.96630882543306",
                    "197.8497872985846",
                    "181.46796338312225",
                    "169.0543866028749",
                    "155.60454567397846",
                    "148.21528339622586",
                    "145.5859486825331",
                    "146.4786307194544",
                    "155.26654906815241",
                    "167.00600545180734",
                    "181.2920067935089",
                    "192.26164398445397",
                    "221.13218464521427",
                    "350.20151892581157",
                    "340.8477353294608",
                    "340.93546055564946",
                    "338.43964020038004",
                    "335.6277990145745",
                    "332.7938685798357",
                    "327.1351170967076",
                    "320.3570283306046",
                    "314.23672810691687",
                    "299.13214382350657",
                    "288.7073944247829",
                    "282.3783987030363",
                    "276.48757638181524",
                    "269.052422065156",
                    "259.73409174007503",
                    "254.02801944657608",
                    "250.6394632771059",
                    "244.46408484503254",
                    "238.17699352582747",
                    "231.3832734957137",
                    "221.77566075686084",
                    "215.0539340269202",
                    "202.370746279784",
                    "185.5438380151674",
                    "172.80593833976283",
                    "163.7547581277045",
                    "154.70581666771338",
                    "151.09869967829684",
                    "154.0579877284035",
                    "162.30421441978535",
                    "173.0813221720055",
                    "186.15816207790584",
                    "196.08894931567335",
                    "223.09167663822518",
                    "353.16534118641334",
                    "344.9890142064684",
                    "344.1605091553746",
                    "339.37048806406744",
                    "338.7127226080233",
                    "336.98738040393084",
                    "328.53962090373415",
                    "320.2978308284991",
                    "313.5657094290768",
                    "303.7608715998435",
                    "293.14312104095836",
                    "283.0579481986293",
                    "278.51459546048756",
                    "272.9475650146303",
                    "265.27241895908617",
                    "258.06274682598104",
                    "249.6780569393401",
                    "240.46182622458474",
                    "234.1726619633555",
                    "227.47361141120751",
                    "220.61871150660193",
                    "215.9119064544713",
                    "204.04251561599304",
                    "190.17579826605123",
                    "178.66404209773697",
                    "172.7809423650138",
                    "164.42337436156305",
                    "158.93573718633556",
                    "162.9350603731196",
                    "170.77147039752924",
                    "180.39487160524342",
                    "192.03905671253588",
                    "200.74385373593006",
                    "225.55754367766306",
                    "355.69418712923294",
                    "347.0893095138234",
                    "345.8814667800384",
                    "339.6548089217322",
                    "339.06635162308436",
                    "336.2380171849185",
                    "324.89788669850327",
                    "318.6545560620989",
                    "312.7661483120709",
                    "304.89607912557454",
                    "295.73490350717367",
                    "286.96881925791325",
                    "281.5658370799079",
                    "274.61266354455995",
                    "266.1220560422612",
                    "259.9978788759085",
                    "250.2121777082621",
                    "243.04894310078086",
                    "236.53303476216036",
                    "231.9345628879305",
                    "227.4097223596231",
                    "220.31288271452829",
                    "210.14126539054686",
                    "199.29314505936068",
                    "188.34456475539724",
                    "182.63565050471493",
                    "179.3440243664899",
                    "172.7989458450605",
                    "174.42929245043786",
                    "180.24398519203248",
                    "188.44266932600192",
                    "198.48626305739091",
                    "205.9043169458767",
                    "228.46222784499298",
                    "357.78579031324404",
                    "346.65985492621706",
                    "343.2946880701661",
                    "341.3655934619139",
                    "340.0443363800775",
                    "332.2686165762213",
                    "320.94042425871186",
                    "315.3597959702061",
                    "311.2551694846061",
                    "306.2025018868408",
                    "298.8873941850425",
                    "291.07391379104934",
                    "287.0620533270965",
                    "276.9551673947378",
                    "265.6729077524117",
                    "263.1824505253691",
                    "256.953888987858",
                    "250.59426831900362",
                    "245.45607572462285",
                    "237.16020225471476",
                    "232.98925449084086",
                    "225.35115765246837",
                    "218.55879541460263",
                    "207.84539129399568",
                    "196.92673412770324",
                    "190.69922201537418",
                    "188.85263459761174",
                    "185.24741493408624",
                    "186.1331556441477",
                    "190.13238120342444",
                    "196.787237747054",
                    "205.17059006274167",
                    "211.32952302453336",
                    "231.71418254611095",
                    "359.44600836467725",
                    "347.10263447542695",
                    "345.29729566310243",
                    "343.1622718194273",
                    "337.03412219662897",
                    "327.61877414677366",
                    "319.0025745803201",
                    "313.17135222344706",
                    "308.31188515807224",
                    "306.455083089386",
                    "302.5356244885869",
                    "295.8292151952945",
                    "291.2923510527841",
                    "281.51717163487695",
                    "269.10419353772664",
                    "265.5449901548181",
                    "262.14770124629496",
                    "257.7043032365323",
                    "252.91782047441743",
                    "247.95132009339503",
                    "243.27484093631557",
                    "236.04268616205727",
                    "224.31121441106612",
                    "215.87475431760538",
                    "207.29816144923515",
                    "198.4519839083223",
                    "194.85434619918027",
                    "193.6837225233743",
                    "196.4338064731942",
                    "199.65370894911763",
                    "204.93117022384186",
                    "211.79299500804737",
                    "216.8001366739762",
                    "235.18587931244068",
                    "360.69969091421433",
                    "347.308186172071",
                    "344.7053377705889",
                    "337.6076157253246",
                    "330.15752256337305",
                    "323.7317106027419",
                    "318.4368308839275",
                    "313.0977833911863",
                    "306.72217443132286",
                    "300.14157306923033",
                    "298.1262317957231",
                    "291.19445087763256",
                    "285.6446341315995",
                    "284.5116989613047",
                    "278.30883478141317",
                    "272.2578248313816",
                    "268.9615294265805",
                    "266.80596791287036",
                    "263.8311274424012",
                    "257.52151491638955",
                    "252.05977701834647",
                    "246.7021001527828",
                    "237.34741070189222",
                    "226.40618441570822",
                    "218.62884265414272",
                    "211.5313229127594",
                    "207.23699212248664",
                    "207.04454739668802",
                    "206.20554315811725",
                    "208.49062676770933",
                    "212.62830193869954",
                    "218.1771651418718",
                    "222.1766297676919",
                    "238.78908754337593",
                    "361.64926451927266",
                    "347.75808605641475",
                    "343.83664464551345",
                    "336.450427611368",
                    "330.4092881779977",
                    "326.77551909277776",
                    "317.3023315961222",
                    "307.94054254733027",
                    "301.3112000286185",
                    "295.4451927702177",
                    "294.1961280038609",
                    "291.198717324441",
                    "287.17395479411556",
                    "287.9593125780242",
                    "284.4890250022703",
                    "276.9631414015477",
                    "276.3588799328678",
                    "272.00757677991504",
                    "269.021231312163",
                    "265.20009751309897",
                    "261.0307307869228",
                    "256.40570120468954",
                    "251.2787761734925",
                    "239.1945588214004",
                    "230.3514097002957",
                    "222.08837496414438",
                    "219.07956446733667",
                    "216.65037940724076",
                    "215.24555148826394",
                    "216.91500611141288",
                    "220.02289627044271",
                    "224.4130772174371",
                    "227.53197376170073",
                    "242.57607056506328",
                    "362.65835632793784",
                    "351.3141331671815",
                    "347.1836065184676",
                    "339.41421676463983",
                    "331.42240861637765",
                    "323.95825939689104",
                    "317.7232922446654",
                    "308.3961169797909",
                    "300.97784103506035",
                    "295.11894976614235",
                    "291.3738172188519",
                    "291.5369370823008",
                    "291.1725683922608",
                    "289.46394101040244",
                    "287.35500271914424",
                    "281.37337040214686",
                    "281.8569343243541",
                    "275.25642158852236",
                    "270.4457560367746",
                    "269.96249278174054",
                    "264.54513698754295",
                    "257.29196034575006",
                    "253.3631883276376",
                    "245.95003520910393",
                    "238.11238822660954",
                    "231.67044719149783",
                    "228.6153953243655",
                    "224.9587014780344",
                    "223.5323556574065",
                    "224.52270470308608",
                    "226.71667158557815",
                    "230.11971945401925",
                    "232.49942907923017",
                    "246.217351241248",
                    "362.9388511375365",
                    "351.5128297256764",
                    "349.66450720294034",
                    "342.50910282352214",
                    "332.08943226684727",
                    "324.8526574823578",
                    "319.5281398171725",
                    "310.7567476051302",
                    "302.8566925151762",
                    "296.33117375948336",
                    "290.4243305175619",
                    "290.68028637852126",
                    "290.9926682811091",
                    "290.79980711561467",
                    "292.58817205745277",
                    "285.95650030359207",
                    "283.17713979559346",
                    "279.32981937882033",
                    "274.6623066868781",
                    "271.44830349539234",
                    "266.82823539998327",
                    "262.19517916111636",
                    "257.49000364815583",
                    "250.795655865449",
                    "244.01670790760178",
                    "238.60537262576875",
                    "234.28186792684937",
                    "231.69626774366748",
                    "230.7757313615746",
                    "231.21238372055515",
                    "232.67282307648864",
                    "235.27576467921585",
                    "237.05392301735753",
                    "249.67138258669007",
                    "362.65307624225073",
                    "350.2124968904047",
                    "347.59507610328524",
                    "341.1108899677573",
                    "334.2223828497661",
                    "326.4492673813734",
                    "318.23123824485515",
                    "309.8471083358216",
                    "302.1124591405119",
                    "296.6510437063646",
                    "293.27131300319957",
                    "292.01522939491315",
                    "291.5373361357364",
                    "290.23207303937073",
                    "289.07768548946353",
                    "285.5336315685959",
                    "282.137222881234",
                    "278.94303550029025",
                    "275.97067453139925",
                    "272.76392195545617",
                    "268.9542577299965",
                    "264.2278288081784",
                    "258.5326764808018",
                    "252.37216476884504",
                    "246.59677347310986",
                    "241.80708569671484",
                    "238.23092046526227",
                    "235.88211689565549",
                    "234.76806851881886",
                    "234.8646361214987",
                    "235.87836355466155",
                    "237.98882236108832",
                    "239.39335286997087",
                    "251.35935754327042",
                    "362.2962192116288",
                    "349.3640344258009",
                    "346.01249581420785",
                    "340.73987251000193",
                    "335.3791532162943",
                    "328.96097839286136",
                    "321.93510942584794",
                    "314.97252625553375",
                    "308.669212920541",
                    "303.91668363511445",
                    "300.80186730123074",
                    "298.71981184880156",
                    "297.1551426583149",
                    "295.31583101752653",
                    "292.95183260086856",
                    "290.2874861382837",
                    "287.4088445167523",
                    "284.3752077725106",
                    "281.1962627040185",
                    "277.8202664700321",
                    "274.22297173019825",
                    "270.347040437093",
                    "266.30154923030017",
                    "262.3661823984711",
                    "258.7734638357227",
                    "255.8010550736447",
                    "253.54818244382082",
                    "251.92494547453535",
                    "250.9336664920943",
                    "250.69709645490033",
                    "251.07943168489817",
                    "252.36530119126206",
                    "253.12805862540165",
                    "263.40204264037044",
                    "40.78409505994377",
                    "55.64044148341673",
                    "59.12163602688054",
                    "64.49190288980711",
                    "69.56262100872526",
                    "74.66593304992192",
                    "79.39464248880007",
                    "83.55501409331552",
                    "86.86787204626874",
                    "88.8737461577972",
                    "89.73845357971378",
                    "90.26310965579135",
                    "91.04535615921326",
                    "92.83772733671465",
                    "95.67343322177996",
                    "98.84203365991378",
                    "101.8822863587347",
                    "104.2679497621648",
                    "105.91692456019965",
                    "107.21390766404406",
                    "108.37770128521899",
                    "109.6414034829343",
                    "111.02797119778506",
                    "112.33839043990986",
                    "113.46060323511716",
                    "114.30187955218449",
                    "114.88407567682422",
                    "115.4356296461799",
                    "116.08362641002032",
                    "116.76405373378769",
                    "117.45473293754947",
                    "117.76902686975791",
                    "118.16596009560062",
                    "113.42781038826207",
                    "37.562429670518156",
                    "51.3234302376081",
                    "55.138965884880285",
                    "60.92701126587394",
                    "66.71502174709276",
                    "73.15609913884134",
                    "79.76144514728351",
                    "85.65591296692314",
                    "90.24850599371678",
                    "92.79657147223415",
                    "93.61725998413577",
                    "93.95924777998614",
                    "94.7273095161669",
                    "96.52858034200312",
                    "99.43014793908812",
                    "102.83681691721003",
                    "106.1486290049596",
                    "107.90624629550112",
                    "108.39781189855724",
                    "108.85075427205668",
                    "109.10706483310543",
                    "109.80825043190053",
                    "111.11061238090102",
                    "113.04888538922829",
                    "112.81504179637608",
                    "113.23430238896643",
                    "113.28676107557862",
                    "113.09333038967777",
                    "114.14143226587142",
                    "115.3506926904547",
                    "116.94973291094627",
                    "118.34074474819704",
                    "119.59318296747956",
                    "116.07188796751066",
                    "34.91709083175705",
                    "47.52854926450234",
                    "51.262921380255825",
                    "56.719147312361144",
                    "62.609381984804024",
                    "69.8466369710507",
                    "77.98302948413506",
                    "84.42732620037062",
                    "89.62154989226144",
                    "91.16360901351588",
                    "91.3538927059894",
                    "92.9332205009229",
                    "94.72220006620468",
                    "96.41451592228779",
                    "99.67759129654624",
                    "102.91572589103642",
                    "108.1923229407107",
                    "111.1761256400042",
                    "110.53855997020489",
                    "110.66204059571386",
                    "109.75172204842305",
                    "109.44190008676716",
                    "110.36401648884356",
                    "112.39666369777194",
                    "110.4195109662743",
                    "112.02000163716119",
                    "113.37543779897473",
                    "111.44138402571313",
                    "112.07578110869088",
                    "113.1763033961007",
                    "115.02880951375097",
                    "116.79791092413923",
                    "118.37117875302029",
                    "115.40605688033862",
                    "31.30289370782706",
                    "42.03587120063301",
                    "44.50077994187367",
                    "48.37226083312055",
                    "55.873060018185065",
                    "66.8018546904913",
                    "74.86354072881501",
                    "80.72033287493596",
                    "89.82569309767875",
                    "92.25511785423316",
                    "90.06446336388032",
                    "94.89041557841483",
                    "97.67433742842684",
                    "99.37070102479883",
                    "103.79413513560264",
                    "106.37358944533096",
                    "109.83980184172565",
                    "114.08649827453614",
                    "112.84885868540488",
                    "109.5118408150616",
                    "106.50416837502401",
                    "109.16345157005756",
                    "110.29079231715292",
                    "107.94035891669327",
                    "109.5351945458306",
                    "111.87016095420996",
                    "113.26680383931807",
                    "111.5275819415621",
                    "110.467240469935",
                    "111.21305122865523",
                    "113.25507651185215",
                    "115.38415957488434",
                    "117.28958443038984",
                    "114.91806407692489",
                    "27.445549747932212",
                    "35.86995189088632",
                    "35.221834830356016",
                    "38.378418287517434",
                    "48.0776677902057",
                    "56.505967729912236",
                    "67.35476226927632",
                    "73.77849556534922",
                    "85.16543722179588",
                    "96.70246415390373",
                    "95.66398901354643",
                    "99.08814462730906",
                    "104.2646790774392",
                    "106.39358319679587",
                    "104.74800098639764",
                    "105.42332347740064",
                    "108.95754023466857",
                    "111.17480673486578",
                    "108.43497444808926",
                    "106.48800803918634",
                    "103.94359743185721",
                    "108.09964226097183",
                    "109.9192236405246",
                    "108.2691290029947",
                    "113.25376247271782",
                    "112.8720246388863",
                    "111.59520067543036",
                    "110.10788748435486",
                    "108.32794733817417",
                    "109.98130464362217",
                    "112.03679140788861",
                    "114.30245974759636",
                    "116.37879818591516",
                    "114.37664585520655",
                    "23.399518303861964",
                    "29.792865934590477",
                    "31.03400616890889",
                    "34.01257852157038",
                    "41.60491888475505",
                    "50.23211819891462",
                    "60.029198300495345",
                    "70.88038862861184",
                    "81.07427632744603",
                    "92.42051258405787",
                    "97.38862767981121",
                    "101.87656603521333",
                    "106.37879760357366",
                    "105.88466649251072",
                    "107.15118900479024",
                    "105.90237373058166",
                    "108.22734465478834",
                    "111.36328245937332",
                    "109.92933331254551",
                    "106.65369936837466",
                    "108.10160916058427",
                    "110.98361431545108",
                    "111.5474094948179",
                    "110.54674149188347",
                    "114.0549753459099",
                    "111.02918539600881",
                    "109.79249134451514",
                    "107.7192737552683",
                    "106.59569529428208",
                    "109.17377036484488",
                    "111.19650190065842",
                    "113.45966427977874",
                    "115.57314439995939",
                    "113.74177884398026",
                    "19.47217503164552",
                    "24.003786000689633",
                    "27.431440962987168",
                    "30.03429121490335",
                    "33.83670020552386",
                    "42.5766685761927",
                    "55.87402193474221",
                    "66.90266613107988",
                    "73.89211645839666",
                    "87.22080901911721",
                    "100.08747782822914",
                    "106.77827561295229",
                    "108.7503001190677",
                    "108.4640177355942",
                    "113.0855825952221",
                    "113.115437330604",
                    "113.82106367570248",
                    "114.60587709634675",
                    "111.54517273591003",
                    "108.18349661103856",
                    "115.91923540086981",
                    "116.08508492809597",
                    "113.66791237388816",
                    "113.46705182199116",
                    "115.70010776141297",
                    "114.54379906041893",
                    "110.05388890511529",
                    "108.25898570716956",
                    "107.90886711519002",
                    "108.62611016165606",
                    "110.44730601319368",
                    "112.62793520223107",
                    "114.69138023726482",
                    "112.90615850508715",
                    "16.07721860724766",
                    "18.720853195717183",
                    "20.2130087750242",
                    "22.702905231126653",
                    "29.84255992536889",
                    "38.98499446991596",
                    "52.14186096075404",
                    "67.25498483311672",
                    "75.36577868374867",
                    "86.96437025107286",
                    "100.63664924687308",
                    "107.84136116390702",
                    "114.66310633668552",
                    "117.60032694092993",
                    "117.15374396633395",
                    "115.01486449568924",
                    "114.49628453974945",
                    "116.18320896067324",
                    "114.66650239133315",
                    "114.53792806163642",
                    "118.63889417908075",
                    "113.72778308445655",
                    "111.89334856123315",
                    "114.65817264905306",
                    "117.25782243251697",
                    "114.66020082658831",
                    "108.11685334697104",
                    "106.69139140361219",
                    "105.93261564709948",
                    "107.32538212471023",
                    "109.13708092636706",
                    "111.30595353665875",
                    "113.39189363576618",
                    "111.79217692579067",
                    "13.349111366197182",
                    "15.20233275304212",
                    "15.272351980011244",
                    "17.291100388558",
                    "26.27497559195861",
                    "36.56689091158289",
                    "50.091012710512935",
                    "64.24738942819558",
                    "72.14128443933994",
                    "83.31547701512937",
                    "98.56437832513515",
                    "108.23228386496373",
                    "112.68853704023508",
                    "117.03600109698218",
                    "119.08846626503481",
                    "115.08972868189002",
                    "112.72894691207284",
                    "114.97065780783542",
                    "115.98948961153553",
                    "114.85594291808046",
                    "118.37211350854984",
                    "115.70806396130736",
                    "113.48726995582298",
                    "113.0198232836689",
                    "114.48639514836688",
                    "110.87651045547211",
                    "110.91896609791036",
                    "109.41179370372701",
                    "106.01741080865658",
                    "105.37045543749836",
                    "107.01660196266302",
                    "109.31038946546786",
                    "111.54955068721891",
                    "110.36392998308851",
                    "11.174812961076594",
                    "12.882544711236244",
                    "14.040904486766204",
                    "16.937029141337845",
                    "21.45600877630881",
                    "31.645683366664727",
                    "46.063552718737824",
                    "57.6813015114083",
                    "68.33449612165073",
                    "81.5358616616035",
                    "95.07277457504652",
                    "102.6306981854329",
                    "107.449674441334",
                    "112.11512254922842",
                    "116.03005622927753",
                    "115.01250178318766",
                    "114.324724816112",
                    "115.73617146161092",
                    "113.65262277340686",
                    "114.06788267454226",
                    "117.74390995380654",
                    "115.86285899198943",
                    "116.82349752578972",
                    "115.11571265515607",
                    "111.88034512044189",
                    "109.21177018459356",
                    "109.47745695172252",
                    "105.73382743955199",
                    "102.81618629794305",
                    "102.34950130036134",
                    "104.07289983014284",
                    "106.64751631528767",
                    "109.17192916674594",
                    "108.61979850207726",
                    "9.412048283711773",
                    "12.093749954509567",
                    "15.490163262518628",
                    "15.669234291820713",
                    "19.19406432377831",
                    "31.771819793780626",
                    "41.621201252131804",
                    "53.08035100670346",
                    "62.192278630045664",
                    "75.6442894419023",
                    "89.34119349635537",
                    "95.99430739430927",
                    "104.33111746050297",
                    "110.55778461648526",
                    "115.80874699411929",
                    "113.76483333164181",
                    "112.84934166350968",
                    "112.9420742438095",
                    "111.0758011852561",
                    "112.61833482007468",
                    "115.76151695915723",
                    "113.38481598539171",
                    "116.24935488203654",
                    "116.95350297034454",
                    "112.31961921188181",
                    "109.68535205651519",
                    "102.80295297553738",
                    "99.73031026296128",
                    "98.48087080582063",
                    "98.51747458761977",
                    "100.5504589857132",
                    "103.53443569692566",
                    "106.42555369696427",
                    "106.62317421210496",
                    "7.7853580258660315",
                    "12.124020100049476",
                    "15.393058672723937",
                    "17.007359965839164",
                    "23.48378398222911",
                    "33.396302184156404",
                    "41.72667374060113",
                    "51.349911200956306",
                    "59.2925305722736",
                    "70.34034690524946",
                    "80.61081301918006",
                    "89.88894702907041",
                    "97.60949586112758",
                    "104.70308826084434",
                    "109.07414063523129",
                    "108.69537528028437",
                    "106.17517117986569",
                    "109.280678769615",
                    "112.2657172310045",
                    "108.9840497620102",
                    "110.5298771109884",
                    "108.50320570825399",
                    "108.28184440440991",
                    "110.34578062942116",
                    "108.00765141063967",
                    "105.63369418574338",
                    "99.87693217186067",
                    "96.02911355739377",
                    "95.16056269326991",
                    "94.67569670852531",
                    "97.08342402929031",
                    "100.52518586621667",
                    "103.73226710579722",
                    "104.53665774213502",
                    "6.107988320777217",
                    "11.267586309479961",
                    "12.417198384297366",
                    "16.528572630845",
                    "24.71546892533934",
                    "32.11594318842096",
                    "42.25966729088185",
                    "48.18811475861578",
                    "58.068508395154595",
                    "66.53001046626133",
                    "76.64156796779726",
                    "85.96741505354335",
                    "92.38994714250678",
                    "95.15483099018425",
                    "96.58364053311499",
                    "98.79410784755652",
                    "98.05958055555088",
                    "103.51338259406181",
                    "104.13175129069685",
                    "103.48039868651152",
                    "104.40349970436263",
                    "102.7046270091542",
                    "99.7329486077021",
                    "101.98752822409546",
                    "101.69456147827108",
                    "101.55364007137786",
                    "97.59534388812003",
                    "92.58706271627923",
                    "90.53311641694242",
                    "91.0524640350529",
                    "94.04322819296735",
                    "97.8870587688993",
                    "101.28326844545182",
                    "102.42979808356574",
                    "4.209860697403578",
                    "10.755906124805305",
                    "14.247794599948723",
                    "19.58229275368605",
                    "29.078795849408056",
                    "31.881123563174572",
                    "39.12506239722409",
                    "48.33766300919947",
                    "57.11121162742156",
                    "62.901215181969604",
                    "69.82128215144539",
                    "76.5016182941044",
                    "85.43572776853308",
                    "88.99696950417977",
                    "90.15491925252812",
                    "92.35114188975915",
                    "90.38855155969411",
                    "95.85666814642457",
                    "96.49811228479204",
                    "98.36126109800105",
                    "100.00274235286454",
                    "97.14185594343533",
                    "93.82082239464715",
                    "94.59272462866906",
                    "93.77392325104671",
                    "94.99244256183509",
                    "89.70997546363037",
                    "85.13476709507344",
                    "87.09179014112112",
                    "88.28699953837676",
                    "91.71386933904203",
                    "95.7300644169776",
                    "99.13573353076345",
                    "100.31991657454236",
                    "2.2348713801433147",
                    "9.128143162740393",
                    "12.564195379982106",
                    "16.075210034111986",
                    "25.475017731915518",
                    "30.874567111702248",
                    "36.20674927772434",
                    "46.4007112105667",
                    "55.45791927899421",
                    "61.885417960787954",
                    "64.86375119533862",
                    "67.19394067025405",
                    "75.76907548917492",
                    "81.87404990649867",
                    "81.1818520505565",
                    "80.98305106464036",
                    "80.83297827166932",
                    "83.93661422047697",
                    "85.6095444708237",
                    "89.23965042215868",
                    "89.84359267516689",
                    "89.44234040578247",
                    "86.29713184597817",
                    "84.14653512763354",
                    "85.85354219045774",
                    "86.37135770818291",
                    "84.38428290705407",
                    "82.02441176812843",
                    "84.64092261778138",
                    "86.5350294786016",
                    "90.11150979233378",
                    "94.01506922679053",
                    "97.23877392379195",
                    "98.16902276428065",
                    "0.7622497246229948",
                    "10.145351794935838",
                    "14.648348868798864",
                    "16.955065919682887",
                    "26.17241878787025",
                    "30.872516567958005",
                    "34.94419297683579",
                    "40.85312209750345",
                    "48.595339705948994",
                    "56.92946264953949",
                    "61.310752069374615",
                    "64.32916862701296",
                    "68.6515021857355",
                    "70.59422485051316",
                    "69.89225924211136",
                    "69.28052662587197",
                    "69.27000966040119",
                    "72.32225312035199",
                    "73.3872488711495",
                    "77.0475875506685",
                    "78.17171791537592",
                    "80.58168362392253",
                    "83.17061809222709",
                    "79.52001606986326",
                    "81.43654693996238",
                    "82.15609731670513",
                    "80.67629975365531",
                    "80.17878167020622",
                    "82.54058382456478",
                    "85.48101958763442",
                    "88.93611556311927",
                    "92.48182091824273",
                    "95.3663779380643",
                    "95.84427495702981",
                    "-0.2631493834957937",
                    "8.837498509948958",
                    "15.179067212200483",
                    "17.701081199051877",
                    "23.449286559556878",
                    "26.48414802981159",
                    "32.363666166618806",
                    "39.30331057269841",
                    "43.578180215254775",
                    "49.43582307495616",
                    "55.19511485294549",
                    "56.093634755754216",
                    "56.91173027981305",
                    "56.49787245605454",
                    "57.043061993307134",
                    "58.386351795791775",
                    "58.60804490632406",
                    "61.16361890436565",
                    "63.69519018745116",
                    "66.75231368388025",
                    "70.72585990962664",
                    "71.69401617737682",
                    "74.47488890536704",
                    "74.82112242241006",
                    "74.90638876631544",
                    "76.99987876110502",
                    "76.71783569484211",
                    "78.59930904127312",
                    "82.01803031862157",
                    "84.90680311608368",
                    "87.98795287720989",
                    "90.989138848023",
                    "93.41506208124913",
                    "93.31095097611677",
                    "-0.9014013038925366",
                    "5.606105927998476",
                    "8.968307109215885",
                    "13.172920515083264",
                    "19.21625390811881",
                    "22.35232374693543",
                    "27.982862268646443",
                    "36.40212560860543",
                    "37.92931202635785",
                    "42.79475879924985",
                    "48.24593827372131",
                    "48.01346777329906",
                    "45.74198949744935",
                    "46.560114408566825",
                    "48.73248035488485",
                    "49.05237024408965",
                    "48.654509817233034",
                    "51.7969168176192",
                    "56.556483720250384",
                    "63.27332677275956",
                    "68.03203540678429",
                    "69.54341268395851",
                    "71.6354047274178",
                    "73.39624054236164",
                    "74.26930780298771",
                    "75.38503058855264",
                    "75.73730735015744",
                    "77.68405724480323",
                    "81.62299577437649",
                    "84.45519189504813",
                    "87.08301987351993",
                    "89.46550705020135",
                    "91.36516457255485",
                    "90.6091902710927",
                    "-1.193401225675339",
                    "4.7194307015090295",
                    "6.1582742141684195",
                    "13.598608471698652",
                    "19.409347886057496",
                    "18.871912988672676",
                    "26.061417403091887",
                    "32.754532091322986",
                    "34.390238139812894",
                    "38.59924613282907",
                    "41.02370487062378",
                    "42.35705299257019",
                    "42.61539520902655",
                    "44.97692980942836",
                    "46.58528155482053",
                    "44.55118126350949",
                    "42.59703229528825",
                    "47.77357381243934",
                    "52.99307516954724",
                    "59.23029234222547",
                    "64.33682657367562",
                    "69.39733788815438",
                    "73.37461298733876",
                    "71.60746458245222",
                    "72.10343470209128",
                    "75.02123121715442",
                    "77.22735650844814",
                    "77.93981572296265",
                    "81.36462163681443",
                    "83.87277556973892",
                    "86.0305841681746",
                    "87.79454812243851",
                    "89.15879281874818",
                    "87.76561342536628",
                    "-1.6902526676185854",
                    "5.591331728219388",
                    "10.150837965365374",
                    "12.469566204363113",
                    "15.822979113625832",
                    "22.51595223807594",
                    "24.39162715144879",
                    "27.90391104396376",
                    "31.12022623209653",
                    "34.11064394772934",
                    "35.817693441783696",
                    "37.79270393325347",
                    "37.15612317056881",
                    "38.54747379135644",
                    "37.768851062299326",
                    "40.81166853536552",
                    "42.507962204504054",
                    "44.18716037248709",
                    "48.229227677819516",
                    "61.05104628768841",
                    "67.11225289211804",
                    "71.74661551548482",
                    "76.93837384095485",
                    "75.29418876923302",
                    "76.1214469634111",
                    "78.04137700660067",
                    "76.04785876914313",
                    "76.53002452994095",
                    "80.65463787452498",
                    "82.84099073984775",
                    "84.50128331775508",
                    "85.69995576772625",
                    "86.59890544264923",
                    "84.7153077170198",
                    "-2.1268579731609343",
                    "6.825498931560021",
                    "9.508100710092696",
                    "12.176389928366563",
                    "15.191788664164319",
                    "20.20305376087",
                    "22.846867304807816",
                    "24.65397818504794",
                    "26.031854307257742",
                    "29.346523848806903",
                    "31.585515769347335",
                    "31.002382436249622",
                    "30.982463054982784",
                    "35.76502640637854",
                    "36.789337966355596",
                    "37.5379441415702",
                    "39.4941526622382",
                    "43.872080890447435",
                    "48.8595274140996",
                    "58.59935971509011",
                    "63.64430016332763",
                    "67.61334494180835",
                    "73.22535286617702",
                    "76.58347244177472",
                    "76.48125630189155",
                    "77.47399502264918",
                    "78.40413040921696",
                    "77.99392963243871",
                    "79.82040770028325",
                    "81.46236343546163",
                    "82.63825007776701",
                    "83.37064180564067",
                    "83.91575495185106",
                    "81.72946971582576",
                    "-2.9589342896335533",
                    "7.4923628177534125",
                    "7.366464424577311",
                    "10.78169916104005",
                    "15.54066003742132",
                    "15.098731075517636",
                    "19.43051950620253",
                    "24.091379773703796",
                    "24.419276241578025",
                    "25.331412700394946",
                    "29.419750911347688",
                    "29.235891714201607",
                    "30.98273056329845",
                    "35.3162065558623",
                    "36.49516664723568",
                    "33.70945067795281",
                    "35.27591783750032",
                    "41.45570843493861",
                    "48.60210313581975",
                    "56.001626063627306",
                    "62.64280621603272",
                    "66.03154413141455",
                    "69.52972637180316",
                    "74.12764374957487",
                    "74.6683778166432",
                    "74.98709821478782",
                    "76.32106154640506",
                    "77.17532032821889",
                    "78.4839357010033",
                    "79.60894514354051",
                    "80.39425135053283",
                    "80.80551787574791",
                    "81.12567127725566",
                    "78.83613928984283",
                    "-3.3003009984381135",
                    "7.3206885748945725",
                    "8.250232198168264",
                    "11.059214660216199",
                    "14.04434844291037",
                    "15.257978985059456",
                    "18.39590417316893",
                    "22.613820797725825",
                    "24.47861652409641",
                    "25.892059032646696",
                    "28.6928872635443",
                    "30.349343849958515",
                    "31.80474704656206",
                    "33.327848183389946",
                    "34.40961718379498",
                    "35.49372363141536",
                    "38.260613516369716",
                    "43.240009930357026",
                    "49.64328685158372",
                    "56.272283339440534",
                    "62.2581550218691",
                    "66.8431540820915",
                    "70.18477281405967",
                    "72.73739042463214",
                    "74.38088161445047",
                    "75.4964082123291",
                    "76.29474399991388",
                    "77.10764429949825",
                    "78.00639842085587",
                    "78.74713894675355",
                    "79.28306939263481",
                    "79.52030023440179",
                    "79.73305825225668",
                    "77.41780471326928",
                    "-11.806863266530803",
                    "-1.1515412043384559",
                    "0.17260435553505427",
                    "2.548292912542326",
                    "4.650562390699587",
                    "7.01885392120895",
                    "9.634390835319738",
                    "12.432234263269843",
                    "15.196020054061108",
                    "17.746700496649247",
                    "20.095816311630003",
                    "22.324649608799586",
                    "24.511228685961726",
                    "26.719490874398343",
                    "29.07175044218383",
                    "31.816095014636705",
                    "35.122154867406344",
                    "39.207937193524764",
                    "43.91303342564869",
                    "48.66202900673857",
                    "53.06534336817004",
                    "56.732288798033046",
                    "59.56233780727515",
                    "61.77031599542492",
                    "63.469056914464296",
                    "64.75290314946922",
                    "65.71769772598769",
                    "66.46432346218911",
                    "67.06692018724564",
                    "67.58152320908655",
                    "68.03046725686066",
                    "68.28893625083548",
                    "68.51860056059424",
                    "66.92700036052011",
                ],
                "UseCyclicTransform": ["false"],
                "UseDirectionCosines": ["true"],
            },
        ],
    }


@pytest.fixture
def simple_transform_affine_large_output():
    return {
        "initial": [],
        "0": [
            {
                "CenterOfRotationPoint": ["7010", "9005.5"],
                "CompressResultImage": ["true"],
                "DefaultPixelValue": ["0"],
                "Direction": ["1", "0", "0", "1"],
                "FixedImageDimension": ["2"],
                "FixedInternalImagePixelType": ["float"],
                "HowToCombineTransforms": ["Compose"],
                "Index": ["0", "0"],
                "InitialTransformParametersFileName": ["NoInitialTransform"],
                "MovingImageDimension": ["2"],
                "MovingInternalImagePixelType": ["float"],
                "NumberOfParameters": ["6"],
                "Origin": ["0", "0"],
                "ResampleInterpolator": ["FinalNearestNeighborInterpolator"],
                "Resampler": ["DefaultResampler"],
                "ResultImageFormat": ["mha"],
                "ResultImagePixelType": ["float"],
                "Size": ["14021", "18012"],
                "Spacing": ["1", "1"],
                "Transform": ["AffineTransform"],
                "TransformParameters": [
                    "0.9737116526894503",
                    "-0.02360806278113504",
                    "0.0040156561848048705",
                    "1.019349427711173",
                    "-260.6092127223852",
                    "-2498.1235259464324",
                ],
                "UseDirectionCosines": ["true"],
            }
        ],
    }


@pytest.fixture
def simple_transform_affine_nl_large_output():
    return pickle.load(open("./fixtures/large_nl_tform.pkl", "rb"))
