# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetEnvironmentResult',
    'AwaitableGetEnvironmentResult',
    'get_environment',
    'get_environment_output',
]

@pulumi.output_type
class GetEnvironmentResult:
    def __init__(__self__, activation_code=None, arn=None, created_at=None, desired_software_set_id=None, desktop_endpoint=None, desktop_type=None, id=None, maintenance_window=None, name=None, pending_software_set_id=None, pending_software_set_version=None, registered_devices_count=None, software_set_compliance_status=None, software_set_update_mode=None, software_set_update_schedule=None, tags=None, updated_at=None):
        if activation_code and not isinstance(activation_code, str):
            raise TypeError("Expected argument 'activation_code' to be a str")
        pulumi.set(__self__, "activation_code", activation_code)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if desired_software_set_id and not isinstance(desired_software_set_id, str):
            raise TypeError("Expected argument 'desired_software_set_id' to be a str")
        pulumi.set(__self__, "desired_software_set_id", desired_software_set_id)
        if desktop_endpoint and not isinstance(desktop_endpoint, str):
            raise TypeError("Expected argument 'desktop_endpoint' to be a str")
        pulumi.set(__self__, "desktop_endpoint", desktop_endpoint)
        if desktop_type and not isinstance(desktop_type, str):
            raise TypeError("Expected argument 'desktop_type' to be a str")
        pulumi.set(__self__, "desktop_type", desktop_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if maintenance_window and not isinstance(maintenance_window, dict):
            raise TypeError("Expected argument 'maintenance_window' to be a dict")
        pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pending_software_set_id and not isinstance(pending_software_set_id, str):
            raise TypeError("Expected argument 'pending_software_set_id' to be a str")
        pulumi.set(__self__, "pending_software_set_id", pending_software_set_id)
        if pending_software_set_version and not isinstance(pending_software_set_version, str):
            raise TypeError("Expected argument 'pending_software_set_version' to be a str")
        pulumi.set(__self__, "pending_software_set_version", pending_software_set_version)
        if registered_devices_count and not isinstance(registered_devices_count, int):
            raise TypeError("Expected argument 'registered_devices_count' to be a int")
        pulumi.set(__self__, "registered_devices_count", registered_devices_count)
        if software_set_compliance_status and not isinstance(software_set_compliance_status, str):
            raise TypeError("Expected argument 'software_set_compliance_status' to be a str")
        pulumi.set(__self__, "software_set_compliance_status", software_set_compliance_status)
        if software_set_update_mode and not isinstance(software_set_update_mode, str):
            raise TypeError("Expected argument 'software_set_update_mode' to be a str")
        pulumi.set(__self__, "software_set_update_mode", software_set_update_mode)
        if software_set_update_schedule and not isinstance(software_set_update_schedule, str):
            raise TypeError("Expected argument 'software_set_update_schedule' to be a str")
        pulumi.set(__self__, "software_set_update_schedule", software_set_update_schedule)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="activationCode")
    def activation_code(self) -> Optional[str]:
        """
        Activation code for devices associated with environment.
        """
        return pulumi.get(self, "activation_code")

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The environment ARN.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp in unix epoch format when environment was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="desiredSoftwareSetId")
    def desired_software_set_id(self) -> Optional[str]:
        """
        The ID of the software set to apply.
        """
        return pulumi.get(self, "desired_software_set_id")

    @property
    @pulumi.getter(name="desktopEndpoint")
    def desktop_endpoint(self) -> Optional[str]:
        """
        The URL for the identity provider login (only for environments that use AppStream 2.0).
        """
        return pulumi.get(self, "desktop_endpoint")

    @property
    @pulumi.getter(name="desktopType")
    def desktop_type(self) -> Optional['EnvironmentDesktopType']:
        """
        The type of VDI.
        """
        return pulumi.get(self, "desktop_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier of the environment.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional['outputs.EnvironmentMaintenanceWindow']:
        """
        A specification for a time window to apply software updates.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the environment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pendingSoftwareSetId")
    def pending_software_set_id(self) -> Optional[str]:
        """
        The ID of the software set that is pending to be installed.
        """
        return pulumi.get(self, "pending_software_set_id")

    @property
    @pulumi.getter(name="pendingSoftwareSetVersion")
    def pending_software_set_version(self) -> Optional[str]:
        """
        The version of the software set that is pending to be installed.
        """
        return pulumi.get(self, "pending_software_set_version")

    @property
    @pulumi.getter(name="registeredDevicesCount")
    def registered_devices_count(self) -> Optional[int]:
        """
        Number of devices registered to the environment.
        """
        return pulumi.get(self, "registered_devices_count")

    @property
    @pulumi.getter(name="softwareSetComplianceStatus")
    def software_set_compliance_status(self) -> Optional['EnvironmentSoftwareSetComplianceStatus']:
        """
        Describes if the software currently installed on all devices in the environment is a supported version.
        """
        return pulumi.get(self, "software_set_compliance_status")

    @property
    @pulumi.getter(name="softwareSetUpdateMode")
    def software_set_update_mode(self) -> Optional['EnvironmentSoftwareSetUpdateMode']:
        """
        An option to define which software updates to apply.
        """
        return pulumi.get(self, "software_set_update_mode")

    @property
    @pulumi.getter(name="softwareSetUpdateSchedule")
    def software_set_update_schedule(self) -> Optional['EnvironmentSoftwareSetUpdateSchedule']:
        """
        An option to define if software updates should be applied within a maintenance window.
        """
        return pulumi.get(self, "software_set_update_schedule")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[str]:
        """
        The timestamp in unix epoch format when environment was last updated.
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetEnvironmentResult(GetEnvironmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnvironmentResult(
            activation_code=self.activation_code,
            arn=self.arn,
            created_at=self.created_at,
            desired_software_set_id=self.desired_software_set_id,
            desktop_endpoint=self.desktop_endpoint,
            desktop_type=self.desktop_type,
            id=self.id,
            maintenance_window=self.maintenance_window,
            name=self.name,
            pending_software_set_id=self.pending_software_set_id,
            pending_software_set_version=self.pending_software_set_version,
            registered_devices_count=self.registered_devices_count,
            software_set_compliance_status=self.software_set_compliance_status,
            software_set_update_mode=self.software_set_update_mode,
            software_set_update_schedule=self.software_set_update_schedule,
            tags=self.tags,
            updated_at=self.updated_at)


def get_environment(id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnvironmentResult:
    """
    Resource type definition for AWS::WorkSpacesThinClient::Environment.


    :param str id: Unique identifier of the environment.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:workspacesthinclient:getEnvironment', __args__, opts=opts, typ=GetEnvironmentResult).value

    return AwaitableGetEnvironmentResult(
        activation_code=pulumi.get(__ret__, 'activation_code'),
        arn=pulumi.get(__ret__, 'arn'),
        created_at=pulumi.get(__ret__, 'created_at'),
        desired_software_set_id=pulumi.get(__ret__, 'desired_software_set_id'),
        desktop_endpoint=pulumi.get(__ret__, 'desktop_endpoint'),
        desktop_type=pulumi.get(__ret__, 'desktop_type'),
        id=pulumi.get(__ret__, 'id'),
        maintenance_window=pulumi.get(__ret__, 'maintenance_window'),
        name=pulumi.get(__ret__, 'name'),
        pending_software_set_id=pulumi.get(__ret__, 'pending_software_set_id'),
        pending_software_set_version=pulumi.get(__ret__, 'pending_software_set_version'),
        registered_devices_count=pulumi.get(__ret__, 'registered_devices_count'),
        software_set_compliance_status=pulumi.get(__ret__, 'software_set_compliance_status'),
        software_set_update_mode=pulumi.get(__ret__, 'software_set_update_mode'),
        software_set_update_schedule=pulumi.get(__ret__, 'software_set_update_schedule'),
        tags=pulumi.get(__ret__, 'tags'),
        updated_at=pulumi.get(__ret__, 'updated_at'))


@_utilities.lift_output_func(get_environment)
def get_environment_output(id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEnvironmentResult]:
    """
    Resource type definition for AWS::WorkSpacesThinClient::Environment.


    :param str id: Unique identifier of the environment.
    """
    ...
