# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['RuleGroupArgs', 'RuleGroup']

@pulumi.input_type
class RuleGroupArgs:
    def __init__(__self__, *,
                 capacity: pulumi.Input[int],
                 scope: pulumi.Input['RuleGroupScope'],
                 visibility_config: pulumi.Input['RuleGroupVisibilityConfigArgs'],
                 available_labels: Optional[pulumi.Input[Sequence[pulumi.Input['RuleGroupLabelSummaryArgs']]]] = None,
                 consumed_labels: Optional[pulumi.Input[Sequence[pulumi.Input['RuleGroupLabelSummaryArgs']]]] = None,
                 custom_response_bodies: Optional[pulumi.Input[Mapping[str, pulumi.Input['RuleGroupCustomResponseBodyArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['RuleGroupRuleArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a RuleGroup resource.
        :param pulumi.Input[Sequence[pulumi.Input['RuleGroupLabelSummaryArgs']]] available_labels: Collection of Available Labels.
        :param pulumi.Input[Sequence[pulumi.Input['RuleGroupLabelSummaryArgs']]] consumed_labels: Collection of Consumed Labels.
        :param pulumi.Input[Sequence[pulumi.Input['RuleGroupRuleArgs']]] rules: Collection of Rules.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "scope", scope)
        pulumi.set(__self__, "visibility_config", visibility_config)
        if available_labels is not None:
            pulumi.set(__self__, "available_labels", available_labels)
        if consumed_labels is not None:
            pulumi.set(__self__, "consumed_labels", consumed_labels)
        if custom_response_bodies is not None:
            pulumi.set(__self__, "custom_response_bodies", custom_response_bodies)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Input[int]:
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input[int]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Input['RuleGroupScope']:
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input['RuleGroupScope']):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="visibilityConfig")
    def visibility_config(self) -> pulumi.Input['RuleGroupVisibilityConfigArgs']:
        return pulumi.get(self, "visibility_config")

    @visibility_config.setter
    def visibility_config(self, value: pulumi.Input['RuleGroupVisibilityConfigArgs']):
        pulumi.set(self, "visibility_config", value)

    @property
    @pulumi.getter(name="availableLabels")
    def available_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleGroupLabelSummaryArgs']]]]:
        """
        Collection of Available Labels.
        """
        return pulumi.get(self, "available_labels")

    @available_labels.setter
    def available_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleGroupLabelSummaryArgs']]]]):
        pulumi.set(self, "available_labels", value)

    @property
    @pulumi.getter(name="consumedLabels")
    def consumed_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleGroupLabelSummaryArgs']]]]:
        """
        Collection of Consumed Labels.
        """
        return pulumi.get(self, "consumed_labels")

    @consumed_labels.setter
    def consumed_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleGroupLabelSummaryArgs']]]]):
        pulumi.set(self, "consumed_labels", value)

    @property
    @pulumi.getter(name="customResponseBodies")
    def custom_response_bodies(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['RuleGroupCustomResponseBodyArgs']]]]:
        return pulumi.get(self, "custom_response_bodies")

    @custom_response_bodies.setter
    def custom_response_bodies(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['RuleGroupCustomResponseBodyArgs']]]]):
        pulumi.set(self, "custom_response_bodies", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleGroupRuleArgs']]]]:
        """
        Collection of Rules.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleGroupRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class RuleGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 available_labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleGroupLabelSummaryArgs']]]]] = None,
                 capacity: Optional[pulumi.Input[int]] = None,
                 consumed_labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleGroupLabelSummaryArgs']]]]] = None,
                 custom_response_bodies: Optional[pulumi.Input[Mapping[str, pulumi.Input[pulumi.InputType['RuleGroupCustomResponseBodyArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleGroupRuleArgs']]]]] = None,
                 scope: Optional[pulumi.Input['RuleGroupScope']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 visibility_config: Optional[pulumi.Input[pulumi.InputType['RuleGroupVisibilityConfigArgs']]] = None,
                 __props__=None):
        """
        Contains the Rules that identify the requests that you want to allow, block, or count. In a RuleGroup, you also specify a default action (ALLOW or BLOCK), and the action for each Rule that you add to a RuleGroup, for example, block requests from specified IP addresses or block requests from specified referrers. You also associate the RuleGroup with a CloudFront distribution to identify the requests that you want AWS WAF to filter. If you add more than one Rule to a RuleGroup, a request needs to match only one of the specifications to be allowed, blocked, or counted.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleGroupLabelSummaryArgs']]]] available_labels: Collection of Available Labels.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleGroupLabelSummaryArgs']]]] consumed_labels: Collection of Consumed Labels.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleGroupRuleArgs']]]] rules: Collection of Rules.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Contains the Rules that identify the requests that you want to allow, block, or count. In a RuleGroup, you also specify a default action (ALLOW or BLOCK), and the action for each Rule that you add to a RuleGroup, for example, block requests from specified IP addresses or block requests from specified referrers. You also associate the RuleGroup with a CloudFront distribution to identify the requests that you want AWS WAF to filter. If you add more than one Rule to a RuleGroup, a request needs to match only one of the specifications to be allowed, blocked, or counted.

        :param str resource_name: The name of the resource.
        :param RuleGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 available_labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleGroupLabelSummaryArgs']]]]] = None,
                 capacity: Optional[pulumi.Input[int]] = None,
                 consumed_labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleGroupLabelSummaryArgs']]]]] = None,
                 custom_response_bodies: Optional[pulumi.Input[Mapping[str, pulumi.Input[pulumi.InputType['RuleGroupCustomResponseBodyArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleGroupRuleArgs']]]]] = None,
                 scope: Optional[pulumi.Input['RuleGroupScope']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 visibility_config: Optional[pulumi.Input[pulumi.InputType['RuleGroupVisibilityConfigArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleGroupArgs.__new__(RuleGroupArgs)

            __props__.__dict__["available_labels"] = available_labels
            if capacity is None and not opts.urn:
                raise TypeError("Missing required property 'capacity'")
            __props__.__dict__["capacity"] = capacity
            __props__.__dict__["consumed_labels"] = consumed_labels
            __props__.__dict__["custom_response_bodies"] = custom_response_bodies
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["rules"] = rules
            if scope is None and not opts.urn:
                raise TypeError("Missing required property 'scope'")
            __props__.__dict__["scope"] = scope
            __props__.__dict__["tags"] = tags
            if visibility_config is None and not opts.urn:
                raise TypeError("Missing required property 'visibility_config'")
            __props__.__dict__["visibility_config"] = visibility_config
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["label_namespace"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["name", "scope"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(RuleGroup, __self__).__init__(
            'aws-native:wafv2:RuleGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'RuleGroup':
        """
        Get an existing RuleGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RuleGroupArgs.__new__(RuleGroupArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["available_labels"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["capacity"] = None
        __props__.__dict__["consumed_labels"] = None
        __props__.__dict__["custom_response_bodies"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["label_namespace"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["rules"] = None
        __props__.__dict__["scope"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["visibility_config"] = None
        return RuleGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="availableLabels")
    def available_labels(self) -> pulumi.Output[Optional[Sequence['outputs.RuleGroupLabelSummary']]]:
        """
        Collection of Available Labels.
        """
        return pulumi.get(self, "available_labels")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[int]:
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="consumedLabels")
    def consumed_labels(self) -> pulumi.Output[Optional[Sequence['outputs.RuleGroupLabelSummary']]]:
        """
        Collection of Consumed Labels.
        """
        return pulumi.get(self, "consumed_labels")

    @property
    @pulumi.getter(name="customResponseBodies")
    def custom_response_bodies(self) -> pulumi.Output[Optional[Mapping[str, 'outputs.RuleGroupCustomResponseBody']]]:
        return pulumi.get(self, "custom_response_bodies")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="labelNamespace")
    def label_namespace(self) -> pulumi.Output[str]:
        return pulumi.get(self, "label_namespace")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.RuleGroupRule']]]:
        """
        Collection of Rules.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output['RuleGroupScope']:
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="visibilityConfig")
    def visibility_config(self) -> pulumi.Output['outputs.RuleGroupVisibilityConfig']:
        return pulumi.get(self, "visibility_config")

