# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['PolicyStoreArgs', 'PolicyStore']

@pulumi.input_type
class PolicyStoreArgs:
    def __init__(__self__, *,
                 validation_settings: pulumi.Input['PolicyStoreValidationSettingsArgs'],
                 description: Optional[pulumi.Input[str]] = None,
                 schema: Optional[pulumi.Input['PolicyStoreSchemaDefinitionArgs']] = None):
        """
        The set of arguments for constructing a PolicyStore resource.
        """
        pulumi.set(__self__, "validation_settings", validation_settings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter(name="validationSettings")
    def validation_settings(self) -> pulumi.Input['PolicyStoreValidationSettingsArgs']:
        return pulumi.get(self, "validation_settings")

    @validation_settings.setter
    def validation_settings(self, value: pulumi.Input['PolicyStoreValidationSettingsArgs']):
        pulumi.set(self, "validation_settings", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input['PolicyStoreSchemaDefinitionArgs']]:
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input['PolicyStoreSchemaDefinitionArgs']]):
        pulumi.set(self, "schema", value)


class PolicyStore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 schema: Optional[pulumi.Input[pulumi.InputType['PolicyStoreSchemaDefinitionArgs']]] = None,
                 validation_settings: Optional[pulumi.Input[pulumi.InputType['PolicyStoreValidationSettingsArgs']]] = None,
                 __props__=None):
        """
        Represents a policy store that you can place schema, policies, and policy templates in to validate authorization requests

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_policy_store = aws_native.verifiedpermissions.PolicyStore("myPolicyStore",
            schema=aws_native.verifiedpermissions.PolicyStoreSchemaDefinitionArgs(
                cedar_json="{\\"PhotoApp\\":{\\"commonTypes\\":{\\"PersonType\\":{\\"type\\":\\"Record\\",\\"attributes\\":{\\"age\\":{\\"type\\":\\"Long\\"},\\"name\\":{\\"type\\":\\"String\\"}}},\\"ContextType\\":{\\"type\\":\\"Record\\",\\"attributes\\":{\\"ip\\":{\\"type\\":\\"Extension\\",\\"name\\":\\"ipaddr\\",\\"required\\":false},\\"authenticated\\":{\\"type\\":\\"Boolean\\",\\"required\\":true}}}},\\"entityTypes\\":{\\"User\\":{\\"shape\\":{\\"type\\":\\"Record\\",\\"attributes\\":{\\"userId\\":{\\"type\\":\\"String\\"},\\"personInformation\\":{\\"type\\":\\"PersonType\\"}}},\\"memberOfTypes\\":[\\"UserGroup\\"]},\\"UserGroup\\":{\\"shape\\":{\\"type\\":\\"Record\\",\\"attributes\\":{}}},\\"Photo\\":{\\"shape\\":{\\"type\\":\\"Record\\",\\"attributes\\":{\\"account\\":{\\"type\\":\\"Entity\\",\\"name\\":\\"Account\\",\\"required\\":true},\\"private\\":{\\"type\\":\\"Boolean\\",\\"required\\":true}}},\\"memberOfTypes\\":[\\"Album\\",\\"Account\\"]},\\"Album\\":{\\"shape\\":{\\"type\\":\\"Record\\",\\"attributes\\":{}}},\\"Account\\":{\\"shape\\":{\\"type\\":\\"Record\\",\\"attributes\\":{}}}},\\"actions\\":{\\"viewPhoto\\":{\\"appliesTo\\":{\\"principalTypes\\":[\\"User\\",\\"UserGroup\\"],\\"resourceTypes\\":[\\"Photo\\"],\\"context\\":{\\"type\\":\\"ContextType\\"}}},\\"createPhoto\\":{\\"appliesTo\\":{\\"principalTypes\\":[\\"User\\",\\"UserGroup\\"],\\"resourceTypes\\":[\\"Photo\\"],\\"context\\":{\\"type\\":\\"ContextType\\"}}},\\"listPhotos\\":{\\"appliesTo\\":{\\"principalTypes\\":[\\"User\\",\\"UserGroup\\"],\\"resourceTypes\\":[\\"Photo\\"],\\"context\\":{\\"type\\":\\"ContextType\\"}}}}}}",
            ),
            validation_settings=aws_native.verifiedpermissions.PolicyStoreValidationSettingsArgs(
                mode=aws_native.verifiedpermissions.PolicyStoreValidationMode.STRICT,
            ))

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyStoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a policy store that you can place schema, policies, and policy templates in to validate authorization requests

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_policy_store = aws_native.verifiedpermissions.PolicyStore("myPolicyStore",
            schema=aws_native.verifiedpermissions.PolicyStoreSchemaDefinitionArgs(
                cedar_json="{\\"PhotoApp\\":{\\"commonTypes\\":{\\"PersonType\\":{\\"type\\":\\"Record\\",\\"attributes\\":{\\"age\\":{\\"type\\":\\"Long\\"},\\"name\\":{\\"type\\":\\"String\\"}}},\\"ContextType\\":{\\"type\\":\\"Record\\",\\"attributes\\":{\\"ip\\":{\\"type\\":\\"Extension\\",\\"name\\":\\"ipaddr\\",\\"required\\":false},\\"authenticated\\":{\\"type\\":\\"Boolean\\",\\"required\\":true}}}},\\"entityTypes\\":{\\"User\\":{\\"shape\\":{\\"type\\":\\"Record\\",\\"attributes\\":{\\"userId\\":{\\"type\\":\\"String\\"},\\"personInformation\\":{\\"type\\":\\"PersonType\\"}}},\\"memberOfTypes\\":[\\"UserGroup\\"]},\\"UserGroup\\":{\\"shape\\":{\\"type\\":\\"Record\\",\\"attributes\\":{}}},\\"Photo\\":{\\"shape\\":{\\"type\\":\\"Record\\",\\"attributes\\":{\\"account\\":{\\"type\\":\\"Entity\\",\\"name\\":\\"Account\\",\\"required\\":true},\\"private\\":{\\"type\\":\\"Boolean\\",\\"required\\":true}}},\\"memberOfTypes\\":[\\"Album\\",\\"Account\\"]},\\"Album\\":{\\"shape\\":{\\"type\\":\\"Record\\",\\"attributes\\":{}}},\\"Account\\":{\\"shape\\":{\\"type\\":\\"Record\\",\\"attributes\\":{}}}},\\"actions\\":{\\"viewPhoto\\":{\\"appliesTo\\":{\\"principalTypes\\":[\\"User\\",\\"UserGroup\\"],\\"resourceTypes\\":[\\"Photo\\"],\\"context\\":{\\"type\\":\\"ContextType\\"}}},\\"createPhoto\\":{\\"appliesTo\\":{\\"principalTypes\\":[\\"User\\",\\"UserGroup\\"],\\"resourceTypes\\":[\\"Photo\\"],\\"context\\":{\\"type\\":\\"ContextType\\"}}},\\"listPhotos\\":{\\"appliesTo\\":{\\"principalTypes\\":[\\"User\\",\\"UserGroup\\"],\\"resourceTypes\\":[\\"Photo\\"],\\"context\\":{\\"type\\":\\"ContextType\\"}}}}}}",
            ),
            validation_settings=aws_native.verifiedpermissions.PolicyStoreValidationSettingsArgs(
                mode=aws_native.verifiedpermissions.PolicyStoreValidationMode.STRICT,
            ))

        ```

        :param str resource_name: The name of the resource.
        :param PolicyStoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyStoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 schema: Optional[pulumi.Input[pulumi.InputType['PolicyStoreSchemaDefinitionArgs']]] = None,
                 validation_settings: Optional[pulumi.Input[pulumi.InputType['PolicyStoreValidationSettingsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyStoreArgs.__new__(PolicyStoreArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["schema"] = schema
            if validation_settings is None and not opts.urn:
                raise TypeError("Missing required property 'validation_settings'")
            __props__.__dict__["validation_settings"] = validation_settings
            __props__.__dict__["arn"] = None
            __props__.__dict__["policy_store_id"] = None
        super(PolicyStore, __self__).__init__(
            'aws-native:verifiedpermissions:PolicyStore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'PolicyStore':
        """
        Get an existing PolicyStore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PolicyStoreArgs.__new__(PolicyStoreArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["policy_store_id"] = None
        __props__.__dict__["schema"] = None
        __props__.__dict__["validation_settings"] = None
        return PolicyStore(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="policyStoreId")
    def policy_store_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "policy_store_id")

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Output[Optional['outputs.PolicyStoreSchemaDefinition']]:
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="validationSettings")
    def validation_settings(self) -> pulumi.Output['outputs.PolicyStoreValidationSettings']:
        return pulumi.get(self, "validation_settings")

