# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['IdentitySourceArgs', 'IdentitySource']

@pulumi.input_type
class IdentitySourceArgs:
    def __init__(__self__, *,
                 configuration: pulumi.Input['IdentitySourceConfigurationArgs'],
                 policy_store_id: pulumi.Input[str],
                 principal_entity_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a IdentitySource resource.
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "policy_store_id", policy_store_id)
        if principal_entity_type is not None:
            pulumi.set(__self__, "principal_entity_type", principal_entity_type)

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Input['IdentitySourceConfigurationArgs']:
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: pulumi.Input['IdentitySourceConfigurationArgs']):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="policyStoreId")
    def policy_store_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "policy_store_id")

    @policy_store_id.setter
    def policy_store_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_store_id", value)

    @property
    @pulumi.getter(name="principalEntityType")
    def principal_entity_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "principal_entity_type")

    @principal_entity_type.setter
    def principal_entity_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_entity_type", value)


class IdentitySource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[pulumi.InputType['IdentitySourceConfigurationArgs']]] = None,
                 policy_store_id: Optional[pulumi.Input[str]] = None,
                 principal_entity_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Definition of AWS::VerifiedPermissions::IdentitySource Resource Type

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        policy_store_id = config.require("policyStoreId")
        user_pool_arn = config.require("userPoolArn")
        client_ids = config.require_object("clientIds")
        principal_entity_type = config.require("principalEntityType")
        identity_source = aws_native.verifiedpermissions.IdentitySource("identitySource",
            policy_store_id=policy_store_id,
            configuration=aws_native.verifiedpermissions.IdentitySourceConfigurationArgs(
                cognito_user_pool_configuration=aws_native.verifiedpermissions.IdentitySourceCognitoUserPoolConfigurationArgs(
                    user_pool_arn=user_pool_arn,
                    client_ids=client_ids,
                ),
            ),
            principal_entity_type=principal_entity_type)
        pulumi.export("identitySourceId", identity_source.identity_source_id)

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IdentitySourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::VerifiedPermissions::IdentitySource Resource Type

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        policy_store_id = config.require("policyStoreId")
        user_pool_arn = config.require("userPoolArn")
        client_ids = config.require_object("clientIds")
        principal_entity_type = config.require("principalEntityType")
        identity_source = aws_native.verifiedpermissions.IdentitySource("identitySource",
            policy_store_id=policy_store_id,
            configuration=aws_native.verifiedpermissions.IdentitySourceConfigurationArgs(
                cognito_user_pool_configuration=aws_native.verifiedpermissions.IdentitySourceCognitoUserPoolConfigurationArgs(
                    user_pool_arn=user_pool_arn,
                    client_ids=client_ids,
                ),
            ),
            principal_entity_type=principal_entity_type)
        pulumi.export("identitySourceId", identity_source.identity_source_id)

        ```

        :param str resource_name: The name of the resource.
        :param IdentitySourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IdentitySourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[pulumi.InputType['IdentitySourceConfigurationArgs']]] = None,
                 policy_store_id: Optional[pulumi.Input[str]] = None,
                 principal_entity_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IdentitySourceArgs.__new__(IdentitySourceArgs)

            if configuration is None and not opts.urn:
                raise TypeError("Missing required property 'configuration'")
            __props__.__dict__["configuration"] = configuration
            if policy_store_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_store_id'")
            __props__.__dict__["policy_store_id"] = policy_store_id
            __props__.__dict__["principal_entity_type"] = principal_entity_type
            __props__.__dict__["details"] = None
            __props__.__dict__["identity_source_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["policyStoreId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(IdentitySource, __self__).__init__(
            'aws-native:verifiedpermissions:IdentitySource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'IdentitySource':
        """
        Get an existing IdentitySource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = IdentitySourceArgs.__new__(IdentitySourceArgs)

        __props__.__dict__["configuration"] = None
        __props__.__dict__["details"] = None
        __props__.__dict__["identity_source_id"] = None
        __props__.__dict__["policy_store_id"] = None
        __props__.__dict__["principal_entity_type"] = None
        return IdentitySource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output['outputs.IdentitySourceConfiguration']:
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def details(self) -> pulumi.Output['outputs.IdentitySourceDetails']:
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="identitySourceId")
    def identity_source_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "identity_source_id")

    @property
    @pulumi.getter(name="policyStoreId")
    def policy_store_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "policy_store_id")

    @property
    @pulumi.getter(name="principalEntityType")
    def principal_entity_type(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "principal_entity_type")

