# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'As2ConfigProperties',
    'SftpConfigProperties',
    'WorkflowEfsInputFileLocation',
    'WorkflowInputFileLocation',
    'WorkflowS3FileLocation',
    'WorkflowS3InputFileLocation',
    'WorkflowS3Tag',
    'WorkflowStep',
    'WorkflowStepCopyStepDetailsProperties',
    'WorkflowStepCustomStepDetailsProperties',
    'WorkflowStepDecryptStepDetailsProperties',
    'WorkflowStepDeleteStepDetailsProperties',
    'WorkflowStepTagStepDetailsProperties',
]

@pulumi.output_type
class As2ConfigProperties(dict):
    """
    Configuration for an AS2 connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicAuthSecretId":
            suggest = "basic_auth_secret_id"
        elif key == "encryptionAlgorithm":
            suggest = "encryption_algorithm"
        elif key == "localProfileId":
            suggest = "local_profile_id"
        elif key == "mdnResponse":
            suggest = "mdn_response"
        elif key == "mdnSigningAlgorithm":
            suggest = "mdn_signing_algorithm"
        elif key == "messageSubject":
            suggest = "message_subject"
        elif key == "partnerProfileId":
            suggest = "partner_profile_id"
        elif key == "signingAlgorithm":
            suggest = "signing_algorithm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in As2ConfigProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        As2ConfigProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        As2ConfigProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_auth_secret_id: Optional[str] = None,
                 compression: Optional['ConnectorAs2ConfigPropertiesCompression'] = None,
                 encryption_algorithm: Optional['ConnectorAs2ConfigPropertiesEncryptionAlgorithm'] = None,
                 local_profile_id: Optional[str] = None,
                 mdn_response: Optional['ConnectorAs2ConfigPropertiesMdnResponse'] = None,
                 mdn_signing_algorithm: Optional['ConnectorAs2ConfigPropertiesMdnSigningAlgorithm'] = None,
                 message_subject: Optional[str] = None,
                 partner_profile_id: Optional[str] = None,
                 signing_algorithm: Optional['ConnectorAs2ConfigPropertiesSigningAlgorithm'] = None):
        """
        Configuration for an AS2 connector.
        :param str basic_auth_secret_id: ARN or name of the secret in AWS Secrets Manager which contains the credentials for Basic authentication. If empty, Basic authentication is disabled for the AS2 connector
        :param 'ConnectorAs2ConfigPropertiesCompression' compression: Compression setting for this AS2 connector configuration.
        :param 'ConnectorAs2ConfigPropertiesEncryptionAlgorithm' encryption_algorithm: Encryption algorithm for this AS2 connector configuration.
        :param str local_profile_id: A unique identifier for the local profile.
        :param 'ConnectorAs2ConfigPropertiesMdnResponse' mdn_response: MDN Response setting for this AS2 connector configuration.
        :param 'ConnectorAs2ConfigPropertiesMdnSigningAlgorithm' mdn_signing_algorithm: MDN Signing algorithm for this AS2 connector configuration.
        :param str message_subject: The message subject for this AS2 connector configuration.
        :param str partner_profile_id: A unique identifier for the partner profile.
        :param 'ConnectorAs2ConfigPropertiesSigningAlgorithm' signing_algorithm: Signing algorithm for this AS2 connector configuration.
        """
        if basic_auth_secret_id is not None:
            pulumi.set(__self__, "basic_auth_secret_id", basic_auth_secret_id)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if encryption_algorithm is not None:
            pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        if local_profile_id is not None:
            pulumi.set(__self__, "local_profile_id", local_profile_id)
        if mdn_response is not None:
            pulumi.set(__self__, "mdn_response", mdn_response)
        if mdn_signing_algorithm is not None:
            pulumi.set(__self__, "mdn_signing_algorithm", mdn_signing_algorithm)
        if message_subject is not None:
            pulumi.set(__self__, "message_subject", message_subject)
        if partner_profile_id is not None:
            pulumi.set(__self__, "partner_profile_id", partner_profile_id)
        if signing_algorithm is not None:
            pulumi.set(__self__, "signing_algorithm", signing_algorithm)

    @property
    @pulumi.getter(name="basicAuthSecretId")
    def basic_auth_secret_id(self) -> Optional[str]:
        """
        ARN or name of the secret in AWS Secrets Manager which contains the credentials for Basic authentication. If empty, Basic authentication is disabled for the AS2 connector
        """
        return pulumi.get(self, "basic_auth_secret_id")

    @property
    @pulumi.getter
    def compression(self) -> Optional['ConnectorAs2ConfigPropertiesCompression']:
        """
        Compression setting for this AS2 connector configuration.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> Optional['ConnectorAs2ConfigPropertiesEncryptionAlgorithm']:
        """
        Encryption algorithm for this AS2 connector configuration.
        """
        return pulumi.get(self, "encryption_algorithm")

    @property
    @pulumi.getter(name="localProfileId")
    def local_profile_id(self) -> Optional[str]:
        """
        A unique identifier for the local profile.
        """
        return pulumi.get(self, "local_profile_id")

    @property
    @pulumi.getter(name="mdnResponse")
    def mdn_response(self) -> Optional['ConnectorAs2ConfigPropertiesMdnResponse']:
        """
        MDN Response setting for this AS2 connector configuration.
        """
        return pulumi.get(self, "mdn_response")

    @property
    @pulumi.getter(name="mdnSigningAlgorithm")
    def mdn_signing_algorithm(self) -> Optional['ConnectorAs2ConfigPropertiesMdnSigningAlgorithm']:
        """
        MDN Signing algorithm for this AS2 connector configuration.
        """
        return pulumi.get(self, "mdn_signing_algorithm")

    @property
    @pulumi.getter(name="messageSubject")
    def message_subject(self) -> Optional[str]:
        """
        The message subject for this AS2 connector configuration.
        """
        return pulumi.get(self, "message_subject")

    @property
    @pulumi.getter(name="partnerProfileId")
    def partner_profile_id(self) -> Optional[str]:
        """
        A unique identifier for the partner profile.
        """
        return pulumi.get(self, "partner_profile_id")

    @property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> Optional['ConnectorAs2ConfigPropertiesSigningAlgorithm']:
        """
        Signing algorithm for this AS2 connector configuration.
        """
        return pulumi.get(self, "signing_algorithm")


@pulumi.output_type
class SftpConfigProperties(dict):
    """
    Configuration for an SFTP connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trustedHostKeys":
            suggest = "trusted_host_keys"
        elif key == "userSecretId":
            suggest = "user_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SftpConfigProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SftpConfigProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SftpConfigProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 trusted_host_keys: Optional[Sequence[str]] = None,
                 user_secret_id: Optional[str] = None):
        """
        Configuration for an SFTP connector.
        :param Sequence[str] trusted_host_keys: List of public host keys, for the external server to which you are connecting.
        :param str user_secret_id: ARN or name of the secret in AWS Secrets Manager which contains the SFTP user's private keys or passwords.
        """
        if trusted_host_keys is not None:
            pulumi.set(__self__, "trusted_host_keys", trusted_host_keys)
        if user_secret_id is not None:
            pulumi.set(__self__, "user_secret_id", user_secret_id)

    @property
    @pulumi.getter(name="trustedHostKeys")
    def trusted_host_keys(self) -> Optional[Sequence[str]]:
        """
        List of public host keys, for the external server to which you are connecting.
        """
        return pulumi.get(self, "trusted_host_keys")

    @property
    @pulumi.getter(name="userSecretId")
    def user_secret_id(self) -> Optional[str]:
        """
        ARN or name of the secret in AWS Secrets Manager which contains the SFTP user's private keys or passwords.
        """
        return pulumi.get(self, "user_secret_id")


@pulumi.output_type
class WorkflowEfsInputFileLocation(dict):
    """
    Specifies the details for an EFS file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystemId":
            suggest = "file_system_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowEfsInputFileLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowEfsInputFileLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowEfsInputFileLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_system_id: Optional[str] = None,
                 path: Optional[str] = None):
        """
        Specifies the details for an EFS file.
        :param str file_system_id: Specifies the EFS filesystem that contains the file.
        :param str path: The name assigned to the file when it was created in EFS. You use the object path to retrieve the object.
        """
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[str]:
        """
        Specifies the EFS filesystem that contains the file.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The name assigned to the file when it was created in EFS. You use the object path to retrieve the object.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class WorkflowInputFileLocation(dict):
    """
    Specifies the location for the file being decrypted. Only applicable for the Decrypt type of workflow steps.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "efsFileLocation":
            suggest = "efs_file_location"
        elif key == "s3FileLocation":
            suggest = "s3_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowInputFileLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowInputFileLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowInputFileLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 efs_file_location: Optional['outputs.WorkflowEfsInputFileLocation'] = None,
                 s3_file_location: Optional['outputs.WorkflowS3InputFileLocation'] = None):
        """
        Specifies the location for the file being decrypted. Only applicable for the Decrypt type of workflow steps.
        """
        if efs_file_location is not None:
            pulumi.set(__self__, "efs_file_location", efs_file_location)
        if s3_file_location is not None:
            pulumi.set(__self__, "s3_file_location", s3_file_location)

    @property
    @pulumi.getter(name="efsFileLocation")
    def efs_file_location(self) -> Optional['outputs.WorkflowEfsInputFileLocation']:
        return pulumi.get(self, "efs_file_location")

    @property
    @pulumi.getter(name="s3FileLocation")
    def s3_file_location(self) -> Optional['outputs.WorkflowS3InputFileLocation']:
        return pulumi.get(self, "s3_file_location")


@pulumi.output_type
class WorkflowS3FileLocation(dict):
    """
    Specifies the location for the file being copied. Only applicable for the Copy type of workflow steps.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3FileLocation":
            suggest = "s3_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowS3FileLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowS3FileLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowS3FileLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_file_location: Optional['outputs.WorkflowS3InputFileLocation'] = None):
        """
        Specifies the location for the file being copied. Only applicable for the Copy type of workflow steps.
        """
        if s3_file_location is not None:
            pulumi.set(__self__, "s3_file_location", s3_file_location)

    @property
    @pulumi.getter(name="s3FileLocation")
    def s3_file_location(self) -> Optional['outputs.WorkflowS3InputFileLocation']:
        return pulumi.get(self, "s3_file_location")


@pulumi.output_type
class WorkflowS3InputFileLocation(dict):
    """
    Specifies the details for a S3 file.
    """
    def __init__(__self__, *,
                 bucket: Optional[str] = None,
                 key: Optional[str] = None):
        """
        Specifies the details for a S3 file.
        :param str bucket: Specifies the S3 bucket that contains the file.
        :param str key: The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        Specifies the S3 bucket that contains the file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class WorkflowS3Tag(dict):
    """
    Specifies the key-value pair that are assigned to a file during the execution of a Tagging step.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        Specifies the key-value pair that are assigned to a file during the execution of a Tagging step.
        :param str key: The name assigned to the tag that you create.
        :param str value: The value that corresponds to the key.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name assigned to the tag that you create.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value that corresponds to the key.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class WorkflowStep(dict):
    """
    The basic building block of a workflow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "copyStepDetails":
            suggest = "copy_step_details"
        elif key == "customStepDetails":
            suggest = "custom_step_details"
        elif key == "decryptStepDetails":
            suggest = "decrypt_step_details"
        elif key == "deleteStepDetails":
            suggest = "delete_step_details"
        elif key == "tagStepDetails":
            suggest = "tag_step_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowStep. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowStep.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowStep.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 copy_step_details: Optional['outputs.WorkflowStepCopyStepDetailsProperties'] = None,
                 custom_step_details: Optional['outputs.WorkflowStepCustomStepDetailsProperties'] = None,
                 decrypt_step_details: Optional['outputs.WorkflowStepDecryptStepDetailsProperties'] = None,
                 delete_step_details: Optional['outputs.WorkflowStepDeleteStepDetailsProperties'] = None,
                 tag_step_details: Optional['outputs.WorkflowStepTagStepDetailsProperties'] = None,
                 type: Optional['WorkflowStepType'] = None):
        """
        The basic building block of a workflow.
        :param 'WorkflowStepCopyStepDetailsProperties' copy_step_details: Details for a step that performs a file copy.
        :param 'WorkflowStepCustomStepDetailsProperties' custom_step_details: Details for a step that invokes a lambda function.
        :param 'WorkflowStepDecryptStepDetailsProperties' decrypt_step_details: Details for a step that performs a file decryption.
        :param 'WorkflowStepDeleteStepDetailsProperties' delete_step_details: Details for a step that deletes the file.
        :param 'WorkflowStepTagStepDetailsProperties' tag_step_details: Details for a step that creates one or more tags.
        """
        if copy_step_details is not None:
            pulumi.set(__self__, "copy_step_details", copy_step_details)
        if custom_step_details is not None:
            pulumi.set(__self__, "custom_step_details", custom_step_details)
        if decrypt_step_details is not None:
            pulumi.set(__self__, "decrypt_step_details", decrypt_step_details)
        if delete_step_details is not None:
            pulumi.set(__self__, "delete_step_details", delete_step_details)
        if tag_step_details is not None:
            pulumi.set(__self__, "tag_step_details", tag_step_details)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="copyStepDetails")
    def copy_step_details(self) -> Optional['outputs.WorkflowStepCopyStepDetailsProperties']:
        """
        Details for a step that performs a file copy.
        """
        return pulumi.get(self, "copy_step_details")

    @property
    @pulumi.getter(name="customStepDetails")
    def custom_step_details(self) -> Optional['outputs.WorkflowStepCustomStepDetailsProperties']:
        """
        Details for a step that invokes a lambda function.
        """
        return pulumi.get(self, "custom_step_details")

    @property
    @pulumi.getter(name="decryptStepDetails")
    def decrypt_step_details(self) -> Optional['outputs.WorkflowStepDecryptStepDetailsProperties']:
        """
        Details for a step that performs a file decryption.
        """
        return pulumi.get(self, "decrypt_step_details")

    @property
    @pulumi.getter(name="deleteStepDetails")
    def delete_step_details(self) -> Optional['outputs.WorkflowStepDeleteStepDetailsProperties']:
        """
        Details for a step that deletes the file.
        """
        return pulumi.get(self, "delete_step_details")

    @property
    @pulumi.getter(name="tagStepDetails")
    def tag_step_details(self) -> Optional['outputs.WorkflowStepTagStepDetailsProperties']:
        """
        Details for a step that creates one or more tags.
        """
        return pulumi.get(self, "tag_step_details")

    @property
    @pulumi.getter
    def type(self) -> Optional['WorkflowStepType']:
        return pulumi.get(self, "type")


@pulumi.output_type
class WorkflowStepCopyStepDetailsProperties(dict):
    """
    Details for a step that performs a file copy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationFileLocation":
            suggest = "destination_file_location"
        elif key == "overwriteExisting":
            suggest = "overwrite_existing"
        elif key == "sourceFileLocation":
            suggest = "source_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowStepCopyStepDetailsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowStepCopyStepDetailsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowStepCopyStepDetailsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_file_location: Optional['outputs.WorkflowS3FileLocation'] = None,
                 name: Optional[str] = None,
                 overwrite_existing: Optional['WorkflowStepCopyStepDetailsPropertiesOverwriteExisting'] = None,
                 source_file_location: Optional[str] = None):
        """
        Details for a step that performs a file copy.
        :param str name: The name of the step, used as an identifier.
        :param 'WorkflowStepCopyStepDetailsPropertiesOverwriteExisting' overwrite_existing: A flag that indicates whether or not to overwrite an existing file of the same name. The default is FALSE.
        :param str source_file_location: Specifies which file to use as input to the workflow step.
        """
        if destination_file_location is not None:
            pulumi.set(__self__, "destination_file_location", destination_file_location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overwrite_existing is not None:
            pulumi.set(__self__, "overwrite_existing", overwrite_existing)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter(name="destinationFileLocation")
    def destination_file_location(self) -> Optional['outputs.WorkflowS3FileLocation']:
        return pulumi.get(self, "destination_file_location")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="overwriteExisting")
    def overwrite_existing(self) -> Optional['WorkflowStepCopyStepDetailsPropertiesOverwriteExisting']:
        """
        A flag that indicates whether or not to overwrite an existing file of the same name. The default is FALSE.
        """
        return pulumi.get(self, "overwrite_existing")

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[str]:
        """
        Specifies which file to use as input to the workflow step.
        """
        return pulumi.get(self, "source_file_location")


@pulumi.output_type
class WorkflowStepCustomStepDetailsProperties(dict):
    """
    Details for a step that invokes a lambda function.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceFileLocation":
            suggest = "source_file_location"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowStepCustomStepDetailsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowStepCustomStepDetailsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowStepCustomStepDetailsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 source_file_location: Optional[str] = None,
                 target: Optional[str] = None,
                 timeout_seconds: Optional[int] = None):
        """
        Details for a step that invokes a lambda function.
        :param str name: The name of the step, used as an identifier.
        :param str source_file_location: Specifies which file to use as input to the workflow step.
        :param str target: The ARN for the lambda function that is being called.
        :param int timeout_seconds: Timeout, in seconds, for the step.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[str]:
        """
        Specifies which file to use as input to the workflow step.
        """
        return pulumi.get(self, "source_file_location")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The ARN for the lambda function that is being called.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        Timeout, in seconds, for the step.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class WorkflowStepDecryptStepDetailsProperties(dict):
    """
    Details for a step that performs a file decryption.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationFileLocation":
            suggest = "destination_file_location"
        elif key == "overwriteExisting":
            suggest = "overwrite_existing"
        elif key == "sourceFileLocation":
            suggest = "source_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowStepDecryptStepDetailsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowStepDecryptStepDetailsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowStepDecryptStepDetailsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_file_location: 'outputs.WorkflowInputFileLocation',
                 type: 'WorkflowStepDecryptStepDetailsPropertiesType',
                 name: Optional[str] = None,
                 overwrite_existing: Optional['WorkflowStepDecryptStepDetailsPropertiesOverwriteExisting'] = None,
                 source_file_location: Optional[str] = None):
        """
        Details for a step that performs a file decryption.
        :param 'WorkflowStepDecryptStepDetailsPropertiesType' type: Specifies which encryption method to use.
        :param str name: The name of the step, used as an identifier.
        :param 'WorkflowStepDecryptStepDetailsPropertiesOverwriteExisting' overwrite_existing: A flag that indicates whether or not to overwrite an existing file of the same name. The default is FALSE.
        :param str source_file_location: Specifies which file to use as input to the workflow step.
        """
        pulumi.set(__self__, "destination_file_location", destination_file_location)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overwrite_existing is not None:
            pulumi.set(__self__, "overwrite_existing", overwrite_existing)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter(name="destinationFileLocation")
    def destination_file_location(self) -> 'outputs.WorkflowInputFileLocation':
        return pulumi.get(self, "destination_file_location")

    @property
    @pulumi.getter
    def type(self) -> 'WorkflowStepDecryptStepDetailsPropertiesType':
        """
        Specifies which encryption method to use.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="overwriteExisting")
    def overwrite_existing(self) -> Optional['WorkflowStepDecryptStepDetailsPropertiesOverwriteExisting']:
        """
        A flag that indicates whether or not to overwrite an existing file of the same name. The default is FALSE.
        """
        return pulumi.get(self, "overwrite_existing")

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[str]:
        """
        Specifies which file to use as input to the workflow step.
        """
        return pulumi.get(self, "source_file_location")


@pulumi.output_type
class WorkflowStepDeleteStepDetailsProperties(dict):
    """
    Details for a step that deletes the file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceFileLocation":
            suggest = "source_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowStepDeleteStepDetailsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowStepDeleteStepDetailsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowStepDeleteStepDetailsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 source_file_location: Optional[str] = None):
        """
        Details for a step that deletes the file.
        :param str name: The name of the step, used as an identifier.
        :param str source_file_location: Specifies which file to use as input to the workflow step.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[str]:
        """
        Specifies which file to use as input to the workflow step.
        """
        return pulumi.get(self, "source_file_location")


@pulumi.output_type
class WorkflowStepTagStepDetailsProperties(dict):
    """
    Details for a step that creates one or more tags.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceFileLocation":
            suggest = "source_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowStepTagStepDetailsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowStepTagStepDetailsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowStepTagStepDetailsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 source_file_location: Optional[str] = None,
                 tags: Optional[Sequence['outputs.WorkflowS3Tag']] = None):
        """
        Details for a step that creates one or more tags.
        :param str name: The name of the step, used as an identifier.
        :param str source_file_location: Specifies which file to use as input to the workflow step.
        :param Sequence['WorkflowS3Tag'] tags: Array that contains from 1 to 10 key/value pairs.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[str]:
        """
        Specifies which file to use as input to the workflow step.
        """
        return pulumi.get(self, "source_file_location")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.WorkflowS3Tag']]:
        """
        Array that contains from 1 to 10 key/value pairs.
        """
        return pulumi.get(self, "tags")


