# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetProfileResult',
    'AwaitableGetProfileResult',
    'get_profile',
    'get_profile_output',
]

@pulumi.output_type
class GetProfileResult:
    def __init__(__self__, arn=None, as2_id=None, certificate_ids=None, profile_id=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if as2_id and not isinstance(as2_id, str):
            raise TypeError("Expected argument 'as2_id' to be a str")
        pulumi.set(__self__, "as2_id", as2_id)
        if certificate_ids and not isinstance(certificate_ids, list):
            raise TypeError("Expected argument 'certificate_ids' to be a list")
        pulumi.set(__self__, "certificate_ids", certificate_ids)
        if profile_id and not isinstance(profile_id, str):
            raise TypeError("Expected argument 'profile_id' to be a str")
        pulumi.set(__self__, "profile_id", profile_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        Specifies the unique Amazon Resource Name (ARN) for the profile.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="as2Id")
    def as2_id(self) -> Optional[str]:
        """
        AS2 identifier agreed with a trading partner.
        """
        return pulumi.get(self, "as2_id")

    @property
    @pulumi.getter(name="certificateIds")
    def certificate_ids(self) -> Optional[Sequence[str]]:
        """
        List of the certificate IDs associated with this profile to be used for encryption and signing of AS2 messages.
        """
        return pulumi.get(self, "certificate_ids")

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[str]:
        """
        A unique identifier for the profile
        """
        return pulumi.get(self, "profile_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetProfileResult(GetProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProfileResult(
            arn=self.arn,
            as2_id=self.as2_id,
            certificate_ids=self.certificate_ids,
            profile_id=self.profile_id,
            tags=self.tags)


def get_profile(profile_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProfileResult:
    """
    Resource Type definition for AWS::Transfer::Profile


    :param str profile_id: A unique identifier for the profile
    """
    __args__ = dict()
    __args__['profileId'] = profile_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:transfer:getProfile', __args__, opts=opts, typ=GetProfileResult).value

    return AwaitableGetProfileResult(
        arn=pulumi.get(__ret__, 'arn'),
        as2_id=pulumi.get(__ret__, 'as2_id'),
        certificate_ids=pulumi.get(__ret__, 'certificate_ids'),
        profile_id=pulumi.get(__ret__, 'profile_id'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_profile)
def get_profile_output(profile_id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProfileResult]:
    """
    Resource Type definition for AWS::Transfer::Profile


    :param str profile_id: A unique identifier for the profile
    """
    ...
