# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'StateMachineAliasDeploymentPreference',
    'StateMachineAliasRoutingConfigurationVersion',
    'StateMachineCloudWatchLogsLogGroup',
    'StateMachineDefinition',
    'StateMachineLogDestination',
    'StateMachineLoggingConfiguration',
    'StateMachineS3Location',
    'StateMachineTracingConfiguration',
]

@pulumi.output_type
class StateMachineAliasDeploymentPreference(dict):
    """
    The settings to enable gradual state machine deployments.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stateMachineVersionArn":
            suggest = "state_machine_version_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StateMachineAliasDeploymentPreference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StateMachineAliasDeploymentPreference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StateMachineAliasDeploymentPreference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 state_machine_version_arn: str,
                 type: 'StateMachineAliasDeploymentPreferenceType',
                 alarms: Optional[Sequence[str]] = None,
                 interval: Optional[int] = None,
                 percentage: Optional[int] = None):
        """
        The settings to enable gradual state machine deployments.
        :param 'StateMachineAliasDeploymentPreferenceType' type: The type of deployment to perform.
        :param Sequence[str] alarms: A list of CloudWatch alarm names that will be monitored during the deployment. The deployment will fail and rollback if any alarms go into ALARM state.
        :param int interval: The time in minutes between each traffic shifting increment.
        :param int percentage: The percentage of traffic to shift to the new version in each increment.
        """
        pulumi.set(__self__, "state_machine_version_arn", state_machine_version_arn)
        pulumi.set(__self__, "type", type)
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if percentage is not None:
            pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter(name="stateMachineVersionArn")
    def state_machine_version_arn(self) -> str:
        return pulumi.get(self, "state_machine_version_arn")

    @property
    @pulumi.getter
    def type(self) -> 'StateMachineAliasDeploymentPreferenceType':
        """
        The type of deployment to perform.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        """
        A list of CloudWatch alarm names that will be monitored during the deployment. The deployment will fail and rollback if any alarms go into ALARM state.
        """
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        The time in minutes between each traffic shifting increment.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def percentage(self) -> Optional[int]:
        """
        The percentage of traffic to shift to the new version in each increment.
        """
        return pulumi.get(self, "percentage")


@pulumi.output_type
class StateMachineAliasRoutingConfigurationVersion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stateMachineVersionArn":
            suggest = "state_machine_version_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StateMachineAliasRoutingConfigurationVersion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StateMachineAliasRoutingConfigurationVersion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StateMachineAliasRoutingConfigurationVersion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 state_machine_version_arn: str,
                 weight: int):
        """
        :param str state_machine_version_arn: The Amazon Resource Name (ARN) that identifies one or two state machine versions defined in the routing configuration.
        :param int weight: The percentage of traffic you want to route to the state machine version. The sum of the weights in the routing configuration must be equal to 100.
        """
        pulumi.set(__self__, "state_machine_version_arn", state_machine_version_arn)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="stateMachineVersionArn")
    def state_machine_version_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) that identifies one or two state machine versions defined in the routing configuration.
        """
        return pulumi.get(self, "state_machine_version_arn")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        The percentage of traffic you want to route to the state machine version. The sum of the weights in the routing configuration must be equal to 100.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class StateMachineCloudWatchLogsLogGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupArn":
            suggest = "log_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StateMachineCloudWatchLogsLogGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StateMachineCloudWatchLogsLogGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StateMachineCloudWatchLogsLogGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group_arn: Optional[str] = None):
        if log_group_arn is not None:
            pulumi.set(__self__, "log_group_arn", log_group_arn)

    @property
    @pulumi.getter(name="logGroupArn")
    def log_group_arn(self) -> Optional[str]:
        return pulumi.get(self, "log_group_arn")


@pulumi.output_type
class StateMachineDefinition(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class StateMachineLogDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatchLogsLogGroup":
            suggest = "cloud_watch_logs_log_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StateMachineLogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StateMachineLogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StateMachineLogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch_logs_log_group: Optional['outputs.StateMachineCloudWatchLogsLogGroup'] = None):
        if cloud_watch_logs_log_group is not None:
            pulumi.set(__self__, "cloud_watch_logs_log_group", cloud_watch_logs_log_group)

    @property
    @pulumi.getter(name="cloudWatchLogsLogGroup")
    def cloud_watch_logs_log_group(self) -> Optional['outputs.StateMachineCloudWatchLogsLogGroup']:
        return pulumi.get(self, "cloud_watch_logs_log_group")


@pulumi.output_type
class StateMachineLoggingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeExecutionData":
            suggest = "include_execution_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StateMachineLoggingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StateMachineLoggingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StateMachineLoggingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destinations: Optional[Sequence['outputs.StateMachineLogDestination']] = None,
                 include_execution_data: Optional[bool] = None,
                 level: Optional['StateMachineLoggingConfigurationLevel'] = None):
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if include_execution_data is not None:
            pulumi.set(__self__, "include_execution_data", include_execution_data)
        if level is not None:
            pulumi.set(__self__, "level", level)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence['outputs.StateMachineLogDestination']]:
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter(name="includeExecutionData")
    def include_execution_data(self) -> Optional[bool]:
        return pulumi.get(self, "include_execution_data")

    @property
    @pulumi.getter
    def level(self) -> Optional['StateMachineLoggingConfigurationLevel']:
        return pulumi.get(self, "level")


@pulumi.output_type
class StateMachineS3Location(dict):
    def __init__(__self__, *,
                 bucket: str,
                 key: str,
                 version: Optional[str] = None):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        return pulumi.get(self, "version")


@pulumi.output_type
class StateMachineTracingConfiguration(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")


