# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetStateMachineAliasResult',
    'AwaitableGetStateMachineAliasResult',
    'get_state_machine_alias',
    'get_state_machine_alias_output',
]

@pulumi.output_type
class GetStateMachineAliasResult:
    def __init__(__self__, arn=None, description=None, routing_configuration=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if routing_configuration and not isinstance(routing_configuration, list):
            raise TypeError("Expected argument 'routing_configuration' to be a list")
        pulumi.set(__self__, "routing_configuration", routing_configuration)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The ARN of the alias.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        An optional description of the alias.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="routingConfiguration")
    def routing_configuration(self) -> Optional[Sequence['outputs.StateMachineAliasRoutingConfigurationVersion']]:
        return pulumi.get(self, "routing_configuration")


class AwaitableGetStateMachineAliasResult(GetStateMachineAliasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStateMachineAliasResult(
            arn=self.arn,
            description=self.description,
            routing_configuration=self.routing_configuration)


def get_state_machine_alias(arn: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStateMachineAliasResult:
    """
    Resource schema for StateMachineAlias


    :param str arn: The ARN of the alias.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:stepfunctions:getStateMachineAlias', __args__, opts=opts, typ=GetStateMachineAliasResult).value

    return AwaitableGetStateMachineAliasResult(
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        routing_configuration=pulumi.get(__ret__, 'routing_configuration'))


@_utilities.lift_output_func(get_state_machine_alias)
def get_state_machine_alias_output(arn: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetStateMachineAliasResult]:
    """
    Resource schema for StateMachineAlias


    :param str arn: The ARN of the alias.
    """
    ...
