# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'StateMachineAliasDeploymentPreferenceArgs',
    'StateMachineAliasRoutingConfigurationVersionArgs',
    'StateMachineCloudWatchLogsLogGroupArgs',
    'StateMachineDefinitionArgs',
    'StateMachineLogDestinationArgs',
    'StateMachineLoggingConfigurationArgs',
    'StateMachineS3LocationArgs',
    'StateMachineTracingConfigurationArgs',
]

@pulumi.input_type
class StateMachineAliasDeploymentPreferenceArgs:
    def __init__(__self__, *,
                 state_machine_version_arn: pulumi.Input[str],
                 type: pulumi.Input['StateMachineAliasDeploymentPreferenceType'],
                 alarms: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 percentage: Optional[pulumi.Input[int]] = None):
        """
        The settings to enable gradual state machine deployments.
        :param pulumi.Input['StateMachineAliasDeploymentPreferenceType'] type: The type of deployment to perform.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alarms: A list of CloudWatch alarm names that will be monitored during the deployment. The deployment will fail and rollback if any alarms go into ALARM state.
        :param pulumi.Input[int] interval: The time in minutes between each traffic shifting increment.
        :param pulumi.Input[int] percentage: The percentage of traffic to shift to the new version in each increment.
        """
        pulumi.set(__self__, "state_machine_version_arn", state_machine_version_arn)
        pulumi.set(__self__, "type", type)
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if percentage is not None:
            pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter(name="stateMachineVersionArn")
    def state_machine_version_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "state_machine_version_arn")

    @state_machine_version_arn.setter
    def state_machine_version_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "state_machine_version_arn", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['StateMachineAliasDeploymentPreferenceType']:
        """
        The type of deployment to perform.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['StateMachineAliasDeploymentPreferenceType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of CloudWatch alarm names that will be monitored during the deployment. The deployment will fail and rollback if any alarms go into ALARM state.
        """
        return pulumi.get(self, "alarms")

    @alarms.setter
    def alarms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "alarms", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[int]]:
        """
        The time in minutes between each traffic shifting increment.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def percentage(self) -> Optional[pulumi.Input[int]]:
        """
        The percentage of traffic to shift to the new version in each increment.
        """
        return pulumi.get(self, "percentage")

    @percentage.setter
    def percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "percentage", value)


@pulumi.input_type
class StateMachineAliasRoutingConfigurationVersionArgs:
    def __init__(__self__, *,
                 state_machine_version_arn: pulumi.Input[str],
                 weight: pulumi.Input[int]):
        """
        :param pulumi.Input[str] state_machine_version_arn: The Amazon Resource Name (ARN) that identifies one or two state machine versions defined in the routing configuration.
        :param pulumi.Input[int] weight: The percentage of traffic you want to route to the state machine version. The sum of the weights in the routing configuration must be equal to 100.
        """
        pulumi.set(__self__, "state_machine_version_arn", state_machine_version_arn)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="stateMachineVersionArn")
    def state_machine_version_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) that identifies one or two state machine versions defined in the routing configuration.
        """
        return pulumi.get(self, "state_machine_version_arn")

    @state_machine_version_arn.setter
    def state_machine_version_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "state_machine_version_arn", value)

    @property
    @pulumi.getter
    def weight(self) -> pulumi.Input[int]:
        """
        The percentage of traffic you want to route to the state machine version. The sum of the weights in the routing configuration must be equal to 100.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: pulumi.Input[int]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class StateMachineCloudWatchLogsLogGroupArgs:
    def __init__(__self__, *,
                 log_group_arn: Optional[pulumi.Input[str]] = None):
        if log_group_arn is not None:
            pulumi.set(__self__, "log_group_arn", log_group_arn)

    @property
    @pulumi.getter(name="logGroupArn")
    def log_group_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "log_group_arn")

    @log_group_arn.setter
    def log_group_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_group_arn", value)


@pulumi.input_type
class StateMachineDefinitionArgs:
    def __init__(__self__):
        pass


@pulumi.input_type
class StateMachineLogDestinationArgs:
    def __init__(__self__, *,
                 cloud_watch_logs_log_group: Optional[pulumi.Input['StateMachineCloudWatchLogsLogGroupArgs']] = None):
        if cloud_watch_logs_log_group is not None:
            pulumi.set(__self__, "cloud_watch_logs_log_group", cloud_watch_logs_log_group)

    @property
    @pulumi.getter(name="cloudWatchLogsLogGroup")
    def cloud_watch_logs_log_group(self) -> Optional[pulumi.Input['StateMachineCloudWatchLogsLogGroupArgs']]:
        return pulumi.get(self, "cloud_watch_logs_log_group")

    @cloud_watch_logs_log_group.setter
    def cloud_watch_logs_log_group(self, value: Optional[pulumi.Input['StateMachineCloudWatchLogsLogGroupArgs']]):
        pulumi.set(self, "cloud_watch_logs_log_group", value)


@pulumi.input_type
class StateMachineLoggingConfigurationArgs:
    def __init__(__self__, *,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input['StateMachineLogDestinationArgs']]]] = None,
                 include_execution_data: Optional[pulumi.Input[bool]] = None,
                 level: Optional[pulumi.Input['StateMachineLoggingConfigurationLevel']] = None):
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if include_execution_data is not None:
            pulumi.set(__self__, "include_execution_data", include_execution_data)
        if level is not None:
            pulumi.set(__self__, "level", level)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StateMachineLogDestinationArgs']]]]:
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StateMachineLogDestinationArgs']]]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter(name="includeExecutionData")
    def include_execution_data(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "include_execution_data")

    @include_execution_data.setter
    def include_execution_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_execution_data", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input['StateMachineLoggingConfigurationLevel']]:
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input['StateMachineLoggingConfigurationLevel']]):
        pulumi.set(self, "level", value)


@pulumi.input_type
class StateMachineS3LocationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 key: pulumi.Input[str],
                 version: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class StateMachineTracingConfigurationArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


