# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = ['ContactChannelArgs', 'ContactChannel']

@pulumi.input_type
class ContactChannelArgs:
    def __init__(__self__, *,
                 channel_address: Optional[pulumi.Input[str]] = None,
                 channel_name: Optional[pulumi.Input[str]] = None,
                 channel_type: Optional[pulumi.Input['ContactChannelChannelType']] = None,
                 contact_id: Optional[pulumi.Input[str]] = None,
                 defer_activation: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a ContactChannel resource.
        :param pulumi.Input[str] channel_address: The details that SSM Incident Manager uses when trying to engage the contact channel.
        :param pulumi.Input[str] channel_name: The device name. String of 6 to 50 alphabetical, numeric, dash, and underscore characters.
        :param pulumi.Input['ContactChannelChannelType'] channel_type: Device type, which specify notification channel. Currently supported values: "SMS", "VOICE", "EMAIL", "CHATBOT.
        :param pulumi.Input[str] contact_id: ARN of the contact resource
        :param pulumi.Input[bool] defer_activation: If you want to activate the channel at a later time, you can choose to defer activation. SSM Incident Manager can't engage your contact channel until it has been activated.
        """
        if channel_address is not None:
            pulumi.set(__self__, "channel_address", channel_address)
        if channel_name is not None:
            pulumi.set(__self__, "channel_name", channel_name)
        if channel_type is not None:
            pulumi.set(__self__, "channel_type", channel_type)
        if contact_id is not None:
            pulumi.set(__self__, "contact_id", contact_id)
        if defer_activation is not None:
            pulumi.set(__self__, "defer_activation", defer_activation)

    @property
    @pulumi.getter(name="channelAddress")
    def channel_address(self) -> Optional[pulumi.Input[str]]:
        """
        The details that SSM Incident Manager uses when trying to engage the contact channel.
        """
        return pulumi.get(self, "channel_address")

    @channel_address.setter
    def channel_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "channel_address", value)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> Optional[pulumi.Input[str]]:
        """
        The device name. String of 6 to 50 alphabetical, numeric, dash, and underscore characters.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter(name="channelType")
    def channel_type(self) -> Optional[pulumi.Input['ContactChannelChannelType']]:
        """
        Device type, which specify notification channel. Currently supported values: "SMS", "VOICE", "EMAIL", "CHATBOT.
        """
        return pulumi.get(self, "channel_type")

    @channel_type.setter
    def channel_type(self, value: Optional[pulumi.Input['ContactChannelChannelType']]):
        pulumi.set(self, "channel_type", value)

    @property
    @pulumi.getter(name="contactId")
    def contact_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the contact resource
        """
        return pulumi.get(self, "contact_id")

    @contact_id.setter
    def contact_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contact_id", value)

    @property
    @pulumi.getter(name="deferActivation")
    def defer_activation(self) -> Optional[pulumi.Input[bool]]:
        """
        If you want to activate the channel at a later time, you can choose to defer activation. SSM Incident Manager can't engage your contact channel until it has been activated.
        """
        return pulumi.get(self, "defer_activation")

    @defer_activation.setter
    def defer_activation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "defer_activation", value)


class ContactChannel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel_address: Optional[pulumi.Input[str]] = None,
                 channel_name: Optional[pulumi.Input[str]] = None,
                 channel_type: Optional[pulumi.Input['ContactChannelChannelType']] = None,
                 contact_id: Optional[pulumi.Input[str]] = None,
                 defer_activation: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SSMContacts::ContactChannel

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] channel_address: The details that SSM Incident Manager uses when trying to engage the contact channel.
        :param pulumi.Input[str] channel_name: The device name. String of 6 to 50 alphabetical, numeric, dash, and underscore characters.
        :param pulumi.Input['ContactChannelChannelType'] channel_type: Device type, which specify notification channel. Currently supported values: "SMS", "VOICE", "EMAIL", "CHATBOT.
        :param pulumi.Input[str] contact_id: ARN of the contact resource
        :param pulumi.Input[bool] defer_activation: If you want to activate the channel at a later time, you can choose to defer activation. SSM Incident Manager can't engage your contact channel until it has been activated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ContactChannelArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SSMContacts::ContactChannel

        :param str resource_name: The name of the resource.
        :param ContactChannelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContactChannelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel_address: Optional[pulumi.Input[str]] = None,
                 channel_name: Optional[pulumi.Input[str]] = None,
                 channel_type: Optional[pulumi.Input['ContactChannelChannelType']] = None,
                 contact_id: Optional[pulumi.Input[str]] = None,
                 defer_activation: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContactChannelArgs.__new__(ContactChannelArgs)

            __props__.__dict__["channel_address"] = channel_address
            __props__.__dict__["channel_name"] = channel_name
            __props__.__dict__["channel_type"] = channel_type
            __props__.__dict__["contact_id"] = contact_id
            __props__.__dict__["defer_activation"] = defer_activation
            __props__.__dict__["arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["channelType", "contactId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ContactChannel, __self__).__init__(
            'aws-native:ssmcontacts:ContactChannel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ContactChannel':
        """
        Get an existing ContactChannel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ContactChannelArgs.__new__(ContactChannelArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["channel_address"] = None
        __props__.__dict__["channel_name"] = None
        __props__.__dict__["channel_type"] = None
        __props__.__dict__["contact_id"] = None
        __props__.__dict__["defer_activation"] = None
        return ContactChannel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the engagement to a contact channel.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="channelAddress")
    def channel_address(self) -> pulumi.Output[Optional[str]]:
        """
        The details that SSM Incident Manager uses when trying to engage the contact channel.
        """
        return pulumi.get(self, "channel_address")

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Output[Optional[str]]:
        """
        The device name. String of 6 to 50 alphabetical, numeric, dash, and underscore characters.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter(name="channelType")
    def channel_type(self) -> pulumi.Output[Optional['ContactChannelChannelType']]:
        """
        Device type, which specify notification channel. Currently supported values: "SMS", "VOICE", "EMAIL", "CHATBOT.
        """
        return pulumi.get(self, "channel_type")

    @property
    @pulumi.getter(name="contactId")
    def contact_id(self) -> pulumi.Output[Optional[str]]:
        """
        ARN of the contact resource
        """
        return pulumi.get(self, "contact_id")

    @property
    @pulumi.getter(name="deferActivation")
    def defer_activation(self) -> pulumi.Output[Optional[bool]]:
        """
        If you want to activate the channel at a later time, you can choose to defer activation. SSM Incident Manager can't engage your contact channel until it has been activated.
        """
        return pulumi.get(self, "defer_activation")

