# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetQueueInlinePolicyResult',
    'AwaitableGetQueueInlinePolicyResult',
    'get_queue_inline_policy',
    'get_queue_inline_policy_output',
]

@pulumi.output_type
class GetQueueInlinePolicyResult:
    def __init__(__self__, policy_document=None):
        if policy_document and not isinstance(policy_document, dict):
            raise TypeError("Expected argument 'policy_document' to be a dict")
        pulumi.set(__self__, "policy_document", policy_document)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Optional[Any]:
        """
        A policy document that contains permissions to add to the specified SQS queue

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SQS::QueueInlinePolicy` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "policy_document")


class AwaitableGetQueueInlinePolicyResult(GetQueueInlinePolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQueueInlinePolicyResult(
            policy_document=self.policy_document)


def get_queue_inline_policy(queue: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQueueInlinePolicyResult:
    """
    Schema for SQS QueueInlinePolicy


    :param str queue: The URL of the SQS queue.
    """
    __args__ = dict()
    __args__['queue'] = queue
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:sqs:getQueueInlinePolicy', __args__, opts=opts, typ=GetQueueInlinePolicyResult).value

    return AwaitableGetQueueInlinePolicyResult(
        policy_document=pulumi.get(__ret__, 'policy_document'))


@_utilities.lift_output_func(get_queue_inline_policy)
def get_queue_inline_policy_output(queue: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetQueueInlinePolicyResult]:
    """
    Schema for SQS QueueInlinePolicy


    :param str queue: The URL of the SQS queue.
    """
    ...
