# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'TopicLoggingConfig',
    'TopicSubscription',
]

@pulumi.output_type
class TopicLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureFeedbackRoleArn":
            suggest = "failure_feedback_role_arn"
        elif key == "successFeedbackRoleArn":
            suggest = "success_feedback_role_arn"
        elif key == "successFeedbackSampleRate":
            suggest = "success_feedback_sample_rate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TopicLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TopicLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TopicLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol: 'TopicLoggingConfigProtocol',
                 failure_feedback_role_arn: Optional[str] = None,
                 success_feedback_role_arn: Optional[str] = None,
                 success_feedback_sample_rate: Optional[str] = None):
        pulumi.set(__self__, "protocol", protocol)
        if failure_feedback_role_arn is not None:
            pulumi.set(__self__, "failure_feedback_role_arn", failure_feedback_role_arn)
        if success_feedback_role_arn is not None:
            pulumi.set(__self__, "success_feedback_role_arn", success_feedback_role_arn)
        if success_feedback_sample_rate is not None:
            pulumi.set(__self__, "success_feedback_sample_rate", success_feedback_sample_rate)

    @property
    @pulumi.getter
    def protocol(self) -> 'TopicLoggingConfigProtocol':
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="failureFeedbackRoleArn")
    def failure_feedback_role_arn(self) -> Optional[str]:
        return pulumi.get(self, "failure_feedback_role_arn")

    @property
    @pulumi.getter(name="successFeedbackRoleArn")
    def success_feedback_role_arn(self) -> Optional[str]:
        return pulumi.get(self, "success_feedback_role_arn")

    @property
    @pulumi.getter(name="successFeedbackSampleRate")
    def success_feedback_sample_rate(self) -> Optional[str]:
        return pulumi.get(self, "success_feedback_sample_rate")


@pulumi.output_type
class TopicSubscription(dict):
    """
    ``Subscription`` is an embedded property that describes the subscription endpoints of an SNS topic.
      For full control over subscription behavior (for example, delivery policy, filtering, raw message delivery, and cross-region subscriptions), use the [AWS::SNS::Subscription](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html) resource.
    """
    def __init__(__self__, *,
                 endpoint: str,
                 protocol: str):
        """
        ``Subscription`` is an embedded property that describes the subscription endpoints of an SNS topic.
          For full control over subscription behavior (for example, delivery policy, filtering, raw message delivery, and cross-region subscriptions), use the [AWS::SNS::Subscription](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html) resource.
        :param str endpoint: The endpoint that receives notifications from the SNS topic. The endpoint value depends on the protocol that you specify. For more information, see the ``Endpoint`` parameter of the ``Subscribe`` action in the *API Reference*.
        :param str protocol: The subscription's protocol. For more information, see the ``Protocol`` parameter of the ``Subscribe`` action in the *API Reference*.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        The endpoint that receives notifications from the SNS topic. The endpoint value depends on the protocol that you specify. For more information, see the ``Endpoint`` parameter of the ``Subscribe`` action in the *API Reference*.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The subscription's protocol. For more information, see the ``Protocol`` parameter of the ``Subscribe`` action in the *API Reference*.
        """
        return pulumi.get(self, "protocol")


