# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ProactiveEngagementArgs', 'ProactiveEngagement']

@pulumi.input_type
class ProactiveEngagementArgs:
    def __init__(__self__, *,
                 emergency_contact_list: pulumi.Input[Sequence[pulumi.Input['ProactiveEngagementEmergencyContactArgs']]],
                 proactive_engagement_status: pulumi.Input['ProactiveEngagementStatus']):
        """
        The set of arguments for constructing a ProactiveEngagement resource.
        :param pulumi.Input[Sequence[pulumi.Input['ProactiveEngagementEmergencyContactArgs']]] emergency_contact_list: A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for escalations to the SRT and to initiate proactive customer support.
               To enable proactive engagement, the contact list must include at least one phone number.
        :param pulumi.Input['ProactiveEngagementStatus'] proactive_engagement_status: If `ENABLED`, the Shield Response Team (SRT) will use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.
               If `DISABLED`, the SRT will not proactively notify contacts about escalations or to initiate proactive customer support.
        """
        pulumi.set(__self__, "emergency_contact_list", emergency_contact_list)
        pulumi.set(__self__, "proactive_engagement_status", proactive_engagement_status)

    @property
    @pulumi.getter(name="emergencyContactList")
    def emergency_contact_list(self) -> pulumi.Input[Sequence[pulumi.Input['ProactiveEngagementEmergencyContactArgs']]]:
        """
        A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for escalations to the SRT and to initiate proactive customer support.
        To enable proactive engagement, the contact list must include at least one phone number.
        """
        return pulumi.get(self, "emergency_contact_list")

    @emergency_contact_list.setter
    def emergency_contact_list(self, value: pulumi.Input[Sequence[pulumi.Input['ProactiveEngagementEmergencyContactArgs']]]):
        pulumi.set(self, "emergency_contact_list", value)

    @property
    @pulumi.getter(name="proactiveEngagementStatus")
    def proactive_engagement_status(self) -> pulumi.Input['ProactiveEngagementStatus']:
        """
        If `ENABLED`, the Shield Response Team (SRT) will use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.
        If `DISABLED`, the SRT will not proactively notify contacts about escalations or to initiate proactive customer support.
        """
        return pulumi.get(self, "proactive_engagement_status")

    @proactive_engagement_status.setter
    def proactive_engagement_status(self, value: pulumi.Input['ProactiveEngagementStatus']):
        pulumi.set(self, "proactive_engagement_status", value)


class ProactiveEngagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 emergency_contact_list: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProactiveEngagementEmergencyContactArgs']]]]] = None,
                 proactive_engagement_status: Optional[pulumi.Input['ProactiveEngagementStatus']] = None,
                 __props__=None):
        """
        Authorizes the Shield Response Team (SRT) to use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProactiveEngagementEmergencyContactArgs']]]] emergency_contact_list: A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for escalations to the SRT and to initiate proactive customer support.
               To enable proactive engagement, the contact list must include at least one phone number.
        :param pulumi.Input['ProactiveEngagementStatus'] proactive_engagement_status: If `ENABLED`, the Shield Response Team (SRT) will use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.
               If `DISABLED`, the SRT will not proactively notify contacts about escalations or to initiate proactive customer support.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProactiveEngagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Authorizes the Shield Response Team (SRT) to use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.

        :param str resource_name: The name of the resource.
        :param ProactiveEngagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProactiveEngagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 emergency_contact_list: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProactiveEngagementEmergencyContactArgs']]]]] = None,
                 proactive_engagement_status: Optional[pulumi.Input['ProactiveEngagementStatus']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProactiveEngagementArgs.__new__(ProactiveEngagementArgs)

            if emergency_contact_list is None and not opts.urn:
                raise TypeError("Missing required property 'emergency_contact_list'")
            __props__.__dict__["emergency_contact_list"] = emergency_contact_list
            if proactive_engagement_status is None and not opts.urn:
                raise TypeError("Missing required property 'proactive_engagement_status'")
            __props__.__dict__["proactive_engagement_status"] = proactive_engagement_status
            __props__.__dict__["account_id"] = None
        super(ProactiveEngagement, __self__).__init__(
            'aws-native:shield:ProactiveEngagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ProactiveEngagement':
        """
        Get an existing ProactiveEngagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ProactiveEngagementArgs.__new__(ProactiveEngagementArgs)

        __props__.__dict__["account_id"] = None
        __props__.__dict__["emergency_contact_list"] = None
        __props__.__dict__["proactive_engagement_status"] = None
        return ProactiveEngagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="emergencyContactList")
    def emergency_contact_list(self) -> pulumi.Output[Sequence['outputs.ProactiveEngagementEmergencyContact']]:
        """
        A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for escalations to the SRT and to initiate proactive customer support.
        To enable proactive engagement, the contact list must include at least one phone number.
        """
        return pulumi.get(self, "emergency_contact_list")

    @property
    @pulumi.getter(name="proactiveEngagementStatus")
    def proactive_engagement_status(self) -> pulumi.Output['ProactiveEngagementStatus']:
        """
        If `ENABLED`, the Shield Response Team (SRT) will use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.
        If `DISABLED`, the SRT will not proactively notify contacts about escalations or to initiate proactive customer support.
        """
        return pulumi.get(self, "proactive_engagement_status")

