# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetProtectionGroupResult',
    'AwaitableGetProtectionGroupResult',
    'get_protection_group',
    'get_protection_group_output',
]

@pulumi.output_type
class GetProtectionGroupResult:
    def __init__(__self__, aggregation=None, members=None, pattern=None, protection_group_arn=None, resource_type=None, tags=None):
        if aggregation and not isinstance(aggregation, str):
            raise TypeError("Expected argument 'aggregation' to be a str")
        pulumi.set(__self__, "aggregation", aggregation)
        if members and not isinstance(members, list):
            raise TypeError("Expected argument 'members' to be a list")
        pulumi.set(__self__, "members", members)
        if pattern and not isinstance(pattern, str):
            raise TypeError("Expected argument 'pattern' to be a str")
        pulumi.set(__self__, "pattern", pattern)
        if protection_group_arn and not isinstance(protection_group_arn, str):
            raise TypeError("Expected argument 'protection_group_arn' to be a str")
        pulumi.set(__self__, "protection_group_arn", protection_group_arn)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def aggregation(self) -> Optional['ProtectionGroupAggregation']:
        """
        Defines how AWS Shield combines resource data for the group in order to detect, mitigate, and report events.
        * Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP addresses for EC2 instances that scale manually or automatically.
        * Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic uniformly. Examples include accelerators and load balancers.
        * Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront and origin resources for CloudFront distributions.
        """
        return pulumi.get(self, "aggregation")

    @property
    @pulumi.getter
    def members(self) -> Optional[Sequence[str]]:
        """
        The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you set `Pattern` to `ARBITRARY` and you must not set it for any other `Pattern` setting.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def pattern(self) -> Optional['ProtectionGroupPattern']:
        """
        The criteria to use to choose the protected resources for inclusion in the group. You can include all resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all resources of a specified resource type.
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter(name="protectionGroupArn")
    def protection_group_arn(self) -> Optional[str]:
        """
        The ARN (Amazon Resource Name) of the protection group.
        """
        return pulumi.get(self, "protection_group_arn")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional['ProtectionGroupResourceType']:
        """
        The resource type to include in the protection group. All protected resources of this type are included in the protection group. Newly protected resources of this type are automatically added to the group. You must set this when you set `Pattern` to `BY_RESOURCE_TYPE` and you must not set it for any other `Pattern` setting.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        One or more tag key-value pairs for the Protection object.
        """
        return pulumi.get(self, "tags")


class AwaitableGetProtectionGroupResult(GetProtectionGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProtectionGroupResult(
            aggregation=self.aggregation,
            members=self.members,
            pattern=self.pattern,
            protection_group_arn=self.protection_group_arn,
            resource_type=self.resource_type,
            tags=self.tags)


def get_protection_group(protection_group_arn: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProtectionGroupResult:
    """
    A grouping of protected resources so they can be handled as a collective. This resource grouping improves the accuracy of detection and reduces false positives.


    :param str protection_group_arn: The ARN (Amazon Resource Name) of the protection group.
    """
    __args__ = dict()
    __args__['protectionGroupArn'] = protection_group_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:shield:getProtectionGroup', __args__, opts=opts, typ=GetProtectionGroupResult).value

    return AwaitableGetProtectionGroupResult(
        aggregation=pulumi.get(__ret__, 'aggregation'),
        members=pulumi.get(__ret__, 'members'),
        pattern=pulumi.get(__ret__, 'pattern'),
        protection_group_arn=pulumi.get(__ret__, 'protection_group_arn'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_protection_group)
def get_protection_group_output(protection_group_arn: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProtectionGroupResult]:
    """
    A grouping of protected resources so they can be handled as a collective. This resource grouping improves the accuracy of detection and reduces false positives.


    :param str protection_group_arn: The ARN (Amazon Resource Name) of the protection group.
    """
    ...
