# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetProactiveEngagementResult',
    'AwaitableGetProactiveEngagementResult',
    'get_proactive_engagement',
    'get_proactive_engagement_output',
]

@pulumi.output_type
class GetProactiveEngagementResult:
    def __init__(__self__, account_id=None, emergency_contact_list=None, proactive_engagement_status=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if emergency_contact_list and not isinstance(emergency_contact_list, list):
            raise TypeError("Expected argument 'emergency_contact_list' to be a list")
        pulumi.set(__self__, "emergency_contact_list", emergency_contact_list)
        if proactive_engagement_status and not isinstance(proactive_engagement_status, str):
            raise TypeError("Expected argument 'proactive_engagement_status' to be a str")
        pulumi.set(__self__, "proactive_engagement_status", proactive_engagement_status)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[str]:
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="emergencyContactList")
    def emergency_contact_list(self) -> Optional[Sequence['outputs.ProactiveEngagementEmergencyContact']]:
        """
        A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for escalations to the SRT and to initiate proactive customer support.
        To enable proactive engagement, the contact list must include at least one phone number.
        """
        return pulumi.get(self, "emergency_contact_list")

    @property
    @pulumi.getter(name="proactiveEngagementStatus")
    def proactive_engagement_status(self) -> Optional['ProactiveEngagementStatus']:
        """
        If `ENABLED`, the Shield Response Team (SRT) will use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.
        If `DISABLED`, the SRT will not proactively notify contacts about escalations or to initiate proactive customer support.
        """
        return pulumi.get(self, "proactive_engagement_status")


class AwaitableGetProactiveEngagementResult(GetProactiveEngagementResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProactiveEngagementResult(
            account_id=self.account_id,
            emergency_contact_list=self.emergency_contact_list,
            proactive_engagement_status=self.proactive_engagement_status)


def get_proactive_engagement(account_id: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProactiveEngagementResult:
    """
    Authorizes the Shield Response Team (SRT) to use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:shield:getProactiveEngagement', __args__, opts=opts, typ=GetProactiveEngagementResult).value

    return AwaitableGetProactiveEngagementResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        emergency_contact_list=pulumi.get(__ret__, 'emergency_contact_list'),
        proactive_engagement_status=pulumi.get(__ret__, 'proactive_engagement_status'))


@_utilities.lift_output_func(get_proactive_engagement)
def get_proactive_engagement_output(account_id: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProactiveEngagementResult]:
    """
    Authorizes the Shield Response Team (SRT) to use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.
    """
    ...
