# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ConfigurationSetDashboardOptions',
    'ConfigurationSetDeliveryOptions',
    'ConfigurationSetEventDestinationCloudWatchDestination',
    'ConfigurationSetEventDestinationDimensionConfiguration',
    'ConfigurationSetEventDestinationEventDestination',
    'ConfigurationSetEventDestinationKinesisFirehoseDestination',
    'ConfigurationSetEventDestinationSnsDestination',
    'ConfigurationSetGuardianOptions',
    'ConfigurationSetReputationOptions',
    'ConfigurationSetSendingOptions',
    'ConfigurationSetSuppressionOptions',
    'ConfigurationSetTrackingOptions',
    'ConfigurationSetVdmOptions',
    'ContactListTopic',
    'EmailIdentityConfigurationSetAttributes',
    'EmailIdentityDkimAttributes',
    'EmailIdentityDkimSigningAttributes',
    'EmailIdentityFeedbackAttributes',
    'EmailIdentityMailFromAttributes',
    'Template',
    'VdmAttributesDashboardAttributes',
    'VdmAttributesGuardianAttributes',
]

@pulumi.output_type
class ConfigurationSetDashboardOptions(dict):
    """
    Preferences regarding the Dashboard feature.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "engagementMetrics":
            suggest = "engagement_metrics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationSetDashboardOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationSetDashboardOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationSetDashboardOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 engagement_metrics: str):
        """
        Preferences regarding the Dashboard feature.
        :param str engagement_metrics: Whether emails sent with this configuration set have engagement tracking enabled.
        """
        pulumi.set(__self__, "engagement_metrics", engagement_metrics)

    @property
    @pulumi.getter(name="engagementMetrics")
    def engagement_metrics(self) -> str:
        """
        Whether emails sent with this configuration set have engagement tracking enabled.
        """
        return pulumi.get(self, "engagement_metrics")


@pulumi.output_type
class ConfigurationSetDeliveryOptions(dict):
    """
    An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sendingPoolName":
            suggest = "sending_pool_name"
        elif key == "tlsPolicy":
            suggest = "tls_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationSetDeliveryOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationSetDeliveryOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationSetDeliveryOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sending_pool_name: Optional[str] = None,
                 tls_policy: Optional[str] = None):
        """
        An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.
        :param str sending_pool_name: The name of the dedicated IP pool to associate with the configuration set.
        :param str tls_policy: Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is Require , messages are only delivered if a TLS connection can be established. If the value is Optional , messages can be delivered in plain text if a TLS connection can't be established.
        """
        if sending_pool_name is not None:
            pulumi.set(__self__, "sending_pool_name", sending_pool_name)
        if tls_policy is not None:
            pulumi.set(__self__, "tls_policy", tls_policy)

    @property
    @pulumi.getter(name="sendingPoolName")
    def sending_pool_name(self) -> Optional[str]:
        """
        The name of the dedicated IP pool to associate with the configuration set.
        """
        return pulumi.get(self, "sending_pool_name")

    @property
    @pulumi.getter(name="tlsPolicy")
    def tls_policy(self) -> Optional[str]:
        """
        Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is Require , messages are only delivered if a TLS connection can be established. If the value is Optional , messages can be delivered in plain text if a TLS connection can't be established.
        """
        return pulumi.get(self, "tls_policy")


@pulumi.output_type
class ConfigurationSetEventDestinationCloudWatchDestination(dict):
    """
    An object that contains the names, default values, and sources of the dimensions associated with an Amazon CloudWatch event destination.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dimensionConfigurations":
            suggest = "dimension_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationSetEventDestinationCloudWatchDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationSetEventDestinationCloudWatchDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationSetEventDestinationCloudWatchDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimension_configurations: Optional[Sequence['outputs.ConfigurationSetEventDestinationDimensionConfiguration']] = None):
        """
        An object that contains the names, default values, and sources of the dimensions associated with an Amazon CloudWatch event destination.
        :param Sequence['ConfigurationSetEventDestinationDimensionConfiguration'] dimension_configurations: A list of dimensions upon which to categorize your emails when you publish email sending events to Amazon CloudWatch.
        """
        if dimension_configurations is not None:
            pulumi.set(__self__, "dimension_configurations", dimension_configurations)

    @property
    @pulumi.getter(name="dimensionConfigurations")
    def dimension_configurations(self) -> Optional[Sequence['outputs.ConfigurationSetEventDestinationDimensionConfiguration']]:
        """
        A list of dimensions upon which to categorize your emails when you publish email sending events to Amazon CloudWatch.
        """
        return pulumi.get(self, "dimension_configurations")


@pulumi.output_type
class ConfigurationSetEventDestinationDimensionConfiguration(dict):
    """
    A list of dimensions upon which to categorize your emails when you publish email sending events to Amazon CloudWatch.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultDimensionValue":
            suggest = "default_dimension_value"
        elif key == "dimensionName":
            suggest = "dimension_name"
        elif key == "dimensionValueSource":
            suggest = "dimension_value_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationSetEventDestinationDimensionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationSetEventDestinationDimensionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationSetEventDestinationDimensionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_dimension_value: str,
                 dimension_name: str,
                 dimension_value_source: str):
        """
        A list of dimensions upon which to categorize your emails when you publish email sending events to Amazon CloudWatch.
        :param str default_dimension_value: The default value of the dimension that is published to Amazon CloudWatch if you do not provide the value of the dimension when you send an email.
        :param str dimension_name: The name of an Amazon CloudWatch dimension associated with an email sending metric.
        :param str dimension_value_source: The place where Amazon SES finds the value of a dimension to publish to Amazon CloudWatch. To use the message tags that you specify using an X-SES-MESSAGE-TAGS header or a parameter to the SendEmail/SendRawEmail API, specify messageTag. To use your own email headers, specify emailHeader. To put a custom tag on any link included in your email, specify linkTag.
        """
        pulumi.set(__self__, "default_dimension_value", default_dimension_value)
        pulumi.set(__self__, "dimension_name", dimension_name)
        pulumi.set(__self__, "dimension_value_source", dimension_value_source)

    @property
    @pulumi.getter(name="defaultDimensionValue")
    def default_dimension_value(self) -> str:
        """
        The default value of the dimension that is published to Amazon CloudWatch if you do not provide the value of the dimension when you send an email.
        """
        return pulumi.get(self, "default_dimension_value")

    @property
    @pulumi.getter(name="dimensionName")
    def dimension_name(self) -> str:
        """
        The name of an Amazon CloudWatch dimension associated with an email sending metric.
        """
        return pulumi.get(self, "dimension_name")

    @property
    @pulumi.getter(name="dimensionValueSource")
    def dimension_value_source(self) -> str:
        """
        The place where Amazon SES finds the value of a dimension to publish to Amazon CloudWatch. To use the message tags that you specify using an X-SES-MESSAGE-TAGS header or a parameter to the SendEmail/SendRawEmail API, specify messageTag. To use your own email headers, specify emailHeader. To put a custom tag on any link included in your email, specify linkTag.
        """
        return pulumi.get(self, "dimension_value_source")


@pulumi.output_type
class ConfigurationSetEventDestinationEventDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchingEventTypes":
            suggest = "matching_event_types"
        elif key == "cloudWatchDestination":
            suggest = "cloud_watch_destination"
        elif key == "kinesisFirehoseDestination":
            suggest = "kinesis_firehose_destination"
        elif key == "snsDestination":
            suggest = "sns_destination"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationSetEventDestinationEventDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationSetEventDestinationEventDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationSetEventDestinationEventDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 matching_event_types: Sequence[str],
                 cloud_watch_destination: Optional['outputs.ConfigurationSetEventDestinationCloudWatchDestination'] = None,
                 enabled: Optional[bool] = None,
                 kinesis_firehose_destination: Optional['outputs.ConfigurationSetEventDestinationKinesisFirehoseDestination'] = None,
                 name: Optional[str] = None,
                 sns_destination: Optional['outputs.ConfigurationSetEventDestinationSnsDestination'] = None):
        """
        :param Sequence[str] matching_event_types: The type of email sending events, send, reject, bounce, complaint, delivery, open, click, renderingFailure, deliveryDelay, and subscription.
        :param 'ConfigurationSetEventDestinationCloudWatchDestination' cloud_watch_destination: An object that contains the names, default values, and sources of the dimensions associated with an Amazon CloudWatch event destination.
        :param bool enabled: Sets whether Amazon SES publishes events to this destination when you send an email with the associated configuration set. Set to true to enable publishing to this destination; set to false to prevent publishing to this destination. The default value is false.   
        :param 'ConfigurationSetEventDestinationKinesisFirehoseDestination' kinesis_firehose_destination: An object that contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.
        :param str name: The name of the event destination set.
        :param 'ConfigurationSetEventDestinationSnsDestination' sns_destination: An object that contains SNS topic ARN associated event destination.
        """
        pulumi.set(__self__, "matching_event_types", matching_event_types)
        if cloud_watch_destination is not None:
            pulumi.set(__self__, "cloud_watch_destination", cloud_watch_destination)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if kinesis_firehose_destination is not None:
            pulumi.set(__self__, "kinesis_firehose_destination", kinesis_firehose_destination)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sns_destination is not None:
            pulumi.set(__self__, "sns_destination", sns_destination)

    @property
    @pulumi.getter(name="matchingEventTypes")
    def matching_event_types(self) -> Sequence[str]:
        """
        The type of email sending events, send, reject, bounce, complaint, delivery, open, click, renderingFailure, deliveryDelay, and subscription.
        """
        return pulumi.get(self, "matching_event_types")

    @property
    @pulumi.getter(name="cloudWatchDestination")
    def cloud_watch_destination(self) -> Optional['outputs.ConfigurationSetEventDestinationCloudWatchDestination']:
        """
        An object that contains the names, default values, and sources of the dimensions associated with an Amazon CloudWatch event destination.
        """
        return pulumi.get(self, "cloud_watch_destination")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Sets whether Amazon SES publishes events to this destination when you send an email with the associated configuration set. Set to true to enable publishing to this destination; set to false to prevent publishing to this destination. The default value is false.   
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="kinesisFirehoseDestination")
    def kinesis_firehose_destination(self) -> Optional['outputs.ConfigurationSetEventDestinationKinesisFirehoseDestination']:
        """
        An object that contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.
        """
        return pulumi.get(self, "kinesis_firehose_destination")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the event destination set.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="snsDestination")
    def sns_destination(self) -> Optional['outputs.ConfigurationSetEventDestinationSnsDestination']:
        """
        An object that contains SNS topic ARN associated event destination.
        """
        return pulumi.get(self, "sns_destination")


@pulumi.output_type
class ConfigurationSetEventDestinationKinesisFirehoseDestination(dict):
    """
    An object that contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deliveryStreamArn":
            suggest = "delivery_stream_arn"
        elif key == "iamRoleArn":
            suggest = "iam_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationSetEventDestinationKinesisFirehoseDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationSetEventDestinationKinesisFirehoseDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationSetEventDestinationKinesisFirehoseDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delivery_stream_arn: str,
                 iam_role_arn: str):
        """
        An object that contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.
        :param str delivery_stream_arn: The ARN of the Amazon Kinesis Firehose stream that email sending events should be published to.
        :param str iam_role_arn: The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis Firehose stream.
        """
        pulumi.set(__self__, "delivery_stream_arn", delivery_stream_arn)
        pulumi.set(__self__, "iam_role_arn", iam_role_arn)

    @property
    @pulumi.getter(name="deliveryStreamArn")
    def delivery_stream_arn(self) -> str:
        """
        The ARN of the Amazon Kinesis Firehose stream that email sending events should be published to.
        """
        return pulumi.get(self, "delivery_stream_arn")

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> str:
        """
        The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis Firehose stream.
        """
        return pulumi.get(self, "iam_role_arn")


@pulumi.output_type
class ConfigurationSetEventDestinationSnsDestination(dict):
    """
    An object that contains SNS topic ARN associated event destination.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topicArn":
            suggest = "topic_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationSetEventDestinationSnsDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationSetEventDestinationSnsDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationSetEventDestinationSnsDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 topic_arn: str):
        """
        An object that contains SNS topic ARN associated event destination.
        """
        pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> str:
        return pulumi.get(self, "topic_arn")


@pulumi.output_type
class ConfigurationSetGuardianOptions(dict):
    """
    Preferences regarding the Guardian feature.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "optimizedSharedDelivery":
            suggest = "optimized_shared_delivery"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationSetGuardianOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationSetGuardianOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationSetGuardianOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 optimized_shared_delivery: str):
        """
        Preferences regarding the Guardian feature.
        :param str optimized_shared_delivery: Whether emails sent with this configuration set have optimized delivery algorithm enabled.
        """
        pulumi.set(__self__, "optimized_shared_delivery", optimized_shared_delivery)

    @property
    @pulumi.getter(name="optimizedSharedDelivery")
    def optimized_shared_delivery(self) -> str:
        """
        Whether emails sent with this configuration set have optimized delivery algorithm enabled.
        """
        return pulumi.get(self, "optimized_shared_delivery")


@pulumi.output_type
class ConfigurationSetReputationOptions(dict):
    """
    An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reputationMetricsEnabled":
            suggest = "reputation_metrics_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationSetReputationOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationSetReputationOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationSetReputationOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reputation_metrics_enabled: Optional[bool] = None):
        """
        An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.
        :param bool reputation_metrics_enabled: If true , tracking of reputation metrics is enabled for the configuration set. If false , tracking of reputation metrics is disabled for the configuration set.
        """
        if reputation_metrics_enabled is not None:
            pulumi.set(__self__, "reputation_metrics_enabled", reputation_metrics_enabled)

    @property
    @pulumi.getter(name="reputationMetricsEnabled")
    def reputation_metrics_enabled(self) -> Optional[bool]:
        """
        If true , tracking of reputation metrics is enabled for the configuration set. If false , tracking of reputation metrics is disabled for the configuration set.
        """
        return pulumi.get(self, "reputation_metrics_enabled")


@pulumi.output_type
class ConfigurationSetSendingOptions(dict):
    """
    An object that defines whether or not Amazon SES can send email that you send using the configuration set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sendingEnabled":
            suggest = "sending_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationSetSendingOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationSetSendingOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationSetSendingOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sending_enabled: Optional[bool] = None):
        """
        An object that defines whether or not Amazon SES can send email that you send using the configuration set.
        """
        if sending_enabled is not None:
            pulumi.set(__self__, "sending_enabled", sending_enabled)

    @property
    @pulumi.getter(name="sendingEnabled")
    def sending_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "sending_enabled")


@pulumi.output_type
class ConfigurationSetSuppressionOptions(dict):
    """
    An object that contains information about the suppression list preferences for your account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "suppressedReasons":
            suggest = "suppressed_reasons"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationSetSuppressionOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationSetSuppressionOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationSetSuppressionOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 suppressed_reasons: Optional[Sequence[str]] = None):
        """
        An object that contains information about the suppression list preferences for your account.
        :param Sequence[str] suppressed_reasons: A list that contains the reasons that email addresses are automatically added to the suppression list for your account.
        """
        if suppressed_reasons is not None:
            pulumi.set(__self__, "suppressed_reasons", suppressed_reasons)

    @property
    @pulumi.getter(name="suppressedReasons")
    def suppressed_reasons(self) -> Optional[Sequence[str]]:
        """
        A list that contains the reasons that email addresses are automatically added to the suppression list for your account.
        """
        return pulumi.get(self, "suppressed_reasons")


@pulumi.output_type
class ConfigurationSetTrackingOptions(dict):
    """
    An object that defines the open and click tracking options for emails that you send using the configuration set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRedirectDomain":
            suggest = "custom_redirect_domain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationSetTrackingOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationSetTrackingOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationSetTrackingOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_redirect_domain: Optional[str] = None):
        """
        An object that defines the open and click tracking options for emails that you send using the configuration set.
        :param str custom_redirect_domain: The domain to use for tracking open and click events.
        """
        if custom_redirect_domain is not None:
            pulumi.set(__self__, "custom_redirect_domain", custom_redirect_domain)

    @property
    @pulumi.getter(name="customRedirectDomain")
    def custom_redirect_domain(self) -> Optional[str]:
        """
        The domain to use for tracking open and click events.
        """
        return pulumi.get(self, "custom_redirect_domain")


@pulumi.output_type
class ConfigurationSetVdmOptions(dict):
    """
    An object that contains Virtual Deliverability Manager (VDM) settings for this configuration set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dashboardOptions":
            suggest = "dashboard_options"
        elif key == "guardianOptions":
            suggest = "guardian_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationSetVdmOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationSetVdmOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationSetVdmOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dashboard_options: Optional['outputs.ConfigurationSetDashboardOptions'] = None,
                 guardian_options: Optional['outputs.ConfigurationSetGuardianOptions'] = None):
        """
        An object that contains Virtual Deliverability Manager (VDM) settings for this configuration set.
        """
        if dashboard_options is not None:
            pulumi.set(__self__, "dashboard_options", dashboard_options)
        if guardian_options is not None:
            pulumi.set(__self__, "guardian_options", guardian_options)

    @property
    @pulumi.getter(name="dashboardOptions")
    def dashboard_options(self) -> Optional['outputs.ConfigurationSetDashboardOptions']:
        return pulumi.get(self, "dashboard_options")

    @property
    @pulumi.getter(name="guardianOptions")
    def guardian_options(self) -> Optional['outputs.ConfigurationSetGuardianOptions']:
        return pulumi.get(self, "guardian_options")


@pulumi.output_type
class ContactListTopic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultSubscriptionStatus":
            suggest = "default_subscription_status"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "topicName":
            suggest = "topic_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactListTopic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactListTopic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactListTopic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_subscription_status: str,
                 display_name: str,
                 topic_name: str,
                 description: Optional[str] = None):
        """
        :param str display_name: The display name of the topic.
        :param str topic_name: The name of the topic.
        :param str description: The description of the topic.
        """
        pulumi.set(__self__, "default_subscription_status", default_subscription_status)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "topic_name", topic_name)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="defaultSubscriptionStatus")
    def default_subscription_status(self) -> str:
        return pulumi.get(self, "default_subscription_status")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the topic.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> str:
        """
        The name of the topic.
        """
        return pulumi.get(self, "topic_name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the topic.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class EmailIdentityConfigurationSetAttributes(dict):
    """
    Used to associate a configuration set with an email identity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationSetName":
            suggest = "configuration_set_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmailIdentityConfigurationSetAttributes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmailIdentityConfigurationSetAttributes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmailIdentityConfigurationSetAttributes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_set_name: Optional[str] = None):
        """
        Used to associate a configuration set with an email identity.
        :param str configuration_set_name: The configuration set to use by default when sending from this identity. Note that any configuration set defined in the email sending request takes precedence.
        """
        if configuration_set_name is not None:
            pulumi.set(__self__, "configuration_set_name", configuration_set_name)

    @property
    @pulumi.getter(name="configurationSetName")
    def configuration_set_name(self) -> Optional[str]:
        """
        The configuration set to use by default when sending from this identity. Note that any configuration set defined in the email sending request takes precedence.
        """
        return pulumi.get(self, "configuration_set_name")


@pulumi.output_type
class EmailIdentityDkimAttributes(dict):
    """
    Used to enable or disable DKIM authentication for an email identity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "signingEnabled":
            suggest = "signing_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmailIdentityDkimAttributes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmailIdentityDkimAttributes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmailIdentityDkimAttributes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 signing_enabled: Optional[bool] = None):
        """
        Used to enable or disable DKIM authentication for an email identity.
        :param bool signing_enabled: Sets the DKIM signing configuration for the identity. When you set this value true, then the messages that are sent from the identity are signed using DKIM. If you set this value to false, your messages are sent without DKIM signing.
        """
        if signing_enabled is not None:
            pulumi.set(__self__, "signing_enabled", signing_enabled)

    @property
    @pulumi.getter(name="signingEnabled")
    def signing_enabled(self) -> Optional[bool]:
        """
        Sets the DKIM signing configuration for the identity. When you set this value true, then the messages that are sent from the identity are signed using DKIM. If you set this value to false, your messages are sent without DKIM signing.
        """
        return pulumi.get(self, "signing_enabled")


@pulumi.output_type
class EmailIdentityDkimSigningAttributes(dict):
    """
    If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for Easy DKIM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainSigningPrivateKey":
            suggest = "domain_signing_private_key"
        elif key == "domainSigningSelector":
            suggest = "domain_signing_selector"
        elif key == "nextSigningKeyLength":
            suggest = "next_signing_key_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmailIdentityDkimSigningAttributes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmailIdentityDkimSigningAttributes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmailIdentityDkimSigningAttributes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_signing_private_key: Optional[str] = None,
                 domain_signing_selector: Optional[str] = None,
                 next_signing_key_length: Optional[str] = None):
        """
        If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for Easy DKIM.
        :param str domain_signing_private_key: [Bring Your Own DKIM] A private key that's used to generate a DKIM signature. The private key must use 1024 or 2048-bit RSA encryption, and must be encoded using base64 encoding.
        :param str domain_signing_selector: [Bring Your Own DKIM] A string that's used to identify a public key in the DNS configuration for a domain.
        :param str next_signing_key_length: [Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per day.
        """
        if domain_signing_private_key is not None:
            pulumi.set(__self__, "domain_signing_private_key", domain_signing_private_key)
        if domain_signing_selector is not None:
            pulumi.set(__self__, "domain_signing_selector", domain_signing_selector)
        if next_signing_key_length is not None:
            pulumi.set(__self__, "next_signing_key_length", next_signing_key_length)

    @property
    @pulumi.getter(name="domainSigningPrivateKey")
    def domain_signing_private_key(self) -> Optional[str]:
        """
        [Bring Your Own DKIM] A private key that's used to generate a DKIM signature. The private key must use 1024 or 2048-bit RSA encryption, and must be encoded using base64 encoding.
        """
        return pulumi.get(self, "domain_signing_private_key")

    @property
    @pulumi.getter(name="domainSigningSelector")
    def domain_signing_selector(self) -> Optional[str]:
        """
        [Bring Your Own DKIM] A string that's used to identify a public key in the DNS configuration for a domain.
        """
        return pulumi.get(self, "domain_signing_selector")

    @property
    @pulumi.getter(name="nextSigningKeyLength")
    def next_signing_key_length(self) -> Optional[str]:
        """
        [Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per day.
        """
        return pulumi.get(self, "next_signing_key_length")


@pulumi.output_type
class EmailIdentityFeedbackAttributes(dict):
    """
    Used to enable or disable feedback forwarding for an identity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailForwardingEnabled":
            suggest = "email_forwarding_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmailIdentityFeedbackAttributes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmailIdentityFeedbackAttributes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmailIdentityFeedbackAttributes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_forwarding_enabled: Optional[bool] = None):
        """
        Used to enable or disable feedback forwarding for an identity.
        :param bool email_forwarding_enabled: If the value is true, you receive email notifications when bounce or complaint events occur
        """
        if email_forwarding_enabled is not None:
            pulumi.set(__self__, "email_forwarding_enabled", email_forwarding_enabled)

    @property
    @pulumi.getter(name="emailForwardingEnabled")
    def email_forwarding_enabled(self) -> Optional[bool]:
        """
        If the value is true, you receive email notifications when bounce or complaint events occur
        """
        return pulumi.get(self, "email_forwarding_enabled")


@pulumi.output_type
class EmailIdentityMailFromAttributes(dict):
    """
    Used to enable or disable the custom Mail-From domain configuration for an email identity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "behaviorOnMxFailure":
            suggest = "behavior_on_mx_failure"
        elif key == "mailFromDomain":
            suggest = "mail_from_domain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmailIdentityMailFromAttributes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmailIdentityMailFromAttributes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmailIdentityMailFromAttributes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 behavior_on_mx_failure: Optional[str] = None,
                 mail_from_domain: Optional[str] = None):
        """
        Used to enable or disable the custom Mail-From domain configuration for an email identity.
        :param str behavior_on_mx_failure: The action to take if the required MX record isn't found when you send an email. When you set this value to UseDefaultValue , the mail is sent using amazonses.com as the MAIL FROM domain. When you set this value to RejectMessage , the Amazon SES API v2 returns a MailFromDomainNotVerified error, and doesn't attempt to deliver the email.
        :param str mail_from_domain: The custom MAIL FROM domain that you want the verified identity to use
        """
        if behavior_on_mx_failure is not None:
            pulumi.set(__self__, "behavior_on_mx_failure", behavior_on_mx_failure)
        if mail_from_domain is not None:
            pulumi.set(__self__, "mail_from_domain", mail_from_domain)

    @property
    @pulumi.getter(name="behaviorOnMxFailure")
    def behavior_on_mx_failure(self) -> Optional[str]:
        """
        The action to take if the required MX record isn't found when you send an email. When you set this value to UseDefaultValue , the mail is sent using amazonses.com as the MAIL FROM domain. When you set this value to RejectMessage , the Amazon SES API v2 returns a MailFromDomainNotVerified error, and doesn't attempt to deliver the email.
        """
        return pulumi.get(self, "behavior_on_mx_failure")

    @property
    @pulumi.getter(name="mailFromDomain")
    def mail_from_domain(self) -> Optional[str]:
        """
        The custom MAIL FROM domain that you want the verified identity to use
        """
        return pulumi.get(self, "mail_from_domain")


@pulumi.output_type
class Template(dict):
    """
    The content of the email, composed of a subject line, an HTML part, and a text-only part
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subjectPart":
            suggest = "subject_part"
        elif key == "htmlPart":
            suggest = "html_part"
        elif key == "templateName":
            suggest = "template_name"
        elif key == "textPart":
            suggest = "text_part"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Template. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Template.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Template.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subject_part: str,
                 html_part: Optional[str] = None,
                 template_name: Optional[str] = None,
                 text_part: Optional[str] = None):
        """
        The content of the email, composed of a subject line, an HTML part, and a text-only part
        :param str subject_part: The subject line of the email.
        :param str html_part: The HTML body of the email.
        :param str template_name: The name of the template.
        :param str text_part: The email body that is visible to recipients whose email clients do not display HTML content.
        """
        pulumi.set(__self__, "subject_part", subject_part)
        if html_part is not None:
            pulumi.set(__self__, "html_part", html_part)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)
        if text_part is not None:
            pulumi.set(__self__, "text_part", text_part)

    @property
    @pulumi.getter(name="subjectPart")
    def subject_part(self) -> str:
        """
        The subject line of the email.
        """
        return pulumi.get(self, "subject_part")

    @property
    @pulumi.getter(name="htmlPart")
    def html_part(self) -> Optional[str]:
        """
        The HTML body of the email.
        """
        return pulumi.get(self, "html_part")

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[str]:
        """
        The name of the template.
        """
        return pulumi.get(self, "template_name")

    @property
    @pulumi.getter(name="textPart")
    def text_part(self) -> Optional[str]:
        """
        The email body that is visible to recipients whose email clients do not display HTML content.
        """
        return pulumi.get(self, "text_part")


@pulumi.output_type
class VdmAttributesDashboardAttributes(dict):
    """
    Preferences regarding the Dashboard feature.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "engagementMetrics":
            suggest = "engagement_metrics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VdmAttributesDashboardAttributes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VdmAttributesDashboardAttributes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VdmAttributesDashboardAttributes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 engagement_metrics: Optional[str] = None):
        """
        Preferences regarding the Dashboard feature.
        :param str engagement_metrics: Whether emails sent from this account have engagement tracking enabled.
        """
        if engagement_metrics is not None:
            pulumi.set(__self__, "engagement_metrics", engagement_metrics)

    @property
    @pulumi.getter(name="engagementMetrics")
    def engagement_metrics(self) -> Optional[str]:
        """
        Whether emails sent from this account have engagement tracking enabled.
        """
        return pulumi.get(self, "engagement_metrics")


@pulumi.output_type
class VdmAttributesGuardianAttributes(dict):
    """
    Preferences regarding the Guardian feature.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "optimizedSharedDelivery":
            suggest = "optimized_shared_delivery"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VdmAttributesGuardianAttributes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VdmAttributesGuardianAttributes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VdmAttributesGuardianAttributes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 optimized_shared_delivery: Optional[str] = None):
        """
        Preferences regarding the Guardian feature.
        :param str optimized_shared_delivery: Whether emails sent from this account have optimized delivery algorithm enabled.
        """
        if optimized_shared_delivery is not None:
            pulumi.set(__self__, "optimized_shared_delivery", optimized_shared_delivery)

    @property
    @pulumi.getter(name="optimizedSharedDelivery")
    def optimized_shared_delivery(self) -> Optional[str]:
        """
        Whether emails sent from this account have optimized delivery algorithm enabled.
        """
        return pulumi.get(self, "optimized_shared_delivery")


