# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetDedicatedIpPoolResult',
    'AwaitableGetDedicatedIpPoolResult',
    'get_dedicated_ip_pool',
    'get_dedicated_ip_pool_output',
]

@pulumi.output_type
class GetDedicatedIpPoolResult:
    def __init__(__self__, scaling_mode=None):
        if scaling_mode and not isinstance(scaling_mode, str):
            raise TypeError("Expected argument 'scaling_mode' to be a str")
        pulumi.set(__self__, "scaling_mode", scaling_mode)

    @property
    @pulumi.getter(name="scalingMode")
    def scaling_mode(self) -> Optional[str]:
        """
        Specifies whether the dedicated IP pool is managed or not. The default value is STANDARD.
        """
        return pulumi.get(self, "scaling_mode")


class AwaitableGetDedicatedIpPoolResult(GetDedicatedIpPoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDedicatedIpPoolResult(
            scaling_mode=self.scaling_mode)


def get_dedicated_ip_pool(pool_name: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDedicatedIpPoolResult:
    """
    Resource Type definition for AWS::SES::DedicatedIpPool


    :param str pool_name: The name of the dedicated IP pool.
    """
    __args__ = dict()
    __args__['poolName'] = pool_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ses:getDedicatedIpPool', __args__, opts=opts, typ=GetDedicatedIpPoolResult).value

    return AwaitableGetDedicatedIpPoolResult(
        scaling_mode=pulumi.get(__ret__, 'scaling_mode'))


@_utilities.lift_output_func(get_dedicated_ip_pool)
def get_dedicated_ip_pool_output(pool_name: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDedicatedIpPoolResult]:
    """
    Resource Type definition for AWS::SES::DedicatedIpPool


    :param str pool_name: The name of the dedicated IP pool.
    """
    ...
