# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigurationSetEventDestinationArgs', 'ConfigurationSetEventDestination']

@pulumi.input_type
class ConfigurationSetEventDestinationArgs:
    def __init__(__self__, *,
                 configuration_set_name: pulumi.Input[str],
                 event_destination: pulumi.Input['ConfigurationSetEventDestinationEventDestinationArgs']):
        """
        The set of arguments for constructing a ConfigurationSetEventDestination resource.
        :param pulumi.Input[str] configuration_set_name: The name of the configuration set that contains the event destination.
        :param pulumi.Input['ConfigurationSetEventDestinationEventDestinationArgs'] event_destination: The event destination object.
        """
        pulumi.set(__self__, "configuration_set_name", configuration_set_name)
        pulumi.set(__self__, "event_destination", event_destination)

    @property
    @pulumi.getter(name="configurationSetName")
    def configuration_set_name(self) -> pulumi.Input[str]:
        """
        The name of the configuration set that contains the event destination.
        """
        return pulumi.get(self, "configuration_set_name")

    @configuration_set_name.setter
    def configuration_set_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "configuration_set_name", value)

    @property
    @pulumi.getter(name="eventDestination")
    def event_destination(self) -> pulumi.Input['ConfigurationSetEventDestinationEventDestinationArgs']:
        """
        The event destination object.
        """
        return pulumi.get(self, "event_destination")

    @event_destination.setter
    def event_destination(self, value: pulumi.Input['ConfigurationSetEventDestinationEventDestinationArgs']):
        pulumi.set(self, "event_destination", value)


class ConfigurationSetEventDestination(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_set_name: Optional[pulumi.Input[str]] = None,
                 event_destination: Optional[pulumi.Input[pulumi.InputType['ConfigurationSetEventDestinationEventDestinationArgs']]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SES::ConfigurationSetEventDestination

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] configuration_set_name: The name of the configuration set that contains the event destination.
        :param pulumi.Input[pulumi.InputType['ConfigurationSetEventDestinationEventDestinationArgs']] event_destination: The event destination object.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigurationSetEventDestinationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SES::ConfigurationSetEventDestination

        :param str resource_name: The name of the resource.
        :param ConfigurationSetEventDestinationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigurationSetEventDestinationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_set_name: Optional[pulumi.Input[str]] = None,
                 event_destination: Optional[pulumi.Input[pulumi.InputType['ConfigurationSetEventDestinationEventDestinationArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigurationSetEventDestinationArgs.__new__(ConfigurationSetEventDestinationArgs)

            if configuration_set_name is None and not opts.urn:
                raise TypeError("Missing required property 'configuration_set_name'")
            __props__.__dict__["configuration_set_name"] = configuration_set_name
            if event_destination is None and not opts.urn:
                raise TypeError("Missing required property 'event_destination'")
            __props__.__dict__["event_destination"] = event_destination
            __props__.__dict__["aws_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["configurationSetName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ConfigurationSetEventDestination, __self__).__init__(
            'aws-native:ses:ConfigurationSetEventDestination',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ConfigurationSetEventDestination':
        """
        Get an existing ConfigurationSetEventDestination resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ConfigurationSetEventDestinationArgs.__new__(ConfigurationSetEventDestinationArgs)

        __props__.__dict__["aws_id"] = None
        __props__.__dict__["configuration_set_name"] = None
        __props__.__dict__["event_destination"] = None
        return ConfigurationSetEventDestination(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="configurationSetName")
    def configuration_set_name(self) -> pulumi.Output[str]:
        """
        The name of the configuration set that contains the event destination.
        """
        return pulumi.get(self, "configuration_set_name")

    @property
    @pulumi.getter(name="eventDestination")
    def event_destination(self) -> pulumi.Output['outputs.ConfigurationSetEventDestinationEventDestination']:
        """
        The event destination object.
        """
        return pulumi.get(self, "event_destination")

