# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ConfigurationSetDashboardOptionsArgs',
    'ConfigurationSetDeliveryOptionsArgs',
    'ConfigurationSetEventDestinationCloudWatchDestinationArgs',
    'ConfigurationSetEventDestinationDimensionConfigurationArgs',
    'ConfigurationSetEventDestinationEventDestinationArgs',
    'ConfigurationSetEventDestinationKinesisFirehoseDestinationArgs',
    'ConfigurationSetEventDestinationSnsDestinationArgs',
    'ConfigurationSetGuardianOptionsArgs',
    'ConfigurationSetReputationOptionsArgs',
    'ConfigurationSetSendingOptionsArgs',
    'ConfigurationSetSuppressionOptionsArgs',
    'ConfigurationSetTrackingOptionsArgs',
    'ConfigurationSetVdmOptionsArgs',
    'ContactListTopicArgs',
    'EmailIdentityConfigurationSetAttributesArgs',
    'EmailIdentityDkimAttributesArgs',
    'EmailIdentityDkimSigningAttributesArgs',
    'EmailIdentityFeedbackAttributesArgs',
    'EmailIdentityMailFromAttributesArgs',
    'TemplateArgs',
    'VdmAttributesDashboardAttributesArgs',
    'VdmAttributesGuardianAttributesArgs',
]

@pulumi.input_type
class ConfigurationSetDashboardOptionsArgs:
    def __init__(__self__, *,
                 engagement_metrics: pulumi.Input[str]):
        """
        Preferences regarding the Dashboard feature.
        :param pulumi.Input[str] engagement_metrics: Whether emails sent with this configuration set have engagement tracking enabled.
        """
        pulumi.set(__self__, "engagement_metrics", engagement_metrics)

    @property
    @pulumi.getter(name="engagementMetrics")
    def engagement_metrics(self) -> pulumi.Input[str]:
        """
        Whether emails sent with this configuration set have engagement tracking enabled.
        """
        return pulumi.get(self, "engagement_metrics")

    @engagement_metrics.setter
    def engagement_metrics(self, value: pulumi.Input[str]):
        pulumi.set(self, "engagement_metrics", value)


@pulumi.input_type
class ConfigurationSetDeliveryOptionsArgs:
    def __init__(__self__, *,
                 sending_pool_name: Optional[pulumi.Input[str]] = None,
                 tls_policy: Optional[pulumi.Input[str]] = None):
        """
        An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.
        :param pulumi.Input[str] sending_pool_name: The name of the dedicated IP pool to associate with the configuration set.
        :param pulumi.Input[str] tls_policy: Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is Require , messages are only delivered if a TLS connection can be established. If the value is Optional , messages can be delivered in plain text if a TLS connection can't be established.
        """
        if sending_pool_name is not None:
            pulumi.set(__self__, "sending_pool_name", sending_pool_name)
        if tls_policy is not None:
            pulumi.set(__self__, "tls_policy", tls_policy)

    @property
    @pulumi.getter(name="sendingPoolName")
    def sending_pool_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the dedicated IP pool to associate with the configuration set.
        """
        return pulumi.get(self, "sending_pool_name")

    @sending_pool_name.setter
    def sending_pool_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sending_pool_name", value)

    @property
    @pulumi.getter(name="tlsPolicy")
    def tls_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is Require , messages are only delivered if a TLS connection can be established. If the value is Optional , messages can be delivered in plain text if a TLS connection can't be established.
        """
        return pulumi.get(self, "tls_policy")

    @tls_policy.setter
    def tls_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_policy", value)


@pulumi.input_type
class ConfigurationSetEventDestinationCloudWatchDestinationArgs:
    def __init__(__self__, *,
                 dimension_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationSetEventDestinationDimensionConfigurationArgs']]]] = None):
        """
        An object that contains the names, default values, and sources of the dimensions associated with an Amazon CloudWatch event destination.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationSetEventDestinationDimensionConfigurationArgs']]] dimension_configurations: A list of dimensions upon which to categorize your emails when you publish email sending events to Amazon CloudWatch.
        """
        if dimension_configurations is not None:
            pulumi.set(__self__, "dimension_configurations", dimension_configurations)

    @property
    @pulumi.getter(name="dimensionConfigurations")
    def dimension_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationSetEventDestinationDimensionConfigurationArgs']]]]:
        """
        A list of dimensions upon which to categorize your emails when you publish email sending events to Amazon CloudWatch.
        """
        return pulumi.get(self, "dimension_configurations")

    @dimension_configurations.setter
    def dimension_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationSetEventDestinationDimensionConfigurationArgs']]]]):
        pulumi.set(self, "dimension_configurations", value)


@pulumi.input_type
class ConfigurationSetEventDestinationDimensionConfigurationArgs:
    def __init__(__self__, *,
                 default_dimension_value: pulumi.Input[str],
                 dimension_name: pulumi.Input[str],
                 dimension_value_source: pulumi.Input[str]):
        """
        A list of dimensions upon which to categorize your emails when you publish email sending events to Amazon CloudWatch.
        :param pulumi.Input[str] default_dimension_value: The default value of the dimension that is published to Amazon CloudWatch if you do not provide the value of the dimension when you send an email.
        :param pulumi.Input[str] dimension_name: The name of an Amazon CloudWatch dimension associated with an email sending metric.
        :param pulumi.Input[str] dimension_value_source: The place where Amazon SES finds the value of a dimension to publish to Amazon CloudWatch. To use the message tags that you specify using an X-SES-MESSAGE-TAGS header or a parameter to the SendEmail/SendRawEmail API, specify messageTag. To use your own email headers, specify emailHeader. To put a custom tag on any link included in your email, specify linkTag.
        """
        pulumi.set(__self__, "default_dimension_value", default_dimension_value)
        pulumi.set(__self__, "dimension_name", dimension_name)
        pulumi.set(__self__, "dimension_value_source", dimension_value_source)

    @property
    @pulumi.getter(name="defaultDimensionValue")
    def default_dimension_value(self) -> pulumi.Input[str]:
        """
        The default value of the dimension that is published to Amazon CloudWatch if you do not provide the value of the dimension when you send an email.
        """
        return pulumi.get(self, "default_dimension_value")

    @default_dimension_value.setter
    def default_dimension_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "default_dimension_value", value)

    @property
    @pulumi.getter(name="dimensionName")
    def dimension_name(self) -> pulumi.Input[str]:
        """
        The name of an Amazon CloudWatch dimension associated with an email sending metric.
        """
        return pulumi.get(self, "dimension_name")

    @dimension_name.setter
    def dimension_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "dimension_name", value)

    @property
    @pulumi.getter(name="dimensionValueSource")
    def dimension_value_source(self) -> pulumi.Input[str]:
        """
        The place where Amazon SES finds the value of a dimension to publish to Amazon CloudWatch. To use the message tags that you specify using an X-SES-MESSAGE-TAGS header or a parameter to the SendEmail/SendRawEmail API, specify messageTag. To use your own email headers, specify emailHeader. To put a custom tag on any link included in your email, specify linkTag.
        """
        return pulumi.get(self, "dimension_value_source")

    @dimension_value_source.setter
    def dimension_value_source(self, value: pulumi.Input[str]):
        pulumi.set(self, "dimension_value_source", value)


@pulumi.input_type
class ConfigurationSetEventDestinationEventDestinationArgs:
    def __init__(__self__, *,
                 matching_event_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 cloud_watch_destination: Optional[pulumi.Input['ConfigurationSetEventDestinationCloudWatchDestinationArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 kinesis_firehose_destination: Optional[pulumi.Input['ConfigurationSetEventDestinationKinesisFirehoseDestinationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sns_destination: Optional[pulumi.Input['ConfigurationSetEventDestinationSnsDestinationArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] matching_event_types: The type of email sending events, send, reject, bounce, complaint, delivery, open, click, renderingFailure, deliveryDelay, and subscription.
        :param pulumi.Input['ConfigurationSetEventDestinationCloudWatchDestinationArgs'] cloud_watch_destination: An object that contains the names, default values, and sources of the dimensions associated with an Amazon CloudWatch event destination.
        :param pulumi.Input[bool] enabled: Sets whether Amazon SES publishes events to this destination when you send an email with the associated configuration set. Set to true to enable publishing to this destination; set to false to prevent publishing to this destination. The default value is false.   
        :param pulumi.Input['ConfigurationSetEventDestinationKinesisFirehoseDestinationArgs'] kinesis_firehose_destination: An object that contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.
        :param pulumi.Input[str] name: The name of the event destination set.
        :param pulumi.Input['ConfigurationSetEventDestinationSnsDestinationArgs'] sns_destination: An object that contains SNS topic ARN associated event destination.
        """
        pulumi.set(__self__, "matching_event_types", matching_event_types)
        if cloud_watch_destination is not None:
            pulumi.set(__self__, "cloud_watch_destination", cloud_watch_destination)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if kinesis_firehose_destination is not None:
            pulumi.set(__self__, "kinesis_firehose_destination", kinesis_firehose_destination)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sns_destination is not None:
            pulumi.set(__self__, "sns_destination", sns_destination)

    @property
    @pulumi.getter(name="matchingEventTypes")
    def matching_event_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The type of email sending events, send, reject, bounce, complaint, delivery, open, click, renderingFailure, deliveryDelay, and subscription.
        """
        return pulumi.get(self, "matching_event_types")

    @matching_event_types.setter
    def matching_event_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "matching_event_types", value)

    @property
    @pulumi.getter(name="cloudWatchDestination")
    def cloud_watch_destination(self) -> Optional[pulumi.Input['ConfigurationSetEventDestinationCloudWatchDestinationArgs']]:
        """
        An object that contains the names, default values, and sources of the dimensions associated with an Amazon CloudWatch event destination.
        """
        return pulumi.get(self, "cloud_watch_destination")

    @cloud_watch_destination.setter
    def cloud_watch_destination(self, value: Optional[pulumi.Input['ConfigurationSetEventDestinationCloudWatchDestinationArgs']]):
        pulumi.set(self, "cloud_watch_destination", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Sets whether Amazon SES publishes events to this destination when you send an email with the associated configuration set. Set to true to enable publishing to this destination; set to false to prevent publishing to this destination. The default value is false.   
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="kinesisFirehoseDestination")
    def kinesis_firehose_destination(self) -> Optional[pulumi.Input['ConfigurationSetEventDestinationKinesisFirehoseDestinationArgs']]:
        """
        An object that contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.
        """
        return pulumi.get(self, "kinesis_firehose_destination")

    @kinesis_firehose_destination.setter
    def kinesis_firehose_destination(self, value: Optional[pulumi.Input['ConfigurationSetEventDestinationKinesisFirehoseDestinationArgs']]):
        pulumi.set(self, "kinesis_firehose_destination", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the event destination set.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="snsDestination")
    def sns_destination(self) -> Optional[pulumi.Input['ConfigurationSetEventDestinationSnsDestinationArgs']]:
        """
        An object that contains SNS topic ARN associated event destination.
        """
        return pulumi.get(self, "sns_destination")

    @sns_destination.setter
    def sns_destination(self, value: Optional[pulumi.Input['ConfigurationSetEventDestinationSnsDestinationArgs']]):
        pulumi.set(self, "sns_destination", value)


@pulumi.input_type
class ConfigurationSetEventDestinationKinesisFirehoseDestinationArgs:
    def __init__(__self__, *,
                 delivery_stream_arn: pulumi.Input[str],
                 iam_role_arn: pulumi.Input[str]):
        """
        An object that contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.
        :param pulumi.Input[str] delivery_stream_arn: The ARN of the Amazon Kinesis Firehose stream that email sending events should be published to.
        :param pulumi.Input[str] iam_role_arn: The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis Firehose stream.
        """
        pulumi.set(__self__, "delivery_stream_arn", delivery_stream_arn)
        pulumi.set(__self__, "iam_role_arn", iam_role_arn)

    @property
    @pulumi.getter(name="deliveryStreamArn")
    def delivery_stream_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the Amazon Kinesis Firehose stream that email sending events should be published to.
        """
        return pulumi.get(self, "delivery_stream_arn")

    @delivery_stream_arn.setter
    def delivery_stream_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "delivery_stream_arn", value)

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis Firehose stream.
        """
        return pulumi.get(self, "iam_role_arn")

    @iam_role_arn.setter
    def iam_role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "iam_role_arn", value)


@pulumi.input_type
class ConfigurationSetEventDestinationSnsDestinationArgs:
    def __init__(__self__, *,
                 topic_arn: pulumi.Input[str]):
        """
        An object that contains SNS topic ARN associated event destination.
        """
        pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic_arn", value)


@pulumi.input_type
class ConfigurationSetGuardianOptionsArgs:
    def __init__(__self__, *,
                 optimized_shared_delivery: pulumi.Input[str]):
        """
        Preferences regarding the Guardian feature.
        :param pulumi.Input[str] optimized_shared_delivery: Whether emails sent with this configuration set have optimized delivery algorithm enabled.
        """
        pulumi.set(__self__, "optimized_shared_delivery", optimized_shared_delivery)

    @property
    @pulumi.getter(name="optimizedSharedDelivery")
    def optimized_shared_delivery(self) -> pulumi.Input[str]:
        """
        Whether emails sent with this configuration set have optimized delivery algorithm enabled.
        """
        return pulumi.get(self, "optimized_shared_delivery")

    @optimized_shared_delivery.setter
    def optimized_shared_delivery(self, value: pulumi.Input[str]):
        pulumi.set(self, "optimized_shared_delivery", value)


@pulumi.input_type
class ConfigurationSetReputationOptionsArgs:
    def __init__(__self__, *,
                 reputation_metrics_enabled: Optional[pulumi.Input[bool]] = None):
        """
        An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.
        :param pulumi.Input[bool] reputation_metrics_enabled: If true , tracking of reputation metrics is enabled for the configuration set. If false , tracking of reputation metrics is disabled for the configuration set.
        """
        if reputation_metrics_enabled is not None:
            pulumi.set(__self__, "reputation_metrics_enabled", reputation_metrics_enabled)

    @property
    @pulumi.getter(name="reputationMetricsEnabled")
    def reputation_metrics_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true , tracking of reputation metrics is enabled for the configuration set. If false , tracking of reputation metrics is disabled for the configuration set.
        """
        return pulumi.get(self, "reputation_metrics_enabled")

    @reputation_metrics_enabled.setter
    def reputation_metrics_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reputation_metrics_enabled", value)


@pulumi.input_type
class ConfigurationSetSendingOptionsArgs:
    def __init__(__self__, *,
                 sending_enabled: Optional[pulumi.Input[bool]] = None):
        """
        An object that defines whether or not Amazon SES can send email that you send using the configuration set.
        """
        if sending_enabled is not None:
            pulumi.set(__self__, "sending_enabled", sending_enabled)

    @property
    @pulumi.getter(name="sendingEnabled")
    def sending_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "sending_enabled")

    @sending_enabled.setter
    def sending_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sending_enabled", value)


@pulumi.input_type
class ConfigurationSetSuppressionOptionsArgs:
    def __init__(__self__, *,
                 suppressed_reasons: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        An object that contains information about the suppression list preferences for your account.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] suppressed_reasons: A list that contains the reasons that email addresses are automatically added to the suppression list for your account.
        """
        if suppressed_reasons is not None:
            pulumi.set(__self__, "suppressed_reasons", suppressed_reasons)

    @property
    @pulumi.getter(name="suppressedReasons")
    def suppressed_reasons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list that contains the reasons that email addresses are automatically added to the suppression list for your account.
        """
        return pulumi.get(self, "suppressed_reasons")

    @suppressed_reasons.setter
    def suppressed_reasons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "suppressed_reasons", value)


@pulumi.input_type
class ConfigurationSetTrackingOptionsArgs:
    def __init__(__self__, *,
                 custom_redirect_domain: Optional[pulumi.Input[str]] = None):
        """
        An object that defines the open and click tracking options for emails that you send using the configuration set.
        :param pulumi.Input[str] custom_redirect_domain: The domain to use for tracking open and click events.
        """
        if custom_redirect_domain is not None:
            pulumi.set(__self__, "custom_redirect_domain", custom_redirect_domain)

    @property
    @pulumi.getter(name="customRedirectDomain")
    def custom_redirect_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain to use for tracking open and click events.
        """
        return pulumi.get(self, "custom_redirect_domain")

    @custom_redirect_domain.setter
    def custom_redirect_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_redirect_domain", value)


@pulumi.input_type
class ConfigurationSetVdmOptionsArgs:
    def __init__(__self__, *,
                 dashboard_options: Optional[pulumi.Input['ConfigurationSetDashboardOptionsArgs']] = None,
                 guardian_options: Optional[pulumi.Input['ConfigurationSetGuardianOptionsArgs']] = None):
        """
        An object that contains Virtual Deliverability Manager (VDM) settings for this configuration set.
        """
        if dashboard_options is not None:
            pulumi.set(__self__, "dashboard_options", dashboard_options)
        if guardian_options is not None:
            pulumi.set(__self__, "guardian_options", guardian_options)

    @property
    @pulumi.getter(name="dashboardOptions")
    def dashboard_options(self) -> Optional[pulumi.Input['ConfigurationSetDashboardOptionsArgs']]:
        return pulumi.get(self, "dashboard_options")

    @dashboard_options.setter
    def dashboard_options(self, value: Optional[pulumi.Input['ConfigurationSetDashboardOptionsArgs']]):
        pulumi.set(self, "dashboard_options", value)

    @property
    @pulumi.getter(name="guardianOptions")
    def guardian_options(self) -> Optional[pulumi.Input['ConfigurationSetGuardianOptionsArgs']]:
        return pulumi.get(self, "guardian_options")

    @guardian_options.setter
    def guardian_options(self, value: Optional[pulumi.Input['ConfigurationSetGuardianOptionsArgs']]):
        pulumi.set(self, "guardian_options", value)


@pulumi.input_type
class ContactListTopicArgs:
    def __init__(__self__, *,
                 default_subscription_status: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 topic_name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] display_name: The display name of the topic.
        :param pulumi.Input[str] topic_name: The name of the topic.
        :param pulumi.Input[str] description: The description of the topic.
        """
        pulumi.set(__self__, "default_subscription_status", default_subscription_status)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "topic_name", topic_name)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="defaultSubscriptionStatus")
    def default_subscription_status(self) -> pulumi.Input[str]:
        return pulumi.get(self, "default_subscription_status")

    @default_subscription_status.setter
    def default_subscription_status(self, value: pulumi.Input[str]):
        pulumi.set(self, "default_subscription_status", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The display name of the topic.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> pulumi.Input[str]:
        """
        The name of the topic.
        """
        return pulumi.get(self, "topic_name")

    @topic_name.setter
    def topic_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the topic.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class EmailIdentityConfigurationSetAttributesArgs:
    def __init__(__self__, *,
                 configuration_set_name: Optional[pulumi.Input[str]] = None):
        """
        Used to associate a configuration set with an email identity.
        :param pulumi.Input[str] configuration_set_name: The configuration set to use by default when sending from this identity. Note that any configuration set defined in the email sending request takes precedence.
        """
        if configuration_set_name is not None:
            pulumi.set(__self__, "configuration_set_name", configuration_set_name)

    @property
    @pulumi.getter(name="configurationSetName")
    def configuration_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        The configuration set to use by default when sending from this identity. Note that any configuration set defined in the email sending request takes precedence.
        """
        return pulumi.get(self, "configuration_set_name")

    @configuration_set_name.setter
    def configuration_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_set_name", value)


@pulumi.input_type
class EmailIdentityDkimAttributesArgs:
    def __init__(__self__, *,
                 signing_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Used to enable or disable DKIM authentication for an email identity.
        :param pulumi.Input[bool] signing_enabled: Sets the DKIM signing configuration for the identity. When you set this value true, then the messages that are sent from the identity are signed using DKIM. If you set this value to false, your messages are sent without DKIM signing.
        """
        if signing_enabled is not None:
            pulumi.set(__self__, "signing_enabled", signing_enabled)

    @property
    @pulumi.getter(name="signingEnabled")
    def signing_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Sets the DKIM signing configuration for the identity. When you set this value true, then the messages that are sent from the identity are signed using DKIM. If you set this value to false, your messages are sent without DKIM signing.
        """
        return pulumi.get(self, "signing_enabled")

    @signing_enabled.setter
    def signing_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "signing_enabled", value)


@pulumi.input_type
class EmailIdentityDkimSigningAttributesArgs:
    def __init__(__self__, *,
                 domain_signing_private_key: Optional[pulumi.Input[str]] = None,
                 domain_signing_selector: Optional[pulumi.Input[str]] = None,
                 next_signing_key_length: Optional[pulumi.Input[str]] = None):
        """
        If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, or, configures the key length to be used for Easy DKIM.
        :param pulumi.Input[str] domain_signing_private_key: [Bring Your Own DKIM] A private key that's used to generate a DKIM signature. The private key must use 1024 or 2048-bit RSA encryption, and must be encoded using base64 encoding.
        :param pulumi.Input[str] domain_signing_selector: [Bring Your Own DKIM] A string that's used to identify a public key in the DNS configuration for a domain.
        :param pulumi.Input[str] next_signing_key_length: [Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per day.
        """
        if domain_signing_private_key is not None:
            pulumi.set(__self__, "domain_signing_private_key", domain_signing_private_key)
        if domain_signing_selector is not None:
            pulumi.set(__self__, "domain_signing_selector", domain_signing_selector)
        if next_signing_key_length is not None:
            pulumi.set(__self__, "next_signing_key_length", next_signing_key_length)

    @property
    @pulumi.getter(name="domainSigningPrivateKey")
    def domain_signing_private_key(self) -> Optional[pulumi.Input[str]]:
        """
        [Bring Your Own DKIM] A private key that's used to generate a DKIM signature. The private key must use 1024 or 2048-bit RSA encryption, and must be encoded using base64 encoding.
        """
        return pulumi.get(self, "domain_signing_private_key")

    @domain_signing_private_key.setter
    def domain_signing_private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_signing_private_key", value)

    @property
    @pulumi.getter(name="domainSigningSelector")
    def domain_signing_selector(self) -> Optional[pulumi.Input[str]]:
        """
        [Bring Your Own DKIM] A string that's used to identify a public key in the DNS configuration for a domain.
        """
        return pulumi.get(self, "domain_signing_selector")

    @domain_signing_selector.setter
    def domain_signing_selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_signing_selector", value)

    @property
    @pulumi.getter(name="nextSigningKeyLength")
    def next_signing_key_length(self) -> Optional[pulumi.Input[str]]:
        """
        [Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per day.
        """
        return pulumi.get(self, "next_signing_key_length")

    @next_signing_key_length.setter
    def next_signing_key_length(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_signing_key_length", value)


@pulumi.input_type
class EmailIdentityFeedbackAttributesArgs:
    def __init__(__self__, *,
                 email_forwarding_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Used to enable or disable feedback forwarding for an identity.
        :param pulumi.Input[bool] email_forwarding_enabled: If the value is true, you receive email notifications when bounce or complaint events occur
        """
        if email_forwarding_enabled is not None:
            pulumi.set(__self__, "email_forwarding_enabled", email_forwarding_enabled)

    @property
    @pulumi.getter(name="emailForwardingEnabled")
    def email_forwarding_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If the value is true, you receive email notifications when bounce or complaint events occur
        """
        return pulumi.get(self, "email_forwarding_enabled")

    @email_forwarding_enabled.setter
    def email_forwarding_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "email_forwarding_enabled", value)


@pulumi.input_type
class EmailIdentityMailFromAttributesArgs:
    def __init__(__self__, *,
                 behavior_on_mx_failure: Optional[pulumi.Input[str]] = None,
                 mail_from_domain: Optional[pulumi.Input[str]] = None):
        """
        Used to enable or disable the custom Mail-From domain configuration for an email identity.
        :param pulumi.Input[str] behavior_on_mx_failure: The action to take if the required MX record isn't found when you send an email. When you set this value to UseDefaultValue , the mail is sent using amazonses.com as the MAIL FROM domain. When you set this value to RejectMessage , the Amazon SES API v2 returns a MailFromDomainNotVerified error, and doesn't attempt to deliver the email.
        :param pulumi.Input[str] mail_from_domain: The custom MAIL FROM domain that you want the verified identity to use
        """
        if behavior_on_mx_failure is not None:
            pulumi.set(__self__, "behavior_on_mx_failure", behavior_on_mx_failure)
        if mail_from_domain is not None:
            pulumi.set(__self__, "mail_from_domain", mail_from_domain)

    @property
    @pulumi.getter(name="behaviorOnMxFailure")
    def behavior_on_mx_failure(self) -> Optional[pulumi.Input[str]]:
        """
        The action to take if the required MX record isn't found when you send an email. When you set this value to UseDefaultValue , the mail is sent using amazonses.com as the MAIL FROM domain. When you set this value to RejectMessage , the Amazon SES API v2 returns a MailFromDomainNotVerified error, and doesn't attempt to deliver the email.
        """
        return pulumi.get(self, "behavior_on_mx_failure")

    @behavior_on_mx_failure.setter
    def behavior_on_mx_failure(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "behavior_on_mx_failure", value)

    @property
    @pulumi.getter(name="mailFromDomain")
    def mail_from_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The custom MAIL FROM domain that you want the verified identity to use
        """
        return pulumi.get(self, "mail_from_domain")

    @mail_from_domain.setter
    def mail_from_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mail_from_domain", value)


@pulumi.input_type
class TemplateArgs:
    def __init__(__self__, *,
                 subject_part: pulumi.Input[str],
                 html_part: Optional[pulumi.Input[str]] = None,
                 template_name: Optional[pulumi.Input[str]] = None,
                 text_part: Optional[pulumi.Input[str]] = None):
        """
        The content of the email, composed of a subject line, an HTML part, and a text-only part
        :param pulumi.Input[str] subject_part: The subject line of the email.
        :param pulumi.Input[str] html_part: The HTML body of the email.
        :param pulumi.Input[str] template_name: The name of the template.
        :param pulumi.Input[str] text_part: The email body that is visible to recipients whose email clients do not display HTML content.
        """
        pulumi.set(__self__, "subject_part", subject_part)
        if html_part is not None:
            pulumi.set(__self__, "html_part", html_part)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)
        if text_part is not None:
            pulumi.set(__self__, "text_part", text_part)

    @property
    @pulumi.getter(name="subjectPart")
    def subject_part(self) -> pulumi.Input[str]:
        """
        The subject line of the email.
        """
        return pulumi.get(self, "subject_part")

    @subject_part.setter
    def subject_part(self, value: pulumi.Input[str]):
        pulumi.set(self, "subject_part", value)

    @property
    @pulumi.getter(name="htmlPart")
    def html_part(self) -> Optional[pulumi.Input[str]]:
        """
        The HTML body of the email.
        """
        return pulumi.get(self, "html_part")

    @html_part.setter
    def html_part(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "html_part", value)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the template.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_name", value)

    @property
    @pulumi.getter(name="textPart")
    def text_part(self) -> Optional[pulumi.Input[str]]:
        """
        The email body that is visible to recipients whose email clients do not display HTML content.
        """
        return pulumi.get(self, "text_part")

    @text_part.setter
    def text_part(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "text_part", value)


@pulumi.input_type
class VdmAttributesDashboardAttributesArgs:
    def __init__(__self__, *,
                 engagement_metrics: Optional[pulumi.Input[str]] = None):
        """
        Preferences regarding the Dashboard feature.
        :param pulumi.Input[str] engagement_metrics: Whether emails sent from this account have engagement tracking enabled.
        """
        if engagement_metrics is not None:
            pulumi.set(__self__, "engagement_metrics", engagement_metrics)

    @property
    @pulumi.getter(name="engagementMetrics")
    def engagement_metrics(self) -> Optional[pulumi.Input[str]]:
        """
        Whether emails sent from this account have engagement tracking enabled.
        """
        return pulumi.get(self, "engagement_metrics")

    @engagement_metrics.setter
    def engagement_metrics(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engagement_metrics", value)


@pulumi.input_type
class VdmAttributesGuardianAttributesArgs:
    def __init__(__self__, *,
                 optimized_shared_delivery: Optional[pulumi.Input[str]] = None):
        """
        Preferences regarding the Guardian feature.
        :param pulumi.Input[str] optimized_shared_delivery: Whether emails sent from this account have optimized delivery algorithm enabled.
        """
        if optimized_shared_delivery is not None:
            pulumi.set(__self__, "optimized_shared_delivery", optimized_shared_delivery)

    @property
    @pulumi.getter(name="optimizedSharedDelivery")
    def optimized_shared_delivery(self) -> Optional[pulumi.Input[str]]:
        """
        Whether emails sent from this account have optimized delivery algorithm enabled.
        """
        return pulumi.get(self, "optimized_shared_delivery")

    @optimized_shared_delivery.setter
    def optimized_shared_delivery(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "optimized_shared_delivery", value)


