# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DataLakeEncryptionConfiguration',
    'DataLakeExpiration',
    'DataLakeLifecycleConfiguration',
    'DataLakeReplicationConfiguration',
    'DataLakeTransitions',
    'SubscriberAwsLogSource',
    'SubscriberCustomLogSource',
    'SubscriberIdentityProperties',
    'SubscriberSource0Properties',
    'SubscriberSource1Properties',
]

@pulumi.output_type
class DataLakeEncryptionConfiguration(dict):
    """
    Provides encryption details of Amazon Security Lake object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataLakeEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataLakeEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataLakeEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: Optional[str] = None):
        """
        Provides encryption details of Amazon Security Lake object.
        :param str kms_key_id: The id of KMS encryption key used by Amazon Security Lake to encrypt the Security Lake object.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The id of KMS encryption key used by Amazon Security Lake to encrypt the Security Lake object.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class DataLakeExpiration(dict):
    """
    Provides data expiration details of Amazon Security Lake object.
    """
    def __init__(__self__, *,
                 days: Optional[int] = None):
        """
        Provides data expiration details of Amazon Security Lake object.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        return pulumi.get(self, "days")


@pulumi.output_type
class DataLakeLifecycleConfiguration(dict):
    """
    Provides lifecycle details of Amazon Security Lake object.
    """
    def __init__(__self__, *,
                 expiration: Optional['outputs.DataLakeExpiration'] = None,
                 transitions: Optional[Sequence['outputs.DataLakeTransitions']] = None):
        """
        Provides lifecycle details of Amazon Security Lake object.
        :param Sequence['DataLakeTransitions'] transitions: Provides data storage transition details of Amazon Security Lake object.
        """
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @property
    @pulumi.getter
    def expiration(self) -> Optional['outputs.DataLakeExpiration']:
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def transitions(self) -> Optional[Sequence['outputs.DataLakeTransitions']]:
        """
        Provides data storage transition details of Amazon Security Lake object.
        """
        return pulumi.get(self, "transitions")


@pulumi.output_type
class DataLakeReplicationConfiguration(dict):
    """
    Provides replication details of Amazon Security Lake object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataLakeReplicationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataLakeReplicationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataLakeReplicationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 regions: Optional[Sequence[str]] = None,
                 role_arn: Optional[str] = None):
        """
        Provides replication details of Amazon Security Lake object.
        :param str role_arn: Replication settings for the Amazon S3 buckets. This parameter uses the AWS Identity and Access Management (IAM) role you created that is managed by Security Lake, to ensure the replication setting is correct.
        """
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        Replication settings for the Amazon S3 buckets. This parameter uses the AWS Identity and Access Management (IAM) role you created that is managed by Security Lake, to ensure the replication setting is correct.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class DataLakeTransitions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataLakeTransitions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataLakeTransitions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataLakeTransitions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days: Optional[int] = None,
                 storage_class: Optional[str] = None):
        """
        :param int days: Number of days before data transitions to a different S3 Storage Class in the Amazon Security Lake object.
        :param str storage_class: The range of storage classes that you can choose from based on the data access, resiliency, and cost requirements of your workloads.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Number of days before data transitions to a different S3 Storage Class in the Amazon Security Lake object.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[str]:
        """
        The range of storage classes that you can choose from based on the data access, resiliency, and cost requirements of your workloads.
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class SubscriberAwsLogSource(dict):
    """
    Amazon Security Lake supports log and event collection for natively supported AWS services.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceName":
            suggest = "source_name"
        elif key == "sourceVersion":
            suggest = "source_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriberAwsLogSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriberAwsLogSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriberAwsLogSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_name: Optional[str] = None,
                 source_version: Optional[str] = None):
        """
        Amazon Security Lake supports log and event collection for natively supported AWS services.
        :param str source_name: The name for a AWS source. This must be a Regionally unique value.
        :param str source_version: The version for a AWS source. This must be a Regionally unique value.
        """
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)
        if source_version is not None:
            pulumi.set(__self__, "source_version", source_version)

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[str]:
        """
        The name for a AWS source. This must be a Regionally unique value.
        """
        return pulumi.get(self, "source_name")

    @property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> Optional[str]:
        """
        The version for a AWS source. This must be a Regionally unique value.
        """
        return pulumi.get(self, "source_version")


@pulumi.output_type
class SubscriberCustomLogSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceName":
            suggest = "source_name"
        elif key == "sourceVersion":
            suggest = "source_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriberCustomLogSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriberCustomLogSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriberCustomLogSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_name: Optional[str] = None,
                 source_version: Optional[str] = None):
        """
        :param str source_name: The name for a third-party custom source. This must be a Regionally unique value.
        :param str source_version: The version for a third-party custom source. This must be a Regionally unique value.
        """
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)
        if source_version is not None:
            pulumi.set(__self__, "source_version", source_version)

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[str]:
        """
        The name for a third-party custom source. This must be a Regionally unique value.
        """
        return pulumi.get(self, "source_name")

    @property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> Optional[str]:
        """
        The version for a third-party custom source. This must be a Regionally unique value.
        """
        return pulumi.get(self, "source_version")


@pulumi.output_type
class SubscriberIdentityProperties(dict):
    """
    The AWS identity used to access your data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalId":
            suggest = "external_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriberIdentityProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriberIdentityProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriberIdentityProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_id: str,
                 principal: str):
        """
        The AWS identity used to access your data.
        :param str external_id: The external ID used to establish trust relationship with the AWS identity.
        :param str principal: The AWS identity principal.
        """
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> str:
        """
        The external ID used to establish trust relationship with the AWS identity.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter
    def principal(self) -> str:
        """
        The AWS identity principal.
        """
        return pulumi.get(self, "principal")


@pulumi.output_type
class SubscriberSource0Properties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsLogSource":
            suggest = "aws_log_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriberSource0Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriberSource0Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriberSource0Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_log_source: 'outputs.SubscriberAwsLogSource'):
        pulumi.set(__self__, "aws_log_source", aws_log_source)

    @property
    @pulumi.getter(name="awsLogSource")
    def aws_log_source(self) -> 'outputs.SubscriberAwsLogSource':
        return pulumi.get(self, "aws_log_source")


@pulumi.output_type
class SubscriberSource1Properties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customLogSource":
            suggest = "custom_log_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriberSource1Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriberSource1Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriberSource1Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_log_source: 'outputs.SubscriberCustomLogSource'):
        pulumi.set(__self__, "custom_log_source", custom_log_source)

    @property
    @pulumi.getter(name="customLogSource")
    def custom_log_source(self) -> 'outputs.SubscriberCustomLogSource':
        return pulumi.get(self, "custom_log_source")


