# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetSubscriberResult',
    'AwaitableGetSubscriberResult',
    'get_subscriber',
    'get_subscriber_output',
]

@pulumi.output_type
class GetSubscriberResult:
    def __init__(__self__, access_types=None, resource_share_arn=None, resource_share_name=None, s3_bucket_arn=None, sources=None, subscriber_arn=None, subscriber_description=None, subscriber_identity=None, subscriber_name=None, subscriber_role_arn=None, tags=None):
        if access_types and not isinstance(access_types, list):
            raise TypeError("Expected argument 'access_types' to be a list")
        pulumi.set(__self__, "access_types", access_types)
        if resource_share_arn and not isinstance(resource_share_arn, str):
            raise TypeError("Expected argument 'resource_share_arn' to be a str")
        pulumi.set(__self__, "resource_share_arn", resource_share_arn)
        if resource_share_name and not isinstance(resource_share_name, str):
            raise TypeError("Expected argument 'resource_share_name' to be a str")
        pulumi.set(__self__, "resource_share_name", resource_share_name)
        if s3_bucket_arn and not isinstance(s3_bucket_arn, str):
            raise TypeError("Expected argument 's3_bucket_arn' to be a str")
        pulumi.set(__self__, "s3_bucket_arn", s3_bucket_arn)
        if sources and not isinstance(sources, list):
            raise TypeError("Expected argument 'sources' to be a list")
        pulumi.set(__self__, "sources", sources)
        if subscriber_arn and not isinstance(subscriber_arn, str):
            raise TypeError("Expected argument 'subscriber_arn' to be a str")
        pulumi.set(__self__, "subscriber_arn", subscriber_arn)
        if subscriber_description and not isinstance(subscriber_description, str):
            raise TypeError("Expected argument 'subscriber_description' to be a str")
        pulumi.set(__self__, "subscriber_description", subscriber_description)
        if subscriber_identity and not isinstance(subscriber_identity, dict):
            raise TypeError("Expected argument 'subscriber_identity' to be a dict")
        pulumi.set(__self__, "subscriber_identity", subscriber_identity)
        if subscriber_name and not isinstance(subscriber_name, str):
            raise TypeError("Expected argument 'subscriber_name' to be a str")
        pulumi.set(__self__, "subscriber_name", subscriber_name)
        if subscriber_role_arn and not isinstance(subscriber_role_arn, str):
            raise TypeError("Expected argument 'subscriber_role_arn' to be a str")
        pulumi.set(__self__, "subscriber_role_arn", subscriber_role_arn)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accessTypes")
    def access_types(self) -> Optional[Sequence['SubscriberAccessTypesItem']]:
        return pulumi.get(self, "access_types")

    @property
    @pulumi.getter(name="resourceShareArn")
    def resource_share_arn(self) -> Optional[str]:
        return pulumi.get(self, "resource_share_arn")

    @property
    @pulumi.getter(name="resourceShareName")
    def resource_share_name(self) -> Optional[str]:
        return pulumi.get(self, "resource_share_name")

    @property
    @pulumi.getter(name="s3BucketArn")
    def s3_bucket_arn(self) -> Optional[str]:
        return pulumi.get(self, "s3_bucket_arn")

    @property
    @pulumi.getter
    def sources(self) -> Optional[Sequence[Any]]:
        """
        The supported AWS services from which logs and events are collected.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter(name="subscriberArn")
    def subscriber_arn(self) -> Optional[str]:
        return pulumi.get(self, "subscriber_arn")

    @property
    @pulumi.getter(name="subscriberDescription")
    def subscriber_description(self) -> Optional[str]:
        """
        The description for your subscriber account in Security Lake.
        """
        return pulumi.get(self, "subscriber_description")

    @property
    @pulumi.getter(name="subscriberIdentity")
    def subscriber_identity(self) -> Optional['outputs.SubscriberIdentityProperties']:
        """
        The AWS identity used to access your data.
        """
        return pulumi.get(self, "subscriber_identity")

    @property
    @pulumi.getter(name="subscriberName")
    def subscriber_name(self) -> Optional[str]:
        """
        The name of your Security Lake subscriber account.
        """
        return pulumi.get(self, "subscriber_name")

    @property
    @pulumi.getter(name="subscriberRoleArn")
    def subscriber_role_arn(self) -> Optional[str]:
        return pulumi.get(self, "subscriber_role_arn")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of objects, one for each tag to associate with the subscriber. For each tag, you must specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
        """
        return pulumi.get(self, "tags")


class AwaitableGetSubscriberResult(GetSubscriberResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscriberResult(
            access_types=self.access_types,
            resource_share_arn=self.resource_share_arn,
            resource_share_name=self.resource_share_name,
            s3_bucket_arn=self.s3_bucket_arn,
            sources=self.sources,
            subscriber_arn=self.subscriber_arn,
            subscriber_description=self.subscriber_description,
            subscriber_identity=self.subscriber_identity,
            subscriber_name=self.subscriber_name,
            subscriber_role_arn=self.subscriber_role_arn,
            tags=self.tags)


def get_subscriber(subscriber_arn: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscriberResult:
    """
    Resource Type definition for AWS::SecurityLake::Subscriber
    """
    __args__ = dict()
    __args__['subscriberArn'] = subscriber_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:securitylake:getSubscriber', __args__, opts=opts, typ=GetSubscriberResult).value

    return AwaitableGetSubscriberResult(
        access_types=pulumi.get(__ret__, 'access_types'),
        resource_share_arn=pulumi.get(__ret__, 'resource_share_arn'),
        resource_share_name=pulumi.get(__ret__, 'resource_share_name'),
        s3_bucket_arn=pulumi.get(__ret__, 's3_bucket_arn'),
        sources=pulumi.get(__ret__, 'sources'),
        subscriber_arn=pulumi.get(__ret__, 'subscriber_arn'),
        subscriber_description=pulumi.get(__ret__, 'subscriber_description'),
        subscriber_identity=pulumi.get(__ret__, 'subscriber_identity'),
        subscriber_name=pulumi.get(__ret__, 'subscriber_name'),
        subscriber_role_arn=pulumi.get(__ret__, 'subscriber_role_arn'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_subscriber)
def get_subscriber_output(subscriber_arn: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSubscriberResult]:
    """
    Resource Type definition for AWS::SecurityLake::Subscriber
    """
    ...
