# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetDataLakeResult',
    'AwaitableGetDataLakeResult',
    'get_data_lake',
    'get_data_lake_output',
]

@pulumi.output_type
class GetDataLakeResult:
    def __init__(__self__, arn=None, encryption_configuration=None, lifecycle_configuration=None, replication_configuration=None, s3_bucket_arn=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if encryption_configuration and not isinstance(encryption_configuration, dict):
            raise TypeError("Expected argument 'encryption_configuration' to be a dict")
        pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if lifecycle_configuration and not isinstance(lifecycle_configuration, dict):
            raise TypeError("Expected argument 'lifecycle_configuration' to be a dict")
        pulumi.set(__self__, "lifecycle_configuration", lifecycle_configuration)
        if replication_configuration and not isinstance(replication_configuration, dict):
            raise TypeError("Expected argument 'replication_configuration' to be a dict")
        pulumi.set(__self__, "replication_configuration", replication_configuration)
        if s3_bucket_arn and not isinstance(s3_bucket_arn, str):
            raise TypeError("Expected argument 's3_bucket_arn' to be a str")
        pulumi.set(__self__, "s3_bucket_arn", s3_bucket_arn)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) created by you to provide to the subscriber.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional['outputs.DataLakeEncryptionConfiguration']:
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter(name="lifecycleConfiguration")
    def lifecycle_configuration(self) -> Optional['outputs.DataLakeLifecycleConfiguration']:
        return pulumi.get(self, "lifecycle_configuration")

    @property
    @pulumi.getter(name="replicationConfiguration")
    def replication_configuration(self) -> Optional['outputs.DataLakeReplicationConfiguration']:
        return pulumi.get(self, "replication_configuration")

    @property
    @pulumi.getter(name="s3BucketArn")
    def s3_bucket_arn(self) -> Optional[str]:
        """
        The ARN for the Amazon Security Lake Amazon S3 bucket.
        """
        return pulumi.get(self, "s3_bucket_arn")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        return pulumi.get(self, "tags")


class AwaitableGetDataLakeResult(GetDataLakeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataLakeResult(
            arn=self.arn,
            encryption_configuration=self.encryption_configuration,
            lifecycle_configuration=self.lifecycle_configuration,
            replication_configuration=self.replication_configuration,
            s3_bucket_arn=self.s3_bucket_arn,
            tags=self.tags)


def get_data_lake(arn: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataLakeResult:
    """
    Resource Type definition for AWS::SecurityLake::DataLake


    :param str arn: The Amazon Resource Name (ARN) created by you to provide to the subscriber.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:securitylake:getDataLake', __args__, opts=opts, typ=GetDataLakeResult).value

    return AwaitableGetDataLakeResult(
        arn=pulumi.get(__ret__, 'arn'),
        encryption_configuration=pulumi.get(__ret__, 'encryption_configuration'),
        lifecycle_configuration=pulumi.get(__ret__, 'lifecycle_configuration'),
        replication_configuration=pulumi.get(__ret__, 'replication_configuration'),
        s3_bucket_arn=pulumi.get(__ret__, 's3_bucket_arn'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_data_lake)
def get_data_lake_output(arn: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDataLakeResult]:
    """
    Resource Type definition for AWS::SecurityLake::DataLake


    :param str arn: The Amazon Resource Name (ARN) created by you to provide to the subscriber.
    """
    ...
