# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetAwsLogSourceResult',
    'AwaitableGetAwsLogSourceResult',
    'get_aws_log_source',
    'get_aws_log_source_output',
]

@pulumi.output_type
class GetAwsLogSourceResult:
    def __init__(__self__, accounts=None):
        if accounts and not isinstance(accounts, list):
            raise TypeError("Expected argument 'accounts' to be a list")
        pulumi.set(__self__, "accounts", accounts)

    @property
    @pulumi.getter
    def accounts(self) -> Optional[Sequence[str]]:
        """
        AWS account where you want to collect logs from.
        """
        return pulumi.get(self, "accounts")


class AwaitableGetAwsLogSourceResult(GetAwsLogSourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAwsLogSourceResult(
            accounts=self.accounts)


def get_aws_log_source(source_name: Optional[str] = None,
                       source_version: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAwsLogSourceResult:
    """
    Resource Type definition for AWS::SecurityLake::AwsLogSource


    :param str source_name: The name for a AWS source. This must be a Regionally unique value.
    :param str source_version: The version for a AWS source. This must be a Regionally unique value.
    """
    __args__ = dict()
    __args__['sourceName'] = source_name
    __args__['sourceVersion'] = source_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:securitylake:getAwsLogSource', __args__, opts=opts, typ=GetAwsLogSourceResult).value

    return AwaitableGetAwsLogSourceResult(
        accounts=pulumi.get(__ret__, 'accounts'))


@_utilities.lift_output_func(get_aws_log_source)
def get_aws_log_source_output(source_name: Optional[pulumi.Input[str]] = None,
                              source_version: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAwsLogSourceResult]:
    """
    Resource Type definition for AWS::SecurityLake::AwsLogSource


    :param str source_name: The name for a AWS source. This must be a Regionally unique value.
    :param str source_version: The version for a AWS source. This must be a Regionally unique value.
    """
    ...
