# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'DataLakeEncryptionConfigurationArgs',
    'DataLakeExpirationArgs',
    'DataLakeLifecycleConfigurationArgs',
    'DataLakeReplicationConfigurationArgs',
    'DataLakeTransitionsArgs',
    'SubscriberAwsLogSourceArgs',
    'SubscriberCustomLogSourceArgs',
    'SubscriberIdentityPropertiesArgs',
    'SubscriberSource0PropertiesArgs',
    'SubscriberSource1PropertiesArgs',
]

@pulumi.input_type
class DataLakeEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 kms_key_id: Optional[pulumi.Input[str]] = None):
        """
        Provides encryption details of Amazon Security Lake object.
        :param pulumi.Input[str] kms_key_id: The id of KMS encryption key used by Amazon Security Lake to encrypt the Security Lake object.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of KMS encryption key used by Amazon Security Lake to encrypt the Security Lake object.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)


@pulumi.input_type
class DataLakeExpirationArgs:
    def __init__(__self__, *,
                 days: Optional[pulumi.Input[int]] = None):
        """
        Provides data expiration details of Amazon Security Lake object.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)


@pulumi.input_type
class DataLakeLifecycleConfigurationArgs:
    def __init__(__self__, *,
                 expiration: Optional[pulumi.Input['DataLakeExpirationArgs']] = None,
                 transitions: Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeTransitionsArgs']]]] = None):
        """
        Provides lifecycle details of Amazon Security Lake object.
        :param pulumi.Input[Sequence[pulumi.Input['DataLakeTransitionsArgs']]] transitions: Provides data storage transition details of Amazon Security Lake object.
        """
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input['DataLakeExpirationArgs']]:
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input['DataLakeExpirationArgs']]):
        pulumi.set(self, "expiration", value)

    @property
    @pulumi.getter
    def transitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeTransitionsArgs']]]]:
        """
        Provides data storage transition details of Amazon Security Lake object.
        """
        return pulumi.get(self, "transitions")

    @transitions.setter
    def transitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeTransitionsArgs']]]]):
        pulumi.set(self, "transitions", value)


@pulumi.input_type
class DataLakeReplicationConfigurationArgs:
    def __init__(__self__, *,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None):
        """
        Provides replication details of Amazon Security Lake object.
        :param pulumi.Input[str] role_arn: Replication settings for the Amazon S3 buckets. This parameter uses the AWS Identity and Access Management (IAM) role you created that is managed by Security Lake, to ensure the replication setting is correct.
        """
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "regions", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Replication settings for the Amazon S3 buckets. This parameter uses the AWS Identity and Access Management (IAM) role you created that is managed by Security Lake, to ensure the replication setting is correct.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)


@pulumi.input_type
class DataLakeTransitionsArgs:
    def __init__(__self__, *,
                 days: Optional[pulumi.Input[int]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] days: Number of days before data transitions to a different S3 Storage Class in the Amazon Security Lake object.
        :param pulumi.Input[str] storage_class: The range of storage classes that you can choose from based on the data access, resiliency, and cost requirements of your workloads.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        """
        Number of days before data transitions to a different S3 Storage Class in the Amazon Security Lake object.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[str]]:
        """
        The range of storage classes that you can choose from based on the data access, resiliency, and cost requirements of your workloads.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_class", value)


@pulumi.input_type
class SubscriberAwsLogSourceArgs:
    def __init__(__self__, *,
                 source_name: Optional[pulumi.Input[str]] = None,
                 source_version: Optional[pulumi.Input[str]] = None):
        """
        Amazon Security Lake supports log and event collection for natively supported AWS services.
        :param pulumi.Input[str] source_name: The name for a AWS source. This must be a Regionally unique value.
        :param pulumi.Input[str] source_version: The version for a AWS source. This must be a Regionally unique value.
        """
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)
        if source_version is not None:
            pulumi.set(__self__, "source_version", source_version)

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for a AWS source. This must be a Regionally unique value.
        """
        return pulumi.get(self, "source_name")

    @source_name.setter
    def source_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_name", value)

    @property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version for a AWS source. This must be a Regionally unique value.
        """
        return pulumi.get(self, "source_version")

    @source_version.setter
    def source_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_version", value)


@pulumi.input_type
class SubscriberCustomLogSourceArgs:
    def __init__(__self__, *,
                 source_name: Optional[pulumi.Input[str]] = None,
                 source_version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] source_name: The name for a third-party custom source. This must be a Regionally unique value.
        :param pulumi.Input[str] source_version: The version for a third-party custom source. This must be a Regionally unique value.
        """
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)
        if source_version is not None:
            pulumi.set(__self__, "source_version", source_version)

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for a third-party custom source. This must be a Regionally unique value.
        """
        return pulumi.get(self, "source_name")

    @source_name.setter
    def source_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_name", value)

    @property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version for a third-party custom source. This must be a Regionally unique value.
        """
        return pulumi.get(self, "source_version")

    @source_version.setter
    def source_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_version", value)


@pulumi.input_type
class SubscriberIdentityPropertiesArgs:
    def __init__(__self__, *,
                 external_id: pulumi.Input[str],
                 principal: pulumi.Input[str]):
        """
        The AWS identity used to access your data.
        :param pulumi.Input[str] external_id: The external ID used to establish trust relationship with the AWS identity.
        :param pulumi.Input[str] principal: The AWS identity principal.
        """
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Input[str]:
        """
        The external ID used to establish trust relationship with the AWS identity.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter
    def principal(self) -> pulumi.Input[str]:
        """
        The AWS identity principal.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal", value)


@pulumi.input_type
class SubscriberSource0PropertiesArgs:
    def __init__(__self__, *,
                 aws_log_source: pulumi.Input['SubscriberAwsLogSourceArgs']):
        pulumi.set(__self__, "aws_log_source", aws_log_source)

    @property
    @pulumi.getter(name="awsLogSource")
    def aws_log_source(self) -> pulumi.Input['SubscriberAwsLogSourceArgs']:
        return pulumi.get(self, "aws_log_source")

    @aws_log_source.setter
    def aws_log_source(self, value: pulumi.Input['SubscriberAwsLogSourceArgs']):
        pulumi.set(self, "aws_log_source", value)


@pulumi.input_type
class SubscriberSource1PropertiesArgs:
    def __init__(__self__, *,
                 custom_log_source: pulumi.Input['SubscriberCustomLogSourceArgs']):
        pulumi.set(__self__, "custom_log_source", custom_log_source)

    @property
    @pulumi.getter(name="customLogSource")
    def custom_log_source(self) -> pulumi.Input['SubscriberCustomLogSourceArgs']:
        return pulumi.get(self, "custom_log_source")

    @custom_log_source.setter
    def custom_log_source(self, value: pulumi.Input['SubscriberCustomLogSourceArgs']):
        pulumi.set(self, "custom_log_source", value)


