# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AutomationRuleDateFilter',
    'AutomationRuleDateRange',
    'AutomationRuleMapFilter',
    'AutomationRuleNoteUpdate',
    'AutomationRuleNumberFilter',
    'AutomationRuleRelatedFinding',
    'AutomationRuleSeverityUpdate',
    'AutomationRuleStringFilter',
    'AutomationRuleWorkflowUpdate',
    'AutomationRulesAction',
    'AutomationRulesFindingFieldsUpdate',
    'AutomationRulesFindingFilters',
    'InsightAwsSecurityFindingFilters',
    'InsightBooleanFilter',
    'InsightDateFilter',
    'InsightDateRange',
    'InsightIpFilter',
    'InsightKeywordFilter',
    'InsightMapFilter',
    'InsightNumberFilter',
    'InsightStringFilter',
    'StandardsControl',
]

@pulumi.output_type
class AutomationRuleDateFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dateRange":
            suggest = "date_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationRuleDateFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationRuleDateFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationRuleDateFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date_range: Optional['outputs.AutomationRuleDateRange'] = None,
                 end: Optional[str] = None,
                 start: Optional[str] = None):
        if date_range is not None:
            pulumi.set(__self__, "date_range", date_range)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter(name="dateRange")
    def date_range(self) -> Optional['outputs.AutomationRuleDateRange']:
        return pulumi.get(self, "date_range")

    @property
    @pulumi.getter
    def end(self) -> Optional[str]:
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def start(self) -> Optional[str]:
        return pulumi.get(self, "start")


@pulumi.output_type
class AutomationRuleDateRange(dict):
    def __init__(__self__, *,
                 unit: 'AutomationRuleDateRangeUnit',
                 value: float):
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> 'AutomationRuleDateRangeUnit':
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> float:
        return pulumi.get(self, "value")


@pulumi.output_type
class AutomationRuleMapFilter(dict):
    def __init__(__self__, *,
                 comparison: 'AutomationRuleMapFilterComparison',
                 key: str,
                 value: str):
        pulumi.set(__self__, "comparison", comparison)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def comparison(self) -> 'AutomationRuleMapFilterComparison':
        return pulumi.get(self, "comparison")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class AutomationRuleNoteUpdate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updatedBy":
            suggest = "updated_by"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationRuleNoteUpdate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationRuleNoteUpdate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationRuleNoteUpdate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 text: str,
                 updated_by: str):
        pulumi.set(__self__, "text", text)
        pulumi.set(__self__, "updated_by", updated_by)

    @property
    @pulumi.getter
    def text(self) -> str:
        return pulumi.get(self, "text")

    @property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> str:
        return pulumi.get(self, "updated_by")


@pulumi.output_type
class AutomationRuleNumberFilter(dict):
    def __init__(__self__, *,
                 eq: Optional[float] = None,
                 gte: Optional[float] = None,
                 lte: Optional[float] = None):
        if eq is not None:
            pulumi.set(__self__, "eq", eq)
        if gte is not None:
            pulumi.set(__self__, "gte", gte)
        if lte is not None:
            pulumi.set(__self__, "lte", lte)

    @property
    @pulumi.getter
    def eq(self) -> Optional[float]:
        return pulumi.get(self, "eq")

    @property
    @pulumi.getter
    def gte(self) -> Optional[float]:
        return pulumi.get(self, "gte")

    @property
    @pulumi.getter
    def lte(self) -> Optional[float]:
        return pulumi.get(self, "lte")


@pulumi.output_type
class AutomationRuleRelatedFinding(dict):
    """
    Provides details about a list of findings that the current finding relates to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "productArn":
            suggest = "product_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationRuleRelatedFinding. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationRuleRelatedFinding.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationRuleRelatedFinding.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 product_arn: str):
        """
        Provides details about a list of findings that the current finding relates to.
        :param str product_arn: The Amazon Resource Name (ARN) for the product that generated a related finding.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "product_arn", product_arn)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="productArn")
    def product_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) for the product that generated a related finding.
        """
        return pulumi.get(self, "product_arn")


@pulumi.output_type
class AutomationRuleSeverityUpdate(dict):
    def __init__(__self__, *,
                 label: Optional['AutomationRuleSeverityUpdateLabel'] = None,
                 normalized: Optional[int] = None,
                 product: Optional[float] = None):
        if label is not None:
            pulumi.set(__self__, "label", label)
        if normalized is not None:
            pulumi.set(__self__, "normalized", normalized)
        if product is not None:
            pulumi.set(__self__, "product", product)

    @property
    @pulumi.getter
    def label(self) -> Optional['AutomationRuleSeverityUpdateLabel']:
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def normalized(self) -> Optional[int]:
        return pulumi.get(self, "normalized")

    @property
    @pulumi.getter
    def product(self) -> Optional[float]:
        return pulumi.get(self, "product")


@pulumi.output_type
class AutomationRuleStringFilter(dict):
    def __init__(__self__, *,
                 comparison: 'AutomationRuleStringFilterComparison',
                 value: str):
        pulumi.set(__self__, "comparison", comparison)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def comparison(self) -> 'AutomationRuleStringFilterComparison':
        return pulumi.get(self, "comparison")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class AutomationRuleWorkflowUpdate(dict):
    def __init__(__self__, *,
                 status: 'AutomationRuleWorkflowUpdateStatus'):
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> 'AutomationRuleWorkflowUpdateStatus':
        return pulumi.get(self, "status")


@pulumi.output_type
class AutomationRulesAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "findingFieldsUpdate":
            suggest = "finding_fields_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationRulesAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationRulesAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationRulesAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 finding_fields_update: 'outputs.AutomationRulesFindingFieldsUpdate',
                 type: 'AutomationRulesActionType'):
        pulumi.set(__self__, "finding_fields_update", finding_fields_update)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="findingFieldsUpdate")
    def finding_fields_update(self) -> 'outputs.AutomationRulesFindingFieldsUpdate':
        return pulumi.get(self, "finding_fields_update")

    @property
    @pulumi.getter
    def type(self) -> 'AutomationRulesActionType':
        return pulumi.get(self, "type")


@pulumi.output_type
class AutomationRulesFindingFieldsUpdate(dict):
    """
    The rule action will update the ``Note`` field of a finding.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relatedFindings":
            suggest = "related_findings"
        elif key == "userDefinedFields":
            suggest = "user_defined_fields"
        elif key == "verificationState":
            suggest = "verification_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationRulesFindingFieldsUpdate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationRulesFindingFieldsUpdate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationRulesFindingFieldsUpdate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 confidence: Optional[int] = None,
                 criticality: Optional[int] = None,
                 note: Optional['outputs.AutomationRuleNoteUpdate'] = None,
                 related_findings: Optional[Sequence['outputs.AutomationRuleRelatedFinding']] = None,
                 severity: Optional['outputs.AutomationRuleSeverityUpdate'] = None,
                 types: Optional[Sequence[str]] = None,
                 user_defined_fields: Optional[Mapping[str, str]] = None,
                 verification_state: Optional['AutomationRulesFindingFieldsUpdateVerificationState'] = None,
                 workflow: Optional['outputs.AutomationRuleWorkflowUpdate'] = None):
        """
        The rule action will update the ``Note`` field of a finding.
        :param 'AutomationRuleNoteUpdate' note: The rule action will update the ``Note`` field of a finding.
        :param Sequence['AutomationRuleRelatedFinding'] related_findings: The rule action will update the ``RelatedFindings`` field of a finding.
        :param 'AutomationRuleSeverityUpdate' severity: The rule action will update the ``Severity`` field of a finding.
        :param 'AutomationRuleWorkflowUpdate' workflow: The rule action will update the ``Workflow`` field of a finding.
        """
        if confidence is not None:
            pulumi.set(__self__, "confidence", confidence)
        if criticality is not None:
            pulumi.set(__self__, "criticality", criticality)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if related_findings is not None:
            pulumi.set(__self__, "related_findings", related_findings)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if types is not None:
            pulumi.set(__self__, "types", types)
        if user_defined_fields is not None:
            pulumi.set(__self__, "user_defined_fields", user_defined_fields)
        if verification_state is not None:
            pulumi.set(__self__, "verification_state", verification_state)
        if workflow is not None:
            pulumi.set(__self__, "workflow", workflow)

    @property
    @pulumi.getter
    def confidence(self) -> Optional[int]:
        return pulumi.get(self, "confidence")

    @property
    @pulumi.getter
    def criticality(self) -> Optional[int]:
        return pulumi.get(self, "criticality")

    @property
    @pulumi.getter
    def note(self) -> Optional['outputs.AutomationRuleNoteUpdate']:
        """
        The rule action will update the ``Note`` field of a finding.
        """
        return pulumi.get(self, "note")

    @property
    @pulumi.getter(name="relatedFindings")
    def related_findings(self) -> Optional[Sequence['outputs.AutomationRuleRelatedFinding']]:
        """
        The rule action will update the ``RelatedFindings`` field of a finding.
        """
        return pulumi.get(self, "related_findings")

    @property
    @pulumi.getter
    def severity(self) -> Optional['outputs.AutomationRuleSeverityUpdate']:
        """
        The rule action will update the ``Severity`` field of a finding.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def types(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "types")

    @property
    @pulumi.getter(name="userDefinedFields")
    def user_defined_fields(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "user_defined_fields")

    @property
    @pulumi.getter(name="verificationState")
    def verification_state(self) -> Optional['AutomationRulesFindingFieldsUpdateVerificationState']:
        return pulumi.get(self, "verification_state")

    @property
    @pulumi.getter
    def workflow(self) -> Optional['outputs.AutomationRuleWorkflowUpdate']:
        """
        The rule action will update the ``Workflow`` field of a finding.
        """
        return pulumi.get(self, "workflow")


@pulumi.output_type
class AutomationRulesFindingFilters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsAccountId":
            suggest = "aws_account_id"
        elif key == "companyName":
            suggest = "company_name"
        elif key == "complianceAssociatedStandardsId":
            suggest = "compliance_associated_standards_id"
        elif key == "complianceSecurityControlId":
            suggest = "compliance_security_control_id"
        elif key == "complianceStatus":
            suggest = "compliance_status"
        elif key == "createdAt":
            suggest = "created_at"
        elif key == "firstObservedAt":
            suggest = "first_observed_at"
        elif key == "generatorId":
            suggest = "generator_id"
        elif key == "lastObservedAt":
            suggest = "last_observed_at"
        elif key == "noteText":
            suggest = "note_text"
        elif key == "noteUpdatedAt":
            suggest = "note_updated_at"
        elif key == "noteUpdatedBy":
            suggest = "note_updated_by"
        elif key == "productArn":
            suggest = "product_arn"
        elif key == "productName":
            suggest = "product_name"
        elif key == "recordState":
            suggest = "record_state"
        elif key == "relatedFindingsId":
            suggest = "related_findings_id"
        elif key == "relatedFindingsProductArn":
            suggest = "related_findings_product_arn"
        elif key == "resourceDetailsOther":
            suggest = "resource_details_other"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "resourcePartition":
            suggest = "resource_partition"
        elif key == "resourceRegion":
            suggest = "resource_region"
        elif key == "resourceTags":
            suggest = "resource_tags"
        elif key == "resourceType":
            suggest = "resource_type"
        elif key == "severityLabel":
            suggest = "severity_label"
        elif key == "sourceUrl":
            suggest = "source_url"
        elif key == "updatedAt":
            suggest = "updated_at"
        elif key == "userDefinedFields":
            suggest = "user_defined_fields"
        elif key == "verificationState":
            suggest = "verification_state"
        elif key == "workflowStatus":
            suggest = "workflow_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationRulesFindingFilters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationRulesFindingFilters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationRulesFindingFilters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_account_id: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 company_name: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 compliance_associated_standards_id: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 compliance_security_control_id: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 compliance_status: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 confidence: Optional[Sequence['outputs.AutomationRuleNumberFilter']] = None,
                 created_at: Optional[Sequence['outputs.AutomationRuleDateFilter']] = None,
                 criticality: Optional[Sequence['outputs.AutomationRuleNumberFilter']] = None,
                 description: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 first_observed_at: Optional[Sequence['outputs.AutomationRuleDateFilter']] = None,
                 generator_id: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 id: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 last_observed_at: Optional[Sequence['outputs.AutomationRuleDateFilter']] = None,
                 note_text: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 note_updated_at: Optional[Sequence['outputs.AutomationRuleDateFilter']] = None,
                 note_updated_by: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 product_arn: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 product_name: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 record_state: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 related_findings_id: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 related_findings_product_arn: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 resource_details_other: Optional[Sequence['outputs.AutomationRuleMapFilter']] = None,
                 resource_id: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 resource_partition: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 resource_region: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 resource_tags: Optional[Sequence['outputs.AutomationRuleMapFilter']] = None,
                 resource_type: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 severity_label: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 source_url: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 title: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 type: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 updated_at: Optional[Sequence['outputs.AutomationRuleDateFilter']] = None,
                 user_defined_fields: Optional[Sequence['outputs.AutomationRuleMapFilter']] = None,
                 verification_state: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None,
                 workflow_status: Optional[Sequence['outputs.AutomationRuleStringFilter']] = None):
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if company_name is not None:
            pulumi.set(__self__, "company_name", company_name)
        if compliance_associated_standards_id is not None:
            pulumi.set(__self__, "compliance_associated_standards_id", compliance_associated_standards_id)
        if compliance_security_control_id is not None:
            pulumi.set(__self__, "compliance_security_control_id", compliance_security_control_id)
        if compliance_status is not None:
            pulumi.set(__self__, "compliance_status", compliance_status)
        if confidence is not None:
            pulumi.set(__self__, "confidence", confidence)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if criticality is not None:
            pulumi.set(__self__, "criticality", criticality)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if first_observed_at is not None:
            pulumi.set(__self__, "first_observed_at", first_observed_at)
        if generator_id is not None:
            pulumi.set(__self__, "generator_id", generator_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if last_observed_at is not None:
            pulumi.set(__self__, "last_observed_at", last_observed_at)
        if note_text is not None:
            pulumi.set(__self__, "note_text", note_text)
        if note_updated_at is not None:
            pulumi.set(__self__, "note_updated_at", note_updated_at)
        if note_updated_by is not None:
            pulumi.set(__self__, "note_updated_by", note_updated_by)
        if product_arn is not None:
            pulumi.set(__self__, "product_arn", product_arn)
        if product_name is not None:
            pulumi.set(__self__, "product_name", product_name)
        if record_state is not None:
            pulumi.set(__self__, "record_state", record_state)
        if related_findings_id is not None:
            pulumi.set(__self__, "related_findings_id", related_findings_id)
        if related_findings_product_arn is not None:
            pulumi.set(__self__, "related_findings_product_arn", related_findings_product_arn)
        if resource_details_other is not None:
            pulumi.set(__self__, "resource_details_other", resource_details_other)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_partition is not None:
            pulumi.set(__self__, "resource_partition", resource_partition)
        if resource_region is not None:
            pulumi.set(__self__, "resource_region", resource_region)
        if resource_tags is not None:
            pulumi.set(__self__, "resource_tags", resource_tags)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if severity_label is not None:
            pulumi.set(__self__, "severity_label", severity_label)
        if source_url is not None:
            pulumi.set(__self__, "source_url", source_url)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if user_defined_fields is not None:
            pulumi.set(__self__, "user_defined_fields", user_defined_fields)
        if verification_state is not None:
            pulumi.set(__self__, "verification_state", verification_state)
        if workflow_status is not None:
            pulumi.set(__self__, "workflow_status", workflow_status)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "aws_account_id")

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "company_name")

    @property
    @pulumi.getter(name="complianceAssociatedStandardsId")
    def compliance_associated_standards_id(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "compliance_associated_standards_id")

    @property
    @pulumi.getter(name="complianceSecurityControlId")
    def compliance_security_control_id(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "compliance_security_control_id")

    @property
    @pulumi.getter(name="complianceStatus")
    def compliance_status(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "compliance_status")

    @property
    @pulumi.getter
    def confidence(self) -> Optional[Sequence['outputs.AutomationRuleNumberFilter']]:
        return pulumi.get(self, "confidence")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[Sequence['outputs.AutomationRuleDateFilter']]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def criticality(self) -> Optional[Sequence['outputs.AutomationRuleNumberFilter']]:
        return pulumi.get(self, "criticality")

    @property
    @pulumi.getter
    def description(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="firstObservedAt")
    def first_observed_at(self) -> Optional[Sequence['outputs.AutomationRuleDateFilter']]:
        return pulumi.get(self, "first_observed_at")

    @property
    @pulumi.getter(name="generatorId")
    def generator_id(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "generator_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastObservedAt")
    def last_observed_at(self) -> Optional[Sequence['outputs.AutomationRuleDateFilter']]:
        return pulumi.get(self, "last_observed_at")

    @property
    @pulumi.getter(name="noteText")
    def note_text(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "note_text")

    @property
    @pulumi.getter(name="noteUpdatedAt")
    def note_updated_at(self) -> Optional[Sequence['outputs.AutomationRuleDateFilter']]:
        return pulumi.get(self, "note_updated_at")

    @property
    @pulumi.getter(name="noteUpdatedBy")
    def note_updated_by(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "note_updated_by")

    @property
    @pulumi.getter(name="productArn")
    def product_arn(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "product_arn")

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "product_name")

    @property
    @pulumi.getter(name="recordState")
    def record_state(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "record_state")

    @property
    @pulumi.getter(name="relatedFindingsId")
    def related_findings_id(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "related_findings_id")

    @property
    @pulumi.getter(name="relatedFindingsProductArn")
    def related_findings_product_arn(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "related_findings_product_arn")

    @property
    @pulumi.getter(name="resourceDetailsOther")
    def resource_details_other(self) -> Optional[Sequence['outputs.AutomationRuleMapFilter']]:
        return pulumi.get(self, "resource_details_other")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourcePartition")
    def resource_partition(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "resource_partition")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[Sequence['outputs.AutomationRuleMapFilter']]:
        return pulumi.get(self, "resource_tags")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="severityLabel")
    def severity_label(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "severity_label")

    @property
    @pulumi.getter(name="sourceUrl")
    def source_url(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "source_url")

    @property
    @pulumi.getter
    def title(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def type(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[Sequence['outputs.AutomationRuleDateFilter']]:
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="userDefinedFields")
    def user_defined_fields(self) -> Optional[Sequence['outputs.AutomationRuleMapFilter']]:
        return pulumi.get(self, "user_defined_fields")

    @property
    @pulumi.getter(name="verificationState")
    def verification_state(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "verification_state")

    @property
    @pulumi.getter(name="workflowStatus")
    def workflow_status(self) -> Optional[Sequence['outputs.AutomationRuleStringFilter']]:
        return pulumi.get(self, "workflow_status")


@pulumi.output_type
class InsightAwsSecurityFindingFilters(dict):
    """
    A collection of filters that are applied to all active findings aggregated by AWS Security Hub.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsAccountId":
            suggest = "aws_account_id"
        elif key == "awsAccountName":
            suggest = "aws_account_name"
        elif key == "companyName":
            suggest = "company_name"
        elif key == "complianceAssociatedStandardsId":
            suggest = "compliance_associated_standards_id"
        elif key == "complianceSecurityControlId":
            suggest = "compliance_security_control_id"
        elif key == "complianceSecurityControlParametersName":
            suggest = "compliance_security_control_parameters_name"
        elif key == "complianceSecurityControlParametersValue":
            suggest = "compliance_security_control_parameters_value"
        elif key == "complianceStatus":
            suggest = "compliance_status"
        elif key == "createdAt":
            suggest = "created_at"
        elif key == "findingProviderFieldsConfidence":
            suggest = "finding_provider_fields_confidence"
        elif key == "findingProviderFieldsCriticality":
            suggest = "finding_provider_fields_criticality"
        elif key == "findingProviderFieldsRelatedFindingsId":
            suggest = "finding_provider_fields_related_findings_id"
        elif key == "findingProviderFieldsRelatedFindingsProductArn":
            suggest = "finding_provider_fields_related_findings_product_arn"
        elif key == "findingProviderFieldsSeverityLabel":
            suggest = "finding_provider_fields_severity_label"
        elif key == "findingProviderFieldsSeverityOriginal":
            suggest = "finding_provider_fields_severity_original"
        elif key == "findingProviderFieldsTypes":
            suggest = "finding_provider_fields_types"
        elif key == "firstObservedAt":
            suggest = "first_observed_at"
        elif key == "generatorId":
            suggest = "generator_id"
        elif key == "lastObservedAt":
            suggest = "last_observed_at"
        elif key == "malwareName":
            suggest = "malware_name"
        elif key == "malwarePath":
            suggest = "malware_path"
        elif key == "malwareState":
            suggest = "malware_state"
        elif key == "malwareType":
            suggest = "malware_type"
        elif key == "networkDestinationDomain":
            suggest = "network_destination_domain"
        elif key == "networkDestinationIpV4":
            suggest = "network_destination_ip_v4"
        elif key == "networkDestinationIpV6":
            suggest = "network_destination_ip_v6"
        elif key == "networkDestinationPort":
            suggest = "network_destination_port"
        elif key == "networkDirection":
            suggest = "network_direction"
        elif key == "networkProtocol":
            suggest = "network_protocol"
        elif key == "networkSourceDomain":
            suggest = "network_source_domain"
        elif key == "networkSourceIpV4":
            suggest = "network_source_ip_v4"
        elif key == "networkSourceIpV6":
            suggest = "network_source_ip_v6"
        elif key == "networkSourceMac":
            suggest = "network_source_mac"
        elif key == "networkSourcePort":
            suggest = "network_source_port"
        elif key == "noteText":
            suggest = "note_text"
        elif key == "noteUpdatedAt":
            suggest = "note_updated_at"
        elif key == "noteUpdatedBy":
            suggest = "note_updated_by"
        elif key == "processLaunchedAt":
            suggest = "process_launched_at"
        elif key == "processName":
            suggest = "process_name"
        elif key == "processParentPid":
            suggest = "process_parent_pid"
        elif key == "processPath":
            suggest = "process_path"
        elif key == "processPid":
            suggest = "process_pid"
        elif key == "processTerminatedAt":
            suggest = "process_terminated_at"
        elif key == "productArn":
            suggest = "product_arn"
        elif key == "productFields":
            suggest = "product_fields"
        elif key == "productName":
            suggest = "product_name"
        elif key == "recommendationText":
            suggest = "recommendation_text"
        elif key == "recordState":
            suggest = "record_state"
        elif key == "relatedFindingsId":
            suggest = "related_findings_id"
        elif key == "relatedFindingsProductArn":
            suggest = "related_findings_product_arn"
        elif key == "resourceApplicationArn":
            suggest = "resource_application_arn"
        elif key == "resourceApplicationName":
            suggest = "resource_application_name"
        elif key == "resourceAwsEc2InstanceIamInstanceProfileArn":
            suggest = "resource_aws_ec2_instance_iam_instance_profile_arn"
        elif key == "resourceAwsEc2InstanceImageId":
            suggest = "resource_aws_ec2_instance_image_id"
        elif key == "resourceAwsEc2InstanceIpV4Addresses":
            suggest = "resource_aws_ec2_instance_ip_v4_addresses"
        elif key == "resourceAwsEc2InstanceIpV6Addresses":
            suggest = "resource_aws_ec2_instance_ip_v6_addresses"
        elif key == "resourceAwsEc2InstanceKeyName":
            suggest = "resource_aws_ec2_instance_key_name"
        elif key == "resourceAwsEc2InstanceLaunchedAt":
            suggest = "resource_aws_ec2_instance_launched_at"
        elif key == "resourceAwsEc2InstanceSubnetId":
            suggest = "resource_aws_ec2_instance_subnet_id"
        elif key == "resourceAwsEc2InstanceType":
            suggest = "resource_aws_ec2_instance_type"
        elif key == "resourceAwsEc2InstanceVpcId":
            suggest = "resource_aws_ec2_instance_vpc_id"
        elif key == "resourceAwsIamAccessKeyCreatedAt":
            suggest = "resource_aws_iam_access_key_created_at"
        elif key == "resourceAwsIamAccessKeyPrincipalName":
            suggest = "resource_aws_iam_access_key_principal_name"
        elif key == "resourceAwsIamAccessKeyStatus":
            suggest = "resource_aws_iam_access_key_status"
        elif key == "resourceAwsIamAccessKeyUserName":
            suggest = "resource_aws_iam_access_key_user_name"
        elif key == "resourceAwsIamUserUserName":
            suggest = "resource_aws_iam_user_user_name"
        elif key == "resourceAwsS3BucketOwnerId":
            suggest = "resource_aws_s3_bucket_owner_id"
        elif key == "resourceAwsS3BucketOwnerName":
            suggest = "resource_aws_s3_bucket_owner_name"
        elif key == "resourceContainerImageId":
            suggest = "resource_container_image_id"
        elif key == "resourceContainerImageName":
            suggest = "resource_container_image_name"
        elif key == "resourceContainerLaunchedAt":
            suggest = "resource_container_launched_at"
        elif key == "resourceContainerName":
            suggest = "resource_container_name"
        elif key == "resourceDetailsOther":
            suggest = "resource_details_other"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "resourcePartition":
            suggest = "resource_partition"
        elif key == "resourceRegion":
            suggest = "resource_region"
        elif key == "resourceTags":
            suggest = "resource_tags"
        elif key == "resourceType":
            suggest = "resource_type"
        elif key == "severityLabel":
            suggest = "severity_label"
        elif key == "severityNormalized":
            suggest = "severity_normalized"
        elif key == "severityProduct":
            suggest = "severity_product"
        elif key == "sourceUrl":
            suggest = "source_url"
        elif key == "threatIntelIndicatorCategory":
            suggest = "threat_intel_indicator_category"
        elif key == "threatIntelIndicatorLastObservedAt":
            suggest = "threat_intel_indicator_last_observed_at"
        elif key == "threatIntelIndicatorSource":
            suggest = "threat_intel_indicator_source"
        elif key == "threatIntelIndicatorSourceUrl":
            suggest = "threat_intel_indicator_source_url"
        elif key == "threatIntelIndicatorType":
            suggest = "threat_intel_indicator_type"
        elif key == "threatIntelIndicatorValue":
            suggest = "threat_intel_indicator_value"
        elif key == "updatedAt":
            suggest = "updated_at"
        elif key == "userDefinedFields":
            suggest = "user_defined_fields"
        elif key == "verificationState":
            suggest = "verification_state"
        elif key == "vulnerabilitiesExploitAvailable":
            suggest = "vulnerabilities_exploit_available"
        elif key == "vulnerabilitiesFixAvailable":
            suggest = "vulnerabilities_fix_available"
        elif key == "workflowState":
            suggest = "workflow_state"
        elif key == "workflowStatus":
            suggest = "workflow_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InsightAwsSecurityFindingFilters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InsightAwsSecurityFindingFilters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InsightAwsSecurityFindingFilters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_account_id: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 aws_account_name: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 company_name: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 compliance_associated_standards_id: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 compliance_security_control_id: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 compliance_security_control_parameters_name: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 compliance_security_control_parameters_value: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 compliance_status: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 confidence: Optional[Sequence['outputs.InsightNumberFilter']] = None,
                 created_at: Optional[Sequence['outputs.InsightDateFilter']] = None,
                 criticality: Optional[Sequence['outputs.InsightNumberFilter']] = None,
                 description: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 finding_provider_fields_confidence: Optional[Sequence['outputs.InsightNumberFilter']] = None,
                 finding_provider_fields_criticality: Optional[Sequence['outputs.InsightNumberFilter']] = None,
                 finding_provider_fields_related_findings_id: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 finding_provider_fields_related_findings_product_arn: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 finding_provider_fields_severity_label: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 finding_provider_fields_severity_original: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 finding_provider_fields_types: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 first_observed_at: Optional[Sequence['outputs.InsightDateFilter']] = None,
                 generator_id: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 id: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 keyword: Optional[Sequence['outputs.InsightKeywordFilter']] = None,
                 last_observed_at: Optional[Sequence['outputs.InsightDateFilter']] = None,
                 malware_name: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 malware_path: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 malware_state: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 malware_type: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 network_destination_domain: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 network_destination_ip_v4: Optional[Sequence['outputs.InsightIpFilter']] = None,
                 network_destination_ip_v6: Optional[Sequence['outputs.InsightIpFilter']] = None,
                 network_destination_port: Optional[Sequence['outputs.InsightNumberFilter']] = None,
                 network_direction: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 network_protocol: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 network_source_domain: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 network_source_ip_v4: Optional[Sequence['outputs.InsightIpFilter']] = None,
                 network_source_ip_v6: Optional[Sequence['outputs.InsightIpFilter']] = None,
                 network_source_mac: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 network_source_port: Optional[Sequence['outputs.InsightNumberFilter']] = None,
                 note_text: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 note_updated_at: Optional[Sequence['outputs.InsightDateFilter']] = None,
                 note_updated_by: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 process_launched_at: Optional[Sequence['outputs.InsightDateFilter']] = None,
                 process_name: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 process_parent_pid: Optional[Sequence['outputs.InsightNumberFilter']] = None,
                 process_path: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 process_pid: Optional[Sequence['outputs.InsightNumberFilter']] = None,
                 process_terminated_at: Optional[Sequence['outputs.InsightDateFilter']] = None,
                 product_arn: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 product_fields: Optional[Sequence['outputs.InsightMapFilter']] = None,
                 product_name: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 recommendation_text: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 record_state: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 region: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 related_findings_id: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 related_findings_product_arn: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 resource_application_arn: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 resource_application_name: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 resource_aws_ec2_instance_iam_instance_profile_arn: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 resource_aws_ec2_instance_image_id: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 resource_aws_ec2_instance_ip_v4_addresses: Optional[Sequence['outputs.InsightIpFilter']] = None,
                 resource_aws_ec2_instance_ip_v6_addresses: Optional[Sequence['outputs.InsightIpFilter']] = None,
                 resource_aws_ec2_instance_key_name: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 resource_aws_ec2_instance_launched_at: Optional[Sequence['outputs.InsightDateFilter']] = None,
                 resource_aws_ec2_instance_subnet_id: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 resource_aws_ec2_instance_type: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 resource_aws_ec2_instance_vpc_id: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 resource_aws_iam_access_key_created_at: Optional[Sequence['outputs.InsightDateFilter']] = None,
                 resource_aws_iam_access_key_principal_name: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 resource_aws_iam_access_key_status: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 resource_aws_iam_access_key_user_name: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 resource_aws_iam_user_user_name: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 resource_aws_s3_bucket_owner_id: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 resource_aws_s3_bucket_owner_name: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 resource_container_image_id: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 resource_container_image_name: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 resource_container_launched_at: Optional[Sequence['outputs.InsightDateFilter']] = None,
                 resource_container_name: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 resource_details_other: Optional[Sequence['outputs.InsightMapFilter']] = None,
                 resource_id: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 resource_partition: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 resource_region: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 resource_tags: Optional[Sequence['outputs.InsightMapFilter']] = None,
                 resource_type: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 sample: Optional[Sequence['outputs.InsightBooleanFilter']] = None,
                 severity_label: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 severity_normalized: Optional[Sequence['outputs.InsightNumberFilter']] = None,
                 severity_product: Optional[Sequence['outputs.InsightNumberFilter']] = None,
                 source_url: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 threat_intel_indicator_category: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 threat_intel_indicator_last_observed_at: Optional[Sequence['outputs.InsightDateFilter']] = None,
                 threat_intel_indicator_source: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 threat_intel_indicator_source_url: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 threat_intel_indicator_type: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 threat_intel_indicator_value: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 title: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 type: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 updated_at: Optional[Sequence['outputs.InsightDateFilter']] = None,
                 user_defined_fields: Optional[Sequence['outputs.InsightMapFilter']] = None,
                 verification_state: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 vulnerabilities_exploit_available: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 vulnerabilities_fix_available: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 workflow_state: Optional[Sequence['outputs.InsightStringFilter']] = None,
                 workflow_status: Optional[Sequence['outputs.InsightStringFilter']] = None):
        """
        A collection of filters that are applied to all active findings aggregated by AWS Security Hub.
        :param Sequence['InsightStringFilter'] aws_account_id: The AWS account ID in which a finding is generated.
        :param Sequence['InsightStringFilter'] aws_account_name: The name of the AWS account in which a finding is generated.
        :param Sequence['InsightStringFilter'] company_name: The name of the findings provider (company) that owns the solution (product) that generates findings.
        :param Sequence['InsightStringFilter'] compliance_associated_standards_id: The unique identifier of a standard in which a control is enabled.
        :param Sequence['InsightStringFilter'] compliance_security_control_id: The unique identifier of a control across standards.
        :param Sequence['InsightStringFilter'] compliance_security_control_parameters_name: The name of a security control parameter.
        :param Sequence['InsightStringFilter'] compliance_security_control_parameters_value: The current value of a security control parameter.
        :param Sequence['InsightStringFilter'] compliance_status: Exclusive to findings that are generated as the result of a check run against a specific rule in a supported standard.
        :param Sequence['InsightNumberFilter'] confidence: A finding's confidence.
        :param Sequence['InsightDateFilter'] created_at: An ISO8601-formatted timestamp that indicates when the security findings provider captured the potential security issue that a finding captured.
        :param Sequence['InsightNumberFilter'] criticality: The level of importance assigned to the resources associated with the finding.
        :param Sequence['InsightStringFilter'] description: A finding's description.
        :param Sequence['InsightNumberFilter'] finding_provider_fields_confidence: The finding provider value for the finding confidence.
        :param Sequence['InsightNumberFilter'] finding_provider_fields_criticality: The finding provider value for the level of importance assigned to the resources associated with the findings.
        :param Sequence['InsightStringFilter'] finding_provider_fields_related_findings_id: The finding identifier of a related finding that is identified by the finding provider.
        :param Sequence['InsightStringFilter'] finding_provider_fields_related_findings_product_arn: The ARN of the solution that generated a related finding that is identified by the finding provider.
        :param Sequence['InsightStringFilter'] finding_provider_fields_severity_label: The finding provider value for the severity label.
        :param Sequence['InsightStringFilter'] finding_provider_fields_severity_original: The finding provider's original value for the severity.
        :param Sequence['InsightStringFilter'] finding_provider_fields_types: One or more finding types that the finding provider assigned to the finding.
        :param Sequence['InsightDateFilter'] first_observed_at: An ISO8601-formatted timestamp that indicates when the security findings provider first observed the potential security issue that a finding captured.
        :param Sequence['InsightStringFilter'] generator_id: The identifier for the solution-specific component (a discrete unit of logic) that generated a finding.
        :param Sequence['InsightStringFilter'] id: The security findings provider-specific identifier for a finding.
        :param Sequence['InsightKeywordFilter'] keyword: A keyword for a finding.
        :param Sequence['InsightDateFilter'] last_observed_at: An ISO8601-formatted timestamp that indicates when the security findings provider most recently observed the potential security issue that a finding captured.
        :param Sequence['InsightStringFilter'] malware_name: The name of the malware that was observed.
        :param Sequence['InsightStringFilter'] malware_path: The filesystem path of the malware that was observed.
        :param Sequence['InsightStringFilter'] malware_state: The state of the malware that was observed.
        :param Sequence['InsightStringFilter'] malware_type: The type of the malware that was observed.
        :param Sequence['InsightStringFilter'] network_destination_domain: The destination domain of network-related information about a finding.
        :param Sequence['InsightIpFilter'] network_destination_ip_v4: The destination IPv4 address of network-related information about a finding.
        :param Sequence['InsightIpFilter'] network_destination_ip_v6: The destination IPv6 address of network-related information about a finding.
        :param Sequence['InsightNumberFilter'] network_destination_port: The destination port of network-related information about a finding.
        :param Sequence['InsightStringFilter'] network_direction: Indicates the direction of network traffic associated with a finding.
        :param Sequence['InsightStringFilter'] network_protocol: The protocol of network-related information about a finding.
        :param Sequence['InsightStringFilter'] network_source_domain: The source domain of network-related information about a finding.
        :param Sequence['InsightIpFilter'] network_source_ip_v4: The source IPv4 address of network-related information about a finding.
        :param Sequence['InsightIpFilter'] network_source_ip_v6: The source IPv6 address of network-related information about a finding.
        :param Sequence['InsightStringFilter'] network_source_mac: The source media access control (MAC) address of network-related information about a finding.
        :param Sequence['InsightNumberFilter'] network_source_port: The source port of network-related information about a finding.
        :param Sequence['InsightStringFilter'] note_text: The text of a note.
        :param Sequence['InsightDateFilter'] note_updated_at: The timestamp of when the note was updated.
        :param Sequence['InsightStringFilter'] note_updated_by: The principal that created a note.
        :param Sequence['InsightDateFilter'] process_launched_at: A timestamp that identifies when the process was launched.
        :param Sequence['InsightStringFilter'] process_name: The name of the process.
        :param Sequence['InsightNumberFilter'] process_parent_pid: The parent process ID.
        :param Sequence['InsightStringFilter'] process_path: The path to the process executable.
        :param Sequence['InsightNumberFilter'] process_pid: The process ID.
        :param Sequence['InsightDateFilter'] process_terminated_at: A timestamp that identifies when the process was terminated.
        :param Sequence['InsightStringFilter'] product_arn: The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider) after this provider's product (solution that generates findings) is registered with Security Hub.
        :param Sequence['InsightMapFilter'] product_fields: A data type where security findings providers can include additional solution-specific details that aren't part of the defined AwsSecurityFinding format.
        :param Sequence['InsightStringFilter'] product_name: The name of the solution (product) that generates findings.
        :param Sequence['InsightStringFilter'] recommendation_text: The recommendation of what to do about the issue described in a finding.
        :param Sequence['InsightStringFilter'] record_state: The updated record state for the finding.
        :param Sequence['InsightStringFilter'] region: The Region from which the finding was generated.
        :param Sequence['InsightStringFilter'] related_findings_id: The solution-generated identifier for a related finding.
        :param Sequence['InsightStringFilter'] related_findings_product_arn: The ARN of the solution that generated a related finding.
        :param Sequence['InsightStringFilter'] resource_application_arn: The ARN of the application that is related to a finding.
        :param Sequence['InsightStringFilter'] resource_application_name: The name of the application that is related to a finding.
        :param Sequence['InsightStringFilter'] resource_aws_ec2_instance_iam_instance_profile_arn: The IAM profile ARN of the instance.
        :param Sequence['InsightStringFilter'] resource_aws_ec2_instance_image_id: The Amazon Machine Image (AMI) ID of the instance.
        :param Sequence['InsightIpFilter'] resource_aws_ec2_instance_ip_v4_addresses: The IPv4 addresses associated with the instance.
        :param Sequence['InsightIpFilter'] resource_aws_ec2_instance_ip_v6_addresses: The IPv6 addresses associated with the instance.
        :param Sequence['InsightStringFilter'] resource_aws_ec2_instance_key_name: The key name associated with the instance.
        :param Sequence['InsightDateFilter'] resource_aws_ec2_instance_launched_at: The date and time the instance was launched.
        :param Sequence['InsightStringFilter'] resource_aws_ec2_instance_subnet_id: The identifier of the subnet that the instance was launched in.
        :param Sequence['InsightStringFilter'] resource_aws_ec2_instance_type: The instance type of the instance.
        :param Sequence['InsightStringFilter'] resource_aws_ec2_instance_vpc_id: The identifier of the VPC that the instance was launched in.
        :param Sequence['InsightDateFilter'] resource_aws_iam_access_key_created_at: The creation date/time of the IAM access key related to a finding.
        :param Sequence['InsightStringFilter'] resource_aws_iam_access_key_principal_name: The name of the principal that is associated with an IAM access key.
        :param Sequence['InsightStringFilter'] resource_aws_iam_access_key_status: The status of the IAM access key related to a finding.
        :param Sequence['InsightStringFilter'] resource_aws_iam_access_key_user_name: The user associated with the IAM access key related to a finding.
        :param Sequence['InsightStringFilter'] resource_aws_iam_user_user_name: The name of an IAM user.
        :param Sequence['InsightStringFilter'] resource_aws_s3_bucket_owner_id: The canonical user ID of the owner of the S3 bucket.
        :param Sequence['InsightStringFilter'] resource_aws_s3_bucket_owner_name: The display name of the owner of the S3 bucket.
        :param Sequence['InsightStringFilter'] resource_container_image_id: The identifier of the image related to a finding.
        :param Sequence['InsightStringFilter'] resource_container_image_name: The name of the image related to a finding.
        :param Sequence['InsightDateFilter'] resource_container_launched_at: A timestamp that identifies when the container was started.
        :param Sequence['InsightStringFilter'] resource_container_name: The name of the container related to a finding.
        :param Sequence['InsightMapFilter'] resource_details_other: The details of a resource that doesn't have a specific subfield for the resource type defined.
        :param Sequence['InsightStringFilter'] resource_id: The canonical identifier for the given resource type.
        :param Sequence['InsightStringFilter'] resource_partition: The canonical AWS partition name that the Region is assigned to.
        :param Sequence['InsightStringFilter'] resource_region: The canonical AWS external Region name where this resource is located.
        :param Sequence['InsightMapFilter'] resource_tags: A list of AWS tags associated with a resource at the time the finding was processed.
        :param Sequence['InsightStringFilter'] resource_type: Specifies the type of the resource that details are provided for.
        :param Sequence['InsightBooleanFilter'] sample: Indicates whether or not sample findings are included in the filter results.
        :param Sequence['InsightStringFilter'] severity_label: The label of a finding's severity.
        :param Sequence['InsightNumberFilter'] severity_normalized: The normalized severity of a finding.
        :param Sequence['InsightNumberFilter'] severity_product: The native severity as defined by the security findings provider's solution that generated the finding.
        :param Sequence['InsightStringFilter'] source_url: A URL that links to a page about the current finding in the security findings provider's solution.
        :param Sequence['InsightStringFilter'] threat_intel_indicator_category: The category of a threat intelligence indicator.
        :param Sequence['InsightDateFilter'] threat_intel_indicator_last_observed_at: A timestamp that identifies the last observation of a threat intelligence indicator.
        :param Sequence['InsightStringFilter'] threat_intel_indicator_source: The source of the threat intelligence.
        :param Sequence['InsightStringFilter'] threat_intel_indicator_source_url: The URL for more details from the source of the threat intelligence.
        :param Sequence['InsightStringFilter'] threat_intel_indicator_type: The type of a threat intelligence indicator.
        :param Sequence['InsightStringFilter'] threat_intel_indicator_value: The value of a threat intelligence indicator.
        :param Sequence['InsightStringFilter'] title: A finding's title.
        :param Sequence['InsightStringFilter'] type: A finding type in the format of namespace/category/classifier that classifies a finding.
        :param Sequence['InsightDateFilter'] updated_at: An ISO8601-formatted timestamp that indicates when the security findings provider last updated the finding record.
        :param Sequence['InsightMapFilter'] user_defined_fields: A list of name/value string pairs associated with the finding.
        :param Sequence['InsightStringFilter'] verification_state: The veracity of a finding.
        :param Sequence['InsightStringFilter'] vulnerabilities_exploit_available: Indicates whether a software vulnerability in your environment has a known exploit.
        :param Sequence['InsightStringFilter'] vulnerabilities_fix_available: Indicates whether a vulnerability is fixed in a newer version of the affected software packages.
        :param Sequence['InsightStringFilter'] workflow_state: The workflow state of a finding.
        :param Sequence['InsightStringFilter'] workflow_status: The status of the investigation into a finding.
        """
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if aws_account_name is not None:
            pulumi.set(__self__, "aws_account_name", aws_account_name)
        if company_name is not None:
            pulumi.set(__self__, "company_name", company_name)
        if compliance_associated_standards_id is not None:
            pulumi.set(__self__, "compliance_associated_standards_id", compliance_associated_standards_id)
        if compliance_security_control_id is not None:
            pulumi.set(__self__, "compliance_security_control_id", compliance_security_control_id)
        if compliance_security_control_parameters_name is not None:
            pulumi.set(__self__, "compliance_security_control_parameters_name", compliance_security_control_parameters_name)
        if compliance_security_control_parameters_value is not None:
            pulumi.set(__self__, "compliance_security_control_parameters_value", compliance_security_control_parameters_value)
        if compliance_status is not None:
            pulumi.set(__self__, "compliance_status", compliance_status)
        if confidence is not None:
            pulumi.set(__self__, "confidence", confidence)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if criticality is not None:
            pulumi.set(__self__, "criticality", criticality)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if finding_provider_fields_confidence is not None:
            pulumi.set(__self__, "finding_provider_fields_confidence", finding_provider_fields_confidence)
        if finding_provider_fields_criticality is not None:
            pulumi.set(__self__, "finding_provider_fields_criticality", finding_provider_fields_criticality)
        if finding_provider_fields_related_findings_id is not None:
            pulumi.set(__self__, "finding_provider_fields_related_findings_id", finding_provider_fields_related_findings_id)
        if finding_provider_fields_related_findings_product_arn is not None:
            pulumi.set(__self__, "finding_provider_fields_related_findings_product_arn", finding_provider_fields_related_findings_product_arn)
        if finding_provider_fields_severity_label is not None:
            pulumi.set(__self__, "finding_provider_fields_severity_label", finding_provider_fields_severity_label)
        if finding_provider_fields_severity_original is not None:
            pulumi.set(__self__, "finding_provider_fields_severity_original", finding_provider_fields_severity_original)
        if finding_provider_fields_types is not None:
            pulumi.set(__self__, "finding_provider_fields_types", finding_provider_fields_types)
        if first_observed_at is not None:
            pulumi.set(__self__, "first_observed_at", first_observed_at)
        if generator_id is not None:
            pulumi.set(__self__, "generator_id", generator_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if keyword is not None:
            pulumi.set(__self__, "keyword", keyword)
        if last_observed_at is not None:
            pulumi.set(__self__, "last_observed_at", last_observed_at)
        if malware_name is not None:
            pulumi.set(__self__, "malware_name", malware_name)
        if malware_path is not None:
            pulumi.set(__self__, "malware_path", malware_path)
        if malware_state is not None:
            pulumi.set(__self__, "malware_state", malware_state)
        if malware_type is not None:
            pulumi.set(__self__, "malware_type", malware_type)
        if network_destination_domain is not None:
            pulumi.set(__self__, "network_destination_domain", network_destination_domain)
        if network_destination_ip_v4 is not None:
            pulumi.set(__self__, "network_destination_ip_v4", network_destination_ip_v4)
        if network_destination_ip_v6 is not None:
            pulumi.set(__self__, "network_destination_ip_v6", network_destination_ip_v6)
        if network_destination_port is not None:
            pulumi.set(__self__, "network_destination_port", network_destination_port)
        if network_direction is not None:
            pulumi.set(__self__, "network_direction", network_direction)
        if network_protocol is not None:
            pulumi.set(__self__, "network_protocol", network_protocol)
        if network_source_domain is not None:
            pulumi.set(__self__, "network_source_domain", network_source_domain)
        if network_source_ip_v4 is not None:
            pulumi.set(__self__, "network_source_ip_v4", network_source_ip_v4)
        if network_source_ip_v6 is not None:
            pulumi.set(__self__, "network_source_ip_v6", network_source_ip_v6)
        if network_source_mac is not None:
            pulumi.set(__self__, "network_source_mac", network_source_mac)
        if network_source_port is not None:
            pulumi.set(__self__, "network_source_port", network_source_port)
        if note_text is not None:
            pulumi.set(__self__, "note_text", note_text)
        if note_updated_at is not None:
            pulumi.set(__self__, "note_updated_at", note_updated_at)
        if note_updated_by is not None:
            pulumi.set(__self__, "note_updated_by", note_updated_by)
        if process_launched_at is not None:
            pulumi.set(__self__, "process_launched_at", process_launched_at)
        if process_name is not None:
            pulumi.set(__self__, "process_name", process_name)
        if process_parent_pid is not None:
            pulumi.set(__self__, "process_parent_pid", process_parent_pid)
        if process_path is not None:
            pulumi.set(__self__, "process_path", process_path)
        if process_pid is not None:
            pulumi.set(__self__, "process_pid", process_pid)
        if process_terminated_at is not None:
            pulumi.set(__self__, "process_terminated_at", process_terminated_at)
        if product_arn is not None:
            pulumi.set(__self__, "product_arn", product_arn)
        if product_fields is not None:
            pulumi.set(__self__, "product_fields", product_fields)
        if product_name is not None:
            pulumi.set(__self__, "product_name", product_name)
        if recommendation_text is not None:
            pulumi.set(__self__, "recommendation_text", recommendation_text)
        if record_state is not None:
            pulumi.set(__self__, "record_state", record_state)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if related_findings_id is not None:
            pulumi.set(__self__, "related_findings_id", related_findings_id)
        if related_findings_product_arn is not None:
            pulumi.set(__self__, "related_findings_product_arn", related_findings_product_arn)
        if resource_application_arn is not None:
            pulumi.set(__self__, "resource_application_arn", resource_application_arn)
        if resource_application_name is not None:
            pulumi.set(__self__, "resource_application_name", resource_application_name)
        if resource_aws_ec2_instance_iam_instance_profile_arn is not None:
            pulumi.set(__self__, "resource_aws_ec2_instance_iam_instance_profile_arn", resource_aws_ec2_instance_iam_instance_profile_arn)
        if resource_aws_ec2_instance_image_id is not None:
            pulumi.set(__self__, "resource_aws_ec2_instance_image_id", resource_aws_ec2_instance_image_id)
        if resource_aws_ec2_instance_ip_v4_addresses is not None:
            pulumi.set(__self__, "resource_aws_ec2_instance_ip_v4_addresses", resource_aws_ec2_instance_ip_v4_addresses)
        if resource_aws_ec2_instance_ip_v6_addresses is not None:
            pulumi.set(__self__, "resource_aws_ec2_instance_ip_v6_addresses", resource_aws_ec2_instance_ip_v6_addresses)
        if resource_aws_ec2_instance_key_name is not None:
            pulumi.set(__self__, "resource_aws_ec2_instance_key_name", resource_aws_ec2_instance_key_name)
        if resource_aws_ec2_instance_launched_at is not None:
            pulumi.set(__self__, "resource_aws_ec2_instance_launched_at", resource_aws_ec2_instance_launched_at)
        if resource_aws_ec2_instance_subnet_id is not None:
            pulumi.set(__self__, "resource_aws_ec2_instance_subnet_id", resource_aws_ec2_instance_subnet_id)
        if resource_aws_ec2_instance_type is not None:
            pulumi.set(__self__, "resource_aws_ec2_instance_type", resource_aws_ec2_instance_type)
        if resource_aws_ec2_instance_vpc_id is not None:
            pulumi.set(__self__, "resource_aws_ec2_instance_vpc_id", resource_aws_ec2_instance_vpc_id)
        if resource_aws_iam_access_key_created_at is not None:
            pulumi.set(__self__, "resource_aws_iam_access_key_created_at", resource_aws_iam_access_key_created_at)
        if resource_aws_iam_access_key_principal_name is not None:
            pulumi.set(__self__, "resource_aws_iam_access_key_principal_name", resource_aws_iam_access_key_principal_name)
        if resource_aws_iam_access_key_status is not None:
            pulumi.set(__self__, "resource_aws_iam_access_key_status", resource_aws_iam_access_key_status)
        if resource_aws_iam_access_key_user_name is not None:
            pulumi.set(__self__, "resource_aws_iam_access_key_user_name", resource_aws_iam_access_key_user_name)
        if resource_aws_iam_user_user_name is not None:
            pulumi.set(__self__, "resource_aws_iam_user_user_name", resource_aws_iam_user_user_name)
        if resource_aws_s3_bucket_owner_id is not None:
            pulumi.set(__self__, "resource_aws_s3_bucket_owner_id", resource_aws_s3_bucket_owner_id)
        if resource_aws_s3_bucket_owner_name is not None:
            pulumi.set(__self__, "resource_aws_s3_bucket_owner_name", resource_aws_s3_bucket_owner_name)
        if resource_container_image_id is not None:
            pulumi.set(__self__, "resource_container_image_id", resource_container_image_id)
        if resource_container_image_name is not None:
            pulumi.set(__self__, "resource_container_image_name", resource_container_image_name)
        if resource_container_launched_at is not None:
            pulumi.set(__self__, "resource_container_launched_at", resource_container_launched_at)
        if resource_container_name is not None:
            pulumi.set(__self__, "resource_container_name", resource_container_name)
        if resource_details_other is not None:
            pulumi.set(__self__, "resource_details_other", resource_details_other)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_partition is not None:
            pulumi.set(__self__, "resource_partition", resource_partition)
        if resource_region is not None:
            pulumi.set(__self__, "resource_region", resource_region)
        if resource_tags is not None:
            pulumi.set(__self__, "resource_tags", resource_tags)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if sample is not None:
            pulumi.set(__self__, "sample", sample)
        if severity_label is not None:
            pulumi.set(__self__, "severity_label", severity_label)
        if severity_normalized is not None:
            pulumi.set(__self__, "severity_normalized", severity_normalized)
        if severity_product is not None:
            pulumi.set(__self__, "severity_product", severity_product)
        if source_url is not None:
            pulumi.set(__self__, "source_url", source_url)
        if threat_intel_indicator_category is not None:
            pulumi.set(__self__, "threat_intel_indicator_category", threat_intel_indicator_category)
        if threat_intel_indicator_last_observed_at is not None:
            pulumi.set(__self__, "threat_intel_indicator_last_observed_at", threat_intel_indicator_last_observed_at)
        if threat_intel_indicator_source is not None:
            pulumi.set(__self__, "threat_intel_indicator_source", threat_intel_indicator_source)
        if threat_intel_indicator_source_url is not None:
            pulumi.set(__self__, "threat_intel_indicator_source_url", threat_intel_indicator_source_url)
        if threat_intel_indicator_type is not None:
            pulumi.set(__self__, "threat_intel_indicator_type", threat_intel_indicator_type)
        if threat_intel_indicator_value is not None:
            pulumi.set(__self__, "threat_intel_indicator_value", threat_intel_indicator_value)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if user_defined_fields is not None:
            pulumi.set(__self__, "user_defined_fields", user_defined_fields)
        if verification_state is not None:
            pulumi.set(__self__, "verification_state", verification_state)
        if vulnerabilities_exploit_available is not None:
            pulumi.set(__self__, "vulnerabilities_exploit_available", vulnerabilities_exploit_available)
        if vulnerabilities_fix_available is not None:
            pulumi.set(__self__, "vulnerabilities_fix_available", vulnerabilities_fix_available)
        if workflow_state is not None:
            pulumi.set(__self__, "workflow_state", workflow_state)
        if workflow_status is not None:
            pulumi.set(__self__, "workflow_status", workflow_status)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The AWS account ID in which a finding is generated.
        """
        return pulumi.get(self, "aws_account_id")

    @property
    @pulumi.getter(name="awsAccountName")
    def aws_account_name(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The name of the AWS account in which a finding is generated.
        """
        return pulumi.get(self, "aws_account_name")

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The name of the findings provider (company) that owns the solution (product) that generates findings.
        """
        return pulumi.get(self, "company_name")

    @property
    @pulumi.getter(name="complianceAssociatedStandardsId")
    def compliance_associated_standards_id(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The unique identifier of a standard in which a control is enabled.
        """
        return pulumi.get(self, "compliance_associated_standards_id")

    @property
    @pulumi.getter(name="complianceSecurityControlId")
    def compliance_security_control_id(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The unique identifier of a control across standards.
        """
        return pulumi.get(self, "compliance_security_control_id")

    @property
    @pulumi.getter(name="complianceSecurityControlParametersName")
    def compliance_security_control_parameters_name(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The name of a security control parameter.
        """
        return pulumi.get(self, "compliance_security_control_parameters_name")

    @property
    @pulumi.getter(name="complianceSecurityControlParametersValue")
    def compliance_security_control_parameters_value(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The current value of a security control parameter.
        """
        return pulumi.get(self, "compliance_security_control_parameters_value")

    @property
    @pulumi.getter(name="complianceStatus")
    def compliance_status(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        Exclusive to findings that are generated as the result of a check run against a specific rule in a supported standard.
        """
        return pulumi.get(self, "compliance_status")

    @property
    @pulumi.getter
    def confidence(self) -> Optional[Sequence['outputs.InsightNumberFilter']]:
        """
        A finding's confidence.
        """
        return pulumi.get(self, "confidence")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[Sequence['outputs.InsightDateFilter']]:
        """
        An ISO8601-formatted timestamp that indicates when the security findings provider captured the potential security issue that a finding captured.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def criticality(self) -> Optional[Sequence['outputs.InsightNumberFilter']]:
        """
        The level of importance assigned to the resources associated with the finding.
        """
        return pulumi.get(self, "criticality")

    @property
    @pulumi.getter
    def description(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        A finding's description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="findingProviderFieldsConfidence")
    def finding_provider_fields_confidence(self) -> Optional[Sequence['outputs.InsightNumberFilter']]:
        """
        The finding provider value for the finding confidence.
        """
        return pulumi.get(self, "finding_provider_fields_confidence")

    @property
    @pulumi.getter(name="findingProviderFieldsCriticality")
    def finding_provider_fields_criticality(self) -> Optional[Sequence['outputs.InsightNumberFilter']]:
        """
        The finding provider value for the level of importance assigned to the resources associated with the findings.
        """
        return pulumi.get(self, "finding_provider_fields_criticality")

    @property
    @pulumi.getter(name="findingProviderFieldsRelatedFindingsId")
    def finding_provider_fields_related_findings_id(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The finding identifier of a related finding that is identified by the finding provider.
        """
        return pulumi.get(self, "finding_provider_fields_related_findings_id")

    @property
    @pulumi.getter(name="findingProviderFieldsRelatedFindingsProductArn")
    def finding_provider_fields_related_findings_product_arn(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The ARN of the solution that generated a related finding that is identified by the finding provider.
        """
        return pulumi.get(self, "finding_provider_fields_related_findings_product_arn")

    @property
    @pulumi.getter(name="findingProviderFieldsSeverityLabel")
    def finding_provider_fields_severity_label(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The finding provider value for the severity label.
        """
        return pulumi.get(self, "finding_provider_fields_severity_label")

    @property
    @pulumi.getter(name="findingProviderFieldsSeverityOriginal")
    def finding_provider_fields_severity_original(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The finding provider's original value for the severity.
        """
        return pulumi.get(self, "finding_provider_fields_severity_original")

    @property
    @pulumi.getter(name="findingProviderFieldsTypes")
    def finding_provider_fields_types(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        One or more finding types that the finding provider assigned to the finding.
        """
        return pulumi.get(self, "finding_provider_fields_types")

    @property
    @pulumi.getter(name="firstObservedAt")
    def first_observed_at(self) -> Optional[Sequence['outputs.InsightDateFilter']]:
        """
        An ISO8601-formatted timestamp that indicates when the security findings provider first observed the potential security issue that a finding captured.
        """
        return pulumi.get(self, "first_observed_at")

    @property
    @pulumi.getter(name="generatorId")
    def generator_id(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The identifier for the solution-specific component (a discrete unit of logic) that generated a finding.
        """
        return pulumi.get(self, "generator_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The security findings provider-specific identifier for a finding.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def keyword(self) -> Optional[Sequence['outputs.InsightKeywordFilter']]:
        """
        A keyword for a finding.
        """
        return pulumi.get(self, "keyword")

    @property
    @pulumi.getter(name="lastObservedAt")
    def last_observed_at(self) -> Optional[Sequence['outputs.InsightDateFilter']]:
        """
        An ISO8601-formatted timestamp that indicates when the security findings provider most recently observed the potential security issue that a finding captured.
        """
        return pulumi.get(self, "last_observed_at")

    @property
    @pulumi.getter(name="malwareName")
    def malware_name(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The name of the malware that was observed.
        """
        return pulumi.get(self, "malware_name")

    @property
    @pulumi.getter(name="malwarePath")
    def malware_path(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The filesystem path of the malware that was observed.
        """
        return pulumi.get(self, "malware_path")

    @property
    @pulumi.getter(name="malwareState")
    def malware_state(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The state of the malware that was observed.
        """
        return pulumi.get(self, "malware_state")

    @property
    @pulumi.getter(name="malwareType")
    def malware_type(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The type of the malware that was observed.
        """
        return pulumi.get(self, "malware_type")

    @property
    @pulumi.getter(name="networkDestinationDomain")
    def network_destination_domain(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The destination domain of network-related information about a finding.
        """
        return pulumi.get(self, "network_destination_domain")

    @property
    @pulumi.getter(name="networkDestinationIpV4")
    def network_destination_ip_v4(self) -> Optional[Sequence['outputs.InsightIpFilter']]:
        """
        The destination IPv4 address of network-related information about a finding.
        """
        return pulumi.get(self, "network_destination_ip_v4")

    @property
    @pulumi.getter(name="networkDestinationIpV6")
    def network_destination_ip_v6(self) -> Optional[Sequence['outputs.InsightIpFilter']]:
        """
        The destination IPv6 address of network-related information about a finding.
        """
        return pulumi.get(self, "network_destination_ip_v6")

    @property
    @pulumi.getter(name="networkDestinationPort")
    def network_destination_port(self) -> Optional[Sequence['outputs.InsightNumberFilter']]:
        """
        The destination port of network-related information about a finding.
        """
        return pulumi.get(self, "network_destination_port")

    @property
    @pulumi.getter(name="networkDirection")
    def network_direction(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        Indicates the direction of network traffic associated with a finding.
        """
        return pulumi.get(self, "network_direction")

    @property
    @pulumi.getter(name="networkProtocol")
    def network_protocol(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The protocol of network-related information about a finding.
        """
        return pulumi.get(self, "network_protocol")

    @property
    @pulumi.getter(name="networkSourceDomain")
    def network_source_domain(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The source domain of network-related information about a finding.
        """
        return pulumi.get(self, "network_source_domain")

    @property
    @pulumi.getter(name="networkSourceIpV4")
    def network_source_ip_v4(self) -> Optional[Sequence['outputs.InsightIpFilter']]:
        """
        The source IPv4 address of network-related information about a finding.
        """
        return pulumi.get(self, "network_source_ip_v4")

    @property
    @pulumi.getter(name="networkSourceIpV6")
    def network_source_ip_v6(self) -> Optional[Sequence['outputs.InsightIpFilter']]:
        """
        The source IPv6 address of network-related information about a finding.
        """
        return pulumi.get(self, "network_source_ip_v6")

    @property
    @pulumi.getter(name="networkSourceMac")
    def network_source_mac(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The source media access control (MAC) address of network-related information about a finding.
        """
        return pulumi.get(self, "network_source_mac")

    @property
    @pulumi.getter(name="networkSourcePort")
    def network_source_port(self) -> Optional[Sequence['outputs.InsightNumberFilter']]:
        """
        The source port of network-related information about a finding.
        """
        return pulumi.get(self, "network_source_port")

    @property
    @pulumi.getter(name="noteText")
    def note_text(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The text of a note.
        """
        return pulumi.get(self, "note_text")

    @property
    @pulumi.getter(name="noteUpdatedAt")
    def note_updated_at(self) -> Optional[Sequence['outputs.InsightDateFilter']]:
        """
        The timestamp of when the note was updated.
        """
        return pulumi.get(self, "note_updated_at")

    @property
    @pulumi.getter(name="noteUpdatedBy")
    def note_updated_by(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The principal that created a note.
        """
        return pulumi.get(self, "note_updated_by")

    @property
    @pulumi.getter(name="processLaunchedAt")
    def process_launched_at(self) -> Optional[Sequence['outputs.InsightDateFilter']]:
        """
        A timestamp that identifies when the process was launched.
        """
        return pulumi.get(self, "process_launched_at")

    @property
    @pulumi.getter(name="processName")
    def process_name(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The name of the process.
        """
        return pulumi.get(self, "process_name")

    @property
    @pulumi.getter(name="processParentPid")
    def process_parent_pid(self) -> Optional[Sequence['outputs.InsightNumberFilter']]:
        """
        The parent process ID.
        """
        return pulumi.get(self, "process_parent_pid")

    @property
    @pulumi.getter(name="processPath")
    def process_path(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The path to the process executable.
        """
        return pulumi.get(self, "process_path")

    @property
    @pulumi.getter(name="processPid")
    def process_pid(self) -> Optional[Sequence['outputs.InsightNumberFilter']]:
        """
        The process ID.
        """
        return pulumi.get(self, "process_pid")

    @property
    @pulumi.getter(name="processTerminatedAt")
    def process_terminated_at(self) -> Optional[Sequence['outputs.InsightDateFilter']]:
        """
        A timestamp that identifies when the process was terminated.
        """
        return pulumi.get(self, "process_terminated_at")

    @property
    @pulumi.getter(name="productArn")
    def product_arn(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider) after this provider's product (solution that generates findings) is registered with Security Hub.
        """
        return pulumi.get(self, "product_arn")

    @property
    @pulumi.getter(name="productFields")
    def product_fields(self) -> Optional[Sequence['outputs.InsightMapFilter']]:
        """
        A data type where security findings providers can include additional solution-specific details that aren't part of the defined AwsSecurityFinding format.
        """
        return pulumi.get(self, "product_fields")

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The name of the solution (product) that generates findings.
        """
        return pulumi.get(self, "product_name")

    @property
    @pulumi.getter(name="recommendationText")
    def recommendation_text(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The recommendation of what to do about the issue described in a finding.
        """
        return pulumi.get(self, "recommendation_text")

    @property
    @pulumi.getter(name="recordState")
    def record_state(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The updated record state for the finding.
        """
        return pulumi.get(self, "record_state")

    @property
    @pulumi.getter
    def region(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The Region from which the finding was generated.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="relatedFindingsId")
    def related_findings_id(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The solution-generated identifier for a related finding.
        """
        return pulumi.get(self, "related_findings_id")

    @property
    @pulumi.getter(name="relatedFindingsProductArn")
    def related_findings_product_arn(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The ARN of the solution that generated a related finding.
        """
        return pulumi.get(self, "related_findings_product_arn")

    @property
    @pulumi.getter(name="resourceApplicationArn")
    def resource_application_arn(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The ARN of the application that is related to a finding.
        """
        return pulumi.get(self, "resource_application_arn")

    @property
    @pulumi.getter(name="resourceApplicationName")
    def resource_application_name(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The name of the application that is related to a finding.
        """
        return pulumi.get(self, "resource_application_name")

    @property
    @pulumi.getter(name="resourceAwsEc2InstanceIamInstanceProfileArn")
    def resource_aws_ec2_instance_iam_instance_profile_arn(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The IAM profile ARN of the instance.
        """
        return pulumi.get(self, "resource_aws_ec2_instance_iam_instance_profile_arn")

    @property
    @pulumi.getter(name="resourceAwsEc2InstanceImageId")
    def resource_aws_ec2_instance_image_id(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The Amazon Machine Image (AMI) ID of the instance.
        """
        return pulumi.get(self, "resource_aws_ec2_instance_image_id")

    @property
    @pulumi.getter(name="resourceAwsEc2InstanceIpV4Addresses")
    def resource_aws_ec2_instance_ip_v4_addresses(self) -> Optional[Sequence['outputs.InsightIpFilter']]:
        """
        The IPv4 addresses associated with the instance.
        """
        return pulumi.get(self, "resource_aws_ec2_instance_ip_v4_addresses")

    @property
    @pulumi.getter(name="resourceAwsEc2InstanceIpV6Addresses")
    def resource_aws_ec2_instance_ip_v6_addresses(self) -> Optional[Sequence['outputs.InsightIpFilter']]:
        """
        The IPv6 addresses associated with the instance.
        """
        return pulumi.get(self, "resource_aws_ec2_instance_ip_v6_addresses")

    @property
    @pulumi.getter(name="resourceAwsEc2InstanceKeyName")
    def resource_aws_ec2_instance_key_name(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The key name associated with the instance.
        """
        return pulumi.get(self, "resource_aws_ec2_instance_key_name")

    @property
    @pulumi.getter(name="resourceAwsEc2InstanceLaunchedAt")
    def resource_aws_ec2_instance_launched_at(self) -> Optional[Sequence['outputs.InsightDateFilter']]:
        """
        The date and time the instance was launched.
        """
        return pulumi.get(self, "resource_aws_ec2_instance_launched_at")

    @property
    @pulumi.getter(name="resourceAwsEc2InstanceSubnetId")
    def resource_aws_ec2_instance_subnet_id(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The identifier of the subnet that the instance was launched in.
        """
        return pulumi.get(self, "resource_aws_ec2_instance_subnet_id")

    @property
    @pulumi.getter(name="resourceAwsEc2InstanceType")
    def resource_aws_ec2_instance_type(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The instance type of the instance.
        """
        return pulumi.get(self, "resource_aws_ec2_instance_type")

    @property
    @pulumi.getter(name="resourceAwsEc2InstanceVpcId")
    def resource_aws_ec2_instance_vpc_id(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The identifier of the VPC that the instance was launched in.
        """
        return pulumi.get(self, "resource_aws_ec2_instance_vpc_id")

    @property
    @pulumi.getter(name="resourceAwsIamAccessKeyCreatedAt")
    def resource_aws_iam_access_key_created_at(self) -> Optional[Sequence['outputs.InsightDateFilter']]:
        """
        The creation date/time of the IAM access key related to a finding.
        """
        return pulumi.get(self, "resource_aws_iam_access_key_created_at")

    @property
    @pulumi.getter(name="resourceAwsIamAccessKeyPrincipalName")
    def resource_aws_iam_access_key_principal_name(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The name of the principal that is associated with an IAM access key.
        """
        return pulumi.get(self, "resource_aws_iam_access_key_principal_name")

    @property
    @pulumi.getter(name="resourceAwsIamAccessKeyStatus")
    def resource_aws_iam_access_key_status(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The status of the IAM access key related to a finding.
        """
        return pulumi.get(self, "resource_aws_iam_access_key_status")

    @property
    @pulumi.getter(name="resourceAwsIamAccessKeyUserName")
    def resource_aws_iam_access_key_user_name(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The user associated with the IAM access key related to a finding.
        """
        return pulumi.get(self, "resource_aws_iam_access_key_user_name")

    @property
    @pulumi.getter(name="resourceAwsIamUserUserName")
    def resource_aws_iam_user_user_name(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The name of an IAM user.
        """
        return pulumi.get(self, "resource_aws_iam_user_user_name")

    @property
    @pulumi.getter(name="resourceAwsS3BucketOwnerId")
    def resource_aws_s3_bucket_owner_id(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The canonical user ID of the owner of the S3 bucket.
        """
        return pulumi.get(self, "resource_aws_s3_bucket_owner_id")

    @property
    @pulumi.getter(name="resourceAwsS3BucketOwnerName")
    def resource_aws_s3_bucket_owner_name(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The display name of the owner of the S3 bucket.
        """
        return pulumi.get(self, "resource_aws_s3_bucket_owner_name")

    @property
    @pulumi.getter(name="resourceContainerImageId")
    def resource_container_image_id(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The identifier of the image related to a finding.
        """
        return pulumi.get(self, "resource_container_image_id")

    @property
    @pulumi.getter(name="resourceContainerImageName")
    def resource_container_image_name(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The name of the image related to a finding.
        """
        return pulumi.get(self, "resource_container_image_name")

    @property
    @pulumi.getter(name="resourceContainerLaunchedAt")
    def resource_container_launched_at(self) -> Optional[Sequence['outputs.InsightDateFilter']]:
        """
        A timestamp that identifies when the container was started.
        """
        return pulumi.get(self, "resource_container_launched_at")

    @property
    @pulumi.getter(name="resourceContainerName")
    def resource_container_name(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The name of the container related to a finding.
        """
        return pulumi.get(self, "resource_container_name")

    @property
    @pulumi.getter(name="resourceDetailsOther")
    def resource_details_other(self) -> Optional[Sequence['outputs.InsightMapFilter']]:
        """
        The details of a resource that doesn't have a specific subfield for the resource type defined.
        """
        return pulumi.get(self, "resource_details_other")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The canonical identifier for the given resource type.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourcePartition")
    def resource_partition(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The canonical AWS partition name that the Region is assigned to.
        """
        return pulumi.get(self, "resource_partition")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The canonical AWS external Region name where this resource is located.
        """
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[Sequence['outputs.InsightMapFilter']]:
        """
        A list of AWS tags associated with a resource at the time the finding was processed.
        """
        return pulumi.get(self, "resource_tags")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        Specifies the type of the resource that details are provided for.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def sample(self) -> Optional[Sequence['outputs.InsightBooleanFilter']]:
        """
        Indicates whether or not sample findings are included in the filter results.
        """
        return pulumi.get(self, "sample")

    @property
    @pulumi.getter(name="severityLabel")
    def severity_label(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The label of a finding's severity.
        """
        return pulumi.get(self, "severity_label")

    @property
    @pulumi.getter(name="severityNormalized")
    def severity_normalized(self) -> Optional[Sequence['outputs.InsightNumberFilter']]:
        """
        The normalized severity of a finding.
        """
        return pulumi.get(self, "severity_normalized")

    @property
    @pulumi.getter(name="severityProduct")
    def severity_product(self) -> Optional[Sequence['outputs.InsightNumberFilter']]:
        """
        The native severity as defined by the security findings provider's solution that generated the finding.
        """
        return pulumi.get(self, "severity_product")

    @property
    @pulumi.getter(name="sourceUrl")
    def source_url(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        A URL that links to a page about the current finding in the security findings provider's solution.
        """
        return pulumi.get(self, "source_url")

    @property
    @pulumi.getter(name="threatIntelIndicatorCategory")
    def threat_intel_indicator_category(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The category of a threat intelligence indicator.
        """
        return pulumi.get(self, "threat_intel_indicator_category")

    @property
    @pulumi.getter(name="threatIntelIndicatorLastObservedAt")
    def threat_intel_indicator_last_observed_at(self) -> Optional[Sequence['outputs.InsightDateFilter']]:
        """
        A timestamp that identifies the last observation of a threat intelligence indicator.
        """
        return pulumi.get(self, "threat_intel_indicator_last_observed_at")

    @property
    @pulumi.getter(name="threatIntelIndicatorSource")
    def threat_intel_indicator_source(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The source of the threat intelligence.
        """
        return pulumi.get(self, "threat_intel_indicator_source")

    @property
    @pulumi.getter(name="threatIntelIndicatorSourceUrl")
    def threat_intel_indicator_source_url(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The URL for more details from the source of the threat intelligence.
        """
        return pulumi.get(self, "threat_intel_indicator_source_url")

    @property
    @pulumi.getter(name="threatIntelIndicatorType")
    def threat_intel_indicator_type(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The type of a threat intelligence indicator.
        """
        return pulumi.get(self, "threat_intel_indicator_type")

    @property
    @pulumi.getter(name="threatIntelIndicatorValue")
    def threat_intel_indicator_value(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The value of a threat intelligence indicator.
        """
        return pulumi.get(self, "threat_intel_indicator_value")

    @property
    @pulumi.getter
    def title(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        A finding's title.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def type(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        A finding type in the format of namespace/category/classifier that classifies a finding.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[Sequence['outputs.InsightDateFilter']]:
        """
        An ISO8601-formatted timestamp that indicates when the security findings provider last updated the finding record.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="userDefinedFields")
    def user_defined_fields(self) -> Optional[Sequence['outputs.InsightMapFilter']]:
        """
        A list of name/value string pairs associated with the finding.
        """
        return pulumi.get(self, "user_defined_fields")

    @property
    @pulumi.getter(name="verificationState")
    def verification_state(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The veracity of a finding.
        """
        return pulumi.get(self, "verification_state")

    @property
    @pulumi.getter(name="vulnerabilitiesExploitAvailable")
    def vulnerabilities_exploit_available(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        Indicates whether a software vulnerability in your environment has a known exploit.
        """
        return pulumi.get(self, "vulnerabilities_exploit_available")

    @property
    @pulumi.getter(name="vulnerabilitiesFixAvailable")
    def vulnerabilities_fix_available(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        Indicates whether a vulnerability is fixed in a newer version of the affected software packages.
        """
        return pulumi.get(self, "vulnerabilities_fix_available")

    @property
    @pulumi.getter(name="workflowState")
    def workflow_state(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The workflow state of a finding.
        """
        return pulumi.get(self, "workflow_state")

    @property
    @pulumi.getter(name="workflowStatus")
    def workflow_status(self) -> Optional[Sequence['outputs.InsightStringFilter']]:
        """
        The status of the investigation into a finding.
        """
        return pulumi.get(self, "workflow_status")


@pulumi.output_type
class InsightBooleanFilter(dict):
    """
    Boolean filter for querying findings.
    """
    def __init__(__self__, *,
                 value: bool):
        """
        Boolean filter for querying findings.
        :param bool value: The value of the boolean.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> bool:
        """
        The value of the boolean.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InsightDateFilter(dict):
    """
    A date filter for querying findings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dateRange":
            suggest = "date_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InsightDateFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InsightDateFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InsightDateFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date_range: Optional['outputs.InsightDateRange'] = None,
                 end: Optional[str] = None,
                 start: Optional[str] = None):
        """
        A date filter for querying findings.
        """
        if date_range is not None:
            pulumi.set(__self__, "date_range", date_range)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter(name="dateRange")
    def date_range(self) -> Optional['outputs.InsightDateRange']:
        return pulumi.get(self, "date_range")

    @property
    @pulumi.getter
    def end(self) -> Optional[str]:
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def start(self) -> Optional[str]:
        return pulumi.get(self, "start")


@pulumi.output_type
class InsightDateRange(dict):
    """
    A date range for the date filter.
    """
    def __init__(__self__, *,
                 unit: 'InsightDateRangeUnit',
                 value: float):
        """
        A date range for the date filter.
        :param 'InsightDateRangeUnit' unit: A date range unit for the date filter.
        :param float value: A date range value for the date filter.
        """
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> 'InsightDateRangeUnit':
        """
        A date range unit for the date filter.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        A date range value for the date filter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InsightIpFilter(dict):
    """
    The IP filter for querying findings.
    """
    def __init__(__self__, *,
                 cidr: str):
        """
        The IP filter for querying findings.
        :param str cidr: A finding's CIDR value.
        """
        pulumi.set(__self__, "cidr", cidr)

    @property
    @pulumi.getter
    def cidr(self) -> str:
        """
        A finding's CIDR value.
        """
        return pulumi.get(self, "cidr")


@pulumi.output_type
class InsightKeywordFilter(dict):
    """
    A keyword filter for querying findings.
    """
    def __init__(__self__, *,
                 value: str):
        """
        A keyword filter for querying findings.
        :param str value: A value for the keyword.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        A value for the keyword.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InsightMapFilter(dict):
    """
    A map filter for filtering AWS Security Hub findings.
    """
    def __init__(__self__, *,
                 comparison: 'InsightMapFilterComparison',
                 key: str,
                 value: str):
        """
        A map filter for filtering AWS Security Hub findings.
        :param 'InsightMapFilterComparison' comparison: The condition to apply to the key value when filtering Security Hub findings with a map filter.
        """
        pulumi.set(__self__, "comparison", comparison)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def comparison(self) -> 'InsightMapFilterComparison':
        """
        The condition to apply to the key value when filtering Security Hub findings with a map filter.
        """
        return pulumi.get(self, "comparison")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class InsightNumberFilter(dict):
    """
    A number filter for querying findings.
    """
    def __init__(__self__, *,
                 eq: Optional[float] = None,
                 gte: Optional[float] = None,
                 lte: Optional[float] = None):
        """
        A number filter for querying findings.
        :param float eq: The equal-to condition to be applied to a single field when querying for findings.
        :param float gte: The greater-than-equal condition to be applied to a single field when querying for findings.
        :param float lte: The less-than-equal condition to be applied to a single field when querying for findings.
        """
        if eq is not None:
            pulumi.set(__self__, "eq", eq)
        if gte is not None:
            pulumi.set(__self__, "gte", gte)
        if lte is not None:
            pulumi.set(__self__, "lte", lte)

    @property
    @pulumi.getter
    def eq(self) -> Optional[float]:
        """
        The equal-to condition to be applied to a single field when querying for findings.
        """
        return pulumi.get(self, "eq")

    @property
    @pulumi.getter
    def gte(self) -> Optional[float]:
        """
        The greater-than-equal condition to be applied to a single field when querying for findings.
        """
        return pulumi.get(self, "gte")

    @property
    @pulumi.getter
    def lte(self) -> Optional[float]:
        """
        The less-than-equal condition to be applied to a single field when querying for findings.
        """
        return pulumi.get(self, "lte")


@pulumi.output_type
class InsightStringFilter(dict):
    """
    A string filter for filtering AWS Security Hub findings.
    """
    def __init__(__self__, *,
                 comparison: 'InsightStringFilterComparison',
                 value: str):
        """
        A string filter for filtering AWS Security Hub findings.
        """
        pulumi.set(__self__, "comparison", comparison)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def comparison(self) -> 'InsightStringFilterComparison':
        return pulumi.get(self, "comparison")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class StandardsControl(dict):
    """
    Provides details about an individual security control. For a list of ASH controls, see [controls reference](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-controls-reference.html) in the *User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "standardsControlArn":
            suggest = "standards_control_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardsControl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardsControl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardsControl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 standards_control_arn: str,
                 reason: Optional[str] = None):
        """
        Provides details about an individual security control. For a list of ASH controls, see [controls reference](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-controls-reference.html) in the *User Guide*.
        :param str standards_control_arn: The Amazon Resource Name (ARN) of the control.
        :param str reason: A user-defined reason for changing a control's enablement status in a specified standard. If you are disabling a control, then this property is required.
        """
        pulumi.set(__self__, "standards_control_arn", standards_control_arn)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter(name="standardsControlArn")
    def standards_control_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the control.
        """
        return pulumi.get(self, "standards_control_arn")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        A user-defined reason for changing a control's enablement status in a specified standard. If you are disabling a control, then this property is required.
        """
        return pulumi.get(self, "reason")


