# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['HubArgs', 'Hub']

@pulumi.input_type
class HubArgs:
    def __init__(__self__, *,
                 auto_enable_controls: Optional[pulumi.Input[bool]] = None,
                 control_finding_generator: Optional[pulumi.Input[str]] = None,
                 enable_default_standards: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Hub resource.
        :param pulumi.Input[bool] auto_enable_controls: Whether to automatically enable new controls when they are added to standards that are enabled
        :param pulumi.Input[str] control_finding_generator: This field, used when enabling Security Hub, specifies whether the calling account has consolidated control findings turned on. If the value for this field is set to SECURITY_CONTROL, Security Hub generates a single finding for a control check even when the check applies to multiple enabled standards.  If the value for this field is set to STANDARD_CONTROL, Security Hub generates separate findings for a control check when the check applies to multiple enabled standards.
        :param pulumi.Input[bool] enable_default_standards: Whether to enable the security standards that Security Hub has designated as automatically enabled.
        """
        if auto_enable_controls is not None:
            pulumi.set(__self__, "auto_enable_controls", auto_enable_controls)
        if control_finding_generator is not None:
            pulumi.set(__self__, "control_finding_generator", control_finding_generator)
        if enable_default_standards is not None:
            pulumi.set(__self__, "enable_default_standards", enable_default_standards)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="autoEnableControls")
    def auto_enable_controls(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically enable new controls when they are added to standards that are enabled
        """
        return pulumi.get(self, "auto_enable_controls")

    @auto_enable_controls.setter
    def auto_enable_controls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_enable_controls", value)

    @property
    @pulumi.getter(name="controlFindingGenerator")
    def control_finding_generator(self) -> Optional[pulumi.Input[str]]:
        """
        This field, used when enabling Security Hub, specifies whether the calling account has consolidated control findings turned on. If the value for this field is set to SECURITY_CONTROL, Security Hub generates a single finding for a control check even when the check applies to multiple enabled standards.  If the value for this field is set to STANDARD_CONTROL, Security Hub generates separate findings for a control check when the check applies to multiple enabled standards.
        """
        return pulumi.get(self, "control_finding_generator")

    @control_finding_generator.setter
    def control_finding_generator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "control_finding_generator", value)

    @property
    @pulumi.getter(name="enableDefaultStandards")
    def enable_default_standards(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable the security standards that Security Hub has designated as automatically enabled.
        """
        return pulumi.get(self, "enable_default_standards")

    @enable_default_standards.setter
    def enable_default_standards(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_default_standards", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class Hub(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_enable_controls: Optional[pulumi.Input[bool]] = None,
                 control_finding_generator: Optional[pulumi.Input[str]] = None,
                 enable_default_standards: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        The AWS::SecurityHub::Hub resource represents the implementation of the AWS Security Hub service in your account. One hub resource is created for each Region in which you enable Security Hub.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        example_hub_with_tags = aws_native.securityhub.Hub("exampleHubWithTags",
            tags={
                "key1": "value1",
                "key2": "value2",
            },
            enable_default_standards=True,
            control_finding_generator="SECURITY_CONTROL")
        pulumi.export("hubArn", example_hub_with_tags.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        example_hub_with_tags = aws_native.securityhub.Hub("exampleHubWithTags",
            tags={
                "key1": "value1",
                "key2": "value2",
            },
            enable_default_standards=True,
            control_finding_generator="SECURITY_CONTROL")
        pulumi.export("hubArn", example_hub_with_tags.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        example_hub_with_tags = aws_native.securityhub.Hub("exampleHubWithTags",
            tags={
                "key1": "value1",
                "key2": "value2",
            },
            enable_default_standards=False,
            control_finding_generator="STANDARD_CONTROL")
        pulumi.export("hubArn", example_hub_with_tags.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        example_hub_with_tags = aws_native.securityhub.Hub("exampleHubWithTags",
            tags={
                "key1": "value1",
                "key2": "value2",
            },
            enable_default_standards=False,
            control_finding_generator="STANDARD_CONTROL")
        pulumi.export("hubArn", example_hub_with_tags.id)

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_enable_controls: Whether to automatically enable new controls when they are added to standards that are enabled
        :param pulumi.Input[str] control_finding_generator: This field, used when enabling Security Hub, specifies whether the calling account has consolidated control findings turned on. If the value for this field is set to SECURITY_CONTROL, Security Hub generates a single finding for a control check even when the check applies to multiple enabled standards.  If the value for this field is set to STANDARD_CONTROL, Security Hub generates separate findings for a control check when the check applies to multiple enabled standards.
        :param pulumi.Input[bool] enable_default_standards: Whether to enable the security standards that Security Hub has designated as automatically enabled.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[HubArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::SecurityHub::Hub resource represents the implementation of the AWS Security Hub service in your account. One hub resource is created for each Region in which you enable Security Hub.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        example_hub_with_tags = aws_native.securityhub.Hub("exampleHubWithTags",
            tags={
                "key1": "value1",
                "key2": "value2",
            },
            enable_default_standards=True,
            control_finding_generator="SECURITY_CONTROL")
        pulumi.export("hubArn", example_hub_with_tags.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        example_hub_with_tags = aws_native.securityhub.Hub("exampleHubWithTags",
            tags={
                "key1": "value1",
                "key2": "value2",
            },
            enable_default_standards=True,
            control_finding_generator="SECURITY_CONTROL")
        pulumi.export("hubArn", example_hub_with_tags.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        example_hub_with_tags = aws_native.securityhub.Hub("exampleHubWithTags",
            tags={
                "key1": "value1",
                "key2": "value2",
            },
            enable_default_standards=False,
            control_finding_generator="STANDARD_CONTROL")
        pulumi.export("hubArn", example_hub_with_tags.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        example_hub_with_tags = aws_native.securityhub.Hub("exampleHubWithTags",
            tags={
                "key1": "value1",
                "key2": "value2",
            },
            enable_default_standards=False,
            control_finding_generator="STANDARD_CONTROL")
        pulumi.export("hubArn", example_hub_with_tags.id)

        ```

        :param str resource_name: The name of the resource.
        :param HubArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HubArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_enable_controls: Optional[pulumi.Input[bool]] = None,
                 control_finding_generator: Optional[pulumi.Input[str]] = None,
                 enable_default_standards: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HubArgs.__new__(HubArgs)

            __props__.__dict__["auto_enable_controls"] = auto_enable_controls
            __props__.__dict__["control_finding_generator"] = control_finding_generator
            __props__.__dict__["enable_default_standards"] = enable_default_standards
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["subscribed_at"] = None
        super(Hub, __self__).__init__(
            'aws-native:securityhub:Hub',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Hub':
        """
        Get an existing Hub resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = HubArgs.__new__(HubArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["auto_enable_controls"] = None
        __props__.__dict__["control_finding_generator"] = None
        __props__.__dict__["enable_default_standards"] = None
        __props__.__dict__["subscribed_at"] = None
        __props__.__dict__["tags"] = None
        return Hub(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        An ARN is automatically created for the customer.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoEnableControls")
    def auto_enable_controls(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to automatically enable new controls when they are added to standards that are enabled
        """
        return pulumi.get(self, "auto_enable_controls")

    @property
    @pulumi.getter(name="controlFindingGenerator")
    def control_finding_generator(self) -> pulumi.Output[Optional[str]]:
        """
        This field, used when enabling Security Hub, specifies whether the calling account has consolidated control findings turned on. If the value for this field is set to SECURITY_CONTROL, Security Hub generates a single finding for a control check even when the check applies to multiple enabled standards.  If the value for this field is set to STANDARD_CONTROL, Security Hub generates separate findings for a control check when the check applies to multiple enabled standards.
        """
        return pulumi.get(self, "control_finding_generator")

    @property
    @pulumi.getter(name="enableDefaultStandards")
    def enable_default_standards(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable the security standards that Security Hub has designated as automatically enabled.
        """
        return pulumi.get(self, "enable_default_standards")

    @property
    @pulumi.getter(name="subscribedAt")
    def subscribed_at(self) -> pulumi.Output[str]:
        """
        The date and time when Security Hub was enabled in the account.
        """
        return pulumi.get(self, "subscribed_at")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "tags")

