# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'GetDelegatedAdminResult',
    'AwaitableGetDelegatedAdminResult',
    'get_delegated_admin',
    'get_delegated_admin_output',
]

@pulumi.output_type
class GetDelegatedAdminResult:
    def __init__(__self__, delegated_admin_identifier=None, status=None):
        if delegated_admin_identifier and not isinstance(delegated_admin_identifier, str):
            raise TypeError("Expected argument 'delegated_admin_identifier' to be a str")
        pulumi.set(__self__, "delegated_admin_identifier", delegated_admin_identifier)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="delegatedAdminIdentifier")
    def delegated_admin_identifier(self) -> Optional[str]:
        """
        The identifier of the DelegatedAdmin being created and assigned as the unique identifier
        """
        return pulumi.get(self, "delegated_admin_identifier")

    @property
    @pulumi.getter
    def status(self) -> Optional['DelegatedAdminStatus']:
        """
        The current status of the Security Hub administrator account. Indicates whether the account is currently enabled as a Security Hub administrator
        """
        return pulumi.get(self, "status")


class AwaitableGetDelegatedAdminResult(GetDelegatedAdminResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDelegatedAdminResult(
            delegated_admin_identifier=self.delegated_admin_identifier,
            status=self.status)


def get_delegated_admin(delegated_admin_identifier: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDelegatedAdminResult:
    """
    The AWS::SecurityHub::DelegatedAdmin resource represents the AWS Security Hub delegated admin account in your organization. One delegated admin resource is allowed to create for the organization in each region in which you configure the AdminAccountId.


    :param str delegated_admin_identifier: The identifier of the DelegatedAdmin being created and assigned as the unique identifier
    """
    __args__ = dict()
    __args__['delegatedAdminIdentifier'] = delegated_admin_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:securityhub:getDelegatedAdmin', __args__, opts=opts, typ=GetDelegatedAdminResult).value

    return AwaitableGetDelegatedAdminResult(
        delegated_admin_identifier=pulumi.get(__ret__, 'delegated_admin_identifier'),
        status=pulumi.get(__ret__, 'status'))


@_utilities.lift_output_func(get_delegated_admin)
def get_delegated_admin_output(delegated_admin_identifier: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDelegatedAdminResult]:
    """
    The AWS::SecurityHub::DelegatedAdmin resource represents the AWS Security Hub delegated admin account in your organization. One delegated admin resource is allowed to create for the organization in each region in which you configure the AdminAccountId.


    :param str delegated_admin_identifier: The identifier of the DelegatedAdmin being created and assigned as the unique identifier
    """
    ...
