# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['ModelCardArgs', 'ModelCard']

@pulumi.input_type
class ModelCardArgs:
    def __init__(__self__, *,
                 content: pulumi.Input['ModelCardContentArgs'],
                 model_card_status: pulumi.Input['ModelCardStatus'],
                 created_by: Optional[pulumi.Input['ModelCardUserContextArgs']] = None,
                 last_modified_by: Optional[pulumi.Input['ModelCardUserContextArgs']] = None,
                 model_card_name: Optional[pulumi.Input[str]] = None,
                 security_config: Optional[pulumi.Input['ModelCardSecurityConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a ModelCard resource.
        :param pulumi.Input['ModelCardStatus'] model_card_status: The approval status of the model card within your organization. Different organizations might have different criteria for model card review and approval.
        :param pulumi.Input['ModelCardUserContextArgs'] created_by: Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
        :param pulumi.Input['ModelCardUserContextArgs'] last_modified_by: Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
        :param pulumi.Input[str] model_card_name: The unique name of the model card.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Key-value pairs used to manage metadata for model cards.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "model_card_status", model_card_status)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if model_card_name is not None:
            pulumi.set(__self__, "model_card_name", model_card_name)
        if security_config is not None:
            pulumi.set(__self__, "security_config", security_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input['ModelCardContentArgs']:
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input['ModelCardContentArgs']):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="modelCardStatus")
    def model_card_status(self) -> pulumi.Input['ModelCardStatus']:
        """
        The approval status of the model card within your organization. Different organizations might have different criteria for model card review and approval.
        """
        return pulumi.get(self, "model_card_status")

    @model_card_status.setter
    def model_card_status(self, value: pulumi.Input['ModelCardStatus']):
        pulumi.set(self, "model_card_status", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input['ModelCardUserContextArgs']]:
        """
        Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input['ModelCardUserContextArgs']]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[pulumi.Input['ModelCardUserContextArgs']]:
        """
        Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
        """
        return pulumi.get(self, "last_modified_by")

    @last_modified_by.setter
    def last_modified_by(self, value: Optional[pulumi.Input['ModelCardUserContextArgs']]):
        pulumi.set(self, "last_modified_by", value)

    @property
    @pulumi.getter(name="modelCardName")
    def model_card_name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique name of the model card.
        """
        return pulumi.get(self, "model_card_name")

    @model_card_name.setter
    def model_card_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_card_name", value)

    @property
    @pulumi.getter(name="securityConfig")
    def security_config(self) -> Optional[pulumi.Input['ModelCardSecurityConfigArgs']]:
        return pulumi.get(self, "security_config")

    @security_config.setter
    def security_config(self, value: Optional[pulumi.Input['ModelCardSecurityConfigArgs']]):
        pulumi.set(self, "security_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Key-value pairs used to manage metadata for model cards.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class ModelCard(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[pulumi.InputType['ModelCardContentArgs']]] = None,
                 created_by: Optional[pulumi.Input[pulumi.InputType['ModelCardUserContextArgs']]] = None,
                 last_modified_by: Optional[pulumi.Input[pulumi.InputType['ModelCardUserContextArgs']]] = None,
                 model_card_name: Optional[pulumi.Input[str]] = None,
                 model_card_status: Optional[pulumi.Input['ModelCardStatus']] = None,
                 security_config: Optional[pulumi.Input[pulumi.InputType['ModelCardSecurityConfigArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SageMaker::ModelCard.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ModelCardUserContextArgs']] created_by: Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
        :param pulumi.Input[pulumi.InputType['ModelCardUserContextArgs']] last_modified_by: Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
        :param pulumi.Input[str] model_card_name: The unique name of the model card.
        :param pulumi.Input['ModelCardStatus'] model_card_status: The approval status of the model card within your organization. Different organizations might have different criteria for model card review and approval.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]] tags: Key-value pairs used to manage metadata for model cards.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ModelCardArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SageMaker::ModelCard.

        :param str resource_name: The name of the resource.
        :param ModelCardArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ModelCardArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[pulumi.InputType['ModelCardContentArgs']]] = None,
                 created_by: Optional[pulumi.Input[pulumi.InputType['ModelCardUserContextArgs']]] = None,
                 last_modified_by: Optional[pulumi.Input[pulumi.InputType['ModelCardUserContextArgs']]] = None,
                 model_card_name: Optional[pulumi.Input[str]] = None,
                 model_card_status: Optional[pulumi.Input['ModelCardStatus']] = None,
                 security_config: Optional[pulumi.Input[pulumi.InputType['ModelCardSecurityConfigArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ModelCardArgs.__new__(ModelCardArgs)

            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            __props__.__dict__["created_by"] = created_by
            __props__.__dict__["last_modified_by"] = last_modified_by
            __props__.__dict__["model_card_name"] = model_card_name
            if model_card_status is None and not opts.urn:
                raise TypeError("Missing required property 'model_card_status'")
            __props__.__dict__["model_card_status"] = model_card_status
            __props__.__dict__["security_config"] = security_config
            __props__.__dict__["tags"] = tags
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["last_modified_time"] = None
            __props__.__dict__["model_card_arn"] = None
            __props__.__dict__["model_card_processing_status"] = None
            __props__.__dict__["model_card_version"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["modelCardName", "securityConfig"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ModelCard, __self__).__init__(
            'aws-native:sagemaker:ModelCard',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ModelCard':
        """
        Get an existing ModelCard resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ModelCardArgs.__new__(ModelCardArgs)

        __props__.__dict__["content"] = None
        __props__.__dict__["created_by"] = None
        __props__.__dict__["creation_time"] = None
        __props__.__dict__["last_modified_by"] = None
        __props__.__dict__["last_modified_time"] = None
        __props__.__dict__["model_card_arn"] = None
        __props__.__dict__["model_card_name"] = None
        __props__.__dict__["model_card_processing_status"] = None
        __props__.__dict__["model_card_status"] = None
        __props__.__dict__["model_card_version"] = None
        __props__.__dict__["security_config"] = None
        __props__.__dict__["tags"] = None
        return ModelCard(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output['outputs.ModelCardContent']:
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[Optional['outputs.ModelCardUserContext']]:
        """
        Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        The date and time the model card was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> pulumi.Output[Optional['outputs.ModelCardUserContext']]:
        """
        Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[str]:
        """
        The date and time the model card was last modified.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="modelCardArn")
    def model_card_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the successfully created model card.
        """
        return pulumi.get(self, "model_card_arn")

    @property
    @pulumi.getter(name="modelCardName")
    def model_card_name(self) -> pulumi.Output[str]:
        """
        The unique name of the model card.
        """
        return pulumi.get(self, "model_card_name")

    @property
    @pulumi.getter(name="modelCardProcessingStatus")
    def model_card_processing_status(self) -> pulumi.Output['ModelCardProcessingStatus']:
        """
        The processing status of model card deletion. The ModelCardProcessingStatus updates throughout the different deletion steps.
        """
        return pulumi.get(self, "model_card_processing_status")

    @property
    @pulumi.getter(name="modelCardStatus")
    def model_card_status(self) -> pulumi.Output['ModelCardStatus']:
        """
        The approval status of the model card within your organization. Different organizations might have different criteria for model card review and approval.
        """
        return pulumi.get(self, "model_card_status")

    @property
    @pulumi.getter(name="modelCardVersion")
    def model_card_version(self) -> pulumi.Output[int]:
        """
        A version of the model card.
        """
        return pulumi.get(self, "model_card_version")

    @property
    @pulumi.getter(name="securityConfig")
    def security_config(self) -> pulumi.Output[Optional['outputs.ModelCardSecurityConfig']]:
        return pulumi.get(self, "security_config")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Key-value pairs used to manage metadata for model cards.
        """
        return pulumi.get(self, "tags")

