# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetProjectResult',
    'AwaitableGetProjectResult',
    'get_project',
    'get_project_output',
]

@pulumi.output_type
class GetProjectResult:
    def __init__(__self__, creation_time=None, project_arn=None, project_id=None, project_status=None, service_catalog_provisioned_product_details=None):
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if project_arn and not isinstance(project_arn, str):
            raise TypeError("Expected argument 'project_arn' to be a str")
        pulumi.set(__self__, "project_arn", project_arn)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if project_status and not isinstance(project_status, str):
            raise TypeError("Expected argument 'project_status' to be a str")
        pulumi.set(__self__, "project_status", project_status)
        if service_catalog_provisioned_product_details and not isinstance(service_catalog_provisioned_product_details, dict):
            raise TypeError("Expected argument 'service_catalog_provisioned_product_details' to be a dict")
        pulumi.set(__self__, "service_catalog_provisioned_product_details", service_catalog_provisioned_product_details)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[str]:
        """
        The time at which the project was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="projectArn")
    def project_arn(self) -> Optional[str]:
        return pulumi.get(self, "project_arn")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="projectStatus")
    def project_status(self) -> Optional['ProjectStatus']:
        """
        The status of a project.
        """
        return pulumi.get(self, "project_status")

    @property
    @pulumi.getter(name="serviceCatalogProvisionedProductDetails")
    def service_catalog_provisioned_product_details(self) -> Optional['outputs.ServiceCatalogProvisionedProductDetailsProperties']:
        """
        Provisioned ServiceCatalog  Details
        """
        return pulumi.get(self, "service_catalog_provisioned_product_details")


class AwaitableGetProjectResult(GetProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectResult(
            creation_time=self.creation_time,
            project_arn=self.project_arn,
            project_id=self.project_id,
            project_status=self.project_status,
            service_catalog_provisioned_product_details=self.service_catalog_provisioned_product_details)


def get_project(project_arn: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectResult:
    """
    Resource Type definition for AWS::SageMaker::Project
    """
    __args__ = dict()
    __args__['projectArn'] = project_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:sagemaker:getProject', __args__, opts=opts, typ=GetProjectResult).value

    return AwaitableGetProjectResult(
        creation_time=pulumi.get(__ret__, 'creation_time'),
        project_arn=pulumi.get(__ret__, 'project_arn'),
        project_id=pulumi.get(__ret__, 'project_id'),
        project_status=pulumi.get(__ret__, 'project_status'),
        service_catalog_provisioned_product_details=pulumi.get(__ret__, 'service_catalog_provisioned_product_details'))


@_utilities.lift_output_func(get_project)
def get_project_output(project_arn: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProjectResult]:
    """
    Resource Type definition for AWS::SageMaker::Project
    """
    ...
