# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetAccessPointPolicyResult',
    'AwaitableGetAccessPointPolicyResult',
    'get_access_point_policy',
    'get_access_point_policy_output',
]

@pulumi.output_type
class GetAccessPointPolicyResult:
    def __init__(__self__, policy_document=None):
        if policy_document and not isinstance(policy_document, dict):
            raise TypeError("Expected argument 'policy_document' to be a dict")
        pulumi.set(__self__, "policy_document", policy_document)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Optional[Any]:
        """
        A policy document containing permissions to add to the specified ObjectLambdaAccessPoint. For more information, see Access Policy Language Overview (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-policy-language-overview.html) in the Amazon Simple Storage Service Developer Guide. 

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::S3ObjectLambda::AccessPointPolicy` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "policy_document")


class AwaitableGetAccessPointPolicyResult(GetAccessPointPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessPointPolicyResult(
            policy_document=self.policy_document)


def get_access_point_policy(object_lambda_access_point: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessPointPolicyResult:
    """
    AWS::S3ObjectLambda::AccessPointPolicy resource is an Amazon S3ObjectLambda policy type that you can use to control permissions for your S3ObjectLambda


    :param str object_lambda_access_point: The name of the Amazon S3 ObjectLambdaAccessPoint to which the policy applies.
    """
    __args__ = dict()
    __args__['objectLambdaAccessPoint'] = object_lambda_access_point
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:s3objectlambda:getAccessPointPolicy', __args__, opts=opts, typ=GetAccessPointPolicyResult).value

    return AwaitableGetAccessPointPolicyResult(
        policy_document=pulumi.get(__ret__, 'policy_document'))


@_utilities.lift_output_func(get_access_point_policy)
def get_access_point_policy_output(object_lambda_access_point: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAccessPointPolicyResult]:
    """
    AWS::S3ObjectLambda::AccessPointPolicy resource is an Amazon S3ObjectLambda policy type that you can use to control permissions for your S3ObjectLambda


    :param str object_lambda_access_point: The name of the Amazon S3 ObjectLambdaAccessPoint to which the policy applies.
    """
    ...
